/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.jdbc.BaanJDBCDatabaseMetaData;
import com.baan.jdbc.BaanJDBCPreparedStatement;
import com.baan.jdbc.BaanJDBCStatement;
import com.baan.jdbc.BusinessDocumentManagerEx;
import com.baan.jdbc.JDBCConstructor;
import com.baan.jdbc.JDBCLicense;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDocFactory;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.exception.BusException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

class BaanJDBCConnection
implements Connection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.jdbc", "BaanJDBCConnection");
    private boolean m_autoCommit = true;
    private boolean m_closed = false;
    private long m_timeoutFistRequest = 60000L;
    private boolean m_readOnly = false;
    private Map m_typeMap = new Hashtable();
    private int m_transactionIsolationLevel = 0;
    private int m_resultSetHoldability = 1;
    private BusinessDocumentManagerEx m_businessDocumentManager;
    private BusDocFactory m_busDocFactory;
    private static int m_connectionCount;
    private static final String LOG_PREFIX = "JDBC : ";

    private BaanJDBCConnection() {
        int n = ++m_connectionCount;
        s_logger.message("JDBC : Connection count: " + (n - 1) + " -> " + n);
    }

    BaanJDBCConnection(String string, Properties properties) throws SQLException {
        this();
        String string2 = string.substring("jdbc:baan://".length());
        s_logger.message("JDBC : SSA JDBC Connector 'com.baan.jdbc' using Adapter for ERP (DAS) as backend");
        s_logger.message("JDBC : Create JDBC connection to backend: " + string2);
        try {
            try {
                this.m_timeoutFistRequest = Integer.parseInt(properties.getProperty("timeoutfirstrequest"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_businessDocumentManager = new BusinessDocumentManagerEx(this.m_timeoutFistRequest);
            String string3 = properties.getProperty("user");
            if (string3 != null) {
                BoiToolkit boiToolkit = BoiToolkit.getDefaultToolkit();
                IUserInfo iUserInfo = boiToolkit.createUserInfo();
                iUserInfo.setUsername(string3);
                String string4 = properties.getProperty("password");
                if (string4 != null) {
                    iUserInfo.setPassword(string4);
                }
                UserSession userSession = (UserSession)boiToolkit.createUserSession(iUserInfo);
                this.m_businessDocumentManager.addToUserSession(userSession);
            }
            this.m_businessDocumentManager.initialize(string2);
            this.m_busDocFactory = new BusDocFactoryImpl();
        }
        catch (BusException busException) {
            throw new SQLException(busException.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLException {
        throw new SQLException("nativeSQL not implemented");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.m_autoCommit = bl;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.m_autoCommit;
    }

    public void commit() throws SQLException {
        if (this.m_autoCommit) {
            s_logger.message("JDBC : SQLException, commit(): in auto-commit mode");
            throw new SQLException("commit(): in auto-commit mode");
        }
        s_logger.message("JDBC : SQLException, commit(): Not implemented");
        throw new SQLException("commit(): Not implemented");
    }

    public void rollback() throws SQLException {
        if (this.m_autoCommit) {
            s_logger.message("JDBC : SQLException, rollback(): in auto-commit mode");
            throw new SQLException("rollback(): in auto-commit mode");
        }
        s_logger.message("JDBC : SQLException, rollback(): Not implemented");
        throw new SQLException("rollback(): Not implemented");
    }

    public synchronized void close() throws SQLException {
        if (this.m_businessDocumentManager != null) {
            try {
                this.m_businessDocumentManager.close();
            }
            catch (BusException busException) {
                throw new SQLException(busException.toString());
            }
            this.m_businessDocumentManager = null;
        }
        if (!this.m_closed) {
            this.m_closed = true;
            s_logger.message("JDBC : Connection count: " + (--m_connectionCount + 1) + " -> " + m_connectionCount);
            if (m_connectionCount <= 0) {
                JDBCLicense.Instance().release();
                m_connectionCount = 0;
            }
        } else {
            s_logger.message("JDBC : Trying to close a Connection which is already closed");
            s_logger.message("JDBC : Connection count: " + m_connectionCount);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isClosed() throws SQLException {
        return this.m_closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new BaanJDBCDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.m_readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.m_transactionIsolationLevel = n;
                break;
            }
            default: {
                s_logger.errorMessage("JDBC : SQLException, setTransactionIsolation(): illegal argument value");
                throw new SQLException("setTransactionIsolation(): illegal argument value");
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return this.m_transactionIsolationLevel;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.m_closed) {
            s_logger.message("JDBC : SQLException, getWarnings(): Connection in closed state");
            throw new SQLException("getWarnings(): Connection in closed state");
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.m_resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.m_resultSetHoldability);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.m_resultSetHoldability);
    }

    public Map getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.m_typeMap = map;
    }

    public void setHoldability(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 2: {
                this.m_resultSetHoldability = n;
                break;
            }
            default: {
                s_logger.errorMessage("JDBC : SQLException, setHoldability(): illegal argument value");
                throw new SQLException("setHoldability(): illegal argument value");
            }
        }
    }

    public int getHoldability() throws SQLException {
        return this.m_resultSetHoldability;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.m_autoCommit) {
            s_logger.message("JDBC : SQLException, setSavepoint(): in auto-commit mode");
            throw new SQLException("setSavepoint(): in auto-commit mode");
        }
        s_logger.message("JDBC : SQLException, setSavepoint(): Not implemented");
        throw new SQLException("setSavepoint(): Not implemented");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.m_autoCommit) {
            s_logger.message("JDBC : SQLException, setSavepoint(String): in auto-commit mode");
            throw new SQLException("setSavepoint(String): in auto-commit mode");
        }
        s_logger.message("JDBC : SQLException, setSavepoint(String): Not implemented");
        throw new SQLException("setSavepoint(String): Not implemented");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.m_autoCommit) {
            s_logger.message("JDBC : SQLException, rollback(Savepoint): in auto-commit mode");
            throw new SQLException("rollback(Savepoint): in auto-commit mode");
        }
        s_logger.message("JDBC : SQLException, rollback(Savepoint): Not implemented");
        throw new SQLException("rollback(Savepoint): Not implemented");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        s_logger.message("JDBC : SQLException, releaseSavepoint(Savepoint): Not implemented");
        throw new SQLException("releaseSavepoint(Savepoint): Not implemented");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return new BaanJDBCStatement(this, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new BaanJDBCPreparedStatement(this, string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        s_logger.message("JDBC : SQLException, prepareCall(String, int, int, int): Not implemented");
        throw new SQLException("prepareCall(String, int, int, int): Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        s_logger.message("JDBC : SQLException, prepareStatement(String, int): Not implemented");
        throw new SQLException("prepareStatement(String, int): Not implemented");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        s_logger.message("JDBC : SQLException, prepareStatement(String, int[]): Not implemented");
        throw new SQLException("prepareStatement(String, int[]): Not implemented");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        s_logger.message("JDBC : SQLException, prepareStatement(String, String[]): Not implemented");
        throw new SQLException("prepareStatement(String, String[]): Not implemented");
    }

    JDBCConstructor createJDBCConstructor(String string) {
        return new JDBCConstructor(this.m_businessDocumentManager, string);
    }

    int getTimeout() {
        long l = this.m_businessDocumentManager.getTimeOut();
        if (l == 0L) {
            return 0;
        }
        return 1 + (int)(l /= 1000L);
    }

    void setTimeout(int n) {
        long l = n;
        this.m_businessDocumentManager.setTimeOut(l *= 1000L);
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_JDBC);
        m_connectionCount = 0;
    }
}

