/*
 * Decompiled with CFR 0.152.
 */
package com.baan.jdbc;

import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.jdbc.BaanJDBCResultSetMetaData;
import com.baan.jdbc.BaanJDBCTypes;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class BaanJDBCArray
implements Array {
    private Node m_columnNode;
    private int m_columnIndex;
    private ResultSetMetaData m_metaData;

    private BaanJDBCArray() {
    }

    public BaanJDBCArray(Node node, int n, ResultSetMetaData resultSetMetaData) {
        this.m_columnNode = node;
        this.m_columnIndex = n;
        this.m_metaData = resultSetMetaData;
    }

    public String getBaseTypeName() throws SQLException {
        return this.m_metaData.getColumnTypeName(this.m_columnIndex);
    }

    public int getBaseType() throws SQLException {
        return ((BaanJDBCResultSetMetaData)this.m_metaData).getColumnBaseType(this.m_columnIndex);
    }

    public Object getArray() throws SQLException {
        int n = this.getBaseType();
        switch (n) {
            case -6: {
                return this.getByteArray();
            }
            case 5: {
                return this.getShortArray();
            }
            case 4: {
                return this.getIntArray();
            }
            case -5: {
                return this.getLongArray();
            }
            case 7: {
                return this.getFloatArray();
            }
            case 6: {
                return this.getDoubleArray();
            }
            case 8: {
                return this.getDoubleArray();
            }
            case 3: {
                return this.getBigDecimalArray();
            }
            case 2: {
                return this.getBigDecimalArray();
            }
            case -7: {
                return this.getBooleanArray();
            }
            case 1: {
                return this.getStringArray();
            }
            case 12: {
                return this.getStringArray();
            }
            case 91: {
                return this.getDateArray();
            }
            case 92: {
                return this.getTimeArray();
            }
            case 93: {
                return this.getTimestampArray();
            }
            case 1111: {
                return this.getStringArray();
            }
        }
        throw new SQLException("Unsupported array type");
    }

    private Date[] getDateArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        Date[] dateArray = new Date[n];
        int n2 = 0;
        while (n2 < n) {
            java.util.Date date = BaanJDBCTypes.get_java_util_Date(stringArray[n2]);
            dateArray[n2] = new Date(date.getTime());
            ++n2;
        }
        return dateArray;
    }

    private Time[] getTimeArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        Time[] timeArray = new Time[n];
        int n2 = 0;
        while (n2 < n) {
            java.util.Date date = BaanJDBCTypes.get_java_util_Date(stringArray[n2]);
            timeArray[n2] = new Time(date.getTime());
            ++n2;
        }
        return timeArray;
    }

    private Timestamp[] getTimestampArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        Timestamp[] timestampArray = new Timestamp[n];
        int n2 = 0;
        while (n2 < n) {
            java.util.Date date = BaanJDBCTypes.get_java_util_Date(stringArray[n2]);
            timestampArray[n2] = new Timestamp(date.getTime());
            ++n2;
        }
        return timestampArray;
    }

    private boolean[] getBooleanArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equalsIgnoreCase("true")) {
                blArray[n2] = true;
            } else {
                int n3;
                try {
                    n3 = Integer.parseInt(stringArray[n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                blArray[n2] = n3 != 0;
            }
            ++n2;
        }
        return blArray;
    }

    private BigDecimal[] getBigDecimalArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                bigDecimalArray[n2] = new BigDecimal(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                bigDecimalArray[n2] = new BigDecimal(0.0);
            }
            ++n2;
        }
        return bigDecimalArray;
    }

    private double[] getDoubleArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                dArray[n2] = Double.parseDouble(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                dArray[n2] = 0.0;
            }
            ++n2;
        }
        return dArray;
    }

    private float[] getFloatArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                fArray[n2] = Float.parseFloat(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                fArray[n2] = 0.0f;
            }
            ++n2;
        }
        return fArray;
    }

    private long[] getLongArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                lArray[n2] = Long.parseLong(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                lArray[n2] = 0L;
            }
            ++n2;
        }
        return lArray;
    }

    private byte[] getByteArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                byArray[n2] = Byte.parseByte(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                byArray[n2] = 0;
            }
            ++n2;
        }
        return byArray;
    }

    private String[] getStringArray() throws SQLException {
        NodeList nodeList = this.m_columnNode.getChildNodes();
        int n = nodeList.getLength();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string;
            Node node = nodeList.item(n2);
            stringArray[n2] = string = this.getNodeValue(node);
            ++n2;
        }
        return stringArray;
    }

    private int[] getIntArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                nArray[n2] = Integer.parseInt(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n2] = 0;
            }
            ++n2;
        }
        return nArray;
    }

    private short[] getShortArray() throws SQLException {
        String[] stringArray = this.getStringArray();
        int n = stringArray.length;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                sArray[n2] = Short.parseShort(stringArray[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                sArray[n2] = 0;
            }
            ++n2;
        }
        return sArray;
    }

    private String getNodeValue(Node node) throws SQLException {
        Node node2;
        if (node != null && (node2 = node.getFirstChild()) != null) {
            String string = node2.getNodeValue();
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        throw new SQLException("getArray(index,count,map) not supported");
    }

    public Object getArray(long l, int n) throws SQLException {
        throw new SQLException("getArray(index,count) not supported");
    }

    public Object getArray(Map map) throws SQLException {
        throw new SQLException("getArray(map) not supported");
    }

    public ResultSet getResultSet() throws SQLException {
        throw new SQLException("getResultSet() not supported");
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        throw new SQLException("getResultSet(index,count,map) not supported");
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        throw new SQLException("getResultSet(index,count) not supported");
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw new SQLException("getResultSet(map) not supported");
    }

    public String toString() {
        try {
            Object object = this.getArray();
            Class<?> clazz = object.getClass();
            if (!clazz.isArray()) {
                return "<error>";
            }
            Class<?> clazz2 = clazz.getComponentType();
            boolean bl = clazz2.isPrimitive();
            if (bl) {
                if (clazz2 == Boolean.TYPE) {
                    boolean[] blArray = (boolean[])object;
                    String string = "";
                    int n = 0;
                    while (n < blArray.length) {
                        string = string + "<" + blArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Character.TYPE) {
                    char[] cArray = (char[])object;
                    String string = "";
                    int n = 0;
                    while (n < cArray.length) {
                        string = string + "<" + cArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = (byte[])object;
                    String string = "";
                    int n = 0;
                    while (n < byArray.length) {
                        string = string + "<" + byArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Short.TYPE) {
                    short[] sArray = (short[])object;
                    String string = "";
                    int n = 0;
                    while (n < sArray.length) {
                        string = string + "<" + sArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Integer.TYPE) {
                    int[] nArray = (int[])object;
                    String string = "";
                    int n = 0;
                    while (n < nArray.length) {
                        string = string + "<" + nArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Long.TYPE) {
                    long[] lArray = (long[])object;
                    String string = "";
                    int n = 0;
                    while (n < lArray.length) {
                        string = string + "<" + lArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Float.TYPE) {
                    float[] fArray = (float[])object;
                    String string = "";
                    int n = 0;
                    while (n < fArray.length) {
                        string = string + "<" + fArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Double.TYPE) {
                    double[] dArray = (double[])object;
                    String string = "";
                    int n = 0;
                    while (n < dArray.length) {
                        string = string + "<" + dArray[n] + ">";
                        ++n;
                    }
                    return string;
                }
                if (clazz2 == Void.TYPE) {
                    return "<void>";
                }
                return "<error>";
            }
            Object[] objectArray = (Object[])this.getArray();
            String string = "";
            if (objectArray == null) {
                return string;
            }
            int n = 0;
            while (n < objectArray.length) {
                string = objectArray[n] == null ? string + "<null>" : string + "<" + objectArray[n] + ">";
                ++n;
            }
            return string;
        }
        catch (SQLException sQLException) {
            return "<error>";
        }
    }
}

