/*
 * Decompiled with CFR 0.152.
 */
package com.baan.erp.audit;

import com.eibus.co.BusinessElement;
import com.eibus.co.Tuple;

public class RecordStatus {
    public static final int NONE = -1;
    public static final int DELETED = 0;
    public static final int UPDATED = 1;
    public static final int INSERTED = 2;
    public static final int UPDATED_NEW_OUT_OF_RANGE = 3;
    public static final int UPDATED_OLD_OUT_OF_RANGE = 4;
    public static final int TABLE_CLEARED = 5;
    public static final int TABLE_DROPPED = 6;
    public static final int TABLE_CREATED = 7;
    static final String STATUS_ATTRIBUTE = "RecordStatus";

    public int retrieveStatus(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement);
    }

    public boolean isDeleted(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 0;
    }

    public boolean isUpdated(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 1;
    }

    public boolean isInserted(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 2;
    }

    public boolean isUpdatedNewOutOfRange(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 3;
    }

    public boolean isUpdatedOldOutOfRange(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 4;
    }

    public boolean isTableCleared(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 5;
    }

    public boolean isTableDeleted(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 6;
    }

    public boolean isTableCreated(BusinessElement businessElement) {
        return RecordStatus.getStatus(businessElement) == 7;
    }

    public static int getStatus(BusinessElement businessElement) {
        Tuple tuple = businessElement.getTuple();
        String string = tuple.getAttribute(STATUS_ATTRIBUTE);
        if (string != null) {
            if (string.equals("I")) {
                return 2;
            }
            if (string.equals("D")) {
                return 0;
            }
            if (string.equals("U")) {
                return 1;
            }
            if (string.equals("M")) {
                return 3;
            }
            if (string.equals("N")) {
                return 4;
            }
            if (string.equals("L")) {
                return 5;
            }
            if (string.equals("R")) {
                return 6;
            }
            if (string.equals("C")) {
                return 7;
            }
        }
        return -1;
    }
}

