/*
 * Decompiled with CFR 0.152.
 */
package com.baan.erp.audit;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.dom.Node;
import com.baan.b3impl.boi1.IBusinessElementAdapter;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.erp.audit.AuditBoToBe;
import com.baan.erp.audit.AuditBoiHack;
import com.baan.erp.audit.AuditCursor;
import com.baan.erp.audit.AuditError;
import com.baan.erp.audit.AuditErrors;
import com.baan.erp.audit.AuditResult;
import com.baan.erp.audit.RecordSet;
import com.baan.erp.audit.SelectionCriteria;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.bdf.Iterator;
import com.eibus.co.BaanDLLCall;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.BusinessElement;
import com.eibus.co.DataSet;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BusinessElementImpl;
import com.eibus.exception.BusException;
import com.eibus.parse.BusDocListener;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.URI;
import com.eibus.services.runtime.Registry;
import com.eibus.version.Version;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AuditReader
extends Iterator {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.erp.audit", "AuditReader");
    static int initialBufferSize;
    static boolean AdapterVersion20;
    Set next;
    Set current;
    BusinessDocumentManager manager;
    BusComponent me;
    BusComponent backend;
    URI backendURI;
    BusDocFactory factory;
    int nextSize = 250;
    AuditCursor cursor = null;
    SelectionCriteria criteria;
    String auditTable;
    BaanDLLCall auditQuery;
    BusDoc busdoc;

    public AuditReader(BusinessObjectManager businessObjectManager, BusinessObject businessObject, SelectionCriteria selectionCriteria) {
        this();
        this.initialize(businessObjectManager, businessObject, selectionCriteria);
    }

    public AuditReader() {
    }

    public void initialize(BusinessObjectManager businessObjectManager, BusinessObject businessObject, SelectionCriteria selectionCriteria) {
        this.manager = AuditBoiHack.INSTANCE.bomToBdm(businessObjectManager);
        this.nextSize = initialBufferSize;
        if (this.manager == null) {
            throw new NullPointerException("Manager cannot be null in an AuditReader");
        }
        if (selectionCriteria == null) {
            throw new NullPointerException("Criteria for audit not specified");
        }
        this.factory = this.manager.getFactory();
        this.current = new Set();
        BusDoc busDoc = this.factory.createBusDoc();
        if (AdapterVersion20) {
            busDoc.setSender(this.backend);
            busDoc.setReceiver(this.me);
        }
        try {
            BusinessElementImpl businessElementImpl = AuditBoToBe.INSTANCE.BoToBe(businessObject);
            this.auditTable = businessElementImpl.type();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal Argument " + exception);
        }
        this.cursor = new AuditCursor();
        this.criteria = selectionCriteria;
        this.auditQuery = this.createAuditQuery(this.auditTable, selectionCriteria, this.nextSize, this.cursor);
        busDoc.addCO(this.auditQuery);
        this.setNextBusDoc(busDoc, 0);
        try {
            this.backendURI = this.backend.getPreferredConnection().getURI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuditResult.initializeRegistry(this.manager);
    }

    private BaanDLLCall createAuditQuery(String string, SelectionCriteria selectionCriteria, int n, AuditCursor auditCursor) {
        BaanDLLCall baanDLLCall = this.factory.createBaanDLLCall();
        baanDLLCall.setDLL("ottstpaudread");
        baanDLLCall.setMethod("ttstpaudread.search.audited.records", null, "elements");
        baanDLLCall.addParameter("Table", "in", "string", null, "8", "" + string);
        baanDLLCall.addParameterElement(selectionCriteria, "in", null, "elements", null);
        baanDLLCall.addParameter("SetSize", "in", "i4", null, null, "" + n);
        baanDLLCall.addParameterElement(auditCursor, "inout", null, "elements", null);
        baanDLLCall.addParameter("RecordSet", "out", null, "elements", null, null);
        return baanDLLCall;
    }

    public synchronized BusinessElement nextElement() throws BusException {
        this.waitForElements();
        BusinessElement businessElement = this.current.get();
        return businessElement;
    }

    public synchronized BusinessObject getOriginalObject(Tuple tuple) throws BusException {
        BusinessObject businessObject = null;
        BusinessElement businessElement = tuple.getOriginal();
        if (businessElement instanceof IBusinessElementAdapter) {
            businessObject = AuditBoiHack.INSTANCE.elementToBo(businessElement);
        }
        return businessObject;
    }

    public synchronized BusinessObject getCurrentObject(Tuple tuple) throws BusException {
        BusinessObject businessObject = null;
        BusinessElement businessElement = tuple.getCurrent();
        if (businessElement instanceof IBusinessElementAdapter) {
            businessObject = AuditBoiHack.INSTANCE.elementToBo(businessElement);
        }
        return businessObject;
    }

    public boolean hasMoreElements() throws BusTimeOutException, BusException {
        if (this.hasMoreLocalElements()) {
            return true;
        }
        try {
            this.waitForElements();
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    private void waitForElements() throws BusException {
        if (this.current.tuple == null) {
            if (this.current.isLastSet) {
                throw new NoSuchElementException("Backend has indicated that the last set has arrived");
            }
            if (this.next == null || !this.next.available) {
                this.fetch();
            }
            try {
                while (!this.next.available) {
                    if (this.manager.getTimeOut() > 0L) {
                        this.wait(this.manager.getTimeOut());
                        if (this.next.available) continue;
                        throw new BusTimeOutException("Timer expired before next dataset arrived");
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new BusTimeOutException("Call to nextElement() or hasMoreElements() was interrupted");
            }
            this.current = this.next;
            this.next = null;
            if (this.current.tuple == null) {
                throw new NoSuchElementException();
            }
        }
    }

    public boolean hasMoreLocalElements() {
        if (this.current.tuple != null) {
            return true;
        }
        if (this.next == null) {
            return false;
        }
        return this.next.available;
    }

    public synchronized void hintNextBufferSize(int n) {
        if (n <= 0) {
            return;
        }
        this.nextSize = n;
        this.busdoc.deleteCOs();
        this.auditQuery = this.createAuditQuery(this.auditTable, this.criteria, this.nextSize, this.cursor);
        this.busdoc.addCO(this.auditQuery);
    }

    public BusDoc getNextBusDoc() {
        return this.busdoc;
    }

    public void setNextBusDoc(BusDoc busDoc, int n) {
        this.busdoc = busDoc.createReply();
        this.cursor.setNode(n);
        this.busdoc.addCO(this.auditQuery);
    }

    public synchronized void fetch() throws BusException {
        if (this.next == null) {
            if (this.current.isLastSet) {
                return;
            }
            this.next = new Set();
            BusDoc busDoc = this.getNextBusDoc();
            Registry.registerManager(busDoc.getHeader().getCorrelationId(), null, null, this.manager);
            BusDoc busDoc2 = this.manager.sendAndWaitForAnswer(busDoc);
            this.next.onReceive(busDoc2);
            if (this.next.exception != null) {
                throw new BusApplicationException(this.next.exception.toString());
            }
        }
    }

    static {
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            initialBufferSize = adapterClientConfiguration.getIteratorSize();
        }
        catch (OWConfigurationException oWConfigurationException) {
            initialBufferSize = 250;
        }
        AdapterVersion20 = Version.getB3BuildNumber().equals("2.0");
    }

    private class Set
    implements BusDocListener {
        boolean isLastSet = false;
        boolean available = false;
        BusSynchronizationException exception;
        RecordSet data;
        Tuple tuple;

        private Set() {
        }

        synchronized BusinessElement get() throws BusException {
            if (this.exception != null) {
                throw this.exception;
            }
            BusinessElement businessElement = this.tuple.getCurrent();
            if (businessElement == null) {
                throw new BusSynchronizationException("Backend sent invalid dataset");
            }
            this.setNextTuple();
            return businessElement;
        }

        private void setNextTuple() {
            Node node;
            Tuple tuple = null;
            if (this.tuple == null) {
                node = this.data.getFirstChild();
                while (node != null) {
                    if (node instanceof Tuple) {
                        tuple = (Tuple)node;
                        break;
                    }
                    node = node.getNextSibling();
                }
            } else {
                tuple = this.tuple.getNextTuple();
                this.data.removeChild(this.tuple);
            }
            while (tuple != null) {
                node = tuple.getCurrent();
                if (node != null) break;
                this.tuple = tuple;
                tuple = tuple.getNextTuple();
                this.data.removeChild(this.tuple);
            }
            this.tuple = tuple;
        }

        public void onError(String string, String string2) {
        }

        public synchronized void onReceive(BusDoc busDoc) {
            Object object;
            Object object2;
            Registry.unRegisterManager(busDoc.getHeader().getCorrelationId(), null, null);
            if (busDoc.hasErrors()) {
                object2 = busDoc.getErrors();
                this.exception = new BusSynchronizationException("Errors in busdoc\n");
                object = new Vector();
                while (object2.hasMoreElements()) {
                    ((Vector)object).addElement(object2.nextElement());
                }
                this.exception.setErrors((Vector)object);
                s_logger.message("The backend signaled an error. The following exception is available");
                s_logger.errorException(this.exception);
            }
            AuditReader.this.backendURI = busDoc.getHeader().getSender().getReplyTo();
            AuditReader.this.backend = busDoc.getHeader().getSender().getComponent();
            object2 = busDoc.getFirstCO();
            if (object2 instanceof DataSet) {
                object = (DataSet)object2;
                Tuple tuple = object.getFirstTuple();
                AuditResult auditResult = (AuditResult)tuple.getOriginal();
                AuditErrors auditErrors = auditResult.getAuditErrors();
                int n = auditErrors.sizeAuditError();
                if (n <= 0) {
                    AuditCursor auditCursor = auditResult.getAuditCursor();
                    if (auditCursor != null) {
                        int n2 = auditCursor.getNode();
                        if (n2 == 0) {
                            this.isLastSet = true;
                        } else {
                            AuditReader.this.setNextBusDoc(busDoc, n2);
                        }
                    } else {
                        this.isLastSet = true;
                    }
                    this.data = auditResult.getRecordSet();
                    this.setNextTuple();
                } else {
                    Vector<AuditError> vector = new Vector<AuditError>(n);
                    int n3 = 0;
                    while (n3 < n) {
                        vector.addElement(auditErrors.getAuditErrorAt(n3));
                        ++n3;
                    }
                    this.exception = new BusSynchronizationException("Returned request did not contain query");
                    this.exception.setErrors(vector);
                }
            }
            this.available = true;
            this.notifyAll();
        }
    }
}

