/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3tools.info;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.b3impl.about.IInstallationComponentInfo;
import com.baan.owimpl.b3.odbc.ODBCConnectorComponentInfo;
import com.baan.owimpl.b3.oledb.OLEDBServerComponentInfo;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.tools.info.B3Info;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class Installation {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3tools.info", "Installation");
    private static final String UNKNOWN_STRING = "Unknown";
    static /* synthetic */ Class class$com$baan$b3impl$about$IInstallationComponentInfo;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length > 0) {
            n = stringArray[0].charAt(0);
        }
        switch (n) {
            case 103: {
                B3Info.main(stringArray);
                break;
            }
            case 108: {
                Installation.printHeader();
                System.out.println(Installation.getBriefInfo());
                break;
            }
            case 118: {
                Installation.printHeader();
                System.out.println(Installation.getAllInfo());
                break;
            }
            default: {
                Installation.printHeader();
                System.out.println("Syntax: com.baan.b3tools.info.Installation  [g|h|l|v]");
                System.out.println("\t(no options) - Undefined");
                System.out.println("\t           g - start graphical user interface");
                System.out.println("\t           h - print this help");
                System.out.println("\t           l - list installed components");
                System.out.println("\t           v - give verbose information");
            }
        }
    }

    public static void printHeader() {
        System.out.println("Adapter Support Information Tool");
        System.out.println(new AdapterComponentInfo().getCopyrightMessage());
        System.out.println();
    }

    public static String getAllInfo() {
        Object object;
        String string;
        Object object2;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Installation.getAllComponentInfo("com.baan.b3impl.about.AdapterComponentInfo");
        stringBuffer.append(string2);
        stringBuffer.append("\n\n\n");
        stringBuffer.append("\n\nLocal host names:\n");
        try {
            serializable = InetAddress.getLocalHost();
            object2 = ((InetAddress)serializable).getHostName();
            string = ((InetAddress)serializable).getHostAddress();
            stringBuffer.append("LocalHost   : ").append((String)object2).append(':').append(string).append('\n');
            object = InetAddress.getAllByName(string);
            int n = 0;
            while (n < ((InetAddress[])object).length) {
                InetAddress inetAddress = object[n];
                String string3 = inetAddress.getHostName();
                String string4 = inetAddress.getHostAddress();
                stringBuffer.append("LocalAlias  : ").append(string3).append(':').append(string4).append('\n');
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        stringBuffer.append("\n\nJava system properties:\n");
        serializable = System.getProperties();
        object2 = ((Properties)serializable).propertyNames();
        while (object2.hasMoreElements()) {
            string = (String)object2.nextElement();
            object = ((Properties)serializable).getProperty(string);
            stringBuffer.append(string).append('=').append((String)object).append('\n');
        }
        stringBuffer.append("\n\nConfiguration:\n");
        stringBuffer.append(Installation.getConfigurationInfo());
        return stringBuffer.toString();
    }

    public static String getConfigurationInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            AdapterClientContext adapterClientContext = AdapterClientContext.getInstance();
            stringBuffer.append("Directory URL  = ").append(adapterClientContext.getURL()).append("\n");
            stringBuffer.append("\nAdapter Client Configuration:\n");
            AdapterClientConfiguration adapterClientConfiguration = adapterClientContext.search();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            adapterClientConfiguration.print(new PrintStream(byteArrayOutputStream));
            stringBuffer.append(byteArrayOutputStream.toString());
            stringBuffer.append("\nLogging Configuration:\n");
            LoggingConfiguration loggingConfiguration = LoggingContext.getInstance().search();
            byteArrayOutputStream = new ByteArrayOutputStream();
            loggingConfiguration.print(new PrintStream(byteArrayOutputStream));
            stringBuffer.append(byteArrayOutputStream.toString());
        }
        catch (OWConfigurationException oWConfigurationException) {
            stringBuffer.append(oWConfigurationException.getMessage()).append('\n');
        }
        return stringBuffer.toString();
    }

    private static String getBriefInfo() {
        String string = Installation.getBriefComponentInfo("com.baan.b3impl.about.AdapterComponentInfo");
        return string;
    }

    private static String getAllComponentInfo(String string) {
        ODBCConnectorComponentInfo oDBCConnectorComponentInfo;
        OLEDBServerComponentInfo oLEDBServerComponentInfo;
        IInstallationComponentInfo iInstallationComponentInfo = Installation.getComponentInfoObject(string);
        if (iInstallationComponentInfo == null) {
            return null;
        }
        if (iInstallationComponentInfo.getComponentName().equals("Connector for OLE DB") ? !(oLEDBServerComponentInfo = (OLEDBServerComponentInfo)iInstallationComponentInfo).isInstalled() : iInstallationComponentInfo.getComponentName().equals("Connector for ODBC") && !(oDBCConnectorComponentInfo = (ODBCConnectorComponentInfo)iInstallationComponentInfo).isInstalled()) {
            return null;
        }
        return iInstallationComponentInfo.getComponentName() + "\n\n" + iInstallationComponentInfo.getCopyrightMessage() + "\n" + "\nVersion\t      : " + Installation.filter(iInstallationComponentInfo.getVersion()) + "\nPatch level     : " + Installation.filter(iInstallationComponentInfo.getPatchLevel()) + "\nBuild number    : " + Installation.filter(iInstallationComponentInfo.getBuildNumber()) + "\n" + "\nBuild GUID      : " + Installation.filter(iInstallationComponentInfo.getBuildGuid()) + "\n" + "\nBuild date      : " + Installation.filter(iInstallationComponentInfo.getBuildDateString()) + "\n" + "\nConfig spec     : " + Installation.filter(iInstallationComponentInfo.getSourceControlConfiguration());
    }

    private static String getBriefComponentInfo(String string) {
        IInstallationComponentInfo iInstallationComponentInfo;
        IInstallationComponentInfo iInstallationComponentInfo2 = Installation.getComponentInfoObject(string);
        if (iInstallationComponentInfo2 == null) {
            return null;
        }
        if (iInstallationComponentInfo2.getComponentName().equals("Connector for OLE DB") && !((OLEDBServerComponentInfo)(iInstallationComponentInfo = (OLEDBServerComponentInfo)iInstallationComponentInfo2)).isInstalled()) {
            return null;
        }
        if (iInstallationComponentInfo2.getComponentName().equals("Connector for ODBC") && !((ODBCConnectorComponentInfo)(iInstallationComponentInfo = (ODBCConnectorComponentInfo)iInstallationComponentInfo2)).isInstalled()) {
            return null;
        }
        return iInstallationComponentInfo2.getComponentName() + " " + Installation.filter(iInstallationComponentInfo2.getVersion()) + "." + Installation.filter(iInstallationComponentInfo2.getPatchLevel());
    }

    private static String filter(String string) {
        if (string == null) {
            return UNKNOWN_STRING;
        }
        return string;
    }

    private static IInstallationComponentInfo getComponentInfoObject(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            Object obj = clazz.newInstance();
            if (obj instanceof IInstallationComponentInfo) {
                return (IInstallationComponentInfo)obj;
            }
            throw new RuntimeException("Expected object of class " + (class$com$baan$b3impl$about$IInstallationComponentInfo == null ? (class$com$baan$b3impl$about$IInstallationComponentInfo = Installation.class$("com.baan.b3impl.about.IInstallationComponentInfo")) : class$com$baan$b3impl$about$IInstallationComponentInfo).getName() + " instead of class " + clazz.getName());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Cannot instantiate an object of class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot access class " + clazz.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_SUPPORT_INFO_TOOL);
    }
}

