/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.legacydirectory;

import com.baan.b3.legacydirectory.DirectoryToolkit;
import com.baan.b3.legacydirectory.IBusComponent;
import com.baan.b3impl.legacydirectory.BusComponent;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import java.util.NoSuchElementException;

public class Toolkit
extends DirectoryToolkit {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.legacydirectory", "Toolkit");
    private static Directory s_directory = null;

    public IBusComponent getBusComponent(String string) throws IllegalArgumentException, NoSuchElementException, com.baan.b3.legacydirectory.DirectoryException {
        if (string == null) {
            s_logger.message("DirectoryToolkit getBusComponent p_id must be non-null");
            throw new IllegalArgumentException("p_id must be non-null");
        }
        com.eibus.services.directory.BusComponent busComponent = null;
        try {
            this.setDirectory();
            busComponent = s_directory.retrieveBusComponent(string);
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit getBusComponent DirectoryException : " + directoryException.getMessage());
            throw this.createDirectoryException(directoryException.getMessage());
        }
        try {
            BusComponent busComponent2 = new BusComponent(busComponent);
            s_logger.message("DirectoryToolkit getBusComponent buscomponent '" + string + "' found");
            return busComponent2;
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            throw this.createDirectoryException("The specified directory entry does not contain the required information (company number)");
        }
    }

    public String[] listAllBusComponentIds() throws com.baan.b3.legacydirectory.DirectoryException {
        try {
            this.setDirectory();
            String[] stringArray = s_directory.listAllBusComponents();
            s_logger.message("DirectoryToolkit listAllBusComponentIds returned a list of " + stringArray.length + " buscomponentIds");
            return stringArray;
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit listAllBusComponentIds DirectoryException : " + directoryException.getMessage());
            throw this.createDirectoryException(directoryException.getMessage());
        }
    }

    public String[] listAllBusComponentCategories() throws com.baan.b3.legacydirectory.DirectoryException {
        try {
            this.setDirectory();
            String[] stringArray = s_directory.listAllBusComponentCategories();
            s_logger.message("DirectoryToolkit listAllBusComponentCategories returned a list of " + stringArray.length + " buscomponentCategories");
            return stringArray;
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit listAllBusComponentCategories DirectoryException : " + directoryException.getMessage());
            throw this.createDirectoryException(directoryException.getMessage());
        }
    }

    public String[] listBusComponentIdsWithCategory(String string) throws com.baan.b3.legacydirectory.DirectoryException {
        try {
            this.setDirectory();
            String[] stringArray = s_directory.listBusComponentIdsWithCategory(string);
            s_logger.message("DirectoryToolkit listBusComponentIdsWithCategory returned a list of " + stringArray.length + " buscomponentCategories");
            return stringArray;
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit listBusComponentIdsWithCategory DirectoryException : " + directoryException.getMessage());
            throw this.createDirectoryException(directoryException.getMessage());
        }
    }

    private void setDirectory() throws DirectoryException {
        if (s_directory == null) {
            s_directory = new DirectoryServiceProvider().getDirectoryService();
        }
    }
}

