/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.directory;

import com.baan.b3impl.directory.AFC_BusComponent;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AFC_Directory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.directory", "AFC_Directory");
    private static Directory s_directory = null;

    public AFC_BusComponent getBusComponent(String string) throws IllegalArgumentException, NoSuchElementException, DirectoryException {
        if (string == null) {
            s_logger.message("DirectoryToolkit getBusComponent p_id must be non-null");
            throw new IllegalArgumentException("p_id must be non-null");
        }
        BusComponent busComponent = null;
        try {
            this.setDirectory();
            busComponent = s_directory.retrieveBusComponent(string);
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit getBusComponent DirectoryException : " + directoryException.getMessage());
            throw directoryException;
        }
        try {
            AFC_BusComponent aFC_BusComponent = new AFC_BusComponent(busComponent);
            s_logger.message("DirectoryToolkit getBusComponent buscomponent '" + string + "' found");
            return aFC_BusComponent;
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            throw new DirectoryException("The specified directory entry does not contain the required information (company number)");
        }
    }

    public String[] listAllBusComponentIds() throws DirectoryException {
        try {
            Object[] objectArray;
            this.setDirectory();
            Enumeration enumeration2 = s_directory.findAllBusComponents(0);
            Vector<String> vector = new Vector<String>();
            while (enumeration2.hasMoreElements()) {
                objectArray = (BusComponent)enumeration2.nextElement();
                vector.addElement(objectArray.getIdentifier());
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            s_logger.message("DirectoryToolkit listAllBusComponentIds returned a list of " + vector.size() + " buscomponentIds");
            Arrays.sort(objectArray);
            return objectArray;
        }
        catch (DirectoryException directoryException) {
            s_logger.message("DirectoryToolkit listAllBusComponentIds DirectoryException : " + directoryException.getMessage());
            throw directoryException;
        }
    }

    private void setDirectory() throws DirectoryException {
        if (s_directory == null) {
            s_directory = new DirectoryServiceProvider().getDirectoryService();
        }
    }
}

