/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Correlator;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import com.eibus.co.dom.BusDocImpl;
import com.eibus.exception.BusException;
import com.eibus.parse.BusDocListener;
import com.eibus.services.guid.Guid;
import java.util.Vector;

class Waiter
implements BusDocListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.connection", "Waiter");
    Correlator registration = null;
    Vector answers = new Vector();
    BusDoc[] questions = null;
    boolean notified = false;
    String m_parseError = null;

    Waiter(Correlator correlator, BusDoc busDoc) {
        this.registration = correlator;
        correlator.putWaiter(busDoc, this);
        this.questions = new BusDocImpl[1];
        this.questions[0] = busDoc;
    }

    Waiter(Correlator correlator, BusDoc[] busDocArray) {
        this.registration = correlator;
        int n = 0;
        while (n < busDocArray.length) {
            correlator.putWaiter(busDocArray[n], this);
            ++n;
        }
        this.questions = busDocArray;
    }

    synchronized BusDoc[] suspend(long l) throws BusException {
        if (this.ready()) {
            return this.answer();
        }
        try {
            while (!this.ready()) {
                if (l <= 0L) {
                    this.wait();
                    continue;
                }
                if (this.notified) continue;
                this.wait(l);
                if (this.notified) continue;
                throw new BusTimeOutException("Did not receive BusDoc before timer expired");
            }
            this.notified = false;
            if (this.m_parseError != null) {
                throw new BusException(this.m_parseError);
            }
            return this.answer();
        }
        catch (InterruptedException interruptedException) {
            s_logger.errorException(interruptedException);
            throw new BusException(interruptedException);
        }
    }

    boolean ready() {
        return this.answers.size() == this.questions.length || this.m_parseError != null;
    }

    synchronized BusDoc[] answer() {
        int n;
        int n2;
        BusDoc[] busDocArray = new BusDoc[this.answers.size()];
        BusDoc[] busDocArray2 = new BusDoc[busDocArray.length];
        int n3 = 0;
        int n4 = 0;
        if (busDocArray.length != this.questions.length) {
            // empty if block
        }
        int n5 = 0;
        while (n5 < busDocArray.length) {
            n2 = 0;
            n = -1;
            BusDoc busDoc = (BusDoc)this.answers.elementAt(n5);
            Guid guid = busDoc.getHeader().getCorrelationId();
            int n6 = 0;
            while (n6 < this.questions.length) {
                Guid guid2 = this.questions[n6].getHeader().getCorrelationId();
                if (guid.equals(guid2)) {
                    if (busDocArray[n6] == null) {
                        n2 = 1;
                        busDocArray[n6] = busDoc;
                        ++n4;
                        break;
                    }
                    n = n6;
                }
                ++n6;
            }
            if (n2 == 0) {
                busDocArray2[n3] = busDoc;
                ++n3;
            }
            ++n5;
        }
        if (n3 > 0) {
            if (n4 + n3 != busDocArray.length) {
                // empty if block
            }
            n2 = 0;
            while (n2 < n3) {
                n = 0;
                while (n < busDocArray.length) {
                    if (busDocArray[n] == null) {
                        busDocArray[n] = busDocArray2[n2];
                        break;
                    }
                    ++n;
                }
                ++n2;
            }
        }
        return busDocArray;
    }

    public synchronized void onReceive(BusDoc busDoc) {
        this.answers.addElement(busDoc);
        this.notified = true;
        this.notifyAll();
    }

    public synchronized void onError(String string, String string2) {
        this.m_parseError = "Error Parsing message with ID '" + string + "', " + string2;
        this.notified = true;
        this.notifyAll();
    }
}

