/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.IPoolPolicy;
import com.baan.b3impl.connection.PoolPoliciesImpl;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import java.util.Hashtable;
import java.util.Vector;

public class PooledConnection {
    private IPoolPolicy m_poolPolicy = null;
    private Vector m_connections = new Vector();
    private Vector m_nrReferences = new Vector();
    private BusComponent m_busComponent = null;
    private UserSession m_UserSession = null;
    private Hashtable m_hTimerStore = null;

    public int getNrConnectionsManaged() {
        return this.m_connections.size();
    }

    public PooledConnection(BusComponent busComponent, UserSession userSession, IPoolPolicy iPoolPolicy) {
        this.m_busComponent = busComponent;
        this.m_UserSession = userSession;
        this.m_poolPolicy = iPoolPolicy;
    }

    public IPoolPolicy getPolicy() {
        return this.m_poolPolicy;
    }

    public void addConnection(int n) throws BusException {
        if (this.m_connections.size() == n) {
            Connection connection = new Connection(this.m_busComponent, this.m_UserSession);
            if (connection != null) {
                this.m_connections.insertElementAt(connection, n);
                this.m_nrReferences.insertElementAt(new Integer(0), n);
            }
        } else {
            Connection connection = new Connection(this.m_busComponent, this.m_UserSession);
            this.m_connections.setElementAt(connection, n);
            this.m_nrReferences.setElementAt(new Integer(0), n);
        }
    }

    public int TotalNoReferences() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getNrConnectionsManaged()) {
            if (this.getNrReferences(n2) >= 0) {
                n += this.getNrReferences(n2);
            }
            ++n2;
        }
        return n;
    }

    public void ReleaseConnection(int n) throws BusException {
        if (n < this.m_connections.size()) {
            Connection connection = (Connection)this.m_connections.elementAt(n);
            try {
                connection.close();
            }
            catch (Exception exception) {
                throw new BusException();
            }
        }
    }

    public int getIndex(Connection connection) {
        return this.m_connections.indexOf(connection);
    }

    public int getNrReferences(int n) {
        if (n < this.m_connections.size()) {
            Integer n2 = (Integer)this.m_nrReferences.elementAt(n);
            return n2;
        }
        return -1;
    }

    public void incNrReferences(int n) {
        int n2 = this.getNrReferences(n);
        if (n2 != -1) {
            this.m_nrReferences.setElementAt(new Integer(n2 + 1), n);
        }
    }

    public void decNrReferences(int n) {
        if (n < this.m_connections.size()) {
            int n2 = this.getNrReferences(n);
            this.m_nrReferences.setElementAt(new Integer(n2 - 1), n);
        }
    }

    public Connection getConnection(int n) {
        return (Connection)this.m_connections.elementAt(n);
    }

    public void setTimer(int n, PoolPoliciesImpl.Timer timer) {
        if (this.m_hTimerStore == null) {
            this.m_hTimerStore = new Hashtable();
        }
        this.m_hTimerStore.put(new Integer(n), timer);
    }

    public PoolPoliciesImpl.Timer getTimer(int n) {
        if (this.m_hTimerStore == null) {
            return null;
        }
        PoolPoliciesImpl.Timer timer = (PoolPoliciesImpl.Timer)this.m_hTimerStore.get(new Integer(n));
        this.m_hTimerStore.remove(timer);
        return timer;
    }
}

