/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.IPoolPolicy;
import com.baan.b3impl.connection.PooledConnection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;

public class PoolPoliciesImpl {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.connection", "PoolPoliciesImpl");
    private static final ILogger s_sharedPolicyLogger = LoggerFactory.createLogger("com.baan.b3impl.connection.PoolPoliciesImpl", "SharedPolicy");
    private static final ILogger s_limSharedPolicyLogger = LoggerFactory.createLogger("com.baan.b3impl.connection.PoolPoliciesImpl", "LimitedSharedPolicy");
    private static String POLICY_SHARED_ID = "shared";
    private static String POLICY_LIMITEDSHARED_ID = "limitedshared";
    private static String POLICY_LIMITEDCONNECTION_ID = "limitedconnection";
    private static PoolPoliciesImpl s_instance = new PoolPoliciesImpl();
    private static IPoolPolicy s_instance_SharedPolicy = s_instance.createSharedPolicy();

    public static synchronized IPoolPolicy getInstance(BusComponent busComponent, boolean bl) throws BusException {
        if (bl) {
            s_logger.message("Bypass the local pooling policy for BusComponent when running with APS");
            return s_instance.createLimitedSharedPolicy(1);
        }
        Activation activation = null;
        try {
            activation = busComponent.getActivation();
            if (activation == null) {
                s_logger.message("Trying to create Pooling policy for BusComponent without Activation, using default policy");
                return s_instance_SharedPolicy;
            }
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            s_logger.message("Trying to create Pooling policy for BusComponent without Activation, using default policy");
            return s_instance_SharedPolicy;
        }
        String string = activation.getPolicy();
        s_logger.message("create Pooling policy code for policy :'" + string + "'.");
        if (string.equalsIgnoreCase(POLICY_SHARED_ID)) {
            return s_instance_SharedPolicy;
        }
        if (string.equalsIgnoreCase(POLICY_LIMITEDSHARED_ID)) {
            int n = activation.getMaxReferences();
            return s_instance.createLimitedSharedPolicy(n);
        }
        if (string.equalsIgnoreCase(POLICY_LIMITEDCONNECTION_ID)) {
            int n = activation.getMaxConnections();
            int n2 = activation.getMaxReferences();
            int n3 = activation.getKeepAliveTime();
            return s_instance.createLimitedConnectionPolicy(n, n2, n3);
        }
        throw new BusException("Invalid pooling policy '" + string + "', check your BusComponent Configuration.");
    }

    IPoolPolicy createSharedPolicy() {
        return new SharedPolicy();
    }

    IPoolPolicy createLimitedSharedPolicy(int n) {
        return new LimitedSharedPolicy(n);
    }

    IPoolPolicy createLimitedConnectionPolicy(int n, int n2, int n3) {
        return new LimitedConnectionPolicy(n, n2, n3);
    }

    class Timer
    extends Thread {
        private int m_iTime;
        private IPoolPolicy m_cCallBack;
        private PooledConnection m_PooledConnection;
        private Connection m_Connection;

        public Timer(IPoolPolicy iPoolPolicy, PooledConnection pooledConnection, Connection connection, int n) {
            this.m_cCallBack = iPoolPolicy;
            this.m_iTime = n * 1000;
            this.m_PooledConnection = pooledConnection;
            this.m_Connection = connection;
            this.setName("PoolPolicyTimer");
            this.start();
            s_logger.message(this.getName() + ": Timer is Started");
        }

        public void stopTimer() {
            this.interrupt();
        }

        public void run() {
            try {
                Thread.sleep(this.m_iTime);
                s_logger.message(this.getName() + ": Timer is expired, calling ReleaseReference");
                this.m_cCallBack.ReleaseReference(this.m_PooledConnection, this.m_Connection, false);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BusException busException) {
                s_logger.message("BusException in waiting thread of pooling policy:" + busException.toString());
            }
        }
    }

    public class LimitedConnectionPolicy
    implements IPoolPolicy {
        private int m_ConnectionLimit;
        private int m_timeout;
        private int m_ManagerTresshold;
        public String LOGPREFIX = null;

        public LimitedConnectionPolicy(int n, int n2, int n3) {
            this.m_ConnectionLimit = n;
            this.m_timeout = n3;
            this.m_ManagerTresshold = n2;
            this.LOGPREFIX = "Activation PoolingPolicy(" + POLICY_LIMITEDCONNECTION_ID + "(con=" + this.m_ConnectionLimit + ", ref=" + this.m_ManagerTresshold + ", time=" + this.m_timeout + ")): ";
        }

        public synchronized Connection GetReference(PooledConnection pooledConnection) throws BusException {
            int n = pooledConnection.getNrConnectionsManaged();
            s_logger.message(this.LOGPREFIX + "GetReference, NrConnections = " + n);
            int n2 = this.getConnectionToUse(pooledConnection);
            if (n2 >= 0) {
                int n3 = pooledConnection.getNrReferences(n2);
                s_logger.message(this.LOGPREFIX + "GetReference, using slot/connection " + n2 + " ref(" + n3 + ")");
                if (n3 <= 0) {
                    if (n3 == 0) {
                        Timer timer = pooledConnection.getTimer(n2);
                        s_logger.message(this.LOGPREFIX + "GetReference, Timer is running, stopping timer, re-using connection(" + n2 + ")");
                        timer.stopTimer();
                        pooledConnection.incNrReferences(n2);
                        return pooledConnection.getConnection(n2);
                    }
                    s_logger.message(this.LOGPREFIX + "GetReference, Creating new Connection(" + n2 + ")");
                    pooledConnection.addConnection(n2);
                    pooledConnection.incNrReferences(n2);
                    return pooledConnection.getConnection(n2);
                }
                s_logger.message(this.LOGPREFIX + "GetReference, Reusing Connection(" + n2 + "), NrRefs " + n3 + "->" + (n3 + 1));
                pooledConnection.incNrReferences(n2);
                return pooledConnection.getConnection(n2);
            }
            pooledConnection.addConnection(n);
            pooledConnection.incNrReferences(n);
            return pooledConnection.getConnection(n);
        }

        public synchronized boolean ReleaseReference(PooledConnection pooledConnection, Connection connection, boolean bl) throws BusException {
            int n = pooledConnection.getNrConnectionsManaged();
            int n2 = pooledConnection.getIndex(connection);
            s_logger.message(this.LOGPREFIX + "ReleaseReference, on Connection(" + n2 + ") (total slots = " + n + ")");
            if (n2 != -1) {
                int n3 = pooledConnection.getNrReferences(n2);
                if (n3 > 0) {
                    s_logger.message(this.LOGPREFIX + "Connection(" + n2 + "), NrReferences " + n3 + "->" + (n3 - 1));
                }
                if (n3 > 1) {
                    pooledConnection.decNrReferences(n2);
                } else if (n3 == 1 && !bl) {
                    s_logger.message(this.LOGPREFIX + "Releasing Last reference to connection(" + n2 + "), starting timer");
                    pooledConnection.decNrReferences(n2);
                    Timer timer = new Timer(this, pooledConnection, connection, this.m_timeout);
                    pooledConnection.setTimer(n2, timer);
                } else {
                    s_logger.message(this.LOGPREFIX + "Closing connection(" + n2 + ")");
                    pooledConnection.decNrReferences(n2);
                    try {
                        pooledConnection.ReleaseConnection(n2);
                    }
                    catch (Exception exception) {
                        s_logger.errorMessage("Policy(limited connection): Close connection failed, because the connection to the backend is already closed! previous error can be ignored!");
                    }
                    if (bl) {
                        pooledConnection.decNrReferences(n2);
                    }
                }
            }
            return pooledConnection.TotalNoReferences() == 0;
        }

        private int getConnectionToUse(PooledConnection pooledConnection) {
            int n = pooledConnection.getNrConnectionsManaged();
            if (n == this.m_ConnectionLimit) {
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                int n4 = -1;
                int n5 = 0;
                while (n5 < n) {
                    int n6 = pooledConnection.getNrReferences(n5);
                    if (n6 < this.m_ManagerTresshold && n6 > 0) {
                        return n5;
                    }
                    if (n2 > n6 || n6 == 0) {
                        if (n6 == 0 && n4 == -1) {
                            n4 = n5;
                        } else {
                            n2 = n6;
                            n3 = n5;
                        }
                    }
                    ++n5;
                }
                if (n4 == -1) {
                    return n3;
                }
                return n4;
            }
            int n7 = 0;
            while (n7 < n) {
                int n8 = pooledConnection.getNrReferences(n7);
                if (n8 < this.m_ManagerTresshold) {
                    return n7;
                }
                ++n7;
            }
            return -1;
        }
    }

    class LimitedSharedPolicy
    implements IPoolPolicy {
        private int m_limit;
        public String LOGPREFIX = null;

        public LimitedSharedPolicy(int n) {
            this.m_limit = n;
            this.LOGPREFIX = "Policy(" + POLICY_LIMITEDSHARED_ID + "(" + this.m_limit + ")): ";
        }

        public synchronized Connection GetReference(PooledConnection pooledConnection) throws BusException {
            int n = pooledConnection.getNrConnectionsManaged();
            int n2 = 0;
            while (n2 < n) {
                int n3 = pooledConnection.getNrReferences(n2);
                s_limSharedPolicyLogger.message(this.LOGPREFIX + "GetReference, NrConnections = " + n + ", NrReferences = " + n3);
                if (n3 < this.m_limit) {
                    s_limSharedPolicyLogger.message(this.LOGPREFIX + "GetReference, using slot " + n2);
                    if (pooledConnection.getNrReferences(n2) == 0) {
                        s_limSharedPolicyLogger.message(this.LOGPREFIX + "GetReference, Creating new Connection");
                        pooledConnection.addConnection(n2);
                    } else {
                        s_limSharedPolicyLogger.message(this.LOGPREFIX + "GetReference, Reusing Connection NrRefs " + n3 + "->" + (n3 + 1));
                    }
                    pooledConnection.incNrReferences(n2);
                    return pooledConnection.getConnection(n2);
                }
                ++n2;
            }
            pooledConnection.addConnection(n);
            pooledConnection.incNrReferences(n);
            return pooledConnection.getConnection(n);
        }

        public synchronized boolean ReleaseReference(PooledConnection pooledConnection, Connection connection, boolean bl) throws BusException {
            int n = pooledConnection.getNrConnectionsManaged();
            int n2 = pooledConnection.getIndex(connection);
            s_limSharedPolicyLogger.message(this.LOGPREFIX + "ReleaseReference, NrConnections = " + n + ", Releasing reference on connection " + n2);
            if (n2 != -1) {
                int n3 = pooledConnection.getNrReferences(n2);
                s_limSharedPolicyLogger.message(this.LOGPREFIX + "NrReferences " + n3 + "->" + (n3 - 1));
                if (n3 > 1) {
                    pooledConnection.decNrReferences(n2);
                } else {
                    s_limSharedPolicyLogger.message(this.LOGPREFIX + "Last reference, releasing connection");
                    pooledConnection.decNrReferences(n2);
                    try {
                        pooledConnection.ReleaseConnection(n2);
                    }
                    catch (Exception exception) {
                        s_limSharedPolicyLogger.errorMessage("Policy(limited shared): Close connection failed, because the connection to the backend is already closed! previous error can be ignored!");
                    }
                }
            }
            return pooledConnection.TotalNoReferences() == 0;
        }
    }

    private class SharedPolicy
    implements IPoolPolicy {
        public synchronized Connection GetReference(PooledConnection pooledConnection) throws BusException {
            int n = pooledConnection.getNrReferences(0);
            s_sharedPolicyLogger.message("Policy(shared): GetReference, NrReferences = " + n);
            if (n <= 0) {
                s_sharedPolicyLogger.message("Policy(shared): GetReference, First time, creating connection.");
                pooledConnection.addConnection(0);
                pooledConnection.incNrReferences(0);
                return pooledConnection.getConnection(0);
            }
            s_sharedPolicyLogger.message("Policy(shared): GetReference, Pooling, NrReferences = " + n + "->" + (n + 1));
            pooledConnection.incNrReferences(0);
            return pooledConnection.getConnection(0);
        }

        public synchronized boolean ReleaseReference(PooledConnection pooledConnection, Connection connection, boolean bl) throws BusException {
            int n = pooledConnection.getNrReferences(0);
            s_sharedPolicyLogger.message("Policy(shared): ReleaseReference, nr references = " + n);
            if (n == 1) {
                s_sharedPolicyLogger.message("Policy(shared): ReleaseReference, Last Reference, releasing Connection. ");
                pooledConnection.decNrReferences(0);
                try {
                    pooledConnection.ReleaseConnection(0);
                }
                catch (Exception exception) {
                    s_sharedPolicyLogger.errorMessage("Policy(shared): Close connection failed, because the connection to the backend is already closed! previous error can be ignored!");
                }
                return true;
            }
            s_sharedPolicyLogger.message("Policy(shared): ReleaseReference, decreasing nrReferences " + n + "->" + (n - 1));
            pooledConnection.decNrReferences(0);
            return false;
        }
    }
}

