/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import com.eibus.parse.BusDocListener;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.guid.Guid;
import java.util.Hashtable;

class Correlator
implements BusDocListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.connection", "Correlator");
    BusDocListener defaultListener = new DefaultListener();
    Hashtable listeners = new Hashtable();

    Correlator() {
    }

    synchronized BusDocListener getWaiter(String string) {
        Guid guid;
        if (string != null && (guid = Guid.createGuid(string)) != null) {
            BusDocListener busDocListener = (BusDocListener)this.listeners.remove(guid);
            if (busDocListener != null) {
                return busDocListener;
            }
            busDocListener = (BusDocListener)this.listeners.get(guid.toString());
            if (busDocListener != null) {
                return busDocListener;
            }
        }
        return this.defaultListener;
    }

    synchronized BusDocListener getWaiter(BusDoc busDoc) {
        String string;
        BusDocListener busDocListener;
        Guid guid = busDoc.getHeader().getCorrelationId();
        if (guid != null) {
            busDocListener = (BusDocListener)this.listeners.remove(guid);
            if (busDocListener != null) {
                return busDocListener;
            }
            busDocListener = (BusDocListener)this.listeners.get(guid.toString());
            if (busDocListener != null) {
                return busDocListener;
            }
        }
        if ((string = busDoc.getHeader().getTransactionId()) != null && (busDocListener = (BusDocListener)this.listeners.get(string)) != null) {
            return busDocListener;
        }
        BusComponent busComponent = busDoc.getHeader().getSender().getComponent();
        if (busComponent != null && (busDocListener = (BusDocListener)this.listeners.get(busComponent.getIdentifier())) != null) {
            return busDocListener;
        }
        BusComponent busComponent2 = busDoc.getHeader().getReceiver().getComponent();
        if (busComponent2 != null && (busDocListener = (BusDocListener)this.listeners.get(busComponent2.getIdentifier())) != null) {
            return busDocListener;
        }
        return this.defaultListener;
    }

    synchronized void putWaiter(BusDoc busDoc, BusDocListener busDocListener) {
        this.listeners.put(busDoc.getHeader().getCorrelationId(), busDocListener);
    }

    synchronized void removeWaiter(BusDoc busDoc) {
        this.listeners.remove(busDoc.getHeader().getCorrelationId());
    }

    synchronized BusDocListener registerWaiter(String string, BusDocListener busDocListener) {
        if (busDocListener == null) {
            return (BusDocListener)this.listeners.remove(string);
        }
        return this.listeners.put(string, busDocListener);
    }

    synchronized void setDefaultListener(BusDocListener busDocListener) {
        if (busDocListener == null) {
            busDocListener = new DefaultListener();
        }
        this.defaultListener = busDocListener;
    }

    public void onReceive(BusDoc busDoc) {
        BusDocListener busDocListener = this.getWaiter(busDoc);
        busDocListener.onReceive(busDoc);
    }

    public void onError(String string, String string2) {
        BusDocListener busDocListener = this.getWaiter(string);
        busDocListener.onError(string, string2);
    }

    class DefaultListener
    implements BusDocListener {
        DefaultListener() {
        }

        public void onReceive(BusDoc busDoc) {
            s_logger.message("The message with identifier " + busDoc.getHeader().getCorrelationId() + " is ignored");
            s_logger.flowMessage("Contents of ignored message: \n");
            s_logger.flowXml(busDoc);
        }

        public void onError(String string, String string2) {
            s_logger.message("Ignoring an message with ID " + string + ", which generated an error during parsing; " + string2);
        }
    }
}

