/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.b3.boi1.IUserInfo;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.IPoolPolicy;
import com.baan.b3impl.connection.PoolPoliciesImpl;
import com.baan.b3impl.connection.PooledConnection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConnectionFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.connection", "ConnectionFactory");
    private Directory m_directoryService = null;
    private static ConnectionFactory s_instance = new ConnectionFactory();
    private ConnectionPool m_connectionPool = new ConnectionPool();
    private Hashtable m_simpleConnectionPool = new Hashtable();

    public static ConnectionFactory getInstance() {
        return s_instance;
    }

    public ConnectionFactory() {
        try {
            this.m_directoryService = new DirectoryServiceProvider().getDirectoryService();
        }
        catch (DirectoryException directoryException) {
            this.m_directoryService = null;
        }
    }

    public boolean isBackendReference(String string) {
        return BusComponent.isBackendReference(string);
    }

    public synchronized Connection giveConnection(String string, UserInfo userInfo) throws BusException {
        SimplePooledConnection simplePooledConnection = userInfo != null ? (SimplePooledConnection)this.m_simpleConnectionPool.get(string + "-" + userInfo.getUsername()) : (SimplePooledConnection)this.m_simpleConnectionPool.get(string);
        if (simplePooledConnection == null) {
            BusComponent busComponent = null;
            if (this.m_directoryService == null) {
                throw new BusException("Initializing/loading of the directory failed.");
            }
            try {
                busComponent = this.m_directoryService.retrieveBusComponent(string);
            }
            catch (DirectoryException directoryException) {
                throw new BusException(directoryException);
            }
            Connection connection = new Connection(busComponent, userInfo);
            simplePooledConnection = new SimplePooledConnection(connection);
            if (userInfo != null) {
                this.m_simpleConnectionPool.put(string + "-" + userInfo.getUsername(), simplePooledConnection);
            } else {
                this.m_simpleConnectionPool.put(string, simplePooledConnection);
            }
            return simplePooledConnection.getConnection();
        }
        simplePooledConnection.incNrReferences();
        return simplePooledConnection.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection giveConnectionFromBackendReference(String string, UserSession userSession) throws BusException {
        IUserInfo iUserInfo = null;
        BusComponent busComponent = null;
        String string2 = null;
        try {
            busComponent = BusComponent.getComponentFromBackendReference(string);
            string2 = busComponent.getIdentifier();
            s_logger.flowMessage("ConnectionFactory: BackendReference: '" + string + "', maps to BC '" + string2 + "'");
        }
        catch (Exception exception) {
            throw new BusException(exception.getMessage());
        }
        Hashtable hashtable = this.m_simpleConnectionPool;
        synchronized (hashtable) {
            SimplePooledConnection simplePooledConnection = (SimplePooledConnection)this.m_simpleConnectionPool.get(string2);
            if (simplePooledConnection == null) {
                s_logger.flowMessage("ConnectionFactory: BackendReference: create new Connection for started BC " + string2);
                Connection connection = new Connection(busComponent, iUserInfo);
                if (userSession != null) {
                    connection.setLicInfo(userSession.getLicenseInfo());
                }
                simplePooledConnection = new SimplePooledConnection(connection);
                this.m_simpleConnectionPool.put(string2, simplePooledConnection);
                return simplePooledConnection.getConnection();
            }
            int n = simplePooledConnection.getNrReferences();
            s_logger.flowMessage("ConnectionFactory: BackendReference: pool existing connection, references " + n + "->" + ++n);
            simplePooledConnection.incNrReferences();
            return simplePooledConnection.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection giveConnection(String string, UserSession userSession) throws BusException {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            BusComponent busComponent = null;
            Connection connection = null;
            if (this.m_directoryService == null) {
                throw new BusException("Initializing/loading of the directory failed.");
            }
            try {
                busComponent = this.m_directoryService.retrieveBusComponent(string);
            }
            catch (DirectoryException directoryException) {
                throw new BusException(directoryException);
            }
            PooledConnection pooledConnection = this.m_connectionPool.getPooledConnection(userSession, string);
            if (pooledConnection == null) {
                s_logger.message("Connection: pooledConnection for usersession: " + userSession + " and '" + string + "' not found in the connectionpool: + " + this.m_connectionPool);
                boolean bl = false;
                try {
                    if (busComponent.getActivation().getAPSBusComponent() != null) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IPoolPolicy iPoolPolicy = PoolPoliciesImpl.getInstance(busComponent, bl);
                pooledConnection = new PooledConnection(busComponent, userSession, iPoolPolicy);
                connection = iPoolPolicy.GetReference(pooledConnection);
                this.m_connectionPool.putPooledConnection(userSession, string, pooledConnection, connection);
            } else {
                connection = pooledConnection.getPolicy().GetReference(pooledConnection);
                PooledConnection pooledConnection2 = this.m_connectionPool.getPooledConnection(connection);
                if (pooledConnection2 == null) {
                    this.m_connectionPool.putPooledConnection(userSession, string, pooledConnection, connection);
                }
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) throws BusException {
        if (connection != null) {
            Connection connection2 = connection;
            synchronized (connection2) {
                PooledConnection pooledConnection = this.m_connectionPool.getPooledConnection(connection);
                if (pooledConnection != null) {
                    boolean bl = pooledConnection.getPolicy().ReleaseReference(pooledConnection, connection, false);
                    if (bl) {
                        this.m_connectionPool.removePooledConnection(connection);
                    }
                } else {
                    Hashtable hashtable = this.m_simpleConnectionPool;
                    synchronized (hashtable) {
                        SimplePooledConnection simplePooledConnection = (SimplePooledConnection)this.m_simpleConnectionPool.get(connection.getServerComponentId());
                        if (simplePooledConnection != null) {
                            int n = simplePooledConnection.getNrReferences();
                            if (n > 1) {
                                s_logger.flowMessage("ConnectionFactory: BackendReference: remove reference to connection, " + n + "->" + --n);
                                simplePooledConnection.decNrReferences();
                            } else {
                                s_logger.flowMessage("ConnectionFactory: BackendReference: last reference, removing connection");
                                simplePooledConnection.getConnection().close();
                                this.m_simpleConnectionPool.remove(connection.getServerComponentId());
                            }
                        }
                    }
                }
            }
        }
    }

    private class ConnectionPool {
        private Hashtable m_userSessions = new Hashtable();
        private Hashtable m_pooledConnectionsPerBusComponentId = null;
        private Hashtable m_pooledConnectionsPerConnection = new Hashtable();

        ConnectionPool() {
        }

        synchronized PooledConnection getPooledConnection(Connection connection) {
            if (connection != null) {
                return (PooledConnection)this.m_pooledConnectionsPerConnection.get(connection);
            }
            return null;
        }

        synchronized PooledConnection getPooledConnection(UserSession userSession, String string) {
            this.m_pooledConnectionsPerBusComponentId = (Hashtable)this.m_userSessions.get(userSession);
            if (this.m_pooledConnectionsPerBusComponentId != null) {
                return (PooledConnection)this.m_pooledConnectionsPerBusComponentId.get(string);
            }
            return null;
        }

        synchronized void putPooledConnection(UserSession userSession, String string, PooledConnection pooledConnection, Connection connection) {
            this.m_pooledConnectionsPerBusComponentId = (Hashtable)this.m_userSessions.get(userSession);
            if (this.m_pooledConnectionsPerBusComponentId == null) {
                this.m_pooledConnectionsPerBusComponentId = new Hashtable();
                this.m_userSessions.put(userSession, this.m_pooledConnectionsPerBusComponentId);
            }
            this.m_pooledConnectionsPerBusComponentId.put(string, pooledConnection);
            this.m_pooledConnectionsPerConnection.put(connection, pooledConnection);
        }

        synchronized void removePooledConnection(Connection connection) {
            this.m_pooledConnectionsPerConnection.remove(connection);
            this.m_pooledConnectionsPerBusComponentId.remove(connection.getServerComponentId());
            if (this.m_pooledConnectionsPerBusComponentId.isEmpty()) {
                Enumeration enumeration2 = this.m_userSessions.keys();
                while (enumeration2.hasMoreElements()) {
                    UserSession userSession = (UserSession)enumeration2.nextElement();
                    if (this.m_userSessions.get(userSession) != this.m_pooledConnectionsPerBusComponentId) continue;
                    this.m_userSessions.remove(userSession);
                }
            }
        }
    }

    private class SimplePooledConnection {
        int m_references;
        Connection m_connection;

        SimplePooledConnection(Connection connection) {
            this.m_connection = connection;
            this.m_references = 1;
        }

        void incNrReferences() {
            ++this.m_references;
        }

        void decNrReferences() {
            --this.m_references;
        }

        int getNrReferences() {
            return this.m_references;
        }

        Connection getConnection() {
            return this.m_connection;
        }
    }
}

