/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.connection;

import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Correlator;
import com.baan.b3impl.connection.Waiter;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.co.Action;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.Control;
import com.eibus.co.LicenseInfoCo;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.parse.MessagePool;
import com.eibus.parse.ParserThread;
import com.eibus.services.activation.ActivationServiceFactory;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.directory.URI;
import com.eibus.services.guid.Guid;
import com.eibus.services.profiling.DefaultTimerFactory;
import com.eibus.services.profiling.Timer;
import com.eibus.xml.util.DOMWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Connection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.connection", "Connection");
    private MessagePool m_messagePool = null;
    private ParserThread m_parser = null;
    private Middleware m_middleware = null;
    private Correlator m_correlator = null;
    private IConnection m_fysicalConnection = null;
    private BusComponent m_clientComponent = null;
    private BusComponent m_serverComponent = null;
    private String m_ServerComponentId = null;
    private String m_ActivationType = null;
    private IActivationService m_activationService = null;
    private UserInfo m_UserInfo = null;
    private boolean bUserSetUserInfo = true;
    private LicenseInfoCo m_LicenseInfo = null;
    private BusDocFactory m_factory = new BusDocFactoryImpl();
    private static final DefaultTimerFactory s_timerFactory = DefaultTimerFactory.getInstance();
    private static final String TIMER_APPLICATION_LEVEL = "Application";

    public Connection(BusComponent busComponent, IUserInfo iUserInfo) throws BusException {
        if (busComponent != null) {
            DirectoryEntry directoryEntry;
            try {
                directoryEntry = busComponent.getActivation();
                if (directoryEntry != null) {
                    throw new BusException("Trying to initialize a Manager with a BusComponent that is configured for automatic activation, this requires the Manager to be part of an UserSession.");
                }
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                // empty catch block
            }
            directoryEntry = busComponent.getPreferredConnection();
            URI uRI = ((ConnectionPoint)directoryEntry).getURI();
            String string = uRI.getProtocol();
            this.m_UserInfo = (UserInfo)iUserInfo;
            this.m_clientComponent = this.createClientcomponent(this.m_UserInfo, string);
            this.m_serverComponent = busComponent;
            this.m_ServerComponentId = this.m_UserInfo != null ? this.m_serverComponent.getIdentifier() + "-" + this.m_UserInfo.getUsername() : this.m_serverComponent.getIdentifier();
            this.m_messagePool = new MessagePool();
            this.m_correlator = new Correlator();
            this.m_middleware = new Middleware(this.m_clientComponent, this.m_messagePool);
            this.m_parser = new ParserThread(this.m_correlator, this.m_messagePool);
            this.m_parser.start();
            this.m_fysicalConnection = this.m_middleware.getConnected(uRI);
            s_logger.message("Creating Connection class for '" + this.m_ServerComponentId + "', protcol:'" + string + "'");
        }
    }

    public Connection(BusComponent busComponent, IUserSession iUserSession) throws BusException {
        if (busComponent != null) {
            UserSession userSession = (UserSession)iUserSession;
            this.m_UserInfo = new UserInfo(userSession.getUserInfo());
            this.bUserSetUserInfo = userSession.bUserSetUserInfo;
            this.m_LicenseInfo = userSession.getLicenseInfo();
            ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
            if (connectionPoint == null) {
                throw new BusException("No Connection Configured within '" + busComponent.getIdentifier() + "'");
            }
            URI uRI = connectionPoint.getURI();
            String string = uRI.getProtocol();
            this.m_clientComponent = this.createClientcomponent(this.m_UserInfo, string);
            try {
                Activation activation = busComponent.getActivation();
                if (activation == null) {
                    throw new AttributeNotSpecifiedException("activation");
                }
                this.m_ActivationType = activation.getType();
                if (activation.getAPSBusComponent() != null) {
                    this.m_ActivationType = "aps";
                }
                this.m_activationService = ActivationServiceFactory.createActivationService(this.m_ActivationType);
                s_logger.message("Connection : Trying to start server by activation service");
                if (this.m_UserInfo != null) {
                    this.m_serverComponent = this.m_activationService.Activate(busComponent, this.m_UserInfo.getInternalObject());
                    if (this.m_serverComponent == null) {
                        s_logger.message("Connection : Server not started by Activation(" + this.m_ActivationType + ")");
                        throw new BusException("SSA Technology Architecture Adapter Server not started with Activation (" + this.m_ActivationType + ")");
                    }
                } else {
                    throw new BusException("Trying to autoacivate Backend without specifying username/password");
                }
                s_logger.message("Connection : Server started by activation service, received buscomponent");
                s_logger.message("Connection : " + this.m_serverComponent.toString());
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                s_logger.message("Connection : No Activation information found in BusComponent, assuming it is running.");
                this.m_serverComponent = busComponent;
            }
            this.m_ServerComponentId = this.m_serverComponent.getIdentifier();
            this.m_messagePool = new MessagePool();
            this.m_correlator = new Correlator();
            this.m_middleware = new Middleware(this.m_clientComponent, this.m_messagePool);
            this.m_parser = new ParserThread(this.m_correlator, this.m_messagePool);
            this.m_parser.start();
            this.m_fysicalConnection = this.m_middleware.getConnected(uRI);
            s_logger.message("Connection : New Connection class");
        } else {
            s_logger.message("Trying to create an Connection without an BusComponent that is null");
        }
    }

    private synchronized BusComponent createClientcomponent(UserInfo userInfo, String string) throws BusException {
        Object object;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        BusComponent busComponent = null;
        String string5 = null;
        try {
            object = AdapterClientContext.getCurrent();
            string5 = ((AdapterClientConfiguration)object).getClientBusComponent();
        }
        catch (OWConfigurationException oWConfigurationException) {
            // empty catch block
        }
        s_logger.message("Connection : Creating buscomponent, properties are: bus.component = '" + string5 + "', protocol = '" + string + "'");
        if (string5 != null && !string5.equals("")) {
            try {
                s_logger.message("Connection, Client Component configured, trying to find it in the directory");
                object = new DirectoryServiceProvider().getDirectoryService();
                busComponent = object.retrieveBusComponent(string5);
                String string6 = new DOMWriter(busComponent.toDOM()).toString();
                busComponent = new BusComponent(string6);
            }
            catch (DirectoryException directoryException) {
                s_logger.message("Connection, error finding BusComponent '" + string5 + "' in the directory");
                throw new BusException(directoryException);
            }
        }
        s_logger.message("Connection, Client Component not configured, creating an 'anonymous' one");
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = "?";
        }
        string4 = userInfo != null ? userInfo.getUsername() : System.getProperty("user.name");
        string2 = string4 + "@" + string3 + "-" + Guid.createGuid();
        try {
            s_logger.message("Connection : Creating anonymous buscomponent -" + string2 + "- -" + string4 + "-");
            object = new DirectoryServiceProvider().getDirectoryService();
            busComponent = object.createAnonymousComponent(string2, string4, string);
        }
        catch (DirectoryException directoryException) {
            s_logger.message("Error in Creating anonymous buscomponent -" + string2 + "- -" + string4 + "-");
            s_logger.errorException(directoryException);
        }
        busComponent.isClientComponent(true);
        return busComponent;
    }

    public BusDoc sendAndWaitForAnswer(BusDoc busDoc, long l) throws BusException {
        BusDoc[] busDocArray;
        LogEvent logEvent = LoggerFactory.getLogEvent(busDoc.getHeader().getCorrelationId());
        logEvent.storeMessage("sending request, timeout = " + l + " ms.");
        Timer timer = null;
        timer = DefaultTimerFactory.newTimer("handle client request");
        s_logger.flowMessage("Connection: sendAndWaitForAnswer called");
        Waiter waiter = new Waiter(this.m_correlator, busDoc);
        try {
            busDoc.setReceiver(this.m_serverComponent);
            busDoc.setSender(this.m_clientComponent);
            if (this.m_UserInfo != null && this.bUserSetUserInfo) {
                busDoc.setUserInfo(this.m_UserInfo.getInternalObject());
            }
            if (this.m_LicenseInfo != null) {
                busDoc.setLicenseInfo(this.m_LicenseInfo);
            }
            logEvent.storeXml(busDoc);
            busDocArray = busDoc.toMessage();
            busDocArray.setITimer(timer);
            this.m_messagePool.setITimer(timer);
            if (s_logger.isInfoEnabled()) {
                s_logger.Xml(busDoc);
            }
            if (busDocArray.HasMessageDigest()) {
                s_logger.flowMessage("Adding message digest to busdoc");
                busDocArray.addMessageDigest();
            }
            logEvent.storeBytes(busDocArray.getText());
            this.m_fysicalConnection.send((Message)busDocArray);
        }
        catch (BusException busException) {
            logEvent.storeMessage(busException.getMessage());
            s_logger.errorEvent(logEvent);
            logEvent = null;
            throw busException;
        }
        try {
            busDocArray = waiter.suspend(l);
            timer.stop("reply handled");
            return busDocArray[0];
        }
        catch (BusTimeOutException busTimeOutException) {
            logEvent.storeMessage("Timeout in sendAndWaitForAnswer for " + busDoc.getHeader().getCorrelationId());
            s_logger.errorEvent(logEvent);
            logEvent = null;
            this.m_correlator.removeWaiter(busDoc);
            throw busTimeOutException;
        }
        catch (BusException busException) {
            logEvent.storeMessage("Error processing/constructing reply: " + busException.getMessage());
            s_logger.errorEvent(logEvent);
            logEvent = null;
            throw busException;
        }
    }

    public synchronized void close() throws BusException {
        s_logger.message("Connection close");
        if (this.m_ActivationType != null) {
            s_logger.message("Activation Type = " + this.m_ActivationType + ", using Activation Code to Deactivate the backend.");
            this.m_activationService.Deactivate(this);
        }
        if (this.m_middleware != null) {
            this.m_middleware.close();
        }
        this.m_middleware = null;
        if (this.m_parser != null) {
            this.m_parser.close();
        }
        this.m_parser = null;
        this.m_messagePool = null;
        this.m_fysicalConnection = null;
        this.m_activationService = null;
        this.m_UserInfo = null;
    }

    public String getServerComponentId() {
        return this.m_ServerComponentId;
    }

    public BusComponent getServerComponent() {
        return this.m_serverComponent;
    }

    public String toString() {
        return this.m_serverComponent.toString();
    }

    void setLicInfo(LicenseInfoCo licenseInfoCo) {
        this.m_LicenseInfo = licenseInfoCo;
    }

    public String sendControlMessage(String string, String string2, long l) throws BusException {
        s_logger.message("Send ContolMessage(" + string + ") to backend '" + this.getServerComponentId() + "'");
        BusDoc busDoc = this.m_factory.createBusDoc();
        Control control = this.m_factory.createControl();
        Action action = this.m_factory.createAction();
        control.setTypeIsRequestForAction();
        action.setActionParameter(string2);
        action.setActionType(string);
        control.setAction(action);
        busDoc.addCO(control);
        busDoc.setVersion(2);
        BusDoc busDoc2 = this.sendAndWaitForAnswer(busDoc, l);
        ProtocolErrors.seekAndThrowManagerExceptions(busDoc2);
        String string3 = busDoc2.getControl().getAction().getActionParameter();
        return string3;
    }
}

