/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1.metadata;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IIteratorMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3impl.boi1.metadata.BusinessObjectMetadata;
import com.baan.b3impl.boi1.metadata.IteratorMetadata;
import com.baan.b3impl.boi1.metadata.PrimalObjectMetadata;
import com.baan.b3impl.boi1.metadata.StringUtil;

class ParameterMetadata
implements IParameterMetadata {
    private static final String[] EMPTYDESCRIPTION = new String[0];
    private final String m_scope;
    private final String m_name;
    private final String m_typeName;
    private IObjectMetadata m_type = null;
    private final String[] m_description;

    ParameterMetadata(String string, String string2, String string3, String[] stringArray) throws IllegalArgumentException {
        this.checkScopeNameAndDescription(string, string2, stringArray);
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("p_typeName must be non-null with length > 0");
        }
        this.m_scope = string.intern();
        this.m_name = string2;
        this.m_typeName = string3;
        this.m_description = stringArray == null ? EMPTYDESCRIPTION : stringArray;
    }

    ParameterMetadata(String string, String string2, IObjectMetadata iObjectMetadata, String[] stringArray) throws IllegalArgumentException {
        this.checkScopeNameAndDescription(string, string2, stringArray);
        if (iObjectMetadata == null) {
            throw new IllegalArgumentException("p_type must be non-null");
        }
        this.m_scope = string.intern();
        this.m_name = string2;
        this.m_type = iObjectMetadata;
        this.m_typeName = iObjectMetadata.getTypeName();
        this.m_description = stringArray == null ? EMPTYDESCRIPTION : stringArray;
    }

    private void checkScopeNameAndDescription(String string, String string2, String[] stringArray) throws IllegalArgumentException {
        if (string == null || !string.equals(IParameterMetadata.SCOPE_IN) && !string.equals(IParameterMetadata.SCOPE_INOUT) && !string.equals(IParameterMetadata.SCOPE_OUT)) {
            throw new IllegalArgumentException("p_scope must be 'in', 'inout' or 'out'");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("p_name must be non-null with length > 0");
        }
        if (stringArray != null && ParameterMetadata.containsNulls(stringArray)) {
            throw new IllegalArgumentException("p_description must have non-null contents");
        }
    }

    private static boolean containsNulls(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getScope() {
        return this.m_scope;
    }

    public String getName() {
        return this.m_name;
    }

    public IObjectMetadata getType() throws RuntimeException {
        if (this.m_type == null) {
            this.m_type = MetadataUtil.getBusinessObjectMetadata(this.m_typeName);
        }
        return this.m_type;
    }

    public String[] getDescription() {
        String[] stringArray = new String[this.m_description.length];
        System.arraycopy(this.m_description, 0, stringArray, 0, this.m_description.length);
        return stringArray;
    }

    private void appendTypeString(StringBuffer stringBuffer) {
        IObjectMetadata iObjectMetadata = this.getType();
        if (iObjectMetadata instanceof IBusinessObjectMetadata) {
            IBusinessObjectMetadata iBusinessObjectMetadata = (IBusinessObjectMetadata)iObjectMetadata;
            BusinessObjectMetadata.appendTypeString(stringBuffer, iBusinessObjectMetadata);
        } else if (iObjectMetadata instanceof IPrimalObjectMetadata) {
            IPrimalObjectMetadata iPrimalObjectMetadata = (IPrimalObjectMetadata)iObjectMetadata;
            PrimalObjectMetadata.appendTypeString(stringBuffer, iPrimalObjectMetadata);
        } else if (iObjectMetadata instanceof IIteratorMetadata) {
            IIteratorMetadata iIteratorMetadata = (IIteratorMetadata)iObjectMetadata;
            IteratorMetadata.appendTypeString(stringBuffer, iIteratorMetadata);
        } else {
            stringBuffer.append("***ERROR***");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTypeString(stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(this.getName());
        String[] stringArray = this.getDescription();
        if (stringArray.length > 0) {
            stringBuffer.append("/*");
            StringUtil.appendDescription(stringBuffer, stringArray);
            stringBuffer.append("*/");
        }
        return stringBuffer.toString();
    }
}

