/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1.metadata;

import com.baan.b3.boi1.metadata.IMethodImplementationAdapter;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3impl.boi1.metadata.StringUtil;
import java.lang.reflect.InvocationTargetException;

abstract class MethodMetadata
implements IMethodMetadata {
    private static final String[] EMPTYDESCRIPTION = new String[0];
    private final String m_name;
    private final IParameterMetadata[] m_parameters;
    private final IParameterMetadata m_returnType;
    private final IMethodImplementationAdapter m_implementation;
    private final String[] m_description;

    MethodMetadata(String string, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, IMethodImplementationAdapter iMethodImplementationAdapter, String[] stringArray) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("p_name must be non-null with length > 0");
        }
        if (iParameterMetadataArray == null || MethodMetadata.containsNulls(iParameterMetadataArray)) {
            throw new IllegalArgumentException("p_parameters must be non-null with non-null contents");
        }
        if (iMethodImplementationAdapter == null) {
            throw new IllegalArgumentException("p_implementation must be non-null");
        }
        if (stringArray != null && MethodMetadata.containsNulls(stringArray)) {
            throw new IllegalArgumentException("p_description must have non-null contents");
        }
        this.m_name = string;
        this.m_parameters = iParameterMetadataArray;
        this.m_returnType = iParameterMetadata;
        this.m_implementation = iMethodImplementationAdapter;
        this.m_description = stringArray == null ? EMPTYDESCRIPTION : stringArray;
    }

    private static boolean containsNulls(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public IParameterMetadata[] getParameters() {
        IParameterMetadata[] iParameterMetadataArray = new IParameterMetadata[this.m_parameters.length];
        System.arraycopy(this.m_parameters, 0, iParameterMetadataArray, 0, this.m_parameters.length);
        return iParameterMetadataArray;
    }

    public IParameterMetadata getReturnType() {
        return this.m_returnType;
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
        return this.m_implementation.invoke(object, objectArray);
    }

    public Object invokeWithStrings(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
        return this.m_implementation.invokeWithStrings(object, objectArray);
    }

    public String[] getDescription() {
        String[] stringArray = new String[this.m_description.length];
        System.arraycopy(this.m_description, 0, stringArray, 0, this.m_description.length);
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_returnType == null) {
            stringBuffer.append("void");
        } else {
            stringBuffer.append(this.m_returnType);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.m_name);
        stringBuffer.append('(');
        int n = this.m_parameters.length;
        if (n > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m_parameters[0]);
        }
        int n2 = 1;
        while (n2 < this.m_parameters.length) {
            stringBuffer.append(", ");
            stringBuffer.append(this.m_parameters[n2]);
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(')');
        String[] stringArray = this.getDescription();
        if (stringArray.length > 0) {
            stringBuffer.append(" //");
            StringUtil.appendDescription(stringBuffer, stringArray);
        }
        return stringBuffer.toString();
    }
}

