/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1.metadata;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3impl.boi1.metadata.BusinessObjectMetadata;
import com.baan.b3impl.boi1.metadata.StringUtil;

class ManagerMetadata
implements IManagerMetadata {
    private static final String EMPTY_STRING = new String().intern();
    private static final String[] EMPTYDESCRIPTION = new String[0];
    private final String m_typeName;
    private final IManagerMethodMetadata[] m_methods;
    private final String[] m_managedObjectsTypeNames;
    private IBusinessObjectMetadata[] m_managedObjects = null;
    private final String[] m_description;

    ManagerMetadata(String string, IManagerMethodMetadata[] iManagerMethodMetadataArray, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("p_typeName must be non-null with length > 0");
        }
        if (iManagerMethodMetadataArray == null || this.containsNulls(iManagerMethodMetadataArray)) {
            throw new IllegalArgumentException("p_methods must be non-null with non-null contents");
        }
        if (stringArray == null || this.containsNulls(stringArray)) {
            throw new IllegalArgumentException("p_managedObjectsTypeNames must be non-null with non-null contents");
        }
        if (stringArray2 != null && this.containsNulls(stringArray2)) {
            throw new IllegalArgumentException("p_description must have non-null contents");
        }
        this.m_typeName = string;
        this.m_methods = iManagerMethodMetadataArray;
        this.m_managedObjectsTypeNames = stringArray;
        this.m_description = stringArray2 == null ? EMPTYDESCRIPTION : stringArray2;
    }

    private boolean containsNulls(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IMethodMetadata[] getMethods() {
        IMethodMetadata[] iMethodMetadataArray = new IManagerMethodMetadata[this.m_methods.length];
        System.arraycopy(this.m_methods, 0, iMethodMetadataArray, 0, this.m_methods.length);
        return iMethodMetadataArray;
    }

    public IManagerMethodMetadata[] getMethods2() {
        IManagerMethodMetadata[] iManagerMethodMetadataArray = new IManagerMethodMetadata[this.m_methods.length];
        System.arraycopy(this.m_methods, 0, iManagerMethodMetadataArray, 0, this.m_methods.length);
        return iManagerMethodMetadataArray;
    }

    public IBusinessObjectMetadata[] getManagedObjects() throws RuntimeException {
        if (this.m_managedObjects == null) {
            IBusinessObjectMetadata[] iBusinessObjectMetadataArray = new IBusinessObjectMetadata[this.m_managedObjectsTypeNames.length];
            int n = 0;
            while (n < this.m_managedObjectsTypeNames.length) {
                iBusinessObjectMetadataArray[n] = MetadataUtil.getBusinessObjectMetadata(this.m_managedObjectsTypeNames[n]);
                ++n;
            }
            this.m_managedObjects = iBusinessObjectMetadataArray;
        }
        return this.m_managedObjects;
    }

    public boolean isManagerOf(String string) {
        int n = 0;
        while (n < this.m_managedObjectsTypeNames.length) {
            if (this.m_managedObjectsTypeNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String[] getDescription() {
        String[] stringArray = new String[this.m_description.length];
        System.arraycopy(this.m_description, 0, stringArray, 0, this.m_description.length);
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BusinessObjectManager ");
        stringBuffer.append(this.getTypeName());
        stringBuffer.append('\n');
        String[] stringArray = this.getDescription();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\t//");
            StringUtil.appendEscapedString(stringBuffer, stringArray[n], EMPTY_STRING);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("{\n");
        IBusinessObjectMetadata[] iBusinessObjectMetadataArray = this.getManagedObjects();
        int n2 = 0;
        while (n2 < iBusinessObjectMetadataArray.length) {
            stringBuffer.append('\t');
            BusinessObjectMetadata.appendTypeString(stringBuffer, iBusinessObjectMetadataArray[n2]);
            stringBuffer.append('\n');
            ++n2;
        }
        stringBuffer.append('\n');
        int n3 = 0;
        while (n3 < this.m_methods.length) {
            stringBuffer.append("\t" + this.m_methods[n3] + "\n");
            ++n3;
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

