/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1.metadata;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IBusinessObjectMethodMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3impl.boi1.metadata.AbstractObjectMetadata;
import com.baan.b3impl.boi1.metadata.StringUtil;

class BusinessObjectMetadata
extends AbstractObjectMetadata
implements IBusinessObjectMetadata {
    private static final String EMPTY_STRING = new String().intern();
    private Class m_businessObjectClass;
    private final IMethodMetadata[] m_methods;
    private final IMemberMetadata[] m_members;
    private final String m_xmlDataType;

    BusinessObjectMetadata(String string, String string2, IBusinessObjectMethodMetadata[] iBusinessObjectMethodMetadataArray, IMemberMetadata[] iMemberMetadataArray, String[] stringArray, boolean bl) throws IllegalArgumentException {
        super(string, stringArray, bl);
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("p_xmlDataType must be non-null and length > 0");
        }
        if (iBusinessObjectMethodMetadataArray == null || AbstractObjectMetadata.containsNulls(iBusinessObjectMethodMetadataArray)) {
            throw new IllegalArgumentException("p_methods must be non-null with non-null contents");
        }
        if (iMemberMetadataArray == null || AbstractObjectMetadata.containsNulls(iMemberMetadataArray)) {
            throw new IllegalArgumentException("p_members must be non-null with non-null contents");
        }
        this.m_xmlDataType = string2;
        this.m_methods = iBusinessObjectMethodMetadataArray;
        this.m_members = iMemberMetadataArray;
    }

    public IMethodMetadata[] getMethods() {
        IMethodMetadata[] iMethodMetadataArray = new IBusinessObjectMethodMetadata[this.m_methods.length];
        System.arraycopy(this.m_methods, 0, iMethodMetadataArray, 0, this.m_methods.length);
        return iMethodMetadataArray;
    }

    public IBusinessObjectMethodMetadata[] getMethods2() {
        IBusinessObjectMethodMetadata[] iBusinessObjectMethodMetadataArray = new IBusinessObjectMethodMetadata[this.m_methods.length];
        System.arraycopy(this.m_methods, 0, iBusinessObjectMethodMetadataArray, 0, this.m_methods.length);
        return iBusinessObjectMethodMetadataArray;
    }

    public IMemberMetadata[] getMembers() {
        IMemberMetadata[] iMemberMetadataArray = new IMemberMetadata[this.m_members.length];
        System.arraycopy(this.m_members, 0, iMemberMetadataArray, 0, this.m_members.length);
        return iMemberMetadataArray;
    }

    public String getXmlDataType() {
        return this.m_xmlDataType;
    }

    public Object newInstance() {
        if (this.m_businessObjectClass == null) {
            try {
                this.m_businessObjectClass = Class.forName(this.getTypeName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("ClassNotFoundException: " + classNotFoundException.getMessage());
            }
        }
        try {
            return this.m_businessObjectClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException: " + illegalAccessException.getMessage());
        }
    }

    static void appendTypeString(StringBuffer stringBuffer, IBusinessObjectMetadata iBusinessObjectMetadata) {
        stringBuffer.append(iBusinessObjectMetadata.getTypeName());
        stringBuffer.append('<');
        stringBuffer.append(iBusinessObjectMetadata.getXmlDataType());
        stringBuffer.append('>');
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BusinessObject ");
        BusinessObjectMetadata.appendTypeString(stringBuffer, this);
        stringBuffer.append('\n');
        String[] stringArray = this.getDescription();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\t//");
            StringUtil.appendEscapedString(stringBuffer, stringArray[n], EMPTY_STRING);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("{\n");
        int n2 = 0;
        while (n2 < this.m_members.length) {
            stringBuffer.append("\t" + this.m_members[n2] + "\n");
            ++n2;
        }
        stringBuffer.append("\n");
        int n3 = 0;
        while (n3 < this.m_methods.length) {
            stringBuffer.append("\t" + this.m_methods[n3] + "\n");
            ++n3;
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

