/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1.metadata;

import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3impl.boi1.metadata.StringUtil;

abstract class AbstractMemberMetadata
implements IMemberMetadata {
    private static final String[] EMPTYDESCRIPTION = new String[0];
    private final String m_name;
    private final int m_cardinalityMin;
    private final int m_cardinalityMax;
    private final String[] m_description;
    private final boolean m_readOnly;
    private final boolean m_attribute;

    AbstractMemberMetadata(String string, int n, int n2, String[] stringArray, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("p_name must be non-null with length > 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("p_cardinalityMin must be 0 or greater");
        }
        if (n2 != -1 && (n2 < n || n2 < 1)) {
            throw new IllegalArgumentException("p_cardinalityMax must be greater than 0 and greater than or equal to p_cardinalityMin or equal to INFINITE_CARDINALITY");
        }
        if (stringArray != null && AbstractMemberMetadata.containsNulls(stringArray)) {
            throw new IllegalArgumentException("p_description must have non-null contents");
        }
        this.m_name = string;
        this.m_cardinalityMin = n;
        this.m_cardinalityMax = n2;
        this.m_readOnly = bl;
        this.m_attribute = bl2;
        this.m_description = stringArray == null ? EMPTYDESCRIPTION : stringArray;
    }

    private static boolean containsNulls(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public int getCardinalityMax() {
        return this.m_cardinalityMax;
    }

    public int getCardinalityMin() {
        return this.m_cardinalityMin;
    }

    public String[] getDescription() {
        String[] stringArray = new String[this.m_description.length];
        System.arraycopy(this.m_description, 0, stringArray, 0, this.m_description.length);
        return stringArray;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean isAttribute() {
        return this.m_attribute;
    }

    protected abstract void appendTypeString(StringBuffer var1);

    private void appendCardinalityString(StringBuffer stringBuffer) {
        stringBuffer.append("[" + this.m_cardinalityMin);
        if (this.m_cardinalityMin != this.m_cardinalityMax) {
            stringBuffer.append("..");
            if (this.m_cardinalityMax == -1) {
                stringBuffer.append("n");
            } else {
                stringBuffer.append(this.m_cardinalityMax);
            }
        }
        stringBuffer.append("]");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTypeString(stringBuffer);
        this.appendCardinalityString(stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(this.getName());
        String[] stringArray = this.getDescription();
        if (stringArray.length > 0) {
            stringBuffer.append(" //");
            StringUtil.appendDescription(stringBuffer, stringArray);
        }
        return stringBuffer.toString();
    }

    public abstract void setValue(Object var1, Object var2) throws IllegalArgumentException;

    public abstract Object getValue(Object var1) throws IllegalArgumentException;

    public abstract IObjectMetadata getType();
}

