/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1;

import com.baan.b3.boi1.IExceptionDescriptor;

public class ExceptionDescriptor
implements IExceptionDescriptor {
    private final boolean m_isError;
    private final String[] m_message;

    ExceptionDescriptor(boolean bl, String[] stringArray) throws NullPointerException, IllegalArgumentException {
        if (stringArray == null) {
            throw new NullPointerException("p_message must not be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("p_message must have length > 0");
        }
        this.m_isError = bl;
        this.m_message = stringArray;
    }

    public boolean isError() {
        return this.m_isError;
    }

    public boolean isWarning() {
        return !this.m_isError;
    }

    public String[] getMessage() {
        String[] stringArray = new String[this.m_message.length];
        System.arraycopy(this.m_message, 0, stringArray, 0, this.m_message.length);
        return stringArray;
    }

    protected StringBuffer toStringBuffer() {
        StringBuffer stringBuffer = this.m_isError ? new StringBuffer("Error: ") : new StringBuffer("Warning: ");
        stringBuffer.append(this.m_message[0]);
        int n = 1;
        while (n < this.m_message.length) {
            stringBuffer.append("\n").append(this.m_message[n]);
            ++n;
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }
}

