/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3impl.boi1;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.IBackend;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3impl.boi1.Toolkit;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.ConnectionFactory;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import java.util.StringTokenizer;

public class Backend
implements IBackend {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3impl.boi1", "Backend");
    private static long s_defaultTimeout = 60000L;
    private long m_Timeout = 0L;
    private IUserInfo m_userinfo = null;
    private String m_LicenseOverride = null;
    private String m_busComponentId = null;
    private ConnectionFactory m_ConnectionFactory = ConnectionFactory.getInstance();
    private Connection m_Connection = null;
    private boolean m_initialized = false;
    private boolean m_closed = false;
    public static final String ACTION_PING = "ping";
    public static final String ACTION_STATISTICS = "getstats";
    public static final String ACTION_DEACTIVATE = "deactivate";
    public static final String ACTION_TYPE_VERSION = "gettypeandversion";
    public static final String ACTION_RESET = "reset";
    public static final String LOG_PREFIX = "Backend: ";

    Backend(String string) {
        this.m_busComponentId = string;
        this.m_Timeout = s_defaultTimeout;
    }

    public void setUserInfo(IUserInfo iUserInfo) throws BoiException {
        if (this.m_initialized || this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already initialized, UserInfo needs to be set before first call."));
        }
        this.m_userinfo = iUserInfo;
    }

    public void setLicenseOverrideKey(String string) throws BoiException {
        if (this.m_initialized || this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already initialized, sLicenseOverrideKey needs to be set before first call."));
        }
        this.m_LicenseOverride = string;
    }

    public void setTimeout(long l) throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        this.m_Timeout = l;
    }

    public long getTimeout() throws BoiException {
        return this.m_Timeout;
    }

    public long ping() throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        if (!this.m_initialized) {
            this.Initialize();
        }
        try {
            long l = System.currentTimeMillis();
            this.sendControlMessage(ACTION_PING);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            s_logger.message("Backend: PING: Reply from '" + this.m_busComponentId + "' took " + l3 + " ms");
            return l3;
        }
        catch (BusException busException) {
            s_logger.message("Backend: Error pinging backend, " + busException.getMessage());
            throw Toolkit.getInstance().createBoiException(new BusException("Error pinging backend, " + busException.getMessage()));
        }
    }

    public void reset() throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        if (!this.m_initialized) {
            this.Initialize();
        }
        try {
            this.sendControlMessage(ACTION_RESET);
        }
        catch (BusException busException) {
            s_logger.message("Backend: Error resetting backend statistics, " + busException.getMessage());
            throw Toolkit.getInstance().createBoiException(new BusException("Error resetting backend statistics, " + busException.getMessage()));
        }
    }

    public IBackend.Statistics statistics() throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        if (!this.m_initialized) {
            this.Initialize();
        }
        try {
            String string = this.sendControlMessage(ACTION_STATISTICS);
            s_logger.message("Backend: STATISTICS from '" + this.m_busComponentId + "' returned " + string);
            IBackend.Statistics statistics = new IBackend.Statistics();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            int n = stringTokenizer.countTokens();
            if (n != 10) {
                s_logger.message("Backend: Error in data returned by server: " + string);
                throw Toolkit.getInstance().createBoiException(new BusException("Error in data returned by server: " + string));
            }
            String string2 = (String)stringTokenizer.nextElement();
            statistics.Total = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.Function = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.Query = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.Update = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.Control = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.BusErrors = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.ApplicationErrors = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.FatalErrors = Integer.parseInt(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.ProcessingTime = Long.parseLong(string2);
            string2 = (String)stringTokenizer.nextElement();
            statistics.RunningTime = Long.parseLong(string2);
            return statistics;
        }
        catch (BusException busException) {
            s_logger.message("Backend: Error retreiving statistics backend, " + busException.getMessage());
            throw Toolkit.getInstance().createBoiException(new BusException("Error retreiving statistics backend, " + busException.getMessage()));
        }
    }

    public void deactivate() throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        if (!this.m_initialized) {
            this.Initialize();
        }
        try {
            this.sendControlMessage(ACTION_DEACTIVATE);
        }
        catch (BusException busException) {
            s_logger.message("Backend: Error deactivation backend, " + busException.getMessage());
            throw Toolkit.getInstance().createBoiException(new BusException("Error deactivation backend, " + busException.getMessage()));
        }
    }

    private void Initialize() throws BoiException {
        if (this.m_userinfo != null) {
            s_logger.message("Backend: Initializing Backend interface for '" + this.m_busComponentId + "', with UserInfo set");
        } else {
            s_logger.message("Backend: Initializing Backend interface for '" + this.m_busComponentId + "', without UserInfo ");
        }
        try {
            if (this.m_Connection != null) {
                this.m_initialized = false;
                this.m_ConnectionFactory.releaseConnection(this.m_Connection);
                this.m_Connection.close();
            }
            if (this.m_ConnectionFactory.isBackendReference(this.m_busComponentId)) {
                UserSession userSession = null;
                if (this.m_LicenseOverride != null) {
                    userSession = new UserSession();
                    userSession.enableLicenseOverride(this.m_LicenseOverride);
                }
                this.m_Connection = this.m_ConnectionFactory.giveConnectionFromBackendReference(this.m_busComponentId, userSession);
                this.m_busComponentId = this.m_Connection.getServerComponentId();
            } else {
                this.m_Connection = this.m_ConnectionFactory.giveConnection(this.m_busComponentId, (UserInfo)this.m_userinfo);
            }
            this.m_initialized = true;
        }
        catch (BusException busException) {
            this.m_initialized = false;
            s_logger.message("Backend: Failed initializing Backend, " + busException.getMessage());
            throw Toolkit.getInstance().createBoiException(new BusException("Error Initializing, " + busException.getMessage()));
        }
    }

    public String getType() throws BoiException {
        if (this.m_closed) {
            throw Toolkit.getInstance().createBoiException(new BusException("Backend Object is already closed"));
        }
        if (!this.m_initialized) {
            this.Initialize();
        }
        try {
            String string = this.sendControlMessage(ACTION_TYPE_VERSION);
            s_logger.message("Backend: GetType: Reply from '" + this.m_busComponentId + "' = '" + string + "'");
            return string;
        }
        catch (BusException busException) {
            throw Toolkit.getInstance().createBoiException(new BusException("Error getting type from backend, " + busException.getMessage()));
        }
    }

    private String sendControlMessage(String string) throws BusException {
        return this.m_Connection.sendControlMessage(string, "", this.m_Timeout);
    }

    public void close() {
        block2: {
            s_logger.message("Backend: Close Connection");
            if (this.m_Connection == null) break block2;
            try {
                this.m_initialized = false;
                this.m_ConnectionFactory.releaseConnection(this.m_Connection);
                this.m_Connection.close();
                this.m_Connection = null;
                this.m_closed = true;
            }
            catch (BusException busException) {
                s_logger.message("Backend: Close Connection failed " + busException.toString());
            }
        }
    }

    protected void finalize() {
        if (!this.m_closed) {
            this.close();
        }
    }

    static {
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            s_defaultTimeout = adapterClientConfiguration.getTimeout();
        }
        catch (OWConfigurationException oWConfigurationException) {}
    }
}

