/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server.ui;

import com.baan.b3.server.ui.BaseServerUI;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CaptureOutput
extends PrintStream {
    static PrintStream oldStdout;
    static PrintStream oldStderr;
    static DefaultListModel m_listData;
    static JScrollPane m_listScroller;
    static JFrame m_jFrame;
    private static BaseServerUI m_parent;
    private static final String NEWLINE;
    private String writeString = null;

    private CaptureOutput(PrintStream printStream) {
        super(printStream);
    }

    public static void start(Image image, String string, BaseServerUI baseServerUI) {
        m_parent = baseServerUI;
        System.setOut(new CaptureOutput(System.out));
        System.setErr(new CaptureOutput(System.err));
        m_jFrame = new JFrame();
        ((Frame)m_jFrame).setIconImage(image);
        ((Component)m_jFrame).setSize(300, 300);
        m_jFrame.setTitle("Server for " + string + " Output");
        m_jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CaptureOutput.closeWindow();
            }
        });
        m_listData = new DefaultListModel();
        JList jList = new JList(m_listData);
        m_listScroller = new JScrollPane(jList);
        m_jFrame.getContentPane().add(m_listScroller);
    }

    private static void closeWindow() {
        m_parent.setCaptureOutputClosed();
    }

    public static void show(boolean bl) {
        if (bl) {
            m_jFrame.show();
        } else {
            m_jFrame.dispose();
        }
    }

    public void write(int n) {
        if (n == 10 || n == 13) {
            m_listData.addElement(this.writeString);
            m_listScroller.getVerticalScrollBar().setValue(m_listScroller.getVerticalScrollBar().getMaximum());
            this.writeString = null;
        } else {
            char c = (char)n;
            this.writeString = this.writeString == null ? "" + c : this.writeString + c;
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        String string = null;
        if (this.writeString != null) {
            string = this.writeString + new String(byArray, n, n2);
            this.writeString = null;
        } else {
            string = new String(byArray, n, n2);
        }
        if (!NEWLINE.equals(string)) {
            m_listData.addElement(new String(byArray, n, n2));
            m_listScroller.getVerticalScrollBar().setValue(m_listScroller.getVerticalScrollBar().getMaximum());
        }
    }

    static {
        m_parent = null;
        NEWLINE = System.getProperty("line.separator");
    }
}

