/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server.ui;

import com.baan.b3.legacydirectory.DirectoryException;
import com.baan.b3.legacydirectory.DirectoryToolkit;
import com.baan.b3.server.IServerRuntime;
import com.baan.b3.server.ui.BaseAbout;
import com.baan.b3.server.ui.CaptureOutput;
import com.baan.b3impl.about.IInstallationComponentInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;

public class BaseServerUI
extends JFrame {
    private static final String CATEGORY_ALL = "<All categories>";
    private static String s_cfgDir = null;
    private static String CFG = "ServerDialog";
    private LED m_ledStarted;
    private LED m_ledBusy;
    private IServerRuntime serverImpl = null;
    private int iErrors = 0;
    private int iCalls = 0;
    private int iServerId = 0;
    private String m_startedBusComponent = null;
    private static boolean bOutput = false;
    private boolean OutputEnabled = false;
    private boolean m_enabled = true;
    private boolean m_loading = false;
    private IInstallationComponentInfo m_componentInfo = null;
    private JButton ButtonAbout;
    private JButton ButtonExit;
    private JButton ButtonOutput;
    private JButton ButtonStart;
    private JButton ButtonStop;
    private JComboBox ComboCategories;
    private JComboBox ComboBusComponents;
    private JLabel LabelCalls;
    private JLabel LabelErrors;
    private JTextPane TextMessages;
    private JLabel _LabelCalls;
    private JLabel _LabelErrors;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;

    public void setServerResources(IInstallationComponentInfo iInstallationComponentInfo, String string, String string2, boolean bl) {
        this.m_componentInfo = iInstallationComponentInfo;
        String string3 = iInstallationComponentInfo.getComponentName();
        int n = string3.indexOf(" for ");
        if (n > 0) {
            string3 = string3.substring(n + 5);
        }
        this.setTitle("Server for " + string3);
        String string4 = System.getProperty("user.home");
        s_cfgDir = string4 + File.separatorChar + ".owconfig" + File.separatorChar + string3;
        CFG = s_cfgDir + File.separatorChar + CFG + ".history";
        Image image = null;
        this.OutputEnabled = bl;
        try {
            image = new ImageIcon(this.getClass().getResource(string)).getImage();
            ((Frame)this).setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.OutputEnabled) {
            CaptureOutput.start(image, string3, this);
        } else {
            this.remove(this.ButtonOutput);
        }
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(string2));
            this.jLabel2.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            this.jLabel2.setIcon(imageIcon);
        }
        catch (Exception exception) {
            this.jLabel2.setText("no picture");
        }
    }

    public BaseServerUI() {
        this.initComponents();
        this.TextMessages.setFont(this.jLabel1.getFont());
        this.ComboCategories.setFont(this.jLabel1.getFont());
        this.ComboBusComponents.setFont(this.jLabel1.getFont());
        this.TextMessages.setAutoscrolls(true);
        this.ButtonStart.setMnemonic('s');
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaseServerUI.this.exitServer();
            }
        });
        new LoadBusComponents(CATEGORY_ALL);
        this.m_ledStarted = new LED();
        this.m_ledBusy = new LED();
        this.getContentPane().add(this.m_ledStarted);
        this.m_ledStarted.setColor(Color.red);
        this.m_ledStarted.setBounds(204, 46, 14, 14);
        this.getContentPane().add(this.m_ledBusy);
        this.m_ledBusy.setBounds(204, 62, 14, 14);
        this.ButtonStop.setEnabled(false);
        ((Component)this).setSize(256, 367);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(dimension.getWidth() - (double)this.getWidth()) / 2;
        int n2 = (int)(dimension.getHeight() - (double)this.getHeight()) / 2;
        ((Component)this).setLocation(n, n2);
    }

    public void showFatalError(String string) {
        JOptionPane.showMessageDialog(this, string, "Fatal Error", 0);
    }

    private void exitServer() {
        if (this.serverImpl != null) {
            this.serverImpl.stopComponent(0);
            this.serverImpl.stopServerRuntime();
        }
        this.saveUI();
        System.exit(0);
    }

    public void startServerRuntime(IServerRuntime iServerRuntime) {
        this.serverImpl = iServerRuntime;
    }

    public void setInitError(String string) {
        this.m_enabled = false;
        this.TextMessages.setText(string);
        this.m_ledStarted.setColor(Color.red);
        this.ButtonStop.setEnabled(false);
        this.ButtonStart.setEnabled(false);
        this.ComboCategories.setEnabled(false);
        this.ComboBusComponents.setEnabled(false);
        this.m_enabled = false;
    }

    private void loadUI() {
        try {
            File file2 = new File(s_cfgDir);
            file2.mkdirs();
            FileInputStream fileInputStream = new FileInputStream(CFG);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            this.ComboBusComponents.setSelectedItem(object);
            objectInputStream.close();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void saveUI() {
        try {
            Object object = this.ComboBusComponents.getSelectedItem();
            if (object != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(CFG);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void dispatchstart() {
        this.m_ledBusy.setColor(Color.orange);
    }

    public void dispatchstop() {
        this.m_ledBusy.setColor(Color.black);
    }

    public void SetStats(boolean bl) {
        ++this.iCalls;
        if (!bl) {
            ++this.iErrors;
            this.LabelErrors.setText("" + this.iErrors);
        }
        this.LabelCalls.setText("" + this.iCalls);
    }

    public void output(String string) {
        this.TextMessages.setText(string);
    }

    public void error(String string) {
        this.TextMessages.setText(string);
        JOptionPane.showMessageDialog(this, string, "Server Error", 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ButtonStop = new JButton();
        this.ButtonStart = new JButton();
        this.ComboCategories = new JComboBox();
        this.ComboCategories.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ComboCategoriesActionPerformed(actionEvent);
            }
        });
        this.ComboBusComponents = new JComboBox();
        this._LabelCalls = new JLabel();
        this._LabelErrors = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.LabelCalls = new JLabel();
        this.LabelErrors = new JLabel();
        this.ButtonAbout = new JButton();
        this.ButtonExit = new JButton();
        this.TextMessages = new JTextPane();
        this.ButtonOutput = new JButton();
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(2);
        this.setTitle("-");
        ((Component)this).setBackground(Color.black);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaseServerUI.this.closeDialog(windowEvent);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Messages");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(12, 210, 80, 20);
        this.jLabel2.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 10, 120, 70);
        this.ButtonStop.setFont(new Font("Dialog", 0, 12));
        this.ButtonStop.setText("Stop");
        this.ButtonStop.setToolTipText("Stops selected BusComponent");
        this.ButtonStop.setEnabled(false);
        this.ButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ButtonStopActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonStop);
        this.ButtonStop.setBounds(170, 188, 70, 22);
        this.ButtonStart.setFont(new Font("Dialog", 0, 12));
        this.ButtonStart.setText("Start");
        this.ButtonStart.setToolTipText("Starts selected BusComponent");
        this.ButtonStart.setMargin(new Insets(2, 16, 2, 16));
        this.ButtonStart.setEnabled(false);
        this.ButtonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ButtonStartActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonStart);
        this.ButtonStart.setBounds(94, 188, 70, 22);
        this.ComboCategories.setToolTipText("BusComponent Category");
        this.ComboCategories.setRequestFocusEnabled(false);
        this.ComboCategories.setEnabled(false);
        this.getContentPane().add(this.ComboCategories);
        this.ComboCategories.setBounds(10, 110, 230, 20);
        this.ComboBusComponents.setToolTipText("BusComponent ID to start");
        this.ComboBusComponents.setRequestFocusEnabled(false);
        this.ComboBusComponents.setEnabled(false);
        this.getContentPane().add(this.ComboBusComponents);
        this.ComboBusComponents.setBounds(10, 160, 230, 20);
        this._LabelCalls.setFont(new Font("Dialog", 0, 12));
        this._LabelCalls.setText("Calls");
        this.getContentPane().add(this._LabelCalls);
        this._LabelCalls.setBounds(150, 10, 70, 16);
        this._LabelErrors.setFont(new Font("Dialog", 0, 12));
        this._LabelErrors.setText("Errors");
        this.getContentPane().add(this._LabelErrors);
        this._LabelErrors.setBounds(150, 26, 70, 16);
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        this.jLabel5.setText("Started");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(150, 42, 70, 16);
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        this.jLabel6.setText("Busy");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(150, 58, 70, 16);
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        this.jLabel7.setText("Select BusComponent Category:");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(12, 90, 230, 20);
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        this.jLabel8.setText("Select BusComponent:");
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(12, 140, 167, 20);
        this.LabelCalls.setFont(new Font("Dialog", 0, 12));
        this.LabelCalls.setHorizontalAlignment(0);
        this.LabelCalls.setText("0");
        this.getContentPane().add(this.LabelCalls);
        this.LabelCalls.setBounds(190, 10, 40, 16);
        this.LabelErrors.setFont(new Font("Dialog", 0, 12));
        this.LabelErrors.setHorizontalAlignment(0);
        this.LabelErrors.setText("0");
        this.getContentPane().add(this.LabelErrors);
        this.LabelErrors.setBounds(190, 26, 40, 16);
        this.ButtonAbout.setFont(new Font("Dialog", 0, 12));
        this.ButtonAbout.setText("About");
        this.ButtonAbout.setToolTipText("About this Server");
        this.ButtonAbout.setMargin(new Insets(2, 16, 2, 16));
        this.ButtonAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ButtonAboutActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonAbout);
        this.ButtonAbout.setBounds(95, 310, 70, 22);
        this.ButtonExit.setFont(new Font("Dialog", 0, 12));
        this.ButtonExit.setText("Exit");
        this.ButtonExit.setToolTipText("Exits this server");
        this.ButtonExit.setMargin(new Insets(2, 16, 2, 16));
        this.ButtonExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ButtonExitActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonExit);
        this.ButtonExit.setBounds(170, 310, 70, 22);
        this.TextMessages.setBackground(SystemColor.control);
        this.TextMessages.setBorder(new BevelBorder(1));
        this.TextMessages.setEditable(false);
        this.getContentPane().add(this.TextMessages);
        this.TextMessages.setBounds(10, 230, 230, 70);
        this.ButtonOutput.setFont(new Font("Dialog", 0, 12));
        this.ButtonOutput.setText("Show Output");
        this.ButtonOutput.setToolTipText("Show Server Output");
        this.ButtonOutput.setMargin(new Insets(2, 16, 2, 16));
        this.ButtonOutput.setName("ButtonOutput");
        this.ButtonOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseServerUI.this.ButtonOutputActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.ButtonOutput);
        this.ButtonOutput.setBounds(10, 310, 78, 22);
    }

    private void ButtonOutputActionPerformed(ActionEvent actionEvent) {
        bOutput = !bOutput;
        CaptureOutput.show(bOutput);
        if (bOutput) {
            this.ButtonOutput.setText("Close Output");
        } else {
            this.ButtonOutput.setText("Show Output");
        }
    }

    void setCaptureOutputClosed() {
        if (bOutput) {
            this.ButtonOutput.setText("Show Output");
            bOutput = false;
        }
    }

    private void ButtonAboutActionPerformed(ActionEvent actionEvent) {
        new BaseAbout(this, this.m_componentInfo, this.serverImpl, this.m_startedBusComponent).show();
    }

    private void ButtonExitActionPerformed(ActionEvent actionEvent) {
        this.exitServer();
    }

    private void ButtonStopActionPerformed(ActionEvent actionEvent) {
        this.serverImpl.stopComponent(this.iServerId);
        this.m_ledStarted.setColor(Color.red);
        this.TextMessages.setText("Server not running, select a BusComponent to start");
        this.ButtonStop.setEnabled(false);
        this.ButtonStart.setEnabled(true);
        this.m_startedBusComponent = null;
        this.ComboCategories.setEnabled(true);
        this.ComboBusComponents.setEnabled(true);
        this.iErrors = 0;
        this.iCalls = 0;
        this.LabelErrors.setText("" + this.iErrors);
        this.LabelCalls.setText("" + this.iCalls);
    }

    private void ButtonStartActionPerformed(ActionEvent actionEvent) {
        this.m_startedBusComponent = (String)this.ComboBusComponents.getSelectedItem();
        this.iServerId = this.serverImpl.startComponent(this.m_startedBusComponent);
        if (this.iServerId < 0) {
            this.TextMessages.setText("Error while starting '" + this.m_startedBusComponent + "', this BusComponent cannot be started on this machine.");
        } else {
            this.ButtonStop.setEnabled(true);
            this.ButtonStart.setEnabled(false);
            this.TextMessages.setText("Server for '" + this.m_startedBusComponent + "' running");
            this.m_ledStarted.setColor(Color.green);
            this.ComboCategories.setEnabled(false);
            this.ComboBusComponents.setEnabled(false);
        }
    }

    private void ComboCategoriesActionPerformed(ActionEvent actionEvent) {
        Object object = this.ComboCategories.getSelectedItem();
        String string = object.toString();
        if (!this.m_loading) {
            new LoadBusComponents(string);
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    static /* synthetic */ JTextPane access$1100(BaseServerUI baseServerUI) {
        return baseServerUI.TextMessages;
    }

    static /* synthetic */ JComboBox access$1200(BaseServerUI baseServerUI) {
        return baseServerUI.ComboCategories;
    }

    static /* synthetic */ JComboBox access$1400(BaseServerUI baseServerUI) {
        return baseServerUI.ComboBusComponents;
    }

    static /* synthetic */ boolean access$1500(BaseServerUI baseServerUI) {
        return baseServerUI.m_enabled;
    }

    static /* synthetic */ JButton access$1600(BaseServerUI baseServerUI) {
        return baseServerUI.ButtonStart;
    }

    static /* synthetic */ void access$1700(BaseServerUI baseServerUI) {
        baseServerUI.loadUI();
    }

    private class LoadBusComponents {
        private String m_category;

        public LoadBusComponents(String string) {
            BaseServerUI.this.m_loading = true;
            this.m_category = string;
            new Thread(new Runnable(this){
                private final /* synthetic */ LoadBusComponents this$1;
                {
                    this.this$1 = loadBusComponents;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block10: {
                        try {
                            try {
                                int n;
                                String[] stringArray;
                                BaseServerUI.access$1100(LoadBusComponents.access$1000(this.this$1)).setText("BusComponents are loading ...");
                                DirectoryToolkit directoryToolkit = DirectoryToolkit.getDefaultToolkit();
                                if (BaseServerUI.access$1200(LoadBusComponents.access$1000(this.this$1)).getItemCount() == 0) {
                                    BaseServerUI.access$1200(LoadBusComponents.access$1000(this.this$1)).addItem("<All categories>");
                                    stringArray = directoryToolkit.listAllBusComponentCategories();
                                    n = 0;
                                    while (n < stringArray.length) {
                                        BaseServerUI.access$1200(LoadBusComponents.access$1000(this.this$1)).addItem(stringArray[n]);
                                        ++n;
                                    }
                                }
                                stringArray = LoadBusComponents.access$1300(this.this$1).equals("<All categories>") ? directoryToolkit.listAllBusComponentIds() : directoryToolkit.listBusComponentIdsWithCategory(LoadBusComponents.access$1300(this.this$1));
                                BaseServerUI.access$1400(LoadBusComponents.access$1000(this.this$1)).removeAllItems();
                                n = 0;
                                while (true) {
                                    if (n >= stringArray.length) {
                                        if (BaseServerUI.access$1500(LoadBusComponents.access$1000(this.this$1))) {
                                            BaseServerUI.access$1400(LoadBusComponents.access$1000(this.this$1)).setEnabled(true);
                                            BaseServerUI.access$1200(LoadBusComponents.access$1000(this.this$1)).setEnabled(true);
                                            BaseServerUI.access$1600(LoadBusComponents.access$1000(this.this$1)).setEnabled(true);
                                            BaseServerUI.access$1700(LoadBusComponents.access$1000(this.this$1));
                                            BaseServerUI.access$1100(LoadBusComponents.access$1000(this.this$1)).setText("Server not running, select a BusComponent to start");
                                        }
                                        break;
                                    }
                                    BaseServerUI.access$1400(LoadBusComponents.access$1000(this.this$1)).addItem(stringArray[n]);
                                    ++n;
                                }
                            }
                            catch (DirectoryException directoryException) {
                                LoadBusComponents.access$1000(this.this$1).setInitError(directoryException.getMessage());
                                Object var5_6 = null;
                                BaseServerUI.access$902(LoadBusComponents.access$1000(this.this$1), false);
                                break block10;
                            }
                            Object var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            BaseServerUI.access$902(LoadBusComponents.access$1000(this.this$1), false);
                            throw throwable;
                        }
                        BaseServerUI.access$902(LoadBusComponents.access$1000(this.this$1), false);
                    }
                    LoadBusComponents.access$1000(this.this$1).setCursor(Cursor.getDefaultCursor());
                }
            }).start();
        }

        static /* synthetic */ BaseServerUI access$1000(LoadBusComponents loadBusComponents) {
            return loadBusComponents.BaseServerUI.this;
        }

        static /* synthetic */ String access$1300(LoadBusComponents loadBusComponents) {
            return loadBusComponents.m_category;
        }
    }

    private class LED
    extends JPanel {
        private Color m_color = Color.black;

        private LED() {
        }

        public void setColor(Color color) {
            this.m_color = color;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.m_color);
            graphics.fillOval(0, 0, 12, 12);
        }
    }
}

