/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server.connection;

import com.baan.b3.server.DatabaseException;
import com.baan.b3.server.IDBInformation;
import com.baan.b3.server.IDBParameterMetaData;
import com.baan.b3.server.IDBRowSet;
import com.baan.b3.server.IDBRowSetMetaData;
import com.baan.b3.server.ServerRuntimeInstance;
import com.baan.b3.server.connection.BusListenerImpl;
import com.baan.b3.server.connection.ControlHandler;
import com.baan.b3.server.ui.BaseServerUI;
import com.baan.owimpl.b3.database.Constructor;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.services.profiling.ITimer;

public class DatabaseHandler {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server.connection", "DatabaseHandler");
    private static final String LOG_PREFIX = "GENERIC SERVER: ";
    private BusListenerImpl m_busListener;
    private ControlHandler m_controlHandler;

    public DatabaseHandler(BusListenerImpl busListenerImpl, ControlHandler controlHandler) {
        this.m_busListener = busListenerImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleDataBaseConstructor(ServerRuntimeInstance serverRuntimeInstance, BusDoc busDoc, Constructor constructor, ITimer iTimer) {
        ++ControlHandler.STATE_NUM_SQL_CALLS;
        int n = constructor.getNrQuestions();
        BaseServerUI baseServerUI = serverRuntimeInstance.getServerDialog();
        DataSet dataSet = this.m_busListener.m_factory.createDataSet();
        if (baseServerUI != null) {
            baseServerUI.dispatchstart();
        }
        iTimer.split("Request");
        try {
            if (n != 1) throw new Exception("Cannot handle DataBase Constructor with " + n + " questions");
            int n2 = constructor.getQuestionType(0);
            switch (n2) {
                case 8: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Fetch some Rows");
                    String string = constructor.getStatementID(0);
                    int n3 = constructor.getFetchStartPos(0);
                    int n4 = constructor.getFetchNumberRows(0);
                    IDBRowSet iDBRowSet = serverRuntimeInstance.DB_fetchSet(string, n3, n4);
                    Data data = this.m_busListener.m_factory.createData();
                    data.addNodeData(iDBRowSet.getXMLData());
                    dataSet.addData(data);
                    break;
                }
                case 1: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Identify Database Implementation");
                    String string = serverRuntimeInstance.DB_productName();
                    String string2 = serverRuntimeInstance.DB_productVersion();
                    Data data = this.m_busListener.m_factory.createData();
                    Data data2 = this.m_busListener.m_factory.createData();
                    data.setStringData(string);
                    data2.setStringData(string2);
                    dataSet.addData(data);
                    dataSet.addData(data2);
                    s_logger.flowMessage("GENERIC SERVER: Server implementation returned '" + string + "', '" + string2 + "'");
                    break;
                }
                case 2: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question get resultSet MetaData");
                    String string = constructor.getStatementID(0);
                    IDBRowSetMetaData iDBRowSetMetaData = serverRuntimeInstance.DB_getRowSetMetaData(string);
                    Data data = this.m_busListener.m_factory.createData();
                    data.addNodeData(iDBRowSetMetaData.getXMLData());
                    dataSet.addData(data);
                    break;
                }
                case 10: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question get Database MetaData");
                    String string = constructor.getDataBaseMetaDataFunction(0);
                    String[] stringArray = constructor.getParameters(0);
                    IDBRowSet iDBRowSet = serverRuntimeInstance.DB_getDataBaseMeta(string, stringArray);
                    IDBRowSetMetaData iDBRowSetMetaData = serverRuntimeInstance.DB_getRowSetMetaData(string);
                    Data data = this.m_busListener.m_factory.createData();
                    Data data3 = this.m_busListener.m_factory.createData();
                    if (iDBRowSet == null || iDBRowSetMetaData == null) throw new Exception("Database MetaData function '" + string + "' returned no data");
                    data.addNodeData(iDBRowSet.getXMLData());
                    data3.addNodeData(iDBRowSetMetaData.getXMLData());
                    dataSet.addData(data);
                    dataSet.addData(data3);
                    break;
                }
                case 3: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Database Information");
                    IDBInformation iDBInformation = serverRuntimeInstance.DB_getDatabaseInformation();
                    Data data = this.m_busListener.m_factory.createData();
                    data.addNodeData(iDBInformation.getXMLData());
                    dataSet.addData(data);
                    break;
                }
                case 4: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Prepare Statement");
                    String string = constructor.getPrepareSQL(0);
                    String string3 = serverRuntimeInstance.DB_prepareStatement(string);
                    Data data = this.m_busListener.m_factory.createData();
                    data.setStringData(string3);
                    dataSet.addData(data);
                    break;
                }
                case 5: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Execute Statement");
                    String string = constructor.getStatementID(0);
                    String[] stringArray = constructor.getParameters(0);
                    String string4 = serverRuntimeInstance.DB_executeStatement(string, stringArray);
                    Data data = this.m_busListener.m_factory.createData();
                    data.setStringData(string4);
                    dataSet.addData(data);
                    break;
                }
                case 9: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Close Statement");
                    String string = constructor.getStatementID(0);
                    String string5 = serverRuntimeInstance.DB_closeStatement(string);
                    Data data = this.m_busListener.m_factory.createData();
                    data.setStringData(string5);
                    dataSet.addData(data);
                    break;
                }
                case 7: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question Reset Statement");
                    String string = constructor.getStatementID(0);
                    String string6 = serverRuntimeInstance.DB_resetStatement(string);
                    Data data = this.m_busListener.m_factory.createData();
                    data.setStringData(string6);
                    dataSet.addData(data);
                    break;
                }
                case 6: {
                    s_logger.flowMessage("GENERIC SERVER: Handle DB constructor for question get Parameter MetaData");
                    String string = constructor.getStatementID(0);
                    IDBParameterMetaData iDBParameterMetaData = serverRuntimeInstance.DB_getParameterMetaData(string);
                    Data data = this.m_busListener.m_factory.createData();
                    data.addNodeData(iDBParameterMetaData.getXMLData());
                    dataSet.addData(data);
                    break;
                }
                default: {
                    throw new Exception("GENERIC SERVER: Cannot handle Constructor " + constructor.toString());
                }
            }
            s_logger.flowMessage("GENERIC SERVER: Handling of Database Constructor finished");
            iTimer.split("DB");
            this.m_busListener.ReplyDataSet(busDoc, dataSet, iTimer);
            if (baseServerUI != null) {
                baseServerUI.dispatchstop();
                baseServerUI.SetStats(true);
            }
            if (iTimer == null) return;
            iTimer.stop();
            ControlHandler.STATE_TIME_PROCESSING += iTimer.getTotalTimePassed();
            return;
        }
        catch (DatabaseException databaseException) {
            if (baseServerUI != null) {
                baseServerUI.dispatchstop();
                baseServerUI.SetStats(false);
            }
            dataSet.setSQLError(databaseException.getSQLError());
            this.m_busListener.ReplyDataSet(busDoc, dataSet, iTimer);
            if (iTimer == null) return;
            iTimer.stop();
            return;
        }
        catch (Throwable throwable) {
            String string;
            if (baseServerUI != null) {
                baseServerUI.dispatchstop();
                baseServerUI.SetStats(false);
            }
            if ((string = throwable.getMessage()) == null) {
                string = "Error, " + throwable.toString();
            }
            s_logger.errorMessage("GENERIC SERVER: Fatal Database Model error, returning error to client '" + string.toString() + "'");
            this.m_busListener.ReplyErrorBusdoc(busDoc, string);
            if (iTimer == null) return;
            iTimer.stop();
        }
    }
}

