/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server.connection;

import com.baan.b3.server.ServerRuntimeInstance;
import com.baan.b3.server.connection.BusListenerImpl;
import com.baan.b3.server.ui.BaseServerUI;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.co.Action;
import com.eibus.co.BusDoc;
import com.eibus.co.Control;
import com.eibus.version.Version;
import java.util.Enumeration;
import java.util.Hashtable;

public class ControlHandler {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server.connection", "ControlHandler");
    private static final String LOG_PREFIX = "GENERIC SERVER: ";
    private BusListenerImpl m_busListener;
    private Hashtable m_serverImplHash = new Hashtable();
    private static int s_ServerImplCounter = 0;
    public static int STATE_NUM_TOTAL_CALLS = 0;
    public static int STATE_NUM_DLL_CALLS = 0;
    public static int STATE_NUM_SQL_CALLS = 0;
    public static int STATE_NUM_UPDATE_CALLS = 0;
    public static int STATE_NUM_CONTROL_CALLS = 0;
    public static int STATE_NUM_BUSERRORS = 0;
    public static int STATE_NUM_APPERRORS = 0;
    public static int STATE_NUM_FATALERRORS = 0;
    public static long STATE_TIME_STARTED = 0L;
    public static long STATE_TIME_PROCESSING = 0L;

    public ControlHandler(BusListenerImpl busListenerImpl) {
        this.m_busListener = busListenerImpl;
    }

    public void handleControlMessage(BusDoc busDoc, Control control) {
        ++STATE_NUM_CONTROL_CALLS;
        if (control.getTypeIsRequestForAction()) {
            Action action = control.getAction();
            String string = action.getActionType();
            if (string != null && string.equalsIgnoreCase(BackendConnection.CONTROLMESSAGE_CONNECTION_CREATE)) {
                BaseServerUI baseServerUI;
                s_logger.message(LOG_PREFIX + string + " message received");
                ServerRuntimeInstance serverRuntimeInstance = this.m_busListener.m_callBackObject.createServerRuntimeInstance();
                if (serverRuntimeInstance == null) {
                    s_logger.errorMessage("GENERIC SERVER: create Instance failed, Connection/Instance model not implemented in this backend");
                    this.m_busListener.ReplyErrorBusdoc(busDoc, "Server: Error, CreateConnection failed, Connection/Instance model not implemented in this backend");
                }
                if ((baseServerUI = serverRuntimeInstance.getServerDialog()) != null) {
                    baseServerUI.SetStats(true);
                }
                String string2 = action.getActionParameter();
                if (serverRuntimeInstance != null) {
                    String string3 = "" + (System.currentTimeMillis() + 1L);
                    String string4 = "" + s_ServerImplCounter++ + "-" + string3.substring(8, string3.length());
                    this.m_serverImplHash.put(string4, serverRuntimeInstance);
                    this.m_busListener.ReplyActionMessage(busDoc, string, string4);
                    s_logger.message("GENERIC SERVER: serverRuntimeInstance created with ID " + string4 + ", current # instances = " + this.m_serverImplHash.size());
                    s_logger.message("GENERIC SERVER: serverRuntimeInstance initializing");
                    try {
                        if (string2 == null || string2.length() == 0) {
                            serverRuntimeInstance.DB_initialize(-1, "");
                        }
                        char c = string2.charAt(0);
                        int n = Integer.parseInt("" + c);
                        string2 = string2.substring(1, string2.length());
                        serverRuntimeInstance.DB_initialize(n, string2);
                    }
                    catch (Throwable throwable) {
                        s_logger.message("GENERIC SERVER: error initializing, " + throwable.getMessage());
                        this.m_busListener.ReplyErrorBusdoc(busDoc, "Server: Error initializing ServerImpl instance, " + throwable.getMessage());
                    }
                } else {
                    this.m_busListener.ReplyErrorBusdoc(busDoc, "Server: Error Creating ServerImpl instance, BackendConnection Model not implemented");
                }
            } else if (string != null && string.equalsIgnoreCase(BackendConnection.CONTROLMESSAGE_CONNECTION_RELEASE)) {
                String string5 = action.getActionParameter();
                s_logger.message(LOG_PREFIX + string + " message received for ConnectionID " + string5);
                ServerRuntimeInstance serverRuntimeInstance = (ServerRuntimeInstance)this.m_serverImplHash.get("" + string5);
                Enumeration enumeration2 = this.m_serverImplHash.keys();
                while (enumeration2.hasMoreElements()) {
                    s_logger.message("Key =" + (String)enumeration2.nextElement());
                }
                if (serverRuntimeInstance != null) {
                    BaseServerUI baseServerUI = serverRuntimeInstance.getServerDialog();
                    if (baseServerUI != null) {
                        baseServerUI.SetStats(true);
                    }
                    this.m_busListener.m_callBackObject.releaseServerRuntimeInstance(serverRuntimeInstance);
                    this.m_serverImplHash.remove(string5);
                    this.m_busListener.ReplyActionMessage(busDoc, string, "Released " + string5);
                    s_logger.message("GENERIC SERVER: serverRuntimeInstance released with ID " + string5 + ", current # instances = " + this.m_serverImplHash.size());
                } else {
                    this.m_busListener.ReplyErrorBusdoc(busDoc, "Server: Error Releasing ServerImpl instance with ID " + string5);
                }
            } else if (string != null && string.equalsIgnoreCase("deactivate")) {
                s_logger.message("GENERIC SERVER: Stop message received, sending stop signal to the server implementation");
                this.m_busListener.ReplyActionMessage(busDoc, string, "");
                this.m_busListener.m_callBackObject.stopAndClose(2);
            } else if (string != null && string.equalsIgnoreCase("ping")) {
                s_logger.message("GENERIC SERVER: ping message received");
                this.m_busListener.ReplyActionMessage(busDoc, string, "");
            } else if (string != null && string.equalsIgnoreCase("gettypeandversion")) {
                s_logger.message("GENERIC SERVER: Request for Type and Version message received");
                String string6 = Version.getTypeAndVersion(this.m_busListener.m_ServerType);
                this.m_busListener.ReplyActionMessage(busDoc, string, string6);
            } else if (string != null && string.equalsIgnoreCase("reset")) {
                s_logger.message("GENERIC SERVER: Reset Statistics Control message received");
                STATE_NUM_TOTAL_CALLS = 0;
                STATE_NUM_DLL_CALLS = 0;
                STATE_NUM_SQL_CALLS = 0;
                STATE_NUM_UPDATE_CALLS = 0;
                STATE_NUM_CONTROL_CALLS = 0;
                STATE_NUM_BUSERRORS = 0;
                STATE_NUM_APPERRORS = 0;
                STATE_NUM_FATALERRORS = 0;
                STATE_TIME_PROCESSING = 0L;
                STATE_TIME_STARTED = System.currentTimeMillis();
                s_logger.message("GENERIC SERVER: Statistics were reset");
                this.m_busListener.ReplyActionMessage(busDoc, string, "");
            } else if (string != null && string.equalsIgnoreCase("getstats")) {
                s_logger.message("GENERIC SERVER: getStatistics Control message received");
                String string7 = STATE_NUM_TOTAL_CALLS + "#" + STATE_NUM_DLL_CALLS + "#" + STATE_NUM_SQL_CALLS + "#" + STATE_NUM_UPDATE_CALLS + "#" + STATE_NUM_CONTROL_CALLS + "#" + STATE_NUM_BUSERRORS + "#" + STATE_NUM_APPERRORS + "#" + STATE_NUM_FATALERRORS + "#" + STATE_TIME_PROCESSING + "#" + (System.currentTimeMillis() - STATE_TIME_STARTED);
                s_logger.message("GENERIC SERVER: Returning Statistics " + string7);
                this.m_busListener.ReplyActionMessage(busDoc, string, string7);
            } else {
                s_logger.errorMessage("GENERIC SERVER: Unknown Action Type '" + string + "' in Control Message");
                this.m_busListener.ReplyErrorBusdoc(busDoc, "Unknown Action Type '" + string + "' in Control Message");
            }
        }
    }

    public ServerRuntimeInstance getProcess(String string) {
        return (ServerRuntimeInstance)this.m_serverImplHash.get(string);
    }
}

