/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server.connection;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.server.DataReplyImpl;
import com.baan.b3.server.IDataReply;
import com.baan.b3.server.IParameter;
import com.baan.b3.server.IQuery;
import com.baan.b3.server.IServerRuntime;
import com.baan.b3.server.ParameterImpl;
import com.baan.b3.server.QueryImpl;
import com.baan.b3.server.ReturnParameterImpl;
import com.baan.b3.server.ServerRuntimeImpl;
import com.baan.b3.server.connection.ControlHandler;
import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.SAXParseException;
import com.baan.b3.xml.sax.helpers.ParserFactory;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.Action;
import com.eibus.co.BaanDLLCall;
import com.eibus.co.BaanSQLQuery;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.BusError;
import com.eibus.co.BusinessDataElement;
import com.eibus.co.BusinessElement;
import com.eibus.co.CommunicationObject;
import com.eibus.co.Control;
import com.eibus.co.DataSet;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.co.parser.EventDelegator;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.services.directory.URI;
import com.eibus.services.profiling.ITimer;
import com.eibus.xml.dom.ElementImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class BusListenerImpl
implements BusListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server.connection", "BusListenerImpl");
    public BusDocFactory m_factory = new BusDocFactoryImpl();
    public String m_ServerType;
    private static final int S_STARTED = 0;
    private static final int S_STOPPING = 1;
    private static final int S_STOPPED = 2;
    private static final String LOG_PREFIX = "GENERIC SERVER: ";
    private ControlHandler m_controlHandler = new ControlHandler(this);
    private static final boolean[][] IS_TRANSITION_POSSIBLE = new boolean[][]{{false, true, true}, {false, true, true}, {false, false, true}};
    private int m_state = 0;
    private boolean m_isProcessing = false;
    private final Object m_stateLock = new Object();
    private Parser m_saxEventGenerator = null;
    private EventDelegator m_saxEventHandler = null;
    public ServerRuntimeImpl m_callBackObject = null;
    private Middleware m_middleware = null;
    private boolean m_hasDefaultServerLicense = false;
    private Hashtable m_UserCache = new Hashtable();
    private ITimer m_timer = null;

    public BusListenerImpl(IServerRuntime iServerRuntime, String string) {
        this.m_callBackObject = (ServerRuntimeImpl)iServerRuntime;
        this.m_ServerType = string;
        try {
            this.m_saxEventGenerator = ParserFactory.makeParser();
            this.m_saxEventHandler = new EventDelegator();
            this.m_saxEventGenerator.setDocumentHandler(this.m_saxEventHandler);
            ControlHandler.STATE_TIME_STARTED = System.currentTimeMillis();
        }
        catch (Exception exception) {
            s_logger.errorMessage("GENERIC SERVER: BusListenerImpl: Initialize parser failed: " + exception);
        }
    }

    public void setDefaultLicense(boolean bl) {
        this.m_hasDefaultServerLicense = bl;
        s_logger.message("GENERIC SERVER: Default server License present = '" + this.m_hasDefaultServerLicense + "'");
    }

    public void setMiddleware(Middleware middleware) {
        this.m_middleware = middleware;
    }

    private void changeState(int n) {
        boolean[] blArray = null;
        try {
            blArray = IS_TRANSITION_POSSIBLE[this.m_state];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Unknown state (" + this.m_state + ") in " + this);
        }
        boolean bl = false;
        try {
            bl = blArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Bad state (" + this.m_state + ") in changeState() " + this);
        }
        if (bl) {
            if (this.m_state != n) {
                this.m_state = n;
                this.m_stateLock.notifyAll();
            }
        } else {
            throw new RuntimeException("Illegal state transition (" + this.stateToString(this.m_state) + " -> " + this.stateToString(n) + ") in " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.changeState(2);
        }
        this.m_controlHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInBackground() {
        Object object = this.m_stateLock;
        synchronized (object) {
            if (this.m_state == 2) {
                return;
            }
            if (this.m_isProcessing) {
                this.changeState(1);
            } else {
                this.changeState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStop(long l) {
        Object object = this.m_stateLock;
        synchronized (object) {
            if (l == 0L) {
                while (this.m_state != 2) {
                    try {
                        this.m_stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (this.m_state == 2) {
                return true;
            }
            try {
                this.m_stateLock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_state == 2;
        }
    }

    private String stateToString(int n) {
        switch (n) {
            case 0: {
                return "STARTED";
            }
            case 1: {
                return "STOPPING";
            }
            case 2: {
                return "STOPPED";
            }
        }
        return "UnknownState(" + n + ')';
    }

    /*
     * Exception decompiling
     */
    public void onReceive(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[TRYBLOCK]], but top level block is 54[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setITimer(ITimer iTimer) {
        this.m_timer = iTimer;
    }

    public ITimer getITimer() {
        return this.m_timer;
    }

    private void handleUpdateMessage(BusDoc busDoc) {
        ++ControlHandler.STATE_NUM_UPDATE_CALLS;
        s_logger.errorMessage("GENERIC SERVER: Error: Handling Update message");
        s_logger.errorMessage("GENERIC SERVER: Not implemented in generic server implementation");
        this.ReplyErrorBusdoc(busDoc, "Updates not supported, Data Model Updates not implemented");
    }

    private void handleBaanSQLConstructor(BusDoc busDoc, BaanSQLQuery baanSQLQuery, ITimer iTimer) {
        Object object;
        Object object2;
        Object object3;
        ++ControlHandler.STATE_NUM_SQL_CALLS;
        String string = null;
        DataSet dataSet = null;
        try {
            object3 = new QueryImpl(baanSQLQuery, null);
            object2 = this.m_callBackObject;
            ((ServerRuntimeImpl)object2).ResetTimer();
            if (iTimer != null) {
                iTimer.split("Request");
            }
            object = new DataReplyImpl(baanSQLQuery, this.m_factory);
            this.m_callBackObject.executeQuery((IDataReply)object, (IQuery)object3);
            dataSet = ((DataReplyImpl)object).getDataSet();
            if (iTimer != null) {
                iTimer.split("Query");
            }
        }
        catch (Exception exception) {
            string = exception.toString();
            s_logger.message("GENERIC SERVER: BusListenerImpl: executeQuery: " + string);
        }
        try {
            object3 = busDoc.createReply();
            object3.setVersion(busDoc.getVersion());
            if (string != null && !string.equals("")) {
                dataSet = this.m_factory.createDataSet();
                ++ControlHandler.STATE_NUM_BUSERRORS;
                object2 = this.m_factory.createError("error", null);
                object = this.m_factory.createBusinessDataElement(string);
                object2.appendChild((Node)object);
                object3.addCO((CommunicationObject)object2);
            } else {
                object3.addCO(dataSet);
            }
            this.send((BusDoc)object3, iTimer);
            if (iTimer != null) {
                iTimer.stop();
                ControlHandler.STATE_TIME_PROCESSING += iTimer.getTotalTimePassed();
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
        }
    }

    private void handleBaanDLLConstructor(BusDoc busDoc, BaanDLLCall baanDLLCall, ITimer iTimer) {
        Node node;
        Object object;
        BusinessElement businessElement;
        ++ControlHandler.STATE_NUM_DLL_CALLS;
        Tuple tuple = null;
        String string = null;
        String string2 = null;
        try {
            Element element;
            String string3;
            Object object2;
            businessElement = baanDLLCall.getParameters();
            object = new ParameterImpl[businessElement.getChildNodes().getLength()];
            node = businessElement.getFirstChild();
            int n = 0;
            while (node != null) {
                object[n++] = new ParameterImpl((Element)node);
                node = node.getNextSibling();
            }
            ReturnParameterImpl returnParameterImpl = null;
            String string4 = BusListenerImpl.getValidTagName(baanDLLCall.getMethodName());
            BusinessElement businessElement2 = baanDLLCall.getMethod();
            String string5 = businessElement2.getAttribute("scope");
            if (string5 != null && !string5.equals("")) {
                object2 = new ElementImpl(string4);
                ((ElementImpl)((Object)businessElement2)).copyAttributesInto((ElementImpl)object2);
                returnParameterImpl = new ReturnParameterImpl((Element)object2);
            }
            object2 = this.m_callBackObject;
            ((ServerRuntimeImpl)object2).ResetTimer();
            if (iTimer != null) {
                iTimer.split("to server app");
            }
            string = this.m_callBackObject.dispatch(baanDLLCall.getDLLName(), baanDLLCall.getMethodName(), (IParameter[])object, returnParameterImpl);
            if (iTimer != null) {
                iTimer.split("from server app");
            }
            if ((string3 = businessElement2.getAttribute("rt")) != null && !string3.equals("")) {
                string4 = string3;
            }
            BusinessElement businessElement3 = this.m_factory.createBusinessElement(string4);
            if (returnParameterImpl != null && (element = ((ParameterImpl)returnParameterImpl).getReturnData()) != null) {
                businessElement3.appendChild(element);
            }
            n = 0;
            while (n < ((Object)object).length) {
                if (object[n].getScope() != 1) {
                    element = ((ParameterImpl)object[n]).getReturnData();
                    businessElement3.appendChild(element);
                }
                ++n;
            }
            tuple = this.m_factory.createTuple();
            tuple.setCurrent(null);
            tuple.setOriginal(businessElement3);
        }
        catch (Exception exception) {
            string2 = exception.toString();
            s_logger.flowMessage("GENERIC SERVER: BusListenerImpl: dispatch: " + string2);
        }
        try {
            businessElement = this.m_factory.createDataSet();
            if (string != null && !string.equals("")) {
                ++ControlHandler.STATE_NUM_APPERRORS;
                object = this.m_factory.createBusinessElement("error");
                node = this.m_factory.createBusinessDataElement(string);
                object.appendChild(node);
                businessElement.appendChild((Node)object);
            } else if (tuple != null) {
                businessElement.addTuple(tuple);
            }
            object = busDoc.createReply();
            object.setVersion(busDoc.getVersion());
            object.addCO((CommunicationObject)businessElement);
            if (string2 != null && !string2.equals("")) {
                ++ControlHandler.STATE_NUM_BUSERRORS;
                node = this.m_factory.createError("error", null);
                BusinessDataElement businessDataElement = this.m_factory.createBusinessDataElement(string2);
                node.appendChild(businessDataElement);
                object.addCO((CommunicationObject)node);
            }
            this.send((BusDoc)object, iTimer);
            if (iTimer != null) {
                iTimer.stop();
                ControlHandler.STATE_TIME_PROCESSING += iTimer.getTotalTimePassed();
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
        }
    }

    public void ReplyDataSet(BusDoc busDoc, DataSet dataSet, ITimer iTimer) {
        try {
            BusDoc busDoc2 = busDoc.createReply();
            busDoc2.setVersion(busDoc.getVersion());
            busDoc2.addCO(dataSet);
            this.send(busDoc2, iTimer);
        }
        catch (BusException busException) {
            s_logger.message("GENERIC SERVER: Error Sending reply " + busException.toString());
        }
    }

    public void ReplyActionMessage(BusDoc busDoc, String string, String string2) {
        try {
            BusDoc busDoc2 = busDoc.createReply();
            busDoc2.setVersion(busDoc.getVersion());
            Control control = this.m_factory.createControl();
            control.setTypeIsReplyOnAction();
            Action action = this.m_factory.createAction();
            action.setActionType(string);
            action.setActionParameter(string2);
            control.setAction(action);
            busDoc2.addCO(control);
            this.send(busDoc2, null);
        }
        catch (BusException busException) {
            s_logger.message("GENERIC SERVER: Error Sending reply " + busException.toString());
        }
    }

    public void ReplyErrorBusdoc(BusDoc busDoc, String string) {
        ++ControlHandler.STATE_NUM_FATALERRORS;
        try {
            BusDoc busDoc2 = busDoc.createReply();
            busDoc2.setVersion(busDoc.getVersion());
            BusError busError = this.m_factory.createError("error", null);
            BusinessDataElement businessDataElement = this.m_factory.createBusinessDataElement(string);
            busError.appendChild(businessDataElement);
            busDoc2.addCO(busError);
            this.send(busDoc2, null);
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusDoc parse(Message message) throws BusException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (message.HasMessageDigest() && !message.CheckMessageDigest()) {
                BusException busException = new BusException("GENERIC SERVER: Wrong Message Digest, message ignored !!");
                s_logger.errorException(busException);
                throw busException;
            }
            this.m_saxEventHandler.reset();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message.getText());
            InputSource inputSource = new InputSource(byteArrayInputStream);
            try {
                this.m_saxEventGenerator.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                BusException busException = new BusException(sAXParseException.toString() + " at (line, col): (" + sAXParseException.getLineNumber() + ", " + sAXParseException.getColumnNumber() + ")");
                s_logger.errorException(busException);
                throw busException;
            }
            catch (SAXException sAXException) {
                BusException busException = new BusException(sAXException.toString());
                s_logger.errorException(busException);
                throw busException;
            }
            catch (IOException iOException) {
                BusException busException = new BusException(iOException.toString());
                s_logger.errorException(busException);
                throw busException;
            }
            return this.m_saxEventHandler.getBusDoc();
        }
    }

    private void send(BusDoc busDoc, ITimer iTimer) throws BusException {
        s_logger.Xml(busDoc);
        Message message = busDoc.toMessage();
        message.setITimer(iTimer);
        URI uRI = busDoc.getHeader().getReceiver().getSentTo();
        IConnection iConnection = this.m_middleware.getConnected(uRI);
        message.setURI(uRI);
        if (message.HasMessageDigest()) {
            message.addMessageDigest();
        }
        iConnection.send(message);
    }

    private static String getValidTagName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                stringBuffer.setCharAt(n, '_');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + this.stateToString(this.m_state);
    }
}

