/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server;

import com.baan.b3.server.IDataReply;
import com.baan.b3.server.IParameter;
import com.baan.b3.server.IQuery;
import com.baan.b3.server.IServerApplicationCallBack;
import com.baan.b3.server.IServerRuntime;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3.server.ServerException;
import com.baan.b3.server.ServerLicenseException;
import com.baan.b3.server.ServerRuntimeInstance;
import com.baan.b3.server.connection.BusListenerImpl;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessObjectRegistration;
import com.eibus.co.dom.LicenseInfoCoImpl;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.services.activation.IActivationCallBack;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ServerRuntimeImpl
implements IServerRuntime,
LicenseListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server", "ServerRuntimeImpl");
    public static final int STOP_SERVER_TIMEOUT = 1;
    public static final int STOP_CLIENT_MESSAGE = 2;
    private Directory m_directory;
    private boolean m_initialized;
    private boolean m_enableStopAndClose;
    private Hashtable s_startedBusComponents;
    private Hashtable s_startedConnections;
    private int s_connectionId;
    private Timer m_Timer;
    private ILicense m_defaultLicense;
    private boolean m_LicenseOverride;
    private String m_ServerType;
    private IActivationCallBack m_ActivationCallBack;
    private IServerApplicationCallBack m_serverApplicationCallBack;
    private ApplicationCallBackThread m_applicationCallBackThread;

    public ServerRuntimeImpl(int n, String string) throws ServerLicenseException {
        this(null, n, string, false);
    }

    public ServerRuntimeImpl(IServerApplicationCallBack iServerApplicationCallBack, int n, String string, boolean bl) throws ServerLicenseException {
        block12: {
            this.m_directory = null;
            this.m_initialized = false;
            this.m_enableStopAndClose = false;
            this.s_startedBusComponents = new Hashtable();
            this.s_startedConnections = new Hashtable();
            this.s_connectionId = 1;
            this.m_Timer = null;
            this.m_defaultLicense = null;
            this.m_LicenseOverride = false;
            this.m_ServerType = "Generic";
            this.m_ActivationCallBack = null;
            this.m_serverApplicationCallBack = null;
            this.m_applicationCallBackThread = null;
            this.m_serverApplicationCallBack = iServerApplicationCallBack;
            this.m_ServerType = string;
            this.m_LicenseOverride = bl;
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Constructing ServerRuntimeImpl (License Override = '" + bl + "')");
            try {
                if (n == -795243658) {
                    this.m_defaultLicense = LicenseFactory.createDummyLicense(0, "dummyUser", "dummyHost");
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: DummyLicense used");
                } else {
                    String string2 = "";
                    int n2 = 0;
                    this.m_defaultLicense = LicenseFactory.createServerLicense(n, string);
                    this.m_defaultLicense.addLicenseListener(this);
                    n2 = this.m_defaultLicense.getDaysLeft();
                    string2 = this.m_defaultLicense.getMessage();
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: " + string2);
                    if (iServerApplicationCallBack != null) {
                        if (n2 == -1) {
                            iServerApplicationCallBack.error(string2);
                            throw new ServerLicenseException(string2);
                        }
                        if (n2 <= 14) {
                            iServerApplicationCallBack.output(string2);
                        }
                    } else if (iServerApplicationCallBack == null && n2 == -1) {
                        throw new ServerLicenseException(string2);
                    }
                }
            }
            catch (LicenseException licenseException) {
                if (bl) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Running in License Override mode");
                }
                if (bl) break block12;
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Initialization of License failed: " + licenseException);
                throw new ServerLicenseException(licenseException.toString());
            }
        }
        try {
            this.m_directory = new DirectoryServiceProvider().getDirectoryService();
            this.m_initialized = true;
        }
        catch (DirectoryException directoryException) {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Initialization of Directory failed: " + directoryException);
            this.m_initialized = false;
        }
    }

    public void finalize() {
        this.stopServerRuntime();
    }

    public void stopServerRuntime() {
        if (this.m_initialized) {
            this.StopServer();
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: StopServerRuntime called");
            while (this.s_startedBusComponents.size() != 0) {
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: There are still Started components.");
                Enumeration enumeration2 = this.s_startedBusComponents.keys();
                while (enumeration2.hasMoreElements()) {
                    Integer n = (Integer)enumeration2.nextElement();
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stopping Component with ID '" + n + "'");
                    this.stopComponent(n);
                }
            }
            if (this.m_defaultLicense != null) {
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Releasing the license");
                if (this.m_defaultLicense != null) {
                    this.m_defaultLicense.removeLicenseListener(this);
                    this.m_defaultLicense.release();
                }
                LicenseInfoCoImpl.releaseOverrideLicenses();
                this.m_initialized = false;
            }
        }
    }

    public String getLicenseHost() {
        if (this.m_defaultLicense != null) {
            return this.m_defaultLicense.getHostName();
        }
        return "No valid license";
    }

    public String getLicenseExpirationDate() {
        if (this.m_defaultLicense != null) {
            return this.m_defaultLicense.getFormattedExpirationDate();
        }
        return "No valid license";
    }

    public String getLicenseUser() {
        if (this.m_defaultLicense != null) {
            return this.m_defaultLicense.getUserName();
        }
        return "No valid license";
    }

    public boolean hasValidLicense() {
        return this.m_defaultLicense != null && this.m_defaultLicense.getDaysLeft() >= 0;
    }

    public int getLicenseDaysLeft() {
        if (this.m_defaultLicense != null) {
            return this.m_defaultLicense.getDaysLeft();
        }
        return -1;
    }

    public int startComponent(String string) {
        int n = -1;
        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: startComponent called for " + string);
        if (this.m_initialized) {
            try {
                BusComponent busComponent = this.m_directory.retrieveBusComponent(string);
                if (this.s_startedBusComponents.contains(busComponent)) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Connection for " + string + " already exists");
                    BusException busException = new BusException("Connection already exists");
                    s_logger.errorException(busException);
                    throw busException;
                }
                BusListenerImpl busListenerImpl = new BusListenerImpl(this, this.m_ServerType);
                busListenerImpl.setDefaultLicense(this.hasValidLicense());
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Now opening connections for " + busComponent.getIdentifier());
                Middleware middleware = new Middleware(busComponent, busListenerImpl);
                busListenerImpl.setMiddleware(middleware);
                n = this.s_connectionId++;
                this.s_startedBusComponents.put(new Integer(n), busComponent);
                this.s_startedConnections.put(new Integer(n), middleware);
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Constructed connection for " + string + " with id " + n);
            }
            catch (BusException busException) {
                s_logger.errorMessage("GENERIC SERVER: ServerRuntimeImpl: Failed to start connection for " + string + ": " + busException);
            }
        } else {
            s_logger.errorMessage("GENERIC SERVER: ServerRuntimeImpl: startComponent failed: Directory not initialized");
        }
        return n;
    }

    public int startActivationComponent(String string, ServerActivationCallBack serverActivationCallBack) {
        int n;
        block10: {
            this.m_ActivationCallBack = (IActivationCallBack)((Object)serverActivationCallBack);
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: startComponent called, starting server with Activation " + this.m_ActivationCallBack.getActivationType());
            n = -1;
            if (this.m_initialized) {
                try {
                    BusComponent busComponent = this.m_directory.retrieveBusComponent(string);
                    if (busComponent != null) {
                        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: BusComponent found in the Directory");
                        String string2 = "720";
                        Activation activation = busComponent.getActivation();
                        if (activation != null) {
                            string2 = activation.getServerTimeout();
                        }
                        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: BusComponent Id   = '" + string + "'");
                        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: timeout (minutes) = '" + string2 + "'");
                        BusListenerImpl busListenerImpl = new BusListenerImpl(this, this.m_ServerType);
                        busListenerImpl.setDefaultLicense(this.hasValidLicense());
                        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: Now opening connections for " + busComponent.getIdentifier());
                        Middleware middleware = new Middleware(busComponent, busListenerImpl);
                        busListenerImpl.setMiddleware(middleware);
                        n = this.s_connectionId++;
                        this.s_startedBusComponents.put(new Integer(n), busComponent);
                        this.s_startedConnections.put(new Integer(n), middleware);
                        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Constructed connection for " + string + " with id " + n);
                        this.m_ActivationCallBack.setBusComponent(busComponent);
                        String string3 = this.m_ActivationCallBack.getActivationType();
                        if (string3.equalsIgnoreCase("asm")) {
                            this.m_ActivationCallBack.returnBusComponent();
                        }
                        if (string3.equalsIgnoreCase("programmatic")) break block10;
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.m_Timer = new Timer(this, n2);
                        s_logger.message("GENERIC SERVER: ServerTimeout timer started, timeout = " + n2);
                        break block10;
                    }
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: BusComponent not found in the Directory, stopping");
                    return -1;
                }
                catch (DirectoryException directoryException) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Failed to connect to the Directory, " + directoryException);
                    return -1;
                }
                catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: BusComponent does not contain Activation info" + string + ": " + attributeNotSpecifiedException);
                    return -1;
                }
                catch (BusException busException) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Failed to start connection for " + string + ": " + busException);
                    return -1;
                }
            }
        }
        return n;
    }

    public boolean stopComponent(int n) {
        boolean bl;
        block4: {
            bl = false;
            s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: stopComponent called for id " + n);
            try {
                Middleware middleware = (Middleware)this.s_startedConnections.remove(new Integer(n));
                if (middleware != null) {
                    BusComponent busComponent = (BusComponent)this.s_startedBusComponents.remove(new Integer(n));
                    BusListenerImpl busListenerImpl = (BusListenerImpl)middleware.getBusListener();
                    if (this.m_Timer != null) {
                        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: Stopping the timeout timer");
                        this.m_Timer.setFinish();
                        this.m_Timer.interrupt();
                        this.m_Timer = null;
                    }
                    bl = true;
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stopped connection for " + busComponent.getIdentifier());
                    middleware.close();
                    busListenerImpl.stop();
                    break block4;
                }
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Cannot find connection for id " + n);
            }
            catch (BusException busException) {
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Failed to stop connection for " + n + ": " + busException);
            }
        }
        return bl;
    }

    public void finishComponentInBackground(int n) {
        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: finishComponentInBackground called for id " + n);
        Integer n2 = new Integer(n);
        Middleware middleware = (Middleware)this.s_startedConnections.get(n2);
        if (middleware != null) {
            BusComponent busComponent = (BusComponent)this.s_startedBusComponents.get(n2);
            BusListenerImpl busListenerImpl = (BusListenerImpl)middleware.getBusListener();
            busListenerImpl.stopInBackground();
            new ComponentStopper(busListenerImpl, n2);
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stopping connection for " + busComponent.getIdentifier());
        } else {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Cannot find connection for id " + n2);
        }
    }

    public boolean waitForFinish(int n, long l) {
        Middleware middleware = (Middleware)this.s_startedConnections.get(new Integer(n));
        if (middleware != null) {
            BusListenerImpl busListenerImpl = (BusListenerImpl)middleware.getBusListener();
            return busListenerImpl.waitForStop(l);
        }
        return true;
    }

    public void enableDeactivation() {
        this.m_enableStopAndClose = true;
    }

    public void stopAndClose(int n) {
        if (n == 1) {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: 'stopAndClose' called, reason = timeout");
        } else if (n == 2) {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: 'stopAndClose' called, reason = stop message from client");
        } else {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: 'stopAndClose' called, reason = unknown");
        }
        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stoping Server runtime");
        if (this.m_ActivationCallBack != null) {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Calling 'stopServer' functionlity of ActivationCallback");
            this.stopServerRuntime();
            this.m_ActivationCallBack.stopServer();
        } else {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: ActivationCallback is null, cannot send stop request to Activation implementation");
            if (this.m_enableStopAndClose) {
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Deactivation is enabled, trying to stop server");
                this.stopServerRuntime();
                s_logger.message("GENERIC SERVER: Stopping java VM");
                System.exit(0);
            } else {
                s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Deactivation is not enabled by this server, ignoring the stop message");
            }
        }
    }

    public void ResetTimer() {
        if (this.m_Timer != null) {
            this.m_Timer.resetTimer();
        }
    }

    void timeExpired() {
        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: Server Timeout has occured, stopping...");
        this.stopAndClose(1);
    }

    public static boolean registerBusinessObject(String string) {
        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: register Business Object " + string);
        try {
            Class<?> clazz = Class.forName(string);
            BusinessObjectRegistration.register(clazz);
            return true;
        }
        catch (Exception exception) {
            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: register Business Object failed: " + exception);
            return false;
        }
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        ILicense iLicense = licenseEvent.getLicense();
        int n = licenseEvent.getReason();
        String string = licenseEvent.getMessage();
        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: " + string);
        try {
            String string2 = "";
            boolean bl = true;
            switch (n) {
                case 2: {
                    string2 = "output";
                    bl = true;
                    break;
                }
                case 1: 
                case 4: {
                    string2 = "error";
                    bl = false;
                    break;
                }
                case 3: {
                    string2 = "output";
                }
            }
            if (n != 3) {
                Enumeration enumeration2 = this.s_startedConnections.elements();
                while (enumeration2.hasMoreElements()) {
                    Middleware middleware = (Middleware)enumeration2.nextElement();
                    if (middleware == null) continue;
                    BusListenerImpl busListenerImpl = (BusListenerImpl)middleware.getBusListener();
                    busListenerImpl.setDefaultLicense(bl);
                }
            }
            if (this.m_serverApplicationCallBack != null) {
                new ApplicationCallBackThread(this.m_serverApplicationCallBack, string2, new Object[]{string});
            }
        }
        catch (Exception exception) {}
    }

    public String dispatch(String string, String string2, IParameter[] iParameterArray, IParameter iParameter) throws ServerException {
        s_logger.flowMessage("GENERIC SERVER: ServerRuntimeImpl: Default implementation of function 'dispatch' called, make sure you implement it in your server specific code");
        throw new ServerException("GENERIC SERVER: ServerRuntimeImpl: Default implementation of function 'dispatch' called, Function Model not implemented in this Server");
    }

    public void executeQuery(IDataReply iDataReply, IQuery iQuery) throws ServerException {
        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Default implementation of function 'executeQuery' called, Data (Receive) Model not implemented in this Server");
        throw new ServerException("GENERIC SERVER: ServerRuntimeImpl: Default implementation of function 'executeQuery' called, Data (Receive) Model not implemented in this Server");
    }

    public boolean checkUserIdentity(String string, String string2) {
        s_logger.message("GENERIC SERVER: Default implementation of function 'checkUserPassword' called, you can also implement it in your server specific code");
        return true;
    }

    public ServerRuntimeInstance createServerRuntimeInstance() {
        s_logger.message("GENERIC SERVER: createNewServerImplInstance: Backend Connection Model not implemented");
        return null;
    }

    public void releaseServerRuntimeInstance(ServerRuntimeInstance serverRuntimeInstance) {
        s_logger.message("GENERIC SERVER: releaseServerImplInstance: Backend Connection Model not implemented");
    }

    public void StopServer() {
        s_logger.message("GENERIC SERVER: Default implementation of StopServer, server specific method not implemented");
    }

    private class ApplicationCallBackThread
    extends Thread {
        private IServerApplicationCallBack m_callback_obj;
        private Method m_callback_method;
        private Object[] m_callback_args;

        public ApplicationCallBackThread(IServerApplicationCallBack iServerApplicationCallBack, String string, Object[] objectArray) {
            try {
                this.m_callback_obj = iServerApplicationCallBack;
                this.m_callback_method = iServerApplicationCallBack.getClass().getMethod(string, Class.forName("java.lang.String"));
                this.m_callback_args = objectArray;
                this.setName("ApplicationCallBackThread Thread");
                this.start();
            }
            catch (Exception exception) {}
        }

        public void run() {
            try {
                this.m_callback_method.invoke((Object)this.m_callback_obj, this.m_callback_args);
            }
            catch (Exception exception) {}
        }
    }

    private class Timer
    extends Thread {
        private ServerRuntimeImpl m_f;
        private int m_time;
        private volatile boolean m_finish;

        public Timer(ServerRuntimeImpl serverRuntimeImpl2, int n) {
            this.m_f = serverRuntimeImpl2;
            this.m_time = n;
            this.m_finish = false;
            this.start();
        }

        public void resetTimer() {
            this.interrupt();
        }

        public void setFinish() {
            s_logger.message("setFinish()");
            this.m_finish = true;
        }

        public void run() {
            while (!this.m_finish) {
                try {
                    long l = this.m_time == 0 ? Long.MAX_VALUE : (long)(this.m_time * 60000);
                    Thread.sleep(l);
                    this.m_finish = true;
                    this.m_f.timeExpired();
                }
                catch (InterruptedException interruptedException) {
                    s_logger.message("GENERIC SERVER: Timer interrupted");
                }
            }
            s_logger.message("GENERIC SERVER: Timer loop finished");
        }
    }

    private class ComponentStopper
    extends Thread {
        private final BusListenerImpl m_listener;
        private final Integer m_connectionId;

        ComponentStopper(BusListenerImpl busListenerImpl, Integer n) {
            this.m_listener = busListenerImpl;
            this.m_connectionId = n;
            this.start();
        }

        public void run() {
            block4: {
                this.m_listener.waitForStop(0L);
                try {
                    Middleware middleware = (Middleware)ServerRuntimeImpl.this.s_startedConnections.remove(this.m_connectionId);
                    if (middleware != null) {
                        BusComponent busComponent = (BusComponent)ServerRuntimeImpl.this.s_startedBusComponents.remove(this.m_connectionId);
                        if (ServerRuntimeImpl.this.m_Timer != null) {
                            s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stopping the timeout timer");
                            ServerRuntimeImpl.this.m_Timer.setFinish();
                            ServerRuntimeImpl.this.m_Timer.interrupt();
                            ServerRuntimeImpl.this.m_Timer = null;
                        }
                        s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Stopped connection for " + busComponent.getIdentifier());
                        middleware.close();
                        break block4;
                    }
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Cannot find connection for id " + this.m_connectionId + "; connection probably previously stopped");
                }
                catch (BusException busException) {
                    s_logger.message("GENERIC SERVER: ServerRuntimeImpl: Failed to stop connection for " + this.m_connectionId + ": " + busException);
                }
            }
        }
    }
}

