/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.server.IParameter;
import com.baan.b3.server.IQuery;
import com.baan.b3.server.ParameterImpl;
import com.baan.b3.server.ServerException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BaanSQLQuery;
import com.eibus.co.BusinessElement;
import com.eibus.co.Layout;
import com.eibus.exception.BusException;

public class QueryImpl
implements IQuery {
    private String m_BusinessObjectName = null;
    private String m_QueryText = null;
    private BaanSQLQuery m_query = null;
    private IParameter[] m_parameters = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server", "QueryImpl");

    public QueryImpl(BaanSQLQuery baanSQLQuery, String string) throws ServerException {
        Node node;
        this.m_query = baanSQLQuery;
        this.m_QueryText = baanSQLQuery.getQueryText();
        BusinessElement businessElement = baanSQLQuery.getParameters();
        if (businessElement != null) {
            try {
                this.m_parameters = new ParameterImpl[businessElement.getChildNodes().getLength()];
                node = businessElement.getFirstChild();
                int n = 0;
                while (node != null) {
                    this.m_parameters[n++] = new ParameterImpl((Element)node);
                    node = node.getNextSibling();
                }
            }
            catch (BusException busException) {
                this.m_parameters = new ParameterImpl[0];
                s_logger.errorMessage("QueryImpl: Error Creating parameters " + busException);
            }
        } else {
            this.m_parameters = new IParameter[0];
        }
        if (string == null) {
            node = baanSQLQuery.getLayout();
            try {
                this.m_BusinessObjectName = node.getChildNodes().item(0).getNodeName();
            }
            catch (Exception exception) {
                s_logger.errorMessage("QueryImpl: Error Defining BusinessObject Name, Layout is mandatory");
                throw new ServerException("Error Defining BusinessObject Name, Layout is mandatory");
            }
        } else {
            this.m_BusinessObjectName = string;
        }
    }

    public String getQueryText() {
        return this.m_QueryText;
    }

    public String getRootElementName() {
        return this.m_BusinessObjectName;
    }

    public IParameter[] getParameters() {
        return this.m_parameters;
    }

    public IQuery[] getSubQueries() throws ServerException {
        BaanSQLQuery[] baanSQLQueryArray = this.m_query.getNestedQueries();
        int n = baanSQLQueryArray.length;
        IQuery[] iQueryArray = new IQuery[n];
        if (n != 0) {
            Layout layout = this.m_query.getLayout();
            int n2 = 0;
            while (n2 < n) {
                String string = layout.getNameFromConstructorId(baanSQLQueryArray[n2].getId());
                iQueryArray[n2] = new QueryImpl(baanSQLQueryArray[n2], string);
                ++n2;
            }
        }
        return iQueryArray;
    }
}

