/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.server;

import com.baan.b3.dom.Element;
import com.baan.b3.server.DOMHelper;
import com.baan.b3.server.IParameter;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import com.eibus.xml.dom.ElementImpl;
import com.eibus.xml.dom.TextImpl;
import java.util.Hashtable;

public class ParameterImpl
implements IParameter {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.server", "ParameterImpl");
    private static final String ATTR_TYPE = "dt";
    private static final String ATTR_ELEM = "ct";
    private static final String ATTR_RETURN = "rt";
    private static final String ATTR_SCOPE = "scope";
    private static final String ATTR_DIMS = "dims";
    private static final String TYPE_ELEMENT_STR = "elements";
    private static final String TYPE_ENUMERATION_STR = "enumeration";
    private static final String TYPE_STRING_STR = "string";
    private static final String TYPE_NUMBER_STR = "number";
    private static final String TYPE_INT_STR = "int";
    private static final String TYPE_BOOLEAN_STR = "boolean";
    private static final String TYPE_DATETIME_STR = "dateTime";
    private static final String TYPE_DATETIME_TZ_STR = "dateTime.tz";
    private static final String TYPE_DATE_STR = "date";
    private static final String TYPE_TIME_STR = "time";
    private static final String TYPE_TIME_TZ_STR = "time.tz";
    private static final String TYPE_I1_STR = "i1";
    private static final String TYPE_I2_STR = "i2";
    private static final String TYPE_I4_STR = "i4";
    private static final String TYPE_I8_STR = "i8";
    private static final String TYPE_UI1_STR = "ui1";
    private static final String TYPE_UI2_STR = "ui2";
    private static final String TYPE_UI4_STR = "ui4";
    private static final String TYPE_UI8_STR = "ui8";
    private static final String TYPE_R4_STR = "r4";
    private static final String TYPE_R8_STR = "r8";
    private static final String TYPE_BIN_BASE64_STR = "bin.base64";
    private static final String TYPE_XML_NODE_STR = "xml.node";
    private static final String TYPE_CHAR_STR = "char";
    private static final String SCOPE_IN_STR = "in";
    private static final String SCOPE_OUT_STR = "out";
    private static final String SCOPE_INOUT_STR = "inout";
    protected Element m_parameterData = null;
    private Element m_returnData = null;
    private String m_name = null;
    protected int m_type = 0;
    private int m_scope = 1;
    private int m_dims = 0;
    protected static Hashtable s_typeTable = new Hashtable();

    public ParameterImpl(Element element) throws BusException {
        this.initialize(element);
    }

    protected ParameterImpl() {
    }

    protected void initialize(Element element) throws BusException {
        String string;
        this.m_parameterData = element;
        this.m_name = element.getNodeName();
        String string2 = element.getAttribute(ATTR_TYPE);
        if (string2 == null || string2.equals("")) {
            string2 = element.getAttribute(ATTR_ELEM);
        }
        if (string2 == null) {
            s_logger.message("ParameterImpl: parameter " + this.m_name + " has no type attribute");
            BusException busException = new BusException("parameter has no type attribute");
            s_logger.errorException(busException);
            throw busException;
        }
        Integer n = (Integer)s_typeTable.get(string2);
        if (n == null) {
            s_logger.message("ParameterImpl: parameter " + this.m_name + " has unknown type " + string2);
            BusException busException = new BusException("parameter has unknown type attribute");
            s_logger.errorException(busException);
            throw busException;
        }
        this.m_type = n;
        String string3 = element.getAttribute(ATTR_SCOPE);
        if (string3 != null) {
            if (string3.equals(SCOPE_OUT_STR)) {
                this.m_scope = 2;
            } else if (string3.equals(SCOPE_INOUT_STR)) {
                this.m_scope = 3;
            }
        }
        if ((string = element.getAttribute(ATTR_DIMS)) != null && !string.equals("")) {
            try {
                this.m_dims = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.m_dims = 0;
            }
        }
        if (this.m_scope != 1) {
            this.m_returnData = new ElementImpl(this.m_name);
        }
    }

    public Element getReturnData() {
        return this.m_returnData;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public int getScope() {
        return this.m_scope;
    }

    public int getDims() {
        return this.m_dims;
    }

    public String getValueString() {
        if (this.m_parameterData.getFirstChild() != null) {
            if (this.m_type == 0) {
                return DOMHelper.serializeElement(this.m_parameterData);
            }
            return this.m_parameterData.getFirstChild().getNodeValue();
        }
        return "";
    }

    public Element getValueElement() {
        return this.m_parameterData;
    }

    public void setValue(String string) {
        if (this.m_type == 0) {
            this.m_returnData = DOMHelper.parseElement(string);
        } else {
            TextImpl textImpl = new TextImpl(string);
            this.m_returnData.appendChild(textImpl);
        }
    }

    public void setValue(Element element) {
        this.m_returnData = element;
    }

    public String getColumnReference() {
        return this.m_parameterData.getAttribute("dd");
    }

    public String toString() {
        String string;
        String string2;
        int n = this.getType();
        switch (n) {
            case 21: {
                string2 = TYPE_BIN_BASE64_STR;
                break;
            }
            case 5: {
                string2 = TYPE_BOOLEAN_STR;
                break;
            }
            case 23: {
                string2 = TYPE_CHAR_STR;
                break;
            }
            case 8: {
                string2 = TYPE_DATE_STR;
                break;
            }
            case 6: {
                string2 = TYPE_DATETIME_STR;
                break;
            }
            case 7: {
                string2 = TYPE_DATETIME_TZ_STR;
                break;
            }
            case 0: {
                string2 = TYPE_ELEMENT_STR;
                break;
            }
            case 1: {
                string2 = TYPE_ENUMERATION_STR;
                break;
            }
            case 11: {
                string2 = TYPE_I1_STR;
                break;
            }
            case 12: {
                string2 = TYPE_I2_STR;
                break;
            }
            case 13: {
                string2 = TYPE_I4_STR;
                break;
            }
            case 14: {
                string2 = TYPE_I8_STR;
                break;
            }
            case 4: {
                string2 = TYPE_INT_STR;
                break;
            }
            case 3: {
                string2 = TYPE_NUMBER_STR;
                break;
            }
            case 19: {
                string2 = TYPE_R4_STR;
                break;
            }
            case 20: {
                string2 = TYPE_R8_STR;
                break;
            }
            case 2: {
                string2 = TYPE_STRING_STR;
                break;
            }
            case 9: {
                string2 = TYPE_TIME_STR;
                break;
            }
            case 10: {
                string2 = TYPE_TIME_TZ_STR;
                break;
            }
            case 15: {
                string2 = TYPE_UI1_STR;
                break;
            }
            case 16: {
                string2 = TYPE_UI2_STR;
                break;
            }
            case 17: {
                string2 = TYPE_UI4_STR;
                break;
            }
            case 18: {
                string2 = TYPE_UI8_STR;
                break;
            }
            case 22: {
                string2 = TYPE_XML_NODE_STR;
                break;
            }
            default: {
                string2 = "?";
            }
        }
        string2 = string2 + "[" + Integer.toString(n) + "]";
        String string3 = this.getName();
        int n2 = this.getScope();
        switch (n2) {
            case 1: {
                string = SCOPE_IN_STR;
                break;
            }
            case 3: {
                string = SCOPE_INOUT_STR;
                break;
            }
            case 2: {
                string = SCOPE_OUT_STR;
                break;
            }
            default: {
                string = "?";
            }
        }
        string = string + "[" + Integer.toString(n2) + "]";
        return "scope(" + string + ") type(" + string2 + ") name(" + string3 + ")";
    }

    static {
        s_typeTable.put(TYPE_ELEMENT_STR, new Integer(0));
        s_typeTable.put(TYPE_ENUMERATION_STR, new Integer(1));
        s_typeTable.put(TYPE_STRING_STR, new Integer(2));
        s_typeTable.put(TYPE_NUMBER_STR, new Integer(3));
        s_typeTable.put(TYPE_INT_STR, new Integer(4));
        s_typeTable.put(TYPE_BOOLEAN_STR, new Integer(5));
        s_typeTable.put(TYPE_DATETIME_STR, new Integer(6));
        s_typeTable.put(TYPE_DATETIME_TZ_STR, new Integer(7));
        s_typeTable.put(TYPE_DATE_STR, new Integer(8));
        s_typeTable.put(TYPE_TIME_STR, new Integer(9));
        s_typeTable.put(TYPE_TIME_TZ_STR, new Integer(10));
        s_typeTable.put(TYPE_I1_STR, new Integer(11));
        s_typeTable.put(TYPE_I2_STR, new Integer(12));
        s_typeTable.put(TYPE_I4_STR, new Integer(13));
        s_typeTable.put(TYPE_I8_STR, new Integer(14));
        s_typeTable.put(TYPE_UI1_STR, new Integer(15));
        s_typeTable.put(TYPE_UI2_STR, new Integer(16));
        s_typeTable.put(TYPE_UI4_STR, new Integer(17));
        s_typeTable.put(TYPE_UI8_STR, new Integer(18));
        s_typeTable.put(TYPE_R4_STR, new Integer(19));
        s_typeTable.put(TYPE_R8_STR, new Integer(20));
        s_typeTable.put(TYPE_BIN_BASE64_STR, new Integer(21));
        s_typeTable.put(TYPE_XML_NODE_STR, new Integer(22));
        s_typeTable.put(TYPE_CHAR_STR, new Integer(23));
    }
}

