/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.jclark.xml.tok;

import com.baan.b3.jclark.xml.tok.Encoding;

public class StringConversionCache {
    private static final int DEFAULT_CACHE_SIZE = 1009;
    private static final int CONVERSION_BUF_SIZE = 64;
    private Bucket[] table;
    private Bucket mru = new Bucket();
    private char[] conversionBuf = new char[64];
    private Encoding enc;
    private int minBPC;
    private int cacheFree;
    private static final double LOAD_FACTOR = 0.7;

    public StringConversionCache(Encoding encoding, int n) {
        this.enc = encoding;
        this.minBPC = encoding.getMinBytesPerChar();
        this.table = new Bucket[n];
        this.cacheFree = (int)((double)this.table.length * 0.7);
        this.mru.nextMru = this.mru;
        this.mru.prevMru = this.mru;
    }

    public StringConversionCache(Encoding encoding) {
        this(encoding, 1009);
    }

    public void setEncoding(Encoding encoding) {
        if (this.cacheFree != (int)((double)this.table.length * 0.7)) {
            throw new IllegalStateException("cache already used");
        }
        this.enc = encoding;
        if (this.minBPC != encoding.getMinBytesPerChar()) {
            throw new IllegalStateException("change to incompatible encoding");
        }
    }

    public String convert(byte[] byArray, int n, int n2, boolean bl) {
        Bucket bucket;
        int n3 = StringConversionCache.hash(byArray, n, n2) % this.table.length;
        Bucket bucket2 = this.table[n3];
        if (bucket2 != null) {
            bucket = bucket2.nextBucket;
            while (bucket != bucket2) {
                if (bucket.matches(byArray, n, n2)) {
                    if (bucket.nextMru != null) {
                        StringConversionCache.unlinkMru(bucket);
                        if (bl) {
                            bucket.nextMru = null;
                        } else {
                            StringConversionCache.linkMru(this.mru, bucket);
                        }
                    }
                    return bucket.string;
                }
                bucket = bucket.nextBucket;
            }
        } else {
            bucket2.nextBucket = bucket2.prevBucket = (bucket2 = new Bucket());
            this.table[n3] = bucket2;
        }
        if (this.cacheFree <= 0) {
            if (this.mru.nextMru == this.mru) {
                int n4 = 0;
                while (n4 < this.table.length) {
                    Bucket bucket3 = this.table[n4];
                    if (bucket3 != null) {
                        Bucket bucket4 = bucket3.nextBucket;
                        while (bucket4 != bucket3) {
                            StringConversionCache.linkMru(this.mru, bucket4);
                            bucket4 = bucket4.nextBucket;
                        }
                        bucket3.nextBucket = bucket3.prevBucket = bucket3;
                    }
                    ++n4;
                }
            }
            bucket = this.mru.prevMru;
            StringConversionCache.unlinkMru(bucket);
            bucket.prevBucket.nextBucket = bucket.nextBucket;
            bucket.nextBucket.prevBucket = bucket.prevBucket;
            if (bl) {
                bucket.nextMru = null;
            } else {
                StringConversionCache.linkMru(this.mru, bucket);
            }
        } else {
            --this.cacheFree;
            bucket = new Bucket();
            if (!bl) {
                StringConversionCache.linkMru(this.mru, bucket);
            }
        }
        if (n2 - n > this.conversionBuf.length * this.minBPC) {
            this.conversionBuf = new char[(n2 - n) / this.minBPC];
        }
        bucket.string = new String(this.conversionBuf, 0, this.enc.convert(byArray, n, n2, this.conversionBuf, 0));
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        bucket.bytes = byArray2;
        bucket.nextBucket = bucket2.nextBucket;
        bucket.nextBucket.prevBucket = bucket;
        bucket.prevBucket = bucket2;
        bucket2.nextBucket = bucket;
        return bucket.string;
    }

    private static final int hash(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n != n2) {
            n3 += (n3 << 5) + (byArray[n++] & 0xFF);
        }
        return n3 & Integer.MAX_VALUE;
    }

    private static final void linkMru(Bucket bucket, Bucket bucket2) {
        bucket2.nextMru = bucket.nextMru;
        bucket2.nextMru.prevMru = bucket2;
        bucket2.prevMru = bucket;
        bucket.nextMru = bucket2;
    }

    private static final void unlinkMru(Bucket bucket) {
        bucket.prevMru.nextMru = bucket.nextMru;
        bucket.nextMru.prevMru = bucket.prevMru;
    }

    private static class Bucket {
        byte[] bytes;
        String string;
        Bucket nextMru;
        Bucket prevMru;
        Bucket nextBucket;
        Bucket prevBucket;

        private Bucket() {
        }

        final boolean matches(byte[] byArray, int n, int n2) {
            if (n2 - n != this.bytes.length) {
                return false;
            }
            int n3 = 0;
            while (n3 < this.bytes.length) {
                if (this.bytes[n3] != byArray[n++]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
    }
}

