/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.jclark.xml.sax;

import com.baan.b3.jclark.xml.parse.ApplicationException;
import com.baan.b3.jclark.xml.parse.CharacterDataEvent;
import com.baan.b3.jclark.xml.parse.DTD;
import com.baan.b3.jclark.xml.parse.EndElementEvent;
import com.baan.b3.jclark.xml.parse.EndPrologEvent;
import com.baan.b3.jclark.xml.parse.EntityManager;
import com.baan.b3.jclark.xml.parse.LocatedEvent;
import com.baan.b3.jclark.xml.parse.NotWellFormedException;
import com.baan.b3.jclark.xml.parse.OpenEntity;
import com.baan.b3.jclark.xml.parse.ProcessingInstructionEvent;
import com.baan.b3.jclark.xml.parse.StartElementEvent;
import com.baan.b3.jclark.xml.parse.base.ApplicationImpl;
import com.baan.b3.jclark.xml.parse.base.ParserImpl;
import com.baan.b3.jclark.xml.sax.Locator;
import com.baan.b3.jclark.xml.sax.ReaderInputStream;
import com.baan.b3.jclark.xml.sax.WrapperException;
import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.DTDHandler;
import com.baan.b3.xml.sax.DocumentHandler;
import com.baan.b3.xml.sax.EntityResolver;
import com.baan.b3.xml.sax.ErrorHandler;
import com.baan.b3.xml.sax.HandlerBase;
import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.SAXParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;

public class Driver
extends ApplicationImpl
implements Parser,
EntityManager,
AttributeList,
Locator {
    private EntityResolver entityResolver;
    private DocumentHandler documentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private com.baan.b3.jclark.xml.parse.base.Parser parser = new ParserImpl();
    private StartElementEvent event;
    private LocatedEvent locatedEvent;
    private static final int INIT_DATA_BUF_SIZE = 80;
    private char[] dataBuf = new char[80];
    private int dataBufUsed = 0;
    private static final int UNKNOWN_INDEX = -2;
    private int idAttributeIndex;

    public Driver() {
        HandlerBase handlerBase = new HandlerBase();
        this.documentHandler = handlerBase;
        this.dtdHandler = handlerBase;
        this.errorHandler = handlerBase;
        this.entityResolver = handlerBase;
        this.parser.setApplication(this);
        this.parser.setEntityManager(this);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setLocale(Locale locale) {
        this.parser.setLocale(locale);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.documentHandler.setDocumentLocator(this);
        try {
            this.parser.parseDocument(this.openInputSource(inputSource));
        }
        catch (WrapperException wrapperException) {
            throw wrapperException.getWrapped();
        }
        catch (NotWellFormedException notWellFormedException) {
            this.errorHandler.fatalError(new SAXParseException(notWellFormedException.getMessageWithoutLocation(), null, notWellFormedException.getEntityLocation(), notWellFormedException.getLineNumber(), notWellFormedException.getColumnNumber()));
        }
        catch (ApplicationException applicationException) {
            throw (SAXException)applicationException.getException();
        }
    }

    public void startDocument() throws SAXException {
        this.documentHandler.startDocument();
    }

    public void startElement(StartElementEvent startElementEvent) throws SAXException {
        this.flushData();
        this.event = startElementEvent;
        this.locatedEvent = startElementEvent;
        this.idAttributeIndex = -2;
        this.documentHandler.startElement(startElementEvent.getName(), this);
        this.locatedEvent = null;
    }

    public void characterData(CharacterDataEvent characterDataEvent) {
        int n = characterDataEvent.getLengthMax() + this.dataBufUsed;
        if (n > this.dataBuf.length) {
            int n2 = this.dataBuf.length << 1;
            while (n > n2) {
                n2 <<= 1;
            }
            char[] cArray = this.dataBuf;
            this.dataBuf = new char[n2];
            if (this.dataBufUsed > 0) {
                System.arraycopy(cArray, 0, this.dataBuf, 0, this.dataBufUsed);
            }
        }
        this.dataBufUsed += characterDataEvent.copyChars(this.dataBuf, this.dataBufUsed);
    }

    private final void flushData() throws SAXException {
        if (this.dataBufUsed > 0) {
            this.documentHandler.characters(this.dataBuf, 0, this.dataBufUsed);
            this.dataBufUsed = 0;
        }
    }

    public void endElement(EndElementEvent endElementEvent) throws SAXException {
        this.flushData();
        this.documentHandler.endElement(endElementEvent.getName());
    }

    public void processingInstruction(ProcessingInstructionEvent processingInstructionEvent) throws SAXException {
        this.flushData();
        this.locatedEvent = processingInstructionEvent;
        this.documentHandler.processingInstruction(processingInstructionEvent.getName(), processingInstructionEvent.getInstruction());
        this.locatedEvent = null;
    }

    public void endProlog(EndPrologEvent endPrologEvent) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        if (this.dtdHandler == null) {
            return;
        }
        DTD dTD = endPrologEvent.getDTD();
        Enumeration enumeration2 = dTD.entityNames((byte)2);
        while (enumeration2.hasMoreElements()) {
            object3 = (String)enumeration2.nextElement();
            object2 = dTD.getEntity((byte)2, (String)object3);
            object = object2.getSystemId();
            if (object != null) {
                try {
                    object = new URL(object2.getBase(), (String)object).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.dtdHandler.notationDecl((String)object3, object2.getPublicId(), (String)object);
        }
        object3 = dTD.entityNames((byte)0);
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = dTD.getEntity((byte)0, (String)object2);
            String string = object.getNotationName();
            if (string == null) continue;
            String string2 = object.getSystemId();
            if (string2 != null) {
                try {
                    string2 = new URL(object.getBase(), string2).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.dtdHandler.unparsedEntityDecl((String)object2, object.getPublicId(), string2, string);
        }
    }

    public void endDocument() throws SAXException {
        this.flushData();
        this.documentHandler.endDocument();
    }

    public OpenEntity open(String string, URL uRL, String string2) throws IOException {
        Object object;
        if (this.entityResolver != null) {
            try {
                object = string;
                try {
                    object = new URL(uRL, string).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                InputSource inputSource = this.entityResolver.resolveEntity(string2, (String)object);
                if (inputSource != null) {
                    return this.openInputSource(inputSource);
                }
            }
            catch (SAXException sAXException) {
                throw new WrapperException(sAXException);
            }
        }
        object = new URL(uRL, string);
        return new OpenEntity(((URL)object).openStream(), ((URL)object).toString(), (URL)object, null);
    }

    private OpenEntity openInputSource(InputSource inputSource) throws IOException {
        String string;
        InputStream inputStream;
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            inputStream = new ReaderInputStream(reader);
            string = "UTF-16";
        } else {
            inputStream = inputSource.getByteStream();
            string = inputSource.getEncoding();
        }
        String string2 = inputSource.getSystemId();
        URL uRL = null;
        if (inputStream == null) {
            if (string2 == null) {
                return null;
            }
            uRL = new URL(string2);
            inputStream = uRL.openStream();
        } else if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            string2 = "(internal)";
        }
        return new OpenEntity(inputStream, string2, uRL, string);
    }

    public int getLength() {
        return this.event.getAttributeCount();
    }

    public String getName(int n) {
        return this.event.getAttributeName(n);
    }

    public String getValue(int n) {
        return this.event.getAttributeValue(n);
    }

    public String getValue(String string) {
        return this.event.getAttributeValue(string);
    }

    public String getType(int n) {
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.event.getIdAttributeIndex();
        }
        return n == this.idAttributeIndex ? "ID" : "CDATA";
    }

    public String getType(String string) {
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.event.getIdAttributeIndex();
        }
        if (this.idAttributeIndex >= 0 && this.event.getAttributeName(this.idAttributeIndex).equals(string)) {
            return "ID";
        }
        return "CDATA";
    }

    public String getSystemId() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityLocation();
    }

    public URL getURL() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityBase();
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        return this.locatedEvent.getLocation().getLineNumber();
    }

    public int getColumnNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        int n = this.locatedEvent.getLocation().getColumnNumber();
        if (n < 0) {
            return n;
        }
        return n + 1;
    }

    public long getByteIndex() {
        if (this.locatedEvent == null) {
            return -1L;
        }
        return this.locatedEvent.getLocation().getByteIndex();
    }
}

