/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.domain;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.baan.b3.domain.AboutDomainExplorer;
import com.baan.b3.domain.Domain;
import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.tools.rtf.Rtf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class DomainExplorer
extends JFrame {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.domain", "DomainExplorer");
    private JTree domainTree;
    private DefaultMutableTreeNode m_rootNode;
    private HelpSet hs;
    private HelpBroker hb;
    private JScrollPane DetailsScrollpane;
    private JMenuItem FileExit;
    private JScrollPane TreeScrollPane;
    private JTextPane contents;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JSplitPane jSplitPane1;
    private JLabel statusBar;

    public DomainExplorer() {
        Object object;
        this.setTitle("Domain Explorer");
        this.initComponents();
        int n = 500;
        int n2 = 400;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        ((Component)this).setBounds(n3, n4, n, n2);
        try {
            object = new ImageIcon(this.getClass().getResource("/com/baan/b3/domain/icon16.gif")).getImage();
            ((Frame)this).setIconImage((Image)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.createHelpSet();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error Creating Helpset, help not available.", "Help Error", 0);
        }
        this.m_rootNode = new DefaultMutableTreeNode("root");
        this.domainTree = new JTree(this.m_rootNode);
        this.domainTree.setRootVisible(false);
        this.TreeScrollPane.setViewportView(this.domainTree);
        this.TreeScrollPane.setAutoscrolls(false);
        this.DetailsScrollpane.setAutoscrolls(false);
        object = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)object).setLeafIcon(null);
        ((DefaultTreeCellRenderer)object).setClosedIcon(null);
        ((DefaultTreeCellRenderer)object).setOpenIcon(null);
        this.domainTree.setCellRenderer((TreeCellRenderer)object);
        this.domainTree.setShowsRootHandles(true);
        this.domainTree.setFont(this.statusBar.getFont());
        this.contents.setContentType("text/rtf");
        this.domainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DomainExplorer.this.jTreeValueChanged(treeSelectionEvent);
            }
        });
        this.loadTree();
        this.domainTree.updateUI();
    }

    private void loadTree() {
        Object object;
        Object object2;
        Object object3;
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object3 = new File(string2);
            if (((File)object3).isDirectory()) {
                object2 = ((File)object3).list();
                int n = 0;
                while (n < ((Object)object2).length) {
                    if (((String)object2[n]).endsWith(".jar")) {
                        object = string2 + File.separator + (String)object2[n];
                        if (vector.indexOf(object) == -1) {
                            vector.addElement(object);
                        }
                    } else if (((String)object2[n]).endsWith(".rep")) {
                        this.addDomain((String)object2[n]);
                    }
                    ++n;
                }
                continue;
            }
            if (!((File)object3).isFile()) continue;
            if (string2.endsWith(".jar")) {
                object2 = string2;
                if (vector.indexOf(object2) != -1) continue;
                vector.addElement(object2);
                continue;
            }
            if (!string2.endsWith(".rep")) continue;
            this.addDomain(((File)object3).getName());
        }
        int n = 0;
        while (n < vector.size()) {
            object3 = (String)vector.elementAt(n);
            try {
                object2 = new ZipFile((String)object3);
                Enumeration<? extends ZipEntry> enumeration2 = ((ZipFile)object2).entries();
                while (enumeration2.hasMoreElements()) {
                    object = enumeration2.nextElement();
                    String string3 = ((ZipEntry)object).getName();
                    if (!string3.endsWith(".rep")) continue;
                    this.addDomain(string3);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            catch (Exception exception) {
                this.setCursor(Cursor.getDefaultCursor());
                s_logger.errorException(exception);
                JOptionPane.showMessageDialog(this, "Reading jar failed: " + exception, "Domain search Error", 0);
            }
            ++n;
        }
        if (this.m_rootNode.getChildCount() == 0) {
            s_logger.message("Could not find domains on your system");
            this.statusBar.setText("Could not find domains on your system");
        } else {
            this.statusBar.setText(" ");
        }
    }

    private void addDomain(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            IDomain iDomain = Domain.open(uRL);
            DomainNode domainNode = new DomainNode(iDomain);
            this.m_rootNode.add(domainNode);
            Enumeration enumeration2 = iDomain.getBois();
            while (enumeration2.hasMoreElements()) {
                IBoiDescriptor iBoiDescriptor = (IBoiDescriptor)enumeration2.nextElement();
                BoiNode boiNode = new BoiNode(iBoiDescriptor);
                domainNode.add(boiNode);
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            JOptionPane.showMessageDialog(this, "addDomain failed: " + exception, "Domain read Error", 0);
        }
    }

    private void createHelpSet() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)"adapter_helpset.hs");
        this.hs = new HelpSet(classLoader, uRL);
        this.hb = this.hs.createHelpBroker();
        JRootPane jRootPane = this.getRootPane();
        this.hb.enableHelpKey((Component)jRootPane, "domainexplorer_intro", this.hs);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.statusBar = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.TreeScrollPane = new JScrollPane();
        this.DetailsScrollpane = new JScrollPane();
        this.contents = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.FileExit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.setName("Domain Explorer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DomainExplorer.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(750, 300));
        this.statusBar.setFont(new Font("Dialog", 0, 12));
        this.statusBar.setText(" ");
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jSplitPane1.setDividerLocation(230);
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setPreferredSize(new Dimension(500, 200));
        this.TreeScrollPane.setAlignmentX(5.0f);
        this.TreeScrollPane.setAlignmentY(5.0f);
        this.jSplitPane1.setLeftComponent(this.TreeScrollPane);
        this.contents.setEditable(false);
        this.DetailsScrollpane.setViewportView(this.contents);
        this.jSplitPane1.setRightComponent(this.DetailsScrollpane);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jMenu1.setMnemonic('F');
        this.jMenu1.setText("File");
        this.FileExit.setMnemonic('x');
        this.FileExit.setText("Exit");
        this.FileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DomainExplorer.this.FileExitActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.FileExit);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setMnemonic('V');
        this.jMenu2.setText("View");
        this.jMenuItem1.setMnemonic('R');
        this.jMenuItem1.setText("Refresh");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DomainExplorer.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setMnemonic('H');
        this.jMenu3.setText("Help");
        this.jMenuItem2.setMnemonic('C');
        this.jMenuItem2.setText("Contents...");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DomainExplorer.this.jMenuItem2ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuItem3.setMnemonic('A');
        this.jMenuItem3.setText("About...");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DomainExplorer.this.jMenuItem3ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jMenuItem3ActionPerformed(ActionEvent actionEvent) {
        new AboutDomainExplorer((Frame)this, true).show();
    }

    private void jMenuItem2ActionPerformed(ActionEvent actionEvent) {
        this.hb.setCurrentID("domainexplorer_intro");
        this.hb.setDisplayed(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        this.m_rootNode.removeAllChildren();
        this.contents.setText("");
        this.loadTree();
    }

    private void FileExitActionPerformed(ActionEvent actionEvent) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void jTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (defaultMutableTreeNode instanceof DomainNode) {
            DomainNode domainNode = (DomainNode)defaultMutableTreeNode;
            this.fillContents(domainNode.getDomain());
        } else if (defaultMutableTreeNode instanceof BoiNode) {
            BoiNode boiNode = (BoiNode)defaultMutableTreeNode;
            this.addBoiMetadata(boiNode);
            this.fillContents(boiNode.getBoi());
        } else if (defaultMutableTreeNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)defaultMutableTreeNode;
            this.fillContents(methodNode.getMethodMetadata());
        } else if (defaultMutableTreeNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)defaultMutableTreeNode;
            this.fillContents(objectNode.getBusinessObjectMetadata());
        } else {
            TreeNode treeNode = defaultMutableTreeNode.getParent();
            BoiNode boiNode = (BoiNode)treeNode;
            this.addBoiMetadata(boiNode);
            this.fillContents(boiNode.getBoi());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void addBoiMetadata(BoiNode boiNode) {
        block6: {
            IBoiDescriptor iBoiDescriptor = boiNode.getBoi();
            if (boiNode.getChildCount() != 0) break block6;
            try {
                Object object;
                IManagerMetadata iManagerMetadata = MetadataUtil.getManagerMetadata(iBoiDescriptor.getManagerClass());
                IMethodMetadata[] iMethodMetadataArray = iManagerMetadata.getMethods();
                if (iMethodMetadataArray.length > 0) {
                    object = new DefaultMutableTreeNode("methods");
                    boiNode.add((MutableTreeNode)object);
                    int n = 0;
                    while (n < iMethodMetadataArray.length) {
                        MethodNode methodNode = new MethodNode(iMethodMetadataArray[n]);
                        ((DefaultMutableTreeNode)object).add(methodNode);
                        ++n;
                    }
                }
                if (((IBusinessObjectMetadata[])(object = iManagerMetadata.getManagedObjects())).length > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("objects");
                    boiNode.add(defaultMutableTreeNode);
                    int n = 0;
                    while (n < ((IBusinessObjectMetadata[])object).length) {
                        ObjectNode objectNode = new ObjectNode((IBusinessObjectMetadata)object[n]);
                        defaultMutableTreeNode.add(objectNode);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
            }
        }
    }

    private void fillContents(IDomain iDomain) {
        Rtf rtf = new Rtf(Rtf.FONT_MS_SANS_SERIF, 24, Rtf.COLOR_BLACK, false, false);
        DomainExplorer.writeHeader(rtf, "Domain information");
        rtf.setIndent(2170);
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        rtf.addTextNewLine("");
        rtf.addPropertyValue("Name    ", iDomain.getName());
        rtf.addPropertyValue("Product ID", iDomain.getID());
        rtf.setPlain();
        DomainExplorer.writeCaption(rtf, "This domain contains the following BOIs");
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        String[] stringArray = iDomain.getBoiNames();
        int n = 0;
        while (n < stringArray.length) {
            rtf.addBulletListItem("-  " + stringArray[n]);
            ++n;
        }
        this.contents.setText(rtf.getRtf());
        this.contents.setCaretPosition(0);
    }

    private void fillContents(IBoiDescriptor iBoiDescriptor) {
        Rtf rtf = new Rtf(Rtf.FONT_MS_SANS_SERIF, 24, Rtf.COLOR_BLACK, false, false);
        DomainExplorer.writeHeader(rtf, "BOI information");
        rtf.setIndent(2170);
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        rtf.addTextNewLine("");
        rtf.addPropertyValue("Name", iBoiDescriptor.getName());
        rtf.addPropertyValue("Version", iBoiDescriptor.getVersion());
        rtf.addPropertyValue("Manager Class", iBoiDescriptor.getManagerClass());
        rtf.setPlain();
        try {
            IBusinessObjectMetadata[] iBusinessObjectMetadataArray;
            IManagerMetadata iManagerMetadata = MetadataUtil.getManagerMetadata(iBoiDescriptor.getManagerClass());
            DomainExplorer.writeCaption(rtf, "This BOI supports the following methods");
            rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
            IMethodMetadata[] iMethodMetadataArray = iManagerMetadata.getMethods();
            int n = 0;
            while (n < iMethodMetadataArray.length) {
                iBusinessObjectMetadataArray = iMethodMetadataArray[n].getName();
                rtf.addBulletListItem("-  " + (String)iBusinessObjectMetadataArray);
                ++n;
            }
            rtf.setPlain();
            DomainExplorer.writeCaption(rtf, "This BOI supports the following objects");
            rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
            iBusinessObjectMetadataArray = iManagerMetadata.getManagedObjects();
            int n2 = 0;
            while (n2 < iBusinessObjectMetadataArray.length) {
                String string = iBusinessObjectMetadataArray[n2].getTypeName();
                rtf.addBulletListItem("-  " + string);
                ++n2;
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            rtf.setFontColor(Rtf.COLOR_RED);
            rtf.addTextNewLine("Cannot find manager class.");
        }
        this.contents.setText(rtf.getRtf());
        this.contents.setCaretPosition(0);
    }

    private void fillContents(IMethodMetadata iMethodMetadata) {
        String string;
        IParameterMetadata[] iParameterMetadataArray;
        StringBuffer stringBuffer = new StringBuffer();
        Rtf rtf = new Rtf(Rtf.FONT_MS_SANS_SERIF, 24, Rtf.COLOR_BLACK, false, false);
        DomainExplorer.writeHeader(rtf, "Method information");
        IParameterMetadata iParameterMetadata = iMethodMetadata.getReturnType();
        if (iParameterMetadata != null) {
            iParameterMetadataArray = iParameterMetadata.getType();
            string = iParameterMetadataArray.getTypeName();
        } else {
            string = "void";
        }
        rtf.setIndent(2170);
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        rtf.addTextNewLine("");
        rtf.addPropertyValue("Name", iMethodMetadata.getName());
        rtf.addPropertyValue("Return Type", string);
        rtf.setPlain();
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(iMethodMetadata.getName());
        stringBuffer.append("(");
        DomainExplorer.writeCaption(rtf, "The method has the following parameters");
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        iParameterMetadataArray = iMethodMetadata.getParameters();
        int n = 0;
        while (n < iParameterMetadataArray.length) {
            String string2 = iParameterMetadataArray[n].getName();
            IObjectMetadata iObjectMetadata = iParameterMetadataArray[n].getType();
            String string3 = iObjectMetadata.getTypeName();
            rtf.addNumberListItem(string3, string2);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3 + " " + string2);
            ++n;
        }
        stringBuffer.append(")");
        rtf.setPlain();
        DomainExplorer.writeCaption(rtf, "The method has the following syntax");
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        rtf.addTextNewLine(stringBuffer.toString());
        this.contents.setText(rtf.getRtf());
        this.contents.setCaretPosition(0);
    }

    private void fillContents(IBusinessObjectMetadata iBusinessObjectMetadata) {
        Rtf rtf = new Rtf(Rtf.FONT_MS_SANS_SERIF, 24, Rtf.COLOR_BLACK, false, false);
        DomainExplorer.writeHeader(rtf, "Object information");
        rtf.setIndent(2170);
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        rtf.addTextNewLine("");
        rtf.addPropertyValue("Name", iBusinessObjectMetadata.getTypeName());
        rtf.setPlain();
        DomainExplorer.writeCaption(rtf, "This object has the following members");
        rtf.setFont(Rtf.FONT_MS_SANS_SERIF);
        IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
        int n = 0;
        while (n < iMemberMetadataArray.length) {
            String string = iMemberMetadataArray[n].getName();
            IObjectMetadata iObjectMetadata = iMemberMetadataArray[n].getType();
            String string2 = iObjectMetadata.getTypeName();
            rtf.addBulletListItem(string2, string);
            ++n;
        }
        this.contents.setText(rtf.getRtf());
        this.contents.setCaretPosition(0);
    }

    private static void writeHeader(Rtf rtf, String string) {
        rtf.setBold();
        rtf.setFontSize(32);
        rtf.setFontColor(Rtf.COLOR_BLUE);
        rtf.addTextNewLine(string + ":");
        rtf.setPlain();
    }

    private static void writeCaption(Rtf rtf, String string) {
        rtf.setFontSize(28);
        rtf.setFontColor(Rtf.COLOR_BLUE);
        rtf.addTextNewLine("");
        rtf.addTextNewLine(string + ":");
        rtf.setPlain();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new DomainExplorer().show();
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_DOMAIN_EXPLORER);
    }

    private class ObjectNode
    extends DefaultMutableTreeNode {
        IBusinessObjectMetadata m_businessObjectMetadata;

        public ObjectNode(IBusinessObjectMetadata iBusinessObjectMetadata) {
            super(iBusinessObjectMetadata.getTypeName());
            this.m_businessObjectMetadata = iBusinessObjectMetadata;
        }

        public IBusinessObjectMetadata getBusinessObjectMetadata() {
            return this.m_businessObjectMetadata;
        }
    }

    private class MethodNode
    extends DefaultMutableTreeNode {
        IMethodMetadata m_methodMetadata;

        public MethodNode(IMethodMetadata iMethodMetadata) {
            super(iMethodMetadata.getName());
            this.m_methodMetadata = iMethodMetadata;
        }

        public IMethodMetadata getMethodMetadata() {
            return this.m_methodMetadata;
        }
    }

    private class BoiNode
    extends DefaultMutableTreeNode {
        IBoiDescriptor m_boi;

        public BoiNode(IBoiDescriptor iBoiDescriptor) {
            super(iBoiDescriptor.getName());
            this.m_boi = iBoiDescriptor;
        }

        public IBoiDescriptor getBoi() {
            return this.m_boi;
        }
    }

    private class DomainNode
    extends DefaultMutableTreeNode {
        private IDomain m_domain;

        public DomainNode(IDomain iDomain) {
            super(iDomain.getName());
            this.m_domain = iDomain;
        }

        public IDomain getDomain() {
            return this.m_domain;
        }
    }
}

