/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.domain;

import com.baan.b3.domain.BoiDescriptor;
import com.baan.b3.domain.Domain;
import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.tools.cmdline.CommandLine;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;

public class DomainCreator {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.domain", "DomainCreator");
    private static final String TOOL_NAME;
    private static final String ARG_DOMAIN_NAME = "name";
    private static final String ARG_DOMAIN_ID = "id";
    private static final String ARG_VERSION = "v";
    private static final String ARG_DIRECTORY = "dir";
    private static final String DESCRIPTION = "BOI Studio, Domain Create Tool (.rep files)";
    private static final int EXIT_ERROR = 1;
    private static final String NEWLINE;
    private static final String FILE_SEP;
    private static final String TOOL_USAGE;
    private static final String MANAGER_SUPERCLASS = "com.baan.b3.boi1.BusinessObjectManager";
    private IDomain m_newDomain = null;
    static /* synthetic */ Class class$com$baan$b3$domain$DomainCreator;

    public DomainCreator(String string, String string2) {
        this.m_newDomain = Domain.create(string, string2);
    }

    private void findClasses(String string, File file2, Vector vector) {
        File[] fileArray = file2.listFiles(new ClassFileFilter());
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                String string2 = null;
                string2 = string.length() == 0 ? fileArray[n].getName() : string + "." + fileArray[n].getName();
                this.findClasses(string2, fileArray[n], vector);
            } else if (string.length() == 0) {
                vector.add(fileArray[n].getName().substring(0, fileArray[n].getName().length() - 6));
            } else {
                vector.add(string + "." + fileArray[n].getName().substring(0, fileArray[n].getName().length() - 6));
            }
            ++n;
        }
    }

    private void createRepFile(String string, String string2) {
        block10: {
            try {
                String string3;
                File file2 = new File(string);
                if (!file2.exists()) {
                    System.out.println("specified directory '" + string + "' does not exist ");
                    return;
                }
                if (!file2.isDirectory()) {
                    System.out.println("specified directory '" + string + "' is not a directory");
                    return;
                }
                string = file2.getAbsolutePath();
                System.out.println("Searching for BOIs in '" + string + "'");
                System.out.println("Domain Name = '" + this.m_newDomain.getName() + "'");
                System.out.println("Domain Id   = '" + this.m_newDomain.getID() + "'");
                System.out.println("BOI Version = '" + string2 + "'");
                System.out.println();
                URL[] uRLArray = new URL[]{file2.toURL()};
                Vector vector = new Vector();
                this.findClasses("", file2, vector);
                Enumeration enumeration2 = vector.elements();
                MyURLClassLoader myURLClassLoader = new MyURLClassLoader(uRLArray);
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    try {
                        String string4;
                        Class clazz = myURLClassLoader.findClass(string3);
                        Class clazz2 = clazz.getSuperclass();
                        if (clazz2 == null || !(string4 = clazz2.getName()).equals(MANAGER_SUPERCLASS)) continue;
                        String string5 = clazz.getName();
                        if ((string5 = string5.substring(string5.lastIndexOf(46) + 1)).endsWith("Manager")) {
                            string5 = string5.substring(0, string5.length() - 7);
                        }
                        System.out.println("Found BOI : " + string5 + ", [" + string3 + "]");
                        s_logger.message("Found BOI : " + string5 + ", [" + string3 + "]");
                        IBoiDescriptor iBoiDescriptor = BoiDescriptor.create(string5, string2, string3);
                        this.m_newDomain.addBoi(iBoiDescriptor);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.out.println(classNotFoundException);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        System.out.println(noClassDefFoundError.getMessage());
                    }
                }
                if (this.m_newDomain.getBois().hasMoreElements()) {
                    string3 = string + FILE_SEP + this.m_newDomain.getName() + ".rep";
                    System.out.println();
                    System.out.println("Found BOIs, writing Domain (rep file) '" + string3 + "'");
                    s_logger.message("Found BOIs, writing Domain (rep file) '" + string3 + "'");
                    this.m_newDomain.save(string3);
                    break block10;
                }
                s_logger.message("Not found any BOIs, Domain not created");
                System.out.println("Not found any BOIs, Domain not created");
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            s_logger.message(DESCRIPTION);
            String[] stringArray2 = new String[]{};
            String[] stringArray3 = new String[]{};
            String[] stringArray4 = new String[]{ARG_DIRECTORY, ARG_DOMAIN_NAME, ARG_DOMAIN_ID, ARG_VERSION};
            CommandLine.ParseResult parseResult = null;
            CommandLine commandLine = null;
            try {
                commandLine = new CommandLine(stringArray, stringArray2, stringArray3, stringArray4);
                parseResult = commandLine.parseResult();
                if (parseResult.hasOption(ARG_DIRECTORY) && parseResult.hasOption(ARG_DOMAIN_NAME) && parseResult.hasOption(ARG_DOMAIN_ID) && parseResult.hasOption(ARG_VERSION)) {
                    String string = parseResult.getOptionArgument(ARG_DIRECTORY);
                    String string2 = parseResult.getOptionArgument(ARG_DOMAIN_NAME);
                    String string3 = parseResult.getOptionArgument(ARG_DOMAIN_ID);
                    String string4 = parseResult.getOptionArgument(ARG_VERSION);
                    s_logger.message("Directory   = '" + string + "'");
                    s_logger.message("Domain Name = '" + string2 + "'");
                    s_logger.message("Domain Id   = '" + string3 + "'");
                    s_logger.message("BOI Version =  '" + string4 + "'");
                    DomainCreator domainCreator = new DomainCreator(string2, string3);
                    domainCreator.createRepFile(string, string4);
                    break block3;
                }
                s_logger.message("Error: insufficient arguments");
                System.out.println("Error: insufficient arguments");
                System.out.println(TOOL_USAGE);
                LoggerFactory.exit(1);
            }
            catch (CommandLine.ParseException parseException) {
                System.out.println("Error: invalid argument(s): " + NEWLINE + parseException);
                System.out.println(TOOL_USAGE);
                LoggerFactory.exit(1);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_DOMAIN_CREATOR);
        TOOL_NAME = (class$com$baan$b3$domain$DomainCreator == null ? (class$com$baan$b3$domain$DomainCreator = DomainCreator.class$("com.baan.b3.domain.DomainCreator")) : class$com$baan$b3$domain$DomainCreator).getName();
        NEWLINE = System.getProperty("line.separator");
        FILE_SEP = System.getProperty("file.separator");
        TOOL_USAGE = DESCRIPTION + NEWLINE + NEWLINE + TOOL_NAME + " -" + ARG_DIRECTORY + " <Directory> -" + ARG_DOMAIN_NAME + " <domain name> -" + ARG_DOMAIN_ID + " <domain id> -" + ARG_VERSION + " <BOI Version>" + NEWLINE + NEWLINE + "options:" + NEWLINE + "  -" + ARG_DIRECTORY + "   Directory to start search for Java BOI (Manager) Classes " + NEWLINE + "  -" + ARG_DOMAIN_NAME + "  Name of the Domain to create" + NEWLINE + "  -" + ARG_DOMAIN_ID + "    ID of the domain to create" + NEWLINE + "  -" + ARG_VERSION + "     BOI Version string" + NEWLINE + NEWLINE;
    }

    private class ClassFileFilter
    implements FileFilter {
        private ClassFileFilter() {
        }

        public boolean accept(File file2) {
            if (file2.isDirectory()) {
                return true;
            }
            String string = file2.getName().toLowerCase();
            return string.endsWith("class");
        }
    }

    private class MyURLClassLoader
    extends URLClassLoader {
        public MyURLClassLoader(URL[] uRLArray) {
            super(uRLArray, ClassLoader.getSystemClassLoader());
        }

        public Class findClass(String string) throws ClassNotFoundException {
            return super.findClass(string);
        }
    }
}

