/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.domain;

import com.baan.b3.domain.IBoiDescriptor;
import com.baan.b3.domain.IDomain;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Domain
implements IDomain,
Serializable {
    static final long serialVersionUID = 3036271864245844668L;
    private String m_name = null;
    private String m_ID = null;
    private Hashtable m_bois = new Hashtable();

    private Domain(String string, String string2) {
        this.m_name = string;
        this.m_ID = string2;
    }

    public static IDomain create(String string, String string2) {
        return new Domain(string, string2);
    }

    public static IDomain open(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        Domain domain = null;
        try {
            domain = (Domain)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        objectInputStream.close();
        return domain;
    }

    public static IDomain open(URL uRL) throws FileNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
        Domain domain = null;
        try {
            domain = (Domain)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        objectInputStream.close();
        return domain;
    }

    public String getName() {
        return this.m_name;
    }

    public String getID() {
        return this.m_ID;
    }

    public synchronized void addBoi(IBoiDescriptor iBoiDescriptor) {
        String string = iBoiDescriptor.getName();
        if (this.m_bois.containsKey(string)) {
            throw new IllegalArgumentException("BOI " + string + " already present in domain");
        }
        this.m_bois.put(string, iBoiDescriptor);
    }

    public void removeBoi(String string) {
        this.m_bois.remove(string);
    }

    public IBoiDescriptor getBoi(String string) {
        return (IBoiDescriptor)this.m_bois.get(string);
    }

    public Enumeration getBois() {
        return this.m_bois.elements();
    }

    public String[] getBoiNames() {
        String[] stringArray = new String[this.m_bois.size()];
        int n = 0;
        Enumeration enumeration2 = this.m_bois.keys();
        while (enumeration2.hasMoreElements()) {
            stringArray[n++] = (String)enumeration2.nextElement();
        }
        return stringArray;
    }

    public void save(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }
}

