/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.dil;

import com.baan.b3.boi1.IUserSession;
import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.owimpl.xmlconnector.error.StatusHandler;
import com.baan.owimpl.xmlconnector.exception.RequestParserException;
import com.baan.owimpl.xmlconnector.preparedmetadata.Definition;
import com.baan.owimpl.xmlconnector.preparedmetadata.XMLConnectorObject;
import com.baan.owimpl.xmlconnector.util.Conversions;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.NiceDOMWriter;
import java.util.Vector;

public class Request {
    private static final String COPYRIGHT = "Copyright (c) 2003 SSA Global Technologies, Inc.";
    private Document m_requestDocument = null;
    private Document m_RED = null;
    private Conversions conversion = new Conversions();
    private IUserSession m_userSession = null;
    private Vector m_ASMManagers = new Vector();
    private XMLConnectorObject xmlConnectorObject = null;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.dil", "XMLConnectorRequestAPI");
    private ILicense m_license = null;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String EMPTY = "";
    private Definition m_def = new Definition();
    private int m_timeOut;
    private int m_fetchsize;
    private boolean isOverRideTimeOut = false;
    private boolean isOverRideFetchSize = false;

    public boolean getMetadata(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4) {
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        String string2 = "DTD";
        Definition.isOldInterface = true;
        try {
            s_logger.message("License : Checking License");
            this.m_license = LicenseFactory.createXMLConnectorLicense();
            if (this.m_license.getDaysLeft() < 0) {
                s_logger.errorMessage("License Expired");
                throw new LicenseException("License Expired");
            }
            s_logger.message("License : License check successful");
            this.m_requestDocument = this.conversion.StringToDocument(string);
            this.parseRequestDocument(this.m_requestDocument, stringBuffer5, stringBuffer6);
            String string3 = new NiceDOMWriter(this.m_requestDocument.getDocumentElement()).toString();
            s_logger.message("Input Request Document : " + string3);
            this.xmlConnectorObject = new XMLConnectorObject(stringBuffer6.toString(), stringBuffer5.toString());
            if (stringBuffer5.toString().equals(EMPTY)) {
                stringBuffer2.append(this.MethodListHeader());
                Node node = this.xmlConnectorObject.getMethodList();
                stringBuffer2.append(new DOMWriter((Document)node).toString());
                s_logger.flowMessage("The Supported Methods are : ");
                s_logger.flowMessage(stringBuffer2.toString());
            } else if (stringBuffer5.toString().equals("GWNetList")) {
                stringBuffer.append(this.xmlConnectorObject.getRequestDocument());
                s_logger.message("Output Request Document : " + stringBuffer.toString());
                stringBuffer3.append(this.xmlConnectorObject.getErrorDocument());
                s_logger.message("Output Error Document : " + stringBuffer3.toString());
            } else {
                stringBuffer.append(this.xmlConnectorObject.getRequestDocument());
                s_logger.message("Output Request Document : " + stringBuffer.toString());
                stringBuffer2.append(this.xmlConnectorObject.getResponseDocument());
                s_logger.message("Output Response Document : " + stringBuffer2.toString());
                stringBuffer3.append(this.xmlConnectorObject.getErrorDocument());
                s_logger.message("Output Error Document : " + stringBuffer3.toString());
            }
            this.m_license.release();
            return true;
        }
        catch (Exception exception) {
            if (!(exception instanceof LicenseException)) {
                this.m_license.release();
            } else {
                s_logger.errorMessage("License : License check Failed");
            }
            s_logger.errorMessage(this.getClass().getName());
            StatusHandler statusHandler = new StatusHandler();
            this.m_RED = statusHandler.createFailureDoc(exception);
            String string4 = new DOMWriter(this.m_RED).toString();
            stringBuffer4.append(string4);
            String string5 = new NiceDOMWriter(this.m_RED.getDocumentElement()).toString();
            s_logger.errorMessage("Output Error Document : " + string5);
            return false;
        }
    }

    public boolean execute(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Definition.isOldInterface = true;
        StatusHandler statusHandler = new StatusHandler();
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.appendChild(documentImpl.createElement("Response"));
        try {
            s_logger.message("License : Checking License");
            this.m_license = LicenseFactory.createXMLConnectorLicense();
            if (this.m_license.getDaysLeft() < 0) {
                throw new LicenseException("License Expired");
            }
            s_logger.message("License : License check successful");
            this.m_requestDocument = this.conversion.StringToDocument(string);
            String string2 = new NiceDOMWriter(this.m_requestDocument.getDocumentElement()).toString();
            s_logger.message("Input Request Document : " + string2);
            this.xmlConnectorObject = new XMLConnectorObject(this.m_requestDocument, this.m_userSession, this.m_ASMManagers, true, this.m_timeOut, this.isOverRideTimeOut);
            String string3 = this.xmlConnectorObject.invoke(stringBuffer2, documentImpl, this.m_fetchsize, this.isOverRideFetchSize);
            stringBuffer.append(string3);
            s_logger.message("Response Document : " + stringBuffer.toString());
            s_logger.message("Request Status : " + stringBuffer2.toString());
        }
        catch (Exception exception) {
            if (!(exception instanceof LicenseException)) {
                this.m_license.release();
            } else {
                s_logger.errorMessage("License : License check Failed");
            }
            s_logger.errorMessage(this.getClass().getName());
            stringBuffer.append(new DOMWriter(documentImpl).toString());
            this.m_RED = statusHandler.createFailureDoc(exception);
            String string4 = new DOMWriter(this.m_RED).toString();
            stringBuffer2.append(string4);
            String string5 = new NiceDOMWriter(this.m_RED.getDocumentElement()).toString();
            s_logger.errorMessage("Output Error Document : " + string5);
            return false;
        }
        this.m_license.release();
        return true;
    }

    public boolean execute1(IUserSession iUserSession, String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.m_userSession = iUserSession;
        this.execute(string, stringBuffer, stringBuffer2);
        return true;
    }

    public boolean close() throws Exception {
        try {
            if (this.xmlConnectorObject != null) {
                s_logger.flowMessage("calling closeall of XML Connector Object from the Request class");
                return this.xmlConnectorObject.closeAll(this.m_ASMManagers);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private StringBuffer MethodListHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE ObjectMethods [ ");
        stringBuffer.append("<!ELEMENT ObjectMethods (MethodName*) >");
        stringBuffer.append("<!ELEMENT MethodName (#PCDATA) > ]>");
        return stringBuffer;
    }

    private void parseRequestDocument(Document document, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        Element element = null;
        NodeList nodeList = null;
        element = (Element)document.getFirstChild();
        this.checkRootNode(element);
        this.checkRootNodeForAttribute(element);
        nodeList = element.getElementsByTagName("ObjectName");
        if (nodeList.getLength() < 1) {
            throw new RequestParserException("ObjectName Tag is missing");
        }
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Request can not have more than one ObjectName Tag");
        }
        if (nodeList.item(0).getFirstChild() == null) {
            throw new RequestParserException("Request can not have empty ObjectName Tag");
        }
        stringBuffer2.append(this.getNodeValue(nodeList.item(0)));
        nodeList = element.getElementsByTagName("MethodName");
        if (nodeList.getLength() < 1) {
            throw new RequestParserException("MethodName Tag is missing");
        }
        if (nodeList.getLength() > 1) {
            throw new RequestParserException("Request can not have more than one MethodName Tag");
        }
        if (nodeList.item(0).getFirstChild() == null) {
            stringBuffer.append(EMPTY);
        } else {
            stringBuffer.append(this.getNodeValue(nodeList.item(0)));
        }
    }

    private String getNodeValue(Node node) throws Exception {
        String string = EMPTY;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() != 3) {
                throw new RequestParserException("Request can not have MIX type of Element tag, check " + node.getNodeName() + " Tag");
            }
            String string2 = nodeList.item(n).getNodeValue();
            if (!string2.equals(EMPTY)) {
                string = string2;
            }
            ++n;
        }
        if (string.equals(EMPTY)) {
            throw new RequestParserException("Element tag " + node.getNodeName() + " can not have empty value");
        }
        return string;
    }

    private void checkRootNode(Node node) throws Exception {
        if (!node.getNodeName().equals("Request")) {
            throw new RequestParserException("Document should have Request Tag as the Root Element");
        }
        NodeList nodeList = node.getChildNodes();
        String string = EMPTY;
        int n = 0;
        while (n < nodeList.getLength()) {
            string = nodeList.item(n).getNodeName();
            if (!(string == null || string.equals("#text") || string.equals("ObjectName") || string.equals("MethodName"))) {
                throw new RequestParserException("Invalid Request Tag : " + string);
            }
            ++n;
        }
        this.checkTextNode(node);
    }

    private void checkTextNode(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 3) {
                String string = nodeList.item(n).getNodeValue();
                int n2 = 0;
                while (n2 < string.length()) {
                    if (!(string.substring(n2, n2 + 1).equals(SPACE) || string.substring(n2, n2 + 1).equals(TAB) || string.substring(n2, n2 + 1).equals(NEW_LINE))) {
                        throw new RequestParserException("Element tag " + node.getNodeName() + " can not have MIX type");
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void checkRootNodeForAttribute(Node node) throws Exception {
        if (node.getAttributes().getLength() > 0) {
            throw new RequestParserException("Request Tag has illegal attribute.");
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node2 = nodeList.item(n);
            if (node2.getAttributes() != null && node2.getAttributes().getLength() > 0) {
                throw new RequestParserException("Invalid attribute in tag : " + node2.getNodeName());
            }
            ++n;
        }
    }
}

