/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.boi1;

import com.baan.b3.boi1.BoiApplicationException;
import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiProgrammingRException;
import com.baan.b3.boi1.BoiSynchronizationException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.dt.TransactionScope;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IMetadataFactory;
import com.baan.b3.boi1.metadata.IMethodImplementationAdapter;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.util.IntStack;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BaanDLLCall;
import com.eibus.co.BaanSQLQuery;
import com.eibus.co.BusinessElement;
import com.eibus.co.DataSet;
import com.eibus.co.Layout;
import com.eibus.co.QueryByDLL;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BusinessElementImpl;
import com.eibus.co.dom.ContentInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Node;

public abstract class BusinessObjectManager {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.b3.boi1", "BusinessObjectManager");
    private static Directory s_directory;
    private BdmAdapter m_impl;
    public static final String BSQ_METHOD_ADAPTER_CLASS_NAME = "com.baan.b3.boi1.BusinessObjectManager$BsqMethodAdapter";
    public static final String BDC_METHOD_ADAPTER_CLASS_NAME = "com.baan.b3.boi1.BusinessObjectManager$BdcMethodAdapter";
    public static final String QBD_METHOD_ADAPTER_CLASS_NAME = "com.baan.b3.boi1.BusinessObjectManager$QbdMethodAdapter";
    private static final int AVG_LAYOUT_DEPTH = 3;
    protected static final int BDC_MNR_BUSINESSOBJECT = 0;
    protected static final int BDC_MNR_VECTOR = 1;
    protected static final int BSQ_MNR_BUSINESSOBJECT = 0;
    protected static final int BSQ_MNR_ITERATOR = 1;
    protected static final int BSQ_MNR_ADD = 2;
    protected static final int QBD_MNR_BUSINESSOBJECT = 0;
    protected static final int QBD_MNR_ITERATOR = 1;

    protected void setContentLicense(String string) {
        this.m_impl.setContentLicense(string);
    }

    protected BusinessObjectManager() throws BoiException {
        try {
            this.m_impl = new BdmAdapter();
        }
        catch (BusException busException) {
            throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
        }
    }

    protected BusinessObjectManager(String string, String string2) throws BoiException {
        try {
            this.m_impl = new BdmAdapter(string, string2);
        }
        catch (BusException busException) {
            throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
        }
    }

    BdmAdapter getImpl() {
        return this.m_impl;
    }

    private static Directory getDirectory() throws DirectoryException {
        if (s_directory == null) {
            s_directory = new DirectoryServiceProvider().getDirectoryService();
        }
        return s_directory;
    }

    protected String date2String(Date date) {
        return BusinessElementImpl.Date2String(date);
    }

    protected String ByteArray2String(byte[] byArray) {
        return BusinessElementImpl.BinBase642String(byArray);
    }

    protected String XMLNode2String(Node node) {
        return BusinessElementImpl.XMLNode2String(node);
    }

    protected abstract Class[] getBusinessObjectClasses();

    protected Iterator baanSqlQueryIterator(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws BoiException {
        return this.m_impl.baanSqlQueryIterator(baanSqlQuerySpec, stringArray);
    }

    protected BusinessObject baanSqlQueryBusinessObject(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws BoiException, BoiApplicationException {
        return this.m_impl.baanSqlQueryBusinessObject(baanSqlQuerySpec, stringArray);
    }

    protected void addBaanSqlQuery(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws IllegalStateException {
        this.m_impl.addBaanSqlQuery(baanSqlQuerySpec, stringArray);
    }

    protected Vector baanDllCallVector(BaanDllCallSpec baanDllCallSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
        return this.m_impl.baanDllCallVector(baanDllCallSpec, stringArray, businessObjectArray);
    }

    protected BusinessObject baanDllCallBusinessObject(BaanDllCallSpec baanDllCallSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
        return this.m_impl.baanDllCallBusinessObject(baanDllCallSpec, stringArray, businessObjectArray);
    }

    protected Iterator queryByDllIterator(QueryByDllSpec queryByDllSpec, String[] stringArray, BusinessObject[] businessObjectArray) {
        return this.m_impl.queryByDllIterator(queryByDllSpec, stringArray, businessObjectArray);
    }

    protected BusinessObject queryByDllBusinessObject(QueryByDllSpec queryByDllSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
        return this.m_impl.queryByDllBusinessObject(queryByDllSpec, stringArray, businessObjectArray);
    }

    protected static IMetadataFactory getMetadataFactory() {
        return BoiToolkit.getDefaultToolkit().getMetadataFactory();
    }

    public Iterator getIterator() throws IllegalStateException {
        return this.m_impl.getIterator();
    }

    public void initialize(String string) throws BoiException {
        this.m_impl.initializeAdapt(string);
    }

    public void ping() throws BoiException {
        this.m_impl.pingAdapt();
    }

    public void synchronize() throws BoiException, BoiSynchronizationException {
        this.m_impl.synchronizeAdapt();
    }

    public void setTimeOut(long l) {
        this.m_impl.setTimeOut(l);
    }

    public long getTimeOut() {
        return this.m_impl.getTimeOut();
    }

    public void add(BusinessObject businessObject) {
        this.m_impl.add(businessObject);
    }

    public void introduce(BusinessObject businessObject) {
        this.m_impl.add(businessObject);
    }

    public void close() {
        this.m_impl.closeAdapt();
    }

    public void releaseAll() {
        this.m_impl.releaseAll();
    }

    public void release(BusinessObject businessObject) {
        this.m_impl.releaseAdapt(businessObject);
    }

    public void remove(BusinessObject businessObject) {
        this.m_impl.removeAdapt(businessObject);
    }

    public IExceptionDescriptor[] getWarnings() {
        return this.m_impl.getWarningsAdapt();
    }

    public void setTransactionScope(TransactionScope transactionScope) {
        transactionScope.doSwitch(new TransactionScope.Switch(){

            public void tsNone() {
                BusinessObjectManager.this.m_impl.setTransactionScope(0);
            }

            public void tsGlobal() {
                BusinessObjectManager.this.m_impl.setTransactionScope(1);
            }

            public void tsManager() {
                BusinessObjectManager.this.m_impl.setTransactionScope(2);
            }

            public void tsBusinessObject() {
                BusinessObjectManager.this.m_impl.setTransactionScope(3);
            }
        });
    }

    public void setUserInfo(IUserInfo iUserInfo) {
        this.m_impl.setUserInfoAdapt(iUserInfo);
    }

    public void setUnconditional(boolean bl) {
        this.m_impl.setUnconditional(bl);
    }

    public void changeBusinessObject(BusinessObject businessObject, BusinessObject businessObject2) throws IllegalArgumentException, BoiProgrammingRException {
        this.m_impl.changeBusinessObject(businessObject, businessObject2);
    }

    public String getCurrentBackend() {
        return this.m_impl.getCurrentBackend();
    }

    protected static IMethodImplementationAdapter createBdcMethodAdapter(int n, BaanDllCallSpec baanDllCallSpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2, int n3) {
        return new BdcMethodAdapter(n, baanDllCallSpec, clazz, iParameterMetadataArray, iParameterMetadata, n2, n3);
    }

    protected static IMethodImplementationAdapter createBsqMethodAdapter(int n, BaanSqlQuerySpec baanSqlQuerySpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2) {
        return new BsqMethodAdapter(n, baanSqlQuerySpec, clazz, iParameterMetadataArray, iParameterMetadata, n2);
    }

    protected static IMethodImplementationAdapter createQbdMethodAdapter(int n, QueryByDllSpec queryByDllSpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2, int n3) {
        return new QbdMethodAdapter(n, queryByDllSpec, clazz, iParameterMetadataArray, iParameterMetadata, n2, n3);
    }

    private static void fillParameterArrays(String[] stringArray, BusinessObject[] businessObjectArray, Object[] objectArray, IParameterMetadata[] iParameterMetadataArray) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < iParameterMetadataArray.length) {
            IParameterMetadata iParameterMetadata = iParameterMetadataArray[n3];
            IObjectMetadata iObjectMetadata = iParameterMetadata.getType();
            if (iObjectMetadata instanceof IBusinessObjectMetadata) {
                if (!objectArray[n3].getClass().getName().equals(iObjectMetadata.getTypeName())) {
                    throw new IllegalArgumentException("p_parameters[" + n3 + "] must be of type '" + iObjectMetadata.getTypeName() + "' instead of '" + objectArray[n3].getClass().getName() + "'");
                }
                businessObjectArray[n2++] = (BusinessObject)objectArray[n3];
            } else if (iObjectMetadata instanceof IPrimalObjectMetadata) {
                int n4 = BusinessObject.getPrimalType(iObjectMetadata.getTypeName());
                BusinessObject.PrimalVal primalVal = null;
                try {
                    primalVal = BusinessObject.PrimalVal.getInstance(objectArray[n3], n4);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("p_parameters[" + n3 + "] must be of type '" + iObjectMetadata.getTypeName() + "' instead of '" + objectArray[n3].getClass().getName() + "'");
                }
                stringArray[n++] = BusinessObject.primalValToDcdString(primalVal, n4);
            } else {
                throw new RuntimeException("Unrecognised parameter type in metadata: " + iObjectMetadata);
            }
            ++n3;
        }
    }

    private static void fillParameterArraysWithStrings(String[] stringArray, BusinessObject[] businessObjectArray, Object[] objectArray, IParameterMetadata[] iParameterMetadataArray) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < iParameterMetadataArray.length) {
            IParameterMetadata iParameterMetadata = iParameterMetadataArray[n3];
            IObjectMetadata iObjectMetadata = iParameterMetadata.getType();
            if (iObjectMetadata instanceof IBusinessObjectMetadata) {
                if (!objectArray[n3].getClass().getName().equals(iObjectMetadata.getTypeName())) {
                    throw new IllegalArgumentException("p_parameters[" + n3 + "] must be of type '" + iObjectMetadata.getTypeName() + "' instead of '" + objectArray[n3].getClass().getName() + "'");
                }
                businessObjectArray[n2++] = (BusinessObject)objectArray[n3];
            } else if (iObjectMetadata instanceof IPrimalObjectMetadata) {
                int n4 = BusinessObject.getPrimalType(iObjectMetadata.getTypeName());
                BusinessObject.PrimalVal primalVal = null;
                try {
                    primalVal = BusinessObject.dcdStringToPrimalVal((String)objectArray[n3], n4);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("p_parameters[" + n3 + "] must be of type 'java.lang.String'" + " instead of '" + objectArray[n3].getClass().getName() + "'");
                }
                stringArray[n++] = BusinessObject.primalValToDcdString(primalVal, n4);
            } else {
                throw new RuntimeException("Unrecognised parameter type in metadata: " + iObjectMetadata);
            }
            ++n3;
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_JAVA_CLIENT);
        s_directory = null;
    }

    private static class QbdMethodAdapter
    implements IMethodImplementationAdapter {
        private final Class m_targetClass;
        private final int m_methodNr;
        private final QueryByDllSpec m_methodSpec;
        private final IParameterMetadata[] m_parameterTypes;
        private final IParameterMetadata m_returnType;
        private final int m_nrStringParameters;
        private final int m_nrBoParameters;

        public QbdMethodAdapter(int n, QueryByDllSpec queryByDllSpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2, int n3) {
            this.m_methodNr = n;
            this.m_methodSpec = queryByDllSpec;
            this.m_targetClass = clazz;
            this.m_parameterTypes = iParameterMetadataArray;
            this.m_returnType = iParameterMetadata;
            this.m_nrStringParameters = n2;
            this.m_nrBoParameters = n3;
        }

        public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrStringParameters];
            BusinessObject[] businessObjectArray = new BusinessObject[this.m_nrBoParameters];
            BusinessObjectManager.fillParameterArrays(stringArray, businessObjectArray, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.queryByDllBusinessObject(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.queryByDllIterator(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.QbdMethodAdapter.invoke: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }

        public Object invokeWithStrings(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrStringParameters];
            BusinessObject[] businessObjectArray = new BusinessObject[this.m_nrBoParameters];
            BusinessObjectManager.fillParameterArraysWithStrings(stringArray, businessObjectArray, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.queryByDllBusinessObject(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.queryByDllIterator(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.QbdMethodAdapter.invokeWithStrings: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
    }

    private static class BsqMethodAdapter
    implements IMethodImplementationAdapter {
        private final Class m_targetClass;
        private final int m_methodNr;
        private final BaanSqlQuerySpec m_methodSpec;
        private final IParameterMetadata[] m_parameterTypes;
        private final IParameterMetadata m_returnType;
        private final int m_nrParameters;

        public BsqMethodAdapter(int n, BaanSqlQuerySpec baanSqlQuerySpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2) {
            this.m_methodNr = n;
            this.m_methodSpec = baanSqlQuerySpec;
            this.m_targetClass = clazz;
            this.m_parameterTypes = iParameterMetadataArray;
            this.m_returnType = iParameterMetadata;
            this.m_nrParameters = n2;
        }

        public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrParameters];
            BusinessObjectManager.fillParameterArrays(stringArray, null, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.baanSqlQueryBusinessObject(this.m_methodSpec, stringArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.baanSqlQueryIterator(this.m_methodSpec, stringArray);
                    }
                    case 2: {
                        businessObjectManager.m_impl.addBaanSqlQuery(this.m_methodSpec, stringArray);
                        return null;
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.BsqMethodAdapter.invoke: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }

        public Object invokeWithStrings(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrParameters];
            BusinessObjectManager.fillParameterArraysWithStrings(stringArray, null, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.baanSqlQueryBusinessObject(this.m_methodSpec, stringArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.baanSqlQueryIterator(this.m_methodSpec, stringArray);
                    }
                    case 2: {
                        businessObjectManager.m_impl.addBaanSqlQuery(this.m_methodSpec, stringArray);
                        return null;
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.BsqMethodAdapter.invokeWithStrings: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
    }

    private static class BdcMethodAdapter
    implements IMethodImplementationAdapter {
        private final Class m_targetClass;
        private final int m_methodNr;
        private final BaanDllCallSpec m_methodSpec;
        private final IParameterMetadata[] m_parameterTypes;
        private final IParameterMetadata m_returnType;
        private final int m_nrStringParameters;
        private final int m_nrBoParameters;

        public BdcMethodAdapter(int n, BaanDllCallSpec baanDllCallSpec, Class clazz, IParameterMetadata[] iParameterMetadataArray, IParameterMetadata iParameterMetadata, int n2, int n3) {
            this.m_methodNr = n;
            this.m_methodSpec = baanDllCallSpec;
            this.m_targetClass = clazz;
            this.m_parameterTypes = iParameterMetadataArray;
            this.m_returnType = iParameterMetadata;
            this.m_nrStringParameters = n2;
            this.m_nrBoParameters = n3;
        }

        public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrStringParameters];
            BusinessObject[] businessObjectArray = new BusinessObject[this.m_nrBoParameters];
            BusinessObjectManager.fillParameterArrays(stringArray, businessObjectArray, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.baanDllCallBusinessObject(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.baanDllCallVector(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.BdcMethodAdapter.invoke: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }

        public Object invokeWithStrings(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObjectManager businessObjectManager = (BusinessObjectManager)object;
            if (objectArray == null || objectArray.length != this.m_parameterTypes.length) {
                throw new IllegalArgumentException("p_parameters must be non-null with length " + this.m_parameterTypes.length);
            }
            String[] stringArray = new String[this.m_nrStringParameters];
            BusinessObject[] businessObjectArray = new BusinessObject[this.m_nrBoParameters];
            BusinessObjectManager.fillParameterArraysWithStrings(stringArray, businessObjectArray, objectArray, this.m_parameterTypes);
            try {
                switch (this.m_methodNr) {
                    case 0: {
                        return businessObjectManager.m_impl.baanDllCallBusinessObject(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                    case 1: {
                        return businessObjectManager.m_impl.baanDllCallVector(this.m_methodSpec, stringArray, businessObjectArray);
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObjectManager.BdcMethodAdapter.invokeWithStrings: Method number not recognised: " + this.m_methodNr);
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
    }

    protected static class QueryByDllParameterSpec {
        public static final String QBDP_SCOPE_OUT = "out".intern();
        public static final String QBDP_SCOPE_IN = "in".intern();
        public static final String QBDP_SCOPE_INOUT = "inout".intern();
        public final boolean isElement;
        public final String scope;
        public final String typeName;
        public final String dcdType;
        public final String length;

        public QueryByDllParameterSpec(boolean bl, String string, String string2, String string3, String string4) throws NullPointerException, IllegalArgumentException {
            string = string.intern();
            if (string != QBDP_SCOPE_OUT && string != QBDP_SCOPE_IN && string != QBDP_SCOPE_INOUT) {
                throw new IllegalArgumentException("value " + string + " not valid for p_scope");
            }
            if (string2 == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            if (string3 == null) {
                throw new NullPointerException("p_dcdType must not be null");
            }
            this.isElement = bl;
            this.scope = string;
            this.typeName = string2;
            this.dcdType = string3;
            this.length = string4;
        }
    }

    protected static class QueryByDllSpec {
        private static final QueryByDllParameterSpec[] QBD_EMPTY_PARAMETERS = new QueryByDllParameterSpec[0];
        public final String idName;
        public final String dllName;
        public final String methodName;
        public final String methodReturnTypeName;
        public final String methodReturnComponentTypeName;
        public final Class returnObjectClass;
        private QueryByDllParameterSpec[] m_parameters = QBD_EMPTY_PARAMETERS;

        public QueryByDllSpec(String string, String string2, String string3, String string4, String string5, Class clazz) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_dllName must not be null");
            }
            if (string3 == null) {
                throw new NullPointerException("p_methodName must not be null");
            }
            if (clazz == null) {
                throw new NullPointerException("p_returnObjectClass must not be null");
            }
            this.idName = string;
            this.dllName = string2;
            this.methodName = string3;
            this.methodReturnTypeName = string4;
            this.methodReturnComponentTypeName = string5;
            this.returnObjectClass = clazz;
        }

        public QueryByDllParameterSpec[] getParameters() {
            return this.m_parameters;
        }

        public void setParameters(QueryByDllParameterSpec[] queryByDllParameterSpecArray) {
            this.m_parameters = queryByDllParameterSpecArray == null ? QBD_EMPTY_PARAMETERS : queryByDllParameterSpecArray;
        }
    }

    protected static class BaanDllCallParameterSpec {
        public static final String BDCP_SCOPE_OUT = "out".intern();
        public static final String BDCP_SCOPE_IN = "in".intern();
        public static final String BDCP_SCOPE_INOUT = "inout".intern();
        public final boolean isElement;
        public final String scope;
        public final String typeName;
        public final String dcdType;
        public final String length;

        public BaanDllCallParameterSpec(boolean bl, String string, String string2, String string3, String string4) throws NullPointerException, IllegalArgumentException {
            string = string.intern();
            if (string != BDCP_SCOPE_OUT && string != BDCP_SCOPE_IN && string != BDCP_SCOPE_INOUT) {
                throw new IllegalArgumentException("value " + string + " not valid for p_scope");
            }
            if (string2 == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            if (string3 == null) {
                throw new NullPointerException("p_dcdType must not be null");
            }
            this.isElement = bl;
            this.scope = string;
            this.typeName = string2;
            this.dcdType = string3;
            this.length = string4;
        }
    }

    protected static class BaanDllCallSpec {
        private static final BaanDllCallParameterSpec[] BDC_EMPTY_PARAMETERS = new BaanDllCallParameterSpec[0];
        public final String dllName;
        public final String methodName;
        public final String methodReturnTypeName;
        public final String methodReturnComponentTypeName;
        public final Class returnObjectClass;
        private BaanDllCallParameterSpec[] m_parameters = BDC_EMPTY_PARAMETERS;

        public BaanDllCallSpec(String string, String string2, String string3, String string4, Class clazz) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_dllName must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_methodName must not be null");
            }
            if (clazz == null) {
                throw new NullPointerException("p_returnObjectClass must not be null");
            }
            this.dllName = string;
            this.methodName = string2;
            this.methodReturnTypeName = string3;
            this.methodReturnComponentTypeName = string4;
            this.returnObjectClass = clazz;
        }

        public BaanDllCallParameterSpec[] getParameters() {
            return this.m_parameters;
        }

        public void setParameters(BaanDllCallParameterSpec[] baanDllCallParameterSpecArray) {
            this.m_parameters = baanDllCallParameterSpecArray == null ? BDC_EMPTY_PARAMETERS : baanDllCallParameterSpecArray;
        }
    }

    protected static class BaanSqlQuerySubLayoutSpec {
        public final BaanSqlQueryLayoutSpec layoutDef;
        public final boolean isReference;
        public final BaanSqlQuerySpec querySpec;
        public final boolean shouldAppendConstructor;
        public final boolean shouldProcessLayoutDef;

        public BaanSqlQuerySubLayoutSpec(BaanSqlQueryLayoutSpec baanSqlQueryLayoutSpec, boolean bl, BaanSqlQuerySpec baanSqlQuerySpec, boolean bl2, boolean bl3) throws NullPointerException {
            if (baanSqlQueryLayoutSpec == null) {
                throw new NullPointerException("p_layoutDef must not be null");
            }
            this.layoutDef = baanSqlQueryLayoutSpec;
            this.isReference = bl;
            this.querySpec = baanSqlQuerySpec;
            this.shouldAppendConstructor = bl2;
            this.shouldProcessLayoutDef = bl3;
        }
    }

    protected static class BaanSqlQueryLayoutSpec {
        private static final BaanSqlQuerySubLayoutSpec[] BSQ_EMPTY_SUBLAYOUTS = new BaanSqlQuerySubLayoutSpec[0];
        private BaanSqlQuerySubLayoutSpec[] m_subLayouts = BSQ_EMPTY_SUBLAYOUTS;
        public final String typeName;
        public final boolean isAlias;

        public BaanSqlQueryLayoutSpec(String string, boolean bl) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            this.typeName = string;
            this.isAlias = bl;
        }

        public BaanSqlQuerySubLayoutSpec[] getSubLayouts() {
            return this.m_subLayouts;
        }

        public void setSubLayouts(BaanSqlQuerySubLayoutSpec[] baanSqlQuerySubLayoutSpecArray) {
            this.m_subLayouts = baanSqlQuerySubLayoutSpecArray == null ? BSQ_EMPTY_SUBLAYOUTS : baanSqlQuerySubLayoutSpecArray;
        }
    }

    protected static class BaanSqlQueryReturnTypeSpec {
        public final Class returnElementClass;

        public BaanSqlQueryReturnTypeSpec(Class clazz) throws NullPointerException {
            if (clazz == null) {
                throw new NullPointerException("p_returnElementClass must not be null");
            }
            this.returnElementClass = clazz;
        }
    }

    protected static class BaanSqlQueryParameterSpec {
        public final String typeName;
        public final String dcdType;
        public final String relatedColumn;

        public BaanSqlQueryParameterSpec(String string, String string2, String string3) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_typeName must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_dcdType must not be null");
            }
            this.typeName = string;
            this.dcdType = string2;
            this.relatedColumn = string3;
        }
    }

    protected static class BaanSqlQuerySpec {
        private static final BaanSqlQueryParameterSpec[] BSQ_EMPTY_PARAMETERS = new BaanSqlQueryParameterSpec[0];
        private BaanSqlQueryParameterSpec[] m_parameters = BSQ_EMPTY_PARAMETERS;
        public final String queryText;
        public final String idName;
        public final BaanSqlQueryLayoutSpec layoutDef;
        public final BaanSqlQueryReturnTypeSpec returnType;

        public BaanSqlQuerySpec(String string, String string2, BaanSqlQueryLayoutSpec baanSqlQueryLayoutSpec, BaanSqlQueryReturnTypeSpec baanSqlQueryReturnTypeSpec) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException("p_queryText must not be null");
            }
            if (string2 == null) {
                throw new NullPointerException("p_idName must not be null");
            }
            this.queryText = string;
            this.idName = string2;
            this.layoutDef = baanSqlQueryLayoutSpec;
            this.returnType = baanSqlQueryReturnTypeSpec;
        }

        public BaanSqlQueryParameterSpec[] getParameters() {
            return this.m_parameters;
        }

        public void setParameters(BaanSqlQueryParameterSpec[] baanSqlQueryParameterSpecArray) {
            this.m_parameters = baanSqlQueryParameterSpecArray == null ? BSQ_EMPTY_PARAMETERS : baanSqlQueryParameterSpecArray;
        }
    }

    private class BdmAdapter
    extends BusinessDocumentManager {
        private BaanSQLQuery m_currentBaanSqlQuery;
        private String m_currentBaanSqlQueryId;
        private Class m_currentReturnElementClass;

        BdmAdapter() throws BusException {
            this.registerBusinessObjects();
        }

        BdmAdapter(String string, String string2) throws BusException {
            super(string, string2);
            this.registerBusinessObjects();
        }

        private void registerBusinessObjects() {
            Class[] classArray = BusinessObjectManager.this.getBusinessObjectClasses();
            int n = 0;
            while (n < classArray.length) {
                this.registerBusinessObject(classArray[n]);
                ++n;
            }
        }

        void closeAdapt() {
            try {
                super.close();
            }
            catch (BusException busException) {}
        }

        void setUserInfoAdapt(IUserInfo iUserInfo) {
            try {
                super.setUserInfo(iUserInfo);
            }
            catch (BusException busException) {}
        }

        void setContentLicense(String string) {
            ContentInfoCoImpl contentInfoCoImpl = new ContentInfoCoImpl(string);
            super.setContentInfo(contentInfoCoImpl);
        }

        private void registerBusinessObject(Class clazz) {
            String[] stringArray = BusinessObject.getNames(clazz);
            if (this.getRegisteredImplementation(clazz) == null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.registerName2Interface(stringArray[n], clazz);
                    ++n;
                }
                this.registerInterface2Implementation(clazz, clazz);
                Class[] classArray = BusinessObject.getDependencies(clazz);
                int n2 = 0;
                while (n2 < classArray.length) {
                    this.registerBusinessObject(classArray[n2]);
                    ++n2;
                }
            }
        }

        void add(BusinessObject businessObject) {
            BusinessObject.BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            if (!businessElementAdapter.isSynchronizable()) {
                throw new RuntimeException("Cannot add a readonly Business Object");
            }
            businessElementAdapter.setManager(this);
            super.add(businessElementAdapter);
        }

        void synchronizeAdapt() throws BoiSynchronizationException, BoiException {
            try {
                this.synchronize();
            }
            catch (BusSynchronizationException busSynchronizationException) {
                throw (BoiSynchronizationException)BoiToolkit.getDefaultToolkit().createBoiException(busSynchronizationException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
        }

        void pingAdapt() throws BoiException {
            try {
                this.ping();
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
        }

        void initializeAdapt(String string) throws BoiException {
            try {
                this.initialize(string);
            }
            catch (DirectoryException directoryException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(directoryException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
        }

        void releaseAdapt(BusinessObject businessObject) {
            this.release(businessObject.getNode());
        }

        void removeAdapt(BusinessObject businessObject) {
            BusinessObject.BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            if (!businessElementAdapter.isSynchronizable()) {
                throw new RuntimeException("Cannot remove a readonly Business Object");
            }
            this.remove(businessElementAdapter);
        }

        IExceptionDescriptor[] getWarningsAdapt() {
            Enumeration enumeration2 = this.getWarnings();
            return BoiException.createDescriptors(enumeration2);
        }

        void changeBusinessObject(BusinessObject businessObject, BusinessObject businessObject2) {
            BusinessObject.BusinessElementAdapter businessElementAdapter;
            BusinessObject.BusinessElementAdapter businessElementAdapter2;
            if (businessObject == null) {
                businessElementAdapter2 = null;
            } else {
                businessElementAdapter2 = businessObject.getNode();
                if (!businessElementAdapter2.isSynchronizable()) {
                    throw new RuntimeException("Cannot change a readonly Business Object");
                }
            }
            if (businessObject2 == null) {
                businessElementAdapter = null;
            } else {
                businessElementAdapter = businessObject2.getNode();
                if (!businessElementAdapter.isSynchronizable()) {
                    throw new RuntimeException("Cannot change a readonly Business Object");
                }
            }
            this.update(businessElementAdapter2, businessElementAdapter);
        }

        private BaanSQLQuery baanSqlQuery(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws BoiException {
            BaanSQLQuery baanSQLQuery = this.createBaanSqlQuery(baanSqlQuerySpec, false);
            BaanSqlQueryParameterSpec[] baanSqlQueryParameterSpecArray = baanSqlQuerySpec.getParameters();
            int n = 0;
            while (n < baanSqlQueryParameterSpecArray.length) {
                BaanSqlQueryParameterSpec baanSqlQueryParameterSpec = baanSqlQueryParameterSpecArray[n];
                baanSQLQuery.addParameter(baanSqlQueryParameterSpec.typeName, stringArray[n], baanSqlQueryParameterSpec.dcdType, baanSqlQueryParameterSpec.relatedColumn);
                ++n;
            }
            if (baanSqlQuerySpec.queryText.indexOf(36) != -1) {
                try {
                    baanSQLQuery.processClientSideParameters();
                }
                catch (BusException busException) {
                    throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
                }
            }
            return baanSQLQuery;
        }

        Iterator baanSqlQueryIterator(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws BoiException {
            BaanSQLQuery baanSQLQuery = this.baanSqlQuery(baanSqlQuerySpec, stringArray);
            return BoiToolkit.getDefaultToolkit().createIterator(baanSQLQuery, this, baanSqlQuerySpec.returnType.returnElementClass);
        }

        BusinessObject baanSqlQueryBusinessObject(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws BoiException, BoiApplicationException {
            DataSet dataSet;
            BaanSQLQuery baanSQLQuery = this.baanSqlQuery(baanSqlQuerySpec, stringArray);
            try {
                dataSet = this.retrieveData(baanSQLQuery);
            }
            catch (BusApplicationException busApplicationException) {
                throw (BoiApplicationException)BoiToolkit.getDefaultToolkit().createBoiException(busApplicationException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
            Tuple tuple = dataSet.getFirstTuple();
            BusinessObject businessObject = null;
            while (tuple != null) {
                Tuple tuple2 = tuple.getNextTuple();
                try {
                    dataSet.removeTuple(tuple);
                    BusinessElement businessElement = tuple.getOriginal();
                    BusinessObject businessObject2 = BusinessObject.elementToBo(businessElement);
                    if (businessObject == null && baanSqlQuerySpec.returnType.returnElementClass.isInstance(businessObject2)) {
                        businessObject = businessObject2;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                tuple = tuple2;
            }
            return businessObject;
        }

        void addBaanSqlQuery(BaanSqlQuerySpec baanSqlQuerySpec, String[] stringArray) throws IllegalStateException {
            if (this.m_currentBaanSqlQuery == null) {
                this.m_currentBaanSqlQuery = this.createBaanSqlQuery(baanSqlQuerySpec, false);
                this.m_currentBaanSqlQueryId = baanSqlQuerySpec.idName;
                this.m_currentReturnElementClass = baanSqlQuerySpec.returnType.returnElementClass;
            } else if (!this.m_currentBaanSqlQueryId.equals(baanSqlQuerySpec.idName)) {
                throw new IllegalStateException("Can't iterate over different Queries (i.e. Constructors); Please call 'getIterator()' to clear the Managers state");
            }
            BaanSQLQuery baanSQLQuery = this.m_currentBaanSqlQuery;
            BaanSqlQueryParameterSpec[] baanSqlQueryParameterSpecArray = baanSqlQuerySpec.getParameters();
            int n = 0;
            while (n < baanSqlQueryParameterSpecArray.length) {
                BaanSqlQueryParameterSpec baanSqlQueryParameterSpec = baanSqlQueryParameterSpecArray[n];
                baanSQLQuery.addParameter(baanSqlQueryParameterSpec.typeName, stringArray[n], baanSqlQueryParameterSpec.dcdType, baanSqlQueryParameterSpec.relatedColumn);
                ++n;
            }
            baanSQLQuery.addParameterSetToList();
        }

        private BaanSQLQuery createBaanSqlQuery(BaanSqlQuerySpec baanSqlQuerySpec, boolean bl) {
            BaanSqlQuerySubLayoutSpec[] baanSqlQuerySubLayoutSpecArray;
            Object object;
            BaanSQLQuery baanSQLQuery = (BaanSQLQuery)this.factory.createConstructor("BaanSQL");
            baanSQLQuery.setQueryText(baanSqlQuerySpec.queryText);
            baanSQLQuery.setId(baanSqlQuerySpec.idName);
            if (bl) {
                object = baanSqlQuerySpec.getParameters();
                int n = 0;
                while (n < ((BaanSqlQueryParameterSpec[])object).length) {
                    baanSqlQuerySubLayoutSpecArray = object[n];
                    baanSQLQuery.addParameter(baanSqlQuerySubLayoutSpecArray.typeName, null, baanSqlQuerySubLayoutSpecArray.dcdType, baanSqlQuerySubLayoutSpecArray.relatedColumn);
                    ++n;
                }
            }
            if (baanSqlQuerySpec.layoutDef != null) {
                object = baanSQLQuery.createLayout();
                Layout layout = object.createLayout(baanSqlQuerySpec.layoutDef.typeName);
                baanSqlQuerySubLayoutSpecArray = baanSqlQuerySpec.layoutDef.getSubLayouts();
                if (baanSqlQuerySubLayoutSpecArray.length != 0) {
                    Stack<BaanSqlQuerySubLayoutSpec[]> stack = new Stack<BaanSqlQuerySubLayoutSpec[]>();
                    IntStack intStack = new IntStack(3);
                    boolean bl2 = false;
                    object = layout;
                    stack.push(baanSqlQuerySubLayoutSpecArray);
                    intStack.push(0);
                    while (!stack.empty()) {
                        int n = intStack.peek();
                        BaanSqlQuerySubLayoutSpec[] baanSqlQuerySubLayoutSpecArray2 = (BaanSqlQuerySubLayoutSpec[])stack.peek();
                        BaanSqlQuerySubLayoutSpec baanSqlQuerySubLayoutSpec = baanSqlQuerySubLayoutSpecArray2[n];
                        BaanSqlQueryLayoutSpec baanSqlQueryLayoutSpec = baanSqlQuerySubLayoutSpec.layoutDef;
                        if (!bl2) {
                            BaanSqlQuerySubLayoutSpec[] baanSqlQuerySubLayoutSpecArray3;
                            layout = object.createLayout(baanSqlQueryLayoutSpec.typeName);
                            if (baanSqlQuerySubLayoutSpec.isReference) {
                                layout.setReference(true);
                            }
                            if (baanSqlQueryLayoutSpec.isAlias) {
                                layout.setAlias(true);
                            }
                            if (baanSqlQuerySubLayoutSpec.querySpec != null) {
                                layout.setConstructor("#" + baanSqlQuerySubLayoutSpec.querySpec.idName);
                                if (baanSqlQuerySubLayoutSpec.shouldAppendConstructor) {
                                    baanSQLQuery.appendConstructor(this.createBaanSqlQuery(baanSqlQuerySubLayoutSpec.querySpec, true));
                                }
                            }
                            if (baanSqlQuerySubLayoutSpec.shouldProcessLayoutDef && (baanSqlQuerySubLayoutSpecArray3 = baanSqlQueryLayoutSpec.getSubLayouts()).length != 0) {
                                object = layout;
                                stack.push(baanSqlQuerySubLayoutSpecArray3);
                                intStack.push(0);
                                continue;
                            }
                            bl2 = true;
                        }
                        if (!bl2) continue;
                        intStack.pop();
                        if (n < baanSqlQuerySubLayoutSpecArray2.length - 1) {
                            bl2 = false;
                            intStack.push(n + 1);
                            continue;
                        }
                        object = object.getParentLayout();
                        stack.pop();
                    }
                }
            }
            return baanSQLQuery;
        }

        Vector baanDllCallVector(BaanDllCallSpec baanDllCallSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
            DataSet dataSet;
            BaanDLLCall baanDLLCall = this.createBaanDllCall(baanDllCallSpec, stringArray, businessObjectArray);
            try {
                dataSet = this.retrieveData(baanDLLCall);
            }
            catch (BusApplicationException busApplicationException) {
                throw (BoiApplicationException)BoiToolkit.getDefaultToolkit().createBoiException(busApplicationException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
            Tuple tuple = dataSet.getFirstTuple();
            Vector<BusinessObject> vector = new Vector<BusinessObject>();
            while (tuple != null) {
                Tuple tuple2 = tuple.getNextTuple();
                try {
                    dataSet.removeTuple(tuple);
                    BusinessElement businessElement = tuple.getOriginal();
                    BusinessObject businessObject = BusinessObject.elementToBo(businessElement);
                    if (baanDllCallSpec.returnObjectClass.isInstance(businessObject)) {
                        vector.addElement(businessObject);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                tuple = tuple2;
            }
            return vector;
        }

        BusinessObject baanDllCallBusinessObject(BaanDllCallSpec baanDllCallSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
            DataSet dataSet;
            BaanDLLCall baanDLLCall = this.createBaanDllCall(baanDllCallSpec, stringArray, businessObjectArray);
            try {
                dataSet = this.retrieveData(baanDLLCall);
            }
            catch (BusApplicationException busApplicationException) {
                throw (BoiApplicationException)BoiToolkit.getDefaultToolkit().createBoiException(busApplicationException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
            Tuple tuple = dataSet.getFirstTuple();
            BusinessObject businessObject = null;
            while (tuple != null) {
                Tuple tuple2 = tuple.getNextTuple();
                try {
                    dataSet.removeTuple(tuple);
                    BusinessElement businessElement = tuple.getOriginal();
                    BusinessObject businessObject2 = BusinessObject.elementToBo(businessElement);
                    if (businessObject == null && baanDllCallSpec.returnObjectClass.isInstance(businessObject2)) {
                        businessObject = businessObject2;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                tuple = tuple2;
            }
            return businessObject;
        }

        private BaanDLLCall createBaanDllCall(BaanDllCallSpec baanDllCallSpec, String[] stringArray, BusinessObject[] businessObjectArray) {
            String[] stringArray2 = BusinessObject.getNames(baanDllCallSpec.returnObjectClass);
            String string = null;
            if (stringArray2 != null && stringArray2.length > 1) {
                string = stringArray2[1];
            }
            BaanDLLCall baanDLLCall = (BaanDLLCall)this.factory.createConstructor("BaanDLL");
            baanDLLCall.setDLL(baanDllCallSpec.dllName);
            baanDLLCall.setMethod(baanDllCallSpec.methodName, baanDllCallSpec.methodReturnTypeName, baanDllCallSpec.methodReturnComponentTypeName, string);
            int n = 0;
            int n2 = 0;
            BaanDllCallParameterSpec[] baanDllCallParameterSpecArray = baanDllCallSpec.getParameters();
            int n3 = 0;
            while (n3 < baanDllCallParameterSpecArray.length) {
                BaanDllCallParameterSpec baanDllCallParameterSpec = baanDllCallParameterSpecArray[n3];
                if (baanDllCallParameterSpec.isElement) {
                    if (baanDllCallParameterSpec.scope == BaanDllCallParameterSpec.BDCP_SCOPE_OUT) {
                        baanDLLCall.addParameter(baanDllCallParameterSpec.typeName, BaanDllCallParameterSpec.BDCP_SCOPE_OUT, null, "elements", null, null);
                    } else {
                        baanDLLCall.addParameterElement(businessObjectArray[n2++].getNode(), baanDllCallParameterSpec.scope, null, "elements", null);
                    }
                } else if (baanDllCallParameterSpec.scope == BaanDllCallParameterSpec.BDCP_SCOPE_OUT) {
                    baanDLLCall.addParameter(baanDllCallParameterSpec.typeName, BaanDllCallParameterSpec.BDCP_SCOPE_OUT, baanDllCallParameterSpec.dcdType, null, baanDllCallParameterSpec.length, null);
                } else {
                    baanDLLCall.addParameter(baanDllCallParameterSpec.typeName, baanDllCallParameterSpec.scope, baanDllCallParameterSpec.dcdType, null, baanDllCallParameterSpec.length, stringArray[n++]);
                }
                ++n3;
            }
            return baanDLLCall;
        }

        Iterator queryByDllIterator(QueryByDllSpec queryByDllSpec, String[] stringArray, BusinessObject[] businessObjectArray) {
            QueryByDLL queryByDLL = this.createQueryByDll(queryByDllSpec, stringArray, businessObjectArray);
            return BoiToolkit.getDefaultToolkit().createIterator(queryByDLL, this, queryByDllSpec.returnObjectClass);
        }

        BusinessObject queryByDllBusinessObject(QueryByDllSpec queryByDllSpec, String[] stringArray, BusinessObject[] businessObjectArray) throws BoiException, BoiApplicationException {
            DataSet dataSet;
            QueryByDLL queryByDLL = this.createQueryByDll(queryByDllSpec, stringArray, businessObjectArray);
            try {
                dataSet = this.retrieveData(queryByDLL);
            }
            catch (BusApplicationException busApplicationException) {
                throw (BoiApplicationException)BoiToolkit.getDefaultToolkit().createBoiException(busApplicationException);
            }
            catch (BusException busException) {
                throw BoiToolkit.getDefaultToolkit().createBoiException(busException);
            }
            Tuple tuple = dataSet.getFirstTuple();
            BusinessObject businessObject = null;
            while (tuple != null) {
                Tuple tuple2 = tuple.getNextTuple();
                try {
                    dataSet.removeTuple(tuple);
                    BusinessElement businessElement = tuple.getOriginal();
                    BusinessObject businessObject2 = BusinessObject.elementToBo(businessElement);
                    if (businessObject == null && queryByDllSpec.returnObjectClass.isInstance(businessObject2)) {
                        businessObject = businessObject2;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                tuple = tuple2;
            }
            return businessObject;
        }

        private QueryByDLL createQueryByDll(QueryByDllSpec queryByDllSpec, String[] stringArray, BusinessObject[] businessObjectArray) {
            QueryByDLL queryByDLL = (QueryByDLL)this.factory.createConstructor("QueryByDLL");
            queryByDLL.setDLL(queryByDllSpec.dllName);
            queryByDLL.setMethod(queryByDllSpec.methodName, queryByDllSpec.methodReturnTypeName, queryByDllSpec.methodReturnComponentTypeName);
            queryByDLL.setId(queryByDllSpec.idName);
            int n = 0;
            int n2 = 0;
            QueryByDllParameterSpec[] queryByDllParameterSpecArray = queryByDllSpec.getParameters();
            int n3 = 0;
            while (n3 < queryByDllParameterSpecArray.length) {
                QueryByDllParameterSpec queryByDllParameterSpec = queryByDllParameterSpecArray[n3];
                if (queryByDllParameterSpec.isElement) {
                    if (queryByDllParameterSpec.scope == QueryByDllParameterSpec.QBDP_SCOPE_OUT) {
                        queryByDLL.addParameter(queryByDllParameterSpec.typeName, QueryByDllParameterSpec.QBDP_SCOPE_OUT, null, "elements", null, null);
                    } else {
                        queryByDLL.addParameterElement(businessObjectArray[n2++].getNode(), queryByDllParameterSpec.scope, null, "elements", null);
                    }
                } else if (queryByDllParameterSpec.scope == QueryByDllParameterSpec.QBDP_SCOPE_OUT) {
                    queryByDLL.addParameter(queryByDllParameterSpec.typeName, QueryByDllParameterSpec.QBDP_SCOPE_OUT, queryByDllParameterSpec.dcdType, null, queryByDllParameterSpec.length, null);
                } else {
                    queryByDLL.addParameter(queryByDllParameterSpec.typeName, queryByDllParameterSpec.scope, queryByDllParameterSpec.dcdType, null, queryByDllParameterSpec.length, stringArray[n++]);
                }
                ++n3;
            }
            return queryByDLL;
        }

        Iterator getIterator() throws IllegalStateException {
            if (this.m_currentBaanSqlQueryId != null && this.m_currentBaanSqlQuery != null) {
                BaanSQLQuery baanSQLQuery = this.m_currentBaanSqlQuery;
                Class clazz = this.m_currentReturnElementClass;
                this.m_currentBaanSqlQuery = null;
                this.m_currentBaanSqlQueryId = null;
                this.m_currentReturnElementClass = null;
                return BoiToolkit.getDefaultToolkit().createIterator(baanSQLQuery, this, clazz);
            }
            throw new IllegalStateException("Nothing to iterate; first call some add...() method on the Manager");
        }
    }
}

