/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.boi1;

import com.baan.b3.boi1.BoiProgrammingRException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.metadata.IMemberAccessor;
import com.baan.b3.boi1.metadata.IMetadataFactory;
import com.baan.b3.boi1.metadata.IMethodImplementationAdapter;
import com.baan.b3.boi1.metadata.IPrimalMemberAccessor;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.b3impl.boi1.IBusinessElementAdapter;
import com.baan.b3impl.boi1.IPrimalTypeConstants;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BusinessElement;
import com.eibus.co.dom.BusinessElementImpl;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Node;

public abstract class BusinessObject {
    private static final Class[] BO_NO_DEPENDENCIES = new Class[0];
    private static Hashtable s_namesByClass = new Hashtable();
    private static Hashtable s_dependenciesByClass = new Hashtable();
    private BusinessElementAdapter m_thisNode = null;
    public static final String BO_METHOD_ADAPTER_CLASS_NAME = "com.baan.b3.boi1.BusinessObject$BoMethodAdapter";
    private static final String PTS_BOOLEAN = "boolean".intern();
    private static final String PTS_BYTE = "byte".intern();
    private static final String PTS_SHORT = "short".intern();
    private static final String PTS_INT = "int".intern();
    private static final String PTS_LONG = "long".intern();
    private static final String PTS_FLOAT = "float".intern();
    private static final String PTS_DOUBLE = "double".intern();
    private static final String PTS_STRING = "java.lang.String".intern();
    private static final String PTS_BIGINTEGER = "java.math.BigInteger".intern();
    private static final String PTS_BIGDECIMAL = "java.math.BigDecimal".intern();
    private static final String PTS_DATE = "java.util.Date".intern();
    private static final String PTS_XML_NODE = "org.w3c.dom.Node".intern();
    private static final String PTS_BIN_BASE64 = "byte[]".intern();
    private static final String PTS_CHAR = "char".intern();
    protected static final int BO_MNR_VECTORELEMENTSAT = 0;
    protected static final int BO_MNR_VECTORELEMENTSATREFERENCE = 1;
    protected static final int BO_MNR_VECTORELEMENTSATPRIMAL = 2;
    protected static final int BO_MNR_ADDMEMBERBUSINESSELEMENT = 3;
    protected static final int BO_MNR_ADDMEMBERBUSINESSELEMENTREFERENCE = 4;
    protected static final int BO_MNR_ADDMEMBERBUSINESSELEMENTPRIMAL = 5;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENTAT = 6;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENTATREFERENCE = 7;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENTATPRIMAL = 8;
    protected static final int BO_MNR_INSERTMEMBERBUSINESSELEMENTAT = 9;
    protected static final int BO_MNR_INSERTMEMBERBUSINESSELEMENTATREFERENCE = 10;
    protected static final int BO_MNR_INSERTMEMBERBUSINESSELEMENTATPRIMAL = 11;
    protected static final int BO_MNR_REMOVEALLMEMBERBUSINESSELEMENT = 12;
    protected static final int BO_MNR_REMOVEMEMBERBUSINESSELEMENTAT = 13;
    protected static final int BO_MNR_REMOVEMEMBERBUSINESSELEMENT = 14;
    protected static final int BO_MNR_SIZEVECTORELEMENTS = 15;
    protected static final int BO_MNR_GETMEMBERELEMENT = 16;
    protected static final int BO_MNR_GETMEMBERELEMENTREFERENCE = 17;
    protected static final int BO_MNR_GETMEMBERELEMENTPRIMAL = 18;
    protected static final int BO_MNR_HASMETHOD = 19;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENT = 20;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENTREFERENCE = 21;
    protected static final int BO_MNR_SETMEMBERBUSINESSELEMENTPRIMAL = 22;
    protected static final int BO_MNR_ATTRIBUTETOPRIMALVAL = 23;
    protected static final int BO_MNR_PRIMALVALTOATTRIBUTE = 24;

    protected BusinessObject() {
        this.m_thisNode = null;
    }

    protected BusinessObject(String string, int n, int n2, Class[] classArray, Dictionary dictionary, boolean bl) {
        this.m_thisNode = new BusinessElementAdapter(string, n, n2, classArray, dictionary, bl);
    }

    protected static void putBusinessObjectInfo(Class clazz, String[] stringArray, Class[] classArray) {
        if (s_namesByClass.get(clazz) != null) {
            throw new Error("putBusinessObjectInfo called twice for the same p_businessObjectClass");
        }
        s_namesByClass.put(clazz, stringArray);
        if (classArray == null) {
            classArray = BO_NO_DEPENDENCIES;
        }
        s_dependenciesByClass.put(clazz, classArray);
    }

    protected static String[] getNames(Class clazz) {
        return (String[])s_namesByClass.get(clazz);
    }

    static Class[] getDependencies(Class clazz) {
        return (Class[])s_dependenciesByClass.get(clazz);
    }

    BusinessElementAdapter getNode() {
        return this.m_thisNode;
    }

    static BusinessObject elementToBo(BusinessElement businessElement) throws ClassCastException {
        return ((BusinessElementAdapter)businessElement).getBusinessObject();
    }

    protected static BusinessElementImpl getBusinessElement(BusinessObject businessObject) {
        return businessObject.getNode();
    }

    protected BusinessObject vectorElementsAt(int n, int n2) {
        return this.m_thisNode.vectorElementsAt(n, n2);
    }

    protected BusinessObject vectorElementsAtReference(int n, int n2) {
        return this.m_thisNode.vectorElementsAtReference(n, n2);
    }

    protected PrimalVal vectorElementsAtPrimal(int n, int n2, int n3) {
        return this.m_thisNode.vectorElementsAtPrimal(n, n2, n3);
    }

    protected void addMemberBusinessElement(int n, BusinessObject businessObject, int n2) {
        this.m_thisNode.addMemberBusinessElement(n, businessObject, n2);
    }

    protected void addMemberBusinessElementReference(int n, BusinessObject businessObject, int n2) {
        this.m_thisNode.addMemberBusinessElementReference(n, businessObject, n2);
    }

    protected void addMemberBusinessElementPrimal(int n, PrimalVal primalVal, String string, int n2) {
        this.m_thisNode.addMemberBusinessElementPrimal(n, primalVal, string, n2);
    }

    protected void setMemberBusinessElementAt(int n, BusinessObject businessObject, int n2, int n3) {
        this.m_thisNode.setMemberBusinessElementAt(n, businessObject, n2, n3);
    }

    protected void setMemberBusinessElementAtReference(int n, BusinessObject businessObject, int n2, int n3) {
        this.m_thisNode.setMemberBusinessElementAtReference(n, businessObject, n2, n3);
    }

    protected void setMemberBusinessElementAtPrimal(int n, PrimalVal primalVal, String string, int n2, int n3) {
        this.m_thisNode.setMemberBusinessElementAtPrimal(n, primalVal, string, n2, n3);
    }

    protected void insertMemberBusinessElementAt(int n, BusinessObject businessObject, int n2, int n3) {
        this.m_thisNode.insertMemberBusinessElementAt(n, businessObject, n2, n3);
    }

    protected void insertMemberBusinessElementAtReference(int n, BusinessObject businessObject, int n2, int n3) {
        this.m_thisNode.insertMemberBusinessElementAtReference(n, businessObject, n2, n3);
    }

    protected void insertMemberBusinessElementAtPrimal(int n, PrimalVal primalVal, String string, int n2, int n3) {
        this.m_thisNode.insertMemberBusinessElementAtPrimal(n, primalVal, string, n2, n3);
    }

    protected void removeAllMemberBusinessElement(int n, int n2) {
        this.m_thisNode.removeAllMemberBusinessElement(n, n2);
    }

    protected void removeMemberBusinessElementAt(int n, int n2, int n3, String string) {
        this.m_thisNode.removeMemberBusinessElementAt(n, n2, n3, string);
    }

    protected boolean removeMemberBusinessElement(int n, BusinessObject businessObject, int n2, String string) {
        return this.m_thisNode.removeMemberBusinessElement(n, businessObject, n2, string);
    }

    protected int sizeVectorElements(int n) {
        return this.m_thisNode.sizeVectorElements(n);
    }

    protected BusinessObject getMemberElement(int n) {
        return this.m_thisNode.getMemberElement(n);
    }

    protected BusinessObject getMemberElementReference(int n) {
        return this.m_thisNode.getMemberElementReference(n);
    }

    protected PrimalVal getMemberElementPrimal(int n, int n2) {
        return this.m_thisNode.getMemberElementPrimal(n, n2);
    }

    protected void setMemberBusinessElement(int n, BusinessObject businessObject) {
        this.m_thisNode.setMemberBusinessElement(n, businessObject);
    }

    protected void setMemberBusinessElementReference(int n, BusinessObject businessObject) {
        this.m_thisNode.setMemberBusinessElementReference(n, businessObject);
    }

    protected void setMemberBusinessElementPrimal(int n, PrimalVal primalVal, String string) {
        this.m_thisNode.setMemberBusinessElementPrimal(n, primalVal, string);
    }

    protected PrimalVal attributeToPrimalVal(String string, int n) {
        return this.m_thisNode.attributeToPrimalVal(string, n);
    }

    protected void primalValToAttribute(PrimalVal primalVal, String string) {
        this.m_thisNode.primalValToAttribute(primalVal, string);
    }

    protected boolean hasMethod(int n) {
        return this.m_thisNode.hasMethod(n);
    }

    protected boolean hasAttribute(String string) {
        return this.m_thisNode.hasAttribute(string);
    }

    protected static IMetadataFactory getMetadataFactory() {
        return BoiToolkit.getDefaultToolkit().getMetadataFactory();
    }

    protected static IMethodImplementationAdapter createBoMethodAdapter(Class clazz, int n, int[] nArray, String[] stringArray, Class clazz2) {
        return new BoMethodAdapter(clazz, n, nArray, stringArray, clazz2);
    }

    protected static IPrimalMemberAccessor createPrimalMemberAccessor(Class clazz, IPrimalObjectMetadata iPrimalObjectMetadata, int n, int n2, int n3, int n4, int n5, String string) {
        if (n3 != 1) {
            return new PrimalVectorAccessor(clazz, iPrimalObjectMetadata, n, n2, n3, n4, n5, string);
        }
        return new PrimalMemberAccessor(clazz, iPrimalObjectMetadata, n, n2 == 0, n4, string);
    }

    protected static IMemberAccessor createBoMemberAccessor(Class clazz, String string, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            if (n2 != 1) {
                return new AssociatedBoVectorAccessor(clazz, string, n, n2, n3, n4);
            }
            return new AssociatedBoMemberAccessor(clazz, string, n == 0, n3);
        }
        if (n2 != 1) {
            return new BoVectorAccessor(clazz, string, n, n2, n3, n4);
        }
        return new BoMemberAccessor(clazz, string, n == 0, n3);
    }

    protected static IPrimalMemberAccessor createAttributeMemberAccessor(Class clazz, IPrimalObjectMetadata iPrimalObjectMetadata, int n, int n2, int n3, String string) {
        boolean bl = n2 == 0;
        return new AttributeMemberAccessor(clazz, iPrimalObjectMetadata, n, bl, string);
    }

    static int getPrimalType(String string) throws IllegalArgumentException {
        String string2 = string.intern();
        if (string2 == PTS_BOOLEAN) {
            return 0;
        }
        if (string2 == PTS_BYTE) {
            return 1;
        }
        if (string2 == PTS_SHORT) {
            return 2;
        }
        if (string2 == PTS_INT) {
            return 3;
        }
        if (string2 == PTS_LONG) {
            return 4;
        }
        if (string2 == PTS_FLOAT) {
            return 5;
        }
        if (string2 == PTS_DOUBLE) {
            return 6;
        }
        if (string2 == PTS_STRING) {
            return 7;
        }
        if (string2 == PTS_BIGINTEGER) {
            return 8;
        }
        if (string2 == PTS_BIGDECIMAL) {
            return 9;
        }
        if (string2 == PTS_DATE) {
            return 10;
        }
        if (string2 == PTS_BIN_BASE64) {
            return 11;
        }
        if (string2 == PTS_XML_NODE) {
            return 12;
        }
        if (string2 == PTS_CHAR) {
            return 13;
        }
        throw new IllegalArgumentException("Unrecognised primal type: " + string2);
    }

    static String getPrimalTypeName(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return PTS_BOOLEAN;
            }
            case 1: {
                return PTS_BYTE;
            }
            case 2: {
                return PTS_SHORT;
            }
            case 3: {
                return PTS_INT;
            }
            case 4: {
                return PTS_LONG;
            }
            case 5: {
                return PTS_FLOAT;
            }
            case 6: {
                return PTS_DOUBLE;
            }
            case 7: {
                return PTS_STRING;
            }
            case 8: {
                return PTS_BIGINTEGER;
            }
            case 9: {
                return PTS_BIGDECIMAL;
            }
            case 10: {
                return PTS_DATE;
            }
            case 11: {
                return PTS_BIN_BASE64;
            }
            case 12: {
                return PTS_XML_NODE;
            }
            case 13: {
                return PTS_CHAR;
            }
        }
        throw new IllegalArgumentException("com.baan.b3.boi1.businessObject.getPrimalTypeName(): Primal type not recognised (" + n + ")");
    }

    static String primalValToDcdString(PrimalVal primalVal, int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                if (primalVal.getBoolean()) {
                    return "1";
                }
                return "0";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return primalVal.toString();
            }
            case 10: {
                return BusinessElementImpl.Date2String(primalVal.getDate());
            }
            case 11: {
                return BusinessElementImpl.BinBase642String(primalVal.getByteArray());
            }
            case 12: {
                return BusinessElementImpl.XMLNode2String(primalVal.getXMLNode());
            }
        }
        throw new IllegalArgumentException("com.baan.b3.boi1.businessObject.primalValToDcdString(): Primal type not recognised (" + n + ")");
    }

    static PrimalVal dcdStringToPrimalVal(String string, int n) throws IllegalArgumentException {
        if (string.length() == 0) {
            return PrimalVal.getDefaultValue(n);
        }
        switch (n) {
            case 0: {
                if (string.equals("0")) {
                    return PrimalVal.getInstance(false);
                }
                if (string.equals("1")) {
                    return PrimalVal.getInstance(true);
                }
                throw new IllegalArgumentException("boolean types must be '0' or '1'");
            }
            case 1: {
                return PrimalVal.getInstance(Byte.parseByte(string));
            }
            case 2: {
                return PrimalVal.getInstance(Short.parseShort(string));
            }
            case 3: {
                return PrimalVal.getInstance(Integer.parseInt(string));
            }
            case 4: {
                return PrimalVal.getInstance(Long.parseLong(string));
            }
            case 5: {
                return PrimalVal.getInstance(Float.valueOf(string).floatValue());
            }
            case 6: {
                return PrimalVal.getInstance(Double.valueOf(string));
            }
            case 7: {
                return PrimalVal.getInstance(string);
            }
            case 8: {
                return PrimalVal.getInstance(new BigInteger(string));
            }
            case 9: {
                return PrimalVal.getInstance(new BigDecimal(string));
            }
            case 10: {
                return PrimalVal.getInstance(BusinessElementImpl.String2Date(string));
            }
            case 11: {
                return PrimalVal.getInstance(BusinessElementImpl.String2BinBase64(string));
            }
            case 12: {
                return PrimalVal.getInstance(BusinessElementImpl.String2XMLNode(string));
            }
            case 13: {
                return PrimalVal.getInstance(string.charAt(0));
            }
        }
        throw new IllegalArgumentException("com.baan.b3.boi1.businessObject.dcdStringToPrimalVal(): Primal type not recognised (" + n + ")");
    }

    private static class AttributeMemberAccessor
    implements IPrimalMemberAccessor {
        private final Class m_targetClass;
        private final IPrimalObjectMetadata m_memberType;
        private final int m_primalType;
        private final boolean m_isOptional;
        private final String m_attributeName;

        AttributeMemberAccessor(Class clazz, IPrimalObjectMetadata iPrimalObjectMetadata, int n, boolean bl, String string) {
            this.m_targetClass = clazz;
            this.m_memberType = iPrimalObjectMetadata;
            this.m_primalType = n;
            this.m_isOptional = bl;
            this.m_attributeName = string;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (this.m_isOptional && !businessObject.m_thisNode.hasAttribute(this.m_attributeName)) {
                return null;
            }
            return businessObject.m_thisNode.attributeToPrimalVal(this.m_attributeName, this.m_primalType).getObject();
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            PrimalVal primalVal = null;
            try {
                primalVal = PrimalVal.getInstance(object2, this.m_primalType);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("p_value is of type " + object2.getClass().getName() + " but should be of type " + this.m_memberType.getTypeName());
            }
            businessObject.m_thisNode.primalValToAttribute(primalVal, this.m_attributeName);
        }

        public Object getValueToString(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (this.m_isOptional && !businessObject.m_thisNode.hasAttribute(this.m_attributeName)) {
                return null;
            }
            PrimalVal primalVal = businessObject.m_thisNode.attributeToPrimalVal(this.m_attributeName, this.m_primalType);
            return BusinessObject.primalValToDcdString(primalVal, this.m_primalType);
        }

        public void setValueFromString(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (!(object2 instanceof String)) {
                throw new IllegalArgumentException("p_value must be of type String");
            }
            PrimalVal primalVal = BusinessObject.dcdStringToPrimalVal((String)object2, this.m_primalType);
            businessObject.m_thisNode.primalValToAttribute(primalVal, this.m_attributeName);
        }
    }

    private static class BoMemberAccessor
    implements IMemberAccessor {
        private final Class m_targetClass;
        private final String m_memberTypeName;
        private final Class m_memberClass;
        private final boolean m_isOptional;
        private final int m_memberIndex;

        BoMemberAccessor(Class clazz, String string, boolean bl, int n) {
            this.m_targetClass = clazz;
            this.m_memberTypeName = string;
            try {
                this.m_memberClass = Class.forName(this.m_memberTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Member BusinessObject class '" + this.m_memberTypeName + "' not found");
            }
            this.m_isOptional = bl;
            this.m_memberIndex = n;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            return businessObject.m_thisNode.getMemberElement(this.m_memberIndex);
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (!this.m_memberClass.isInstance(object2)) {
                throw new IllegalArgumentException("p_value must be of type '" + this.m_memberTypeName + "'");
            }
            businessObject.m_thisNode.setMemberBusinessElement(this.m_memberIndex, (BusinessObject)object2);
        }
    }

    private static class BoVectorAccessor
    implements IMemberAccessor {
        private final Class m_targetClass;
        private final String m_memberTypeName;
        private final Class m_memberClass;
        private final int m_cardinalityMin;
        private final int m_cardinalityMax;
        private final int m_memberIndex;
        private final int m_vectorIndex;

        BoVectorAccessor(Class clazz, String string, int n, int n2, int n3, int n4) {
            this.m_targetClass = clazz;
            this.m_memberTypeName = string;
            try {
                this.m_memberClass = Class.forName(this.m_memberTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Member BusinessObject class '" + this.m_memberTypeName + "' not found");
            }
            this.m_cardinalityMin = n;
            this.m_cardinalityMax = n2;
            this.m_memberIndex = n3;
            this.m_vectorIndex = n4;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            int n = businessObject.sizeVectorElements(this.m_vectorIndex);
            BusinessObject[] businessObjectArray = (BusinessObject[])Array.newInstance(this.m_memberClass, n);
            int n2 = 0;
            while (n2 < n) {
                businessObjectArray[n2] = businessObject.m_thisNode.vectorElementsAt(this.m_vectorIndex, n2);
                ++n2;
            }
            return businessObjectArray;
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            Class<?> clazz = object2.getClass();
            if (!clazz.isArray()) {
                throw new IllegalArgumentException("p_value must be an array");
            }
            Class<?> clazz2 = clazz.getComponentType();
            if (!this.m_memberClass.isAssignableFrom(clazz2)) {
                BusinessObject[] businessObjectArray;
                try {
                    businessObjectArray = (BusinessObject[])object2;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("p_value is of type " + object2.getClass().getComponentType().getName() + "[] but should be of type BusinessObject[]");
                }
                businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
                int n = 0;
                while (n < businessObjectArray.length) {
                    BusinessObject businessObject2 = businessObjectArray[n];
                    if (!this.m_memberClass.isInstance(businessObject2)) {
                        throw new IllegalArgumentException("p_value must have elements of type '" + this.m_memberTypeName + "'");
                    }
                    businessObject.m_thisNode.addMemberBusinessElement(this.m_memberIndex, businessObject2, this.m_vectorIndex);
                    ++n;
                }
            } else {
                BusinessObject[] businessObjectArray = (BusinessObject[])object2;
                businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
                int n = 0;
                while (n < businessObjectArray.length) {
                    businessObject.m_thisNode.addMemberBusinessElement(this.m_memberIndex, businessObjectArray[n], this.m_vectorIndex);
                    ++n;
                }
            }
        }
    }

    private static class AssociatedBoMemberAccessor
    implements IMemberAccessor {
        private final Class m_targetClass;
        private final String m_memberTypeName;
        private final Class m_memberClass;
        private final boolean m_isOptional;
        private final int m_memberIndex;

        AssociatedBoMemberAccessor(Class clazz, String string, boolean bl, int n) {
            this.m_targetClass = clazz;
            this.m_memberTypeName = string;
            try {
                this.m_memberClass = Class.forName(this.m_memberTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Member BusinessObject class '" + this.m_memberTypeName + "' not found");
            }
            this.m_isOptional = bl;
            this.m_memberIndex = n;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            return businessObject.m_thisNode.getMemberElementReference(this.m_memberIndex);
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (!this.m_memberClass.isInstance(object2)) {
                throw new IllegalArgumentException("p_value must be of type '" + this.m_memberTypeName + "'");
            }
            businessObject.m_thisNode.setMemberBusinessElementReference(this.m_memberIndex, (BusinessObject)object2);
        }
    }

    private static class AssociatedBoVectorAccessor
    implements IMemberAccessor {
        private final Class m_targetClass;
        private final String m_memberTypeName;
        private final Class m_memberClass;
        private final int m_cardinalityMin;
        private final int m_cardinalityMax;
        private final int m_memberIndex;
        private final int m_vectorIndex;

        AssociatedBoVectorAccessor(Class clazz, String string, int n, int n2, int n3, int n4) {
            this.m_targetClass = clazz;
            this.m_memberTypeName = string;
            try {
                this.m_memberClass = Class.forName(this.m_memberTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Member BusinessObject class '" + this.m_memberTypeName + "' not found");
            }
            this.m_cardinalityMin = n;
            this.m_cardinalityMax = n2;
            this.m_memberIndex = n3;
            this.m_vectorIndex = n4;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            int n = businessObject.sizeVectorElements(this.m_vectorIndex);
            BusinessObject[] businessObjectArray = (BusinessObject[])Array.newInstance(this.m_memberClass, n);
            int n2 = 0;
            while (n2 < n) {
                businessObjectArray[n2] = businessObject.m_thisNode.vectorElementsAtReference(this.m_vectorIndex, n2);
                ++n2;
            }
            return businessObjectArray;
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            Class<?> clazz = object2.getClass();
            if (!clazz.isArray()) {
                throw new IllegalArgumentException("p_value must be an array");
            }
            Class<?> clazz2 = clazz.getComponentType();
            if (!this.m_memberClass.isAssignableFrom(clazz2)) {
                BusinessObject[] businessObjectArray;
                try {
                    businessObjectArray = (BusinessObject[])object2;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("p_value is of type " + object2.getClass().getComponentType().getName() + "[] but should be of type BusinessObject[]");
                }
                businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
                int n = 0;
                while (n < businessObjectArray.length) {
                    BusinessObject businessObject2 = businessObjectArray[n];
                    if (!this.m_memberClass.isInstance(businessObject2)) {
                        throw new IllegalArgumentException("p_value must have elements of type '" + this.m_memberTypeName + "'");
                    }
                    businessObject.m_thisNode.addMemberBusinessElementReference(this.m_memberIndex, businessObject2, this.m_vectorIndex);
                    ++n;
                }
            } else {
                BusinessObject[] businessObjectArray = (BusinessObject[])object2;
                businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
                int n = 0;
                while (n < businessObjectArray.length) {
                    businessObject.m_thisNode.addMemberBusinessElementReference(this.m_memberIndex, businessObjectArray[n], this.m_vectorIndex);
                    ++n;
                }
            }
        }
    }

    private static class PrimalMemberAccessor
    implements IPrimalMemberAccessor {
        private final Class m_targetClass;
        private final IPrimalObjectMetadata m_memberType;
        private final int m_primalType;
        private final boolean m_isOptional;
        private final int m_memberIndex;
        private final String m_tagName;

        PrimalMemberAccessor(Class clazz, IPrimalObjectMetadata iPrimalObjectMetadata, int n, boolean bl, int n2, String string) {
            this.m_targetClass = clazz;
            this.m_memberType = iPrimalObjectMetadata;
            this.m_primalType = n;
            this.m_isOptional = bl;
            this.m_memberIndex = n2;
            this.m_tagName = string;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (this.m_isOptional && !businessObject.m_thisNode.hasMember(this.m_memberIndex)) {
                return null;
            }
            return businessObject.m_thisNode.getMemberElementPrimal(this.m_memberIndex, this.m_primalType).getObject();
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            PrimalVal primalVal = null;
            try {
                primalVal = PrimalVal.getInstance(object2, this.m_primalType);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("p_value is of type " + object2.getClass().getName() + " but should be of type " + this.m_memberType.getTypeName());
            }
            businessObject.m_thisNode.setMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName);
        }

        public Object getValueToString(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (this.m_isOptional && !businessObject.m_thisNode.hasMember(this.m_memberIndex)) {
                return null;
            }
            PrimalVal primalVal = businessObject.m_thisNode.getMemberElementPrimal(this.m_memberIndex, this.m_primalType);
            return BusinessObject.primalValToDcdString(primalVal, this.m_primalType);
        }

        public void setValueFromString(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (!(object2 instanceof String)) {
                throw new IllegalArgumentException("p_value must be of type String");
            }
            PrimalVal primalVal = BusinessObject.dcdStringToPrimalVal((String)object2, this.m_primalType);
            businessObject.m_thisNode.setMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName);
        }
    }

    private static class PrimalVectorAccessor
    implements IPrimalMemberAccessor {
        private Class m_targetClass;
        private IPrimalObjectMetadata m_memberType;
        private int m_primalType;
        private int m_cardinalityMin;
        private int m_cardinalityMax;
        private int m_memberIndex;
        private int m_vectorIndex;
        private String m_tagName;

        PrimalVectorAccessor(Class clazz, IPrimalObjectMetadata iPrimalObjectMetadata, int n, int n2, int n3, int n4, int n5, String string) {
            this.m_targetClass = clazz;
            this.m_memberType = iPrimalObjectMetadata;
            this.m_primalType = n;
            this.m_cardinalityMin = n2;
            this.m_cardinalityMax = n3;
            this.m_memberIndex = n4;
            this.m_vectorIndex = n5;
            this.m_tagName = string;
        }

        public Object getValue(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            int n = businessObject.sizeVectorElements(this.m_vectorIndex);
            Object[] objectArray = null;
            switch (this.m_primalType) {
                case 0: {
                    boolean[] blArray = new boolean[n];
                    int n2 = 0;
                    while (n2 < n) {
                        blArray[n2] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n2, 0).getBoolean();
                        ++n2;
                    }
                    objectArray = blArray;
                    break;
                }
                case 1: {
                    byte[] byArray = new byte[n];
                    int n3 = 0;
                    while (n3 < n) {
                        byArray[n3] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n3, 1).getByte();
                        ++n3;
                    }
                    objectArray = byArray;
                    break;
                }
                case 2: {
                    short[] sArray = new short[n];
                    int n4 = 0;
                    while (n4 < n) {
                        sArray[n4] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n4, 2).getShort();
                        ++n4;
                    }
                    objectArray = sArray;
                    break;
                }
                case 3: {
                    int[] nArray = new int[n];
                    int n5 = 0;
                    while (n5 < n) {
                        nArray[n5] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n5, 3).getInt();
                        ++n5;
                    }
                    objectArray = nArray;
                    break;
                }
                case 4: {
                    long[] lArray = new long[n];
                    int n6 = 0;
                    while (n6 < n) {
                        lArray[n6] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n6, 4).getLong();
                        ++n6;
                    }
                    objectArray = lArray;
                    break;
                }
                case 5: {
                    float[] fArray = new float[n];
                    int n7 = 0;
                    while (n7 < n) {
                        fArray[n7] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n7, 5).getFloat();
                        ++n7;
                    }
                    objectArray = fArray;
                    break;
                }
                case 6: {
                    double[] dArray = new double[n];
                    int n8 = 0;
                    while (n8 < n) {
                        dArray[n8] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n8, 6).getDouble();
                        ++n8;
                    }
                    objectArray = dArray;
                    break;
                }
                case 7: {
                    String[] stringArray = new String[n];
                    int n9 = 0;
                    while (n9 < n) {
                        stringArray[n9] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n9, 7).getString();
                        ++n9;
                    }
                    objectArray = stringArray;
                    break;
                }
                case 8: {
                    BigInteger[] bigIntegerArray = new BigInteger[n];
                    int n10 = 0;
                    while (n10 < n) {
                        bigIntegerArray[n10] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n10, 8).getBigInteger();
                        ++n10;
                    }
                    objectArray = bigIntegerArray;
                    break;
                }
                case 9: {
                    BigDecimal[] bigDecimalArray = new BigDecimal[n];
                    int n11 = 0;
                    while (n11 < n) {
                        bigDecimalArray[n11] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n11, 9).getBigDecimal();
                        ++n11;
                    }
                    objectArray = bigDecimalArray;
                    break;
                }
                case 10: {
                    Date[] dateArray = new Date[n];
                    int n12 = 0;
                    while (n12 < n) {
                        dateArray[n12] = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n12, 10).getDate();
                        ++n12;
                    }
                    objectArray = dateArray;
                    break;
                }
                default: {
                    throw new RuntimeException("com.baan.b3.boi1.BusinessObject.PrimalVectorAccessor.getValue(): Primal type not recognised (" + this.m_primalType + ")");
                }
            }
            return objectArray;
        }

        public void setValue(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            Class<?> clazz = object2.getClass();
            if (!clazz.isArray()) {
                throw new IllegalArgumentException("p_value must be an array");
            }
            businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
            try {
                switch (this.m_primalType) {
                    case 0: {
                        boolean[] blArray = (boolean[])object2;
                        int n = 0;
                        while (n < blArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(blArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 1: {
                        byte[] byArray = (byte[])object2;
                        int n = 0;
                        while (n < byArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(byArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object2;
                        int n = 0;
                        while (n < sArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(sArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object2;
                        int n = 0;
                        while (n < nArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(nArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 4: {
                        long[] lArray = (long[])object2;
                        int n = 0;
                        while (n < lArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(lArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 5: {
                        float[] fArray = (float[])object2;
                        int n = 0;
                        while (n < fArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(fArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 6: {
                        double[] dArray = (double[])object2;
                        int n = 0;
                        while (n < dArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(dArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 7: {
                        String[] stringArray = (String[])object2;
                        int n = 0;
                        while (n < stringArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(stringArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 8: {
                        BigInteger[] bigIntegerArray = (BigInteger[])object2;
                        int n = 0;
                        while (n < bigIntegerArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(bigIntegerArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 9: {
                        BigDecimal[] bigDecimalArray = (BigDecimal[])object2;
                        int n = 0;
                        while (n < bigDecimalArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(bigDecimalArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 10: {
                        Date[] dateArray = (Date[])object2;
                        int n = 0;
                        while (n < dateArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(dateArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    case 13: {
                        char[] cArray = (char[])object2;
                        int n = 0;
                        while (n < cArray.length) {
                            PrimalVal primalVal = PrimalVal.getInstance(cArray[n]);
                            businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                            ++n;
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("com.baan.b3.boi1.BusinessObject.PrimalVectorAccessor.setValue(): Primal type not recognised (" + this.m_primalType + ")");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("p_value is of type " + object2.getClass().getComponentType().getName() + "[] but should be of type " + this.m_memberType.getTypeName() + "[]");
            }
        }

        public Object getValueToString(Object object) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            int n = businessObject.sizeVectorElements(this.m_vectorIndex);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                PrimalVal primalVal = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_vectorIndex, n2, this.m_primalType);
                stringArray[n2] = BusinessObject.primalValToDcdString(primalVal, this.m_primalType);
                ++n2;
            }
            return stringArray;
        }

        public void setValueFromString(Object object, Object object2) throws IllegalArgumentException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            if (!(object2 instanceof String[])) {
                throw new IllegalArgumentException("p_value must be an array of Strings");
            }
            String[] stringArray = (String[])object2;
            businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_memberIndex, this.m_vectorIndex);
            int n = 0;
            while (n < stringArray.length) {
                PrimalVal primalVal = BusinessObject.dcdStringToPrimalVal(stringArray[n], this.m_primalType);
                businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_memberIndex, primalVal, this.m_tagName, this.m_vectorIndex);
                ++n;
            }
        }
    }

    private static class BoMethodAdapter
    implements IMethodImplementationAdapter {
        private final Class m_targetClass;
        private final int m_methodNr;
        private final int[] m_intConsts;
        private final String[] m_stringConsts;
        private final Class m_boType;

        public BoMethodAdapter(Class clazz, int n, int[] nArray, String[] stringArray, Class clazz2) {
            this.m_targetClass = clazz;
            this.m_methodNr = n;
            this.m_intConsts = nArray;
            this.m_stringConsts = stringArray;
            this.m_boType = clazz2;
        }

        public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            try {
                int n = 0;
                PrimalVal primalVal = null;
                switch (this.m_methodNr) {
                    case 0: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            n = (Integer)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters must be of type { java.lang.Integer }");
                        }
                        return businessObject.m_thisNode.vectorElementsAt(this.m_intConsts[0], n);
                    }
                    case 1: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            n = (Integer)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters must be of type { java.lang.Integer }");
                        }
                        return businessObject.m_thisNode.vectorElementsAtReference(this.m_intConsts[0], n);
                    }
                    case 2: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            n = (Integer)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters must be of type { java.lang.Integer }");
                        }
                        return businessObject.m_thisNode.vectorElementsAtPrimal(this.m_intConsts[0], n, this.m_intConsts[1]).getObject();
                    }
                    case 3: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.addMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 4: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.addMemberBusinessElementReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 5: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            primalVal = PrimalVal.getInstance(objectArray[0], this.m_intConsts[2]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters is of type {" + objectArray[0].getClass().getName() + "} but should be of type {" + BusinessObject.getPrimalTypeName(this.m_intConsts[2]) + "}");
                        }
                        businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 6: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type " + this.m_boType.getName());
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.setMemberBusinessElementAt(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 7: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must[0] be of type " + this.m_boType.getName());
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.setMemberBusinessElementAtReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 8: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        try {
                            primalVal = PrimalVal.getInstance(objectArray[0], this.m_intConsts[2]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] is of type " + objectArray[0].getClass().getName() + " but should be of type " + BusinessObject.getPrimalTypeName(this.m_intConsts[2]));
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.setMemberBusinessElementAtPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 9: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type " + this.m_boType.getName());
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.insertMemberBusinessElementAt(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 10: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must[0] be of type " + this.m_boType.getName());
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.insertMemberBusinessElementAtReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 11: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        try {
                            primalVal = PrimalVal.getInstance(objectArray[0], this.m_intConsts[2]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] is of type " + objectArray[0].getClass().getName() + " but should be of type " + BusinessObject.getPrimalTypeName(this.m_intConsts[2]));
                        }
                        try {
                            n = (Integer)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.insertMemberBusinessElementAtPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 12: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_intConsts[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 13: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            n = (Integer)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.Integer");
                        }
                        businessObject.m_thisNode.removeMemberBusinessElementAt(this.m_intConsts[0], this.m_intConsts[1], n, this.m_stringConsts[0]);
                        return null;
                    }
                    case 14: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.removeMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], this.m_stringConsts[0]);
                        return null;
                    }
                    case 15: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return new Integer(businessObject.m_thisNode.sizeVectorElements(this.m_intConsts[0]));
                    }
                    case 16: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.getMemberElement(this.m_intConsts[0]);
                    }
                    case 17: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.getMemberElementReference(this.m_intConsts[0]);
                    }
                    case 18: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.getMemberElementPrimal(this.m_intConsts[0], this.m_intConsts[1]).getObject();
                    }
                    case 19: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.hasMethod(this.m_intConsts[0]) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 20: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.setMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0]);
                        return null;
                    }
                    case 21: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.setMemberBusinessElementReference(this.m_intConsts[0], (BusinessObject)objectArray[0]);
                        return null;
                    }
                    case 22: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            primalVal = PrimalVal.getInstance(objectArray[0], this.m_intConsts[1]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] is of type " + objectArray[0].getClass().getName() + " but should be of type " + BusinessObject.getPrimalTypeName(this.m_intConsts[1]));
                        }
                        businessObject.m_thisNode.setMemberBusinessElementPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0]);
                        return null;
                    }
                    case 23: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.attributeToPrimalVal(this.m_stringConsts[0], this.m_intConsts[0]).getObject();
                    }
                    case 24: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            primalVal = PrimalVal.getInstance(objectArray[0], this.m_intConsts[0]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] is of type " + objectArray[0].getClass().getName() + " but should be of type " + BusinessObject.getPrimalTypeName(this.m_intConsts[0]));
                        }
                        businessObject.m_thisNode.primalValToAttribute(primalVal, this.m_stringConsts[0]);
                        return null;
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObject.BoMethodAdapter.invoke: Method number not recognised: " + this.m_methodNr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }

        public Object invokeWithStrings(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
            if (!this.m_targetClass.isInstance(object)) {
                throw new IllegalArgumentException("p_instance must be of type '" + this.m_targetClass.getName() + "'");
            }
            BusinessObject businessObject = (BusinessObject)object;
            try {
                int n = 0;
                PrimalVal primalVal = null;
                String string = null;
                switch (this.m_methodNr) {
                    case 0: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, 3);
                        n = primalVal.getInt();
                        return businessObject.m_thisNode.vectorElementsAt(this.m_intConsts[0], n);
                    }
                    case 1: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, 3);
                        n = primalVal.getInt();
                        return businessObject.m_thisNode.vectorElementsAtReference(this.m_intConsts[0], n);
                    }
                    case 2: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, 3);
                        n = primalVal.getInt();
                        primalVal = businessObject.m_thisNode.vectorElementsAtPrimal(this.m_intConsts[0], n, this.m_intConsts[1]);
                        return BusinessObject.primalValToDcdString(primalVal, this.m_intConsts[1]);
                    }
                    case 3: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.addMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 4: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.addMemberBusinessElementReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 5: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, this.m_intConsts[2]);
                        businessObject.m_thisNode.addMemberBusinessElementPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 6: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type " + this.m_boType.getName());
                        }
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, 3);
                        n = primalVal.getInt();
                        businessObject.m_thisNode.setMemberBusinessElementAt(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 7: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type " + this.m_boType.getName());
                        }
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, 3);
                        n = primalVal.getInt();
                        businessObject.m_thisNode.setMemberBusinessElementAtReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 8: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, this.m_intConsts[2]);
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        n = BusinessObject.dcdStringToPrimalVal(string, 3).getInt();
                        businessObject.m_thisNode.setMemberBusinessElementAtPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 9: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type " + this.m_boType.getName());
                        }
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        n = BusinessObject.dcdStringToPrimalVal(string, 3).getInt();
                        businessObject.m_thisNode.insertMemberBusinessElementAt(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 10: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must[0] be of type " + this.m_boType.getName());
                        }
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        n = BusinessObject.dcdStringToPrimalVal(string, 3).getInt();
                        businessObject.m_thisNode.insertMemberBusinessElementAtReference(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 11: {
                        if (objectArray == null || objectArray.length != 2) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 2");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, this.m_intConsts[2]);
                        try {
                            string = (String)objectArray[1];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[1] must be of type java.lang.String");
                        }
                        n = BusinessObject.dcdStringToPrimalVal(string, 3).getInt();
                        businessObject.m_thisNode.insertMemberBusinessElementAtPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0], this.m_intConsts[1], n);
                        return null;
                    }
                    case 12: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        businessObject.m_thisNode.removeAllMemberBusinessElement(this.m_intConsts[0], this.m_intConsts[1]);
                        return null;
                    }
                    case 13: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        n = BusinessObject.dcdStringToPrimalVal(string, 3).getInt();
                        businessObject.m_thisNode.removeMemberBusinessElementAt(this.m_intConsts[0], this.m_intConsts[1], n, this.m_stringConsts[0]);
                        return null;
                    }
                    case 14: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.removeMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0], this.m_intConsts[1], this.m_stringConsts[0]);
                        return null;
                    }
                    case 15: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        primalVal = PrimalVal.getInstance(businessObject.m_thisNode.sizeVectorElements(this.m_intConsts[0]));
                        return BusinessObject.primalValToDcdString(primalVal, 3);
                    }
                    case 16: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.getMemberElement(this.m_intConsts[0]);
                    }
                    case 17: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        return businessObject.m_thisNode.getMemberElementReference(this.m_intConsts[0]);
                    }
                    case 18: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        primalVal = businessObject.m_thisNode.getMemberElementPrimal(this.m_intConsts[0], this.m_intConsts[1]);
                        return BusinessObject.primalValToDcdString(primalVal, this.m_intConsts[1]);
                    }
                    case 19: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        primalVal = PrimalVal.getInstance(businessObject.m_thisNode.hasMethod(this.m_intConsts[0]));
                        return BusinessObject.primalValToDcdString(primalVal, 0);
                    }
                    case 20: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.setMemberBusinessElement(this.m_intConsts[0], (BusinessObject)objectArray[0]);
                        return null;
                    }
                    case 21: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        if (!this.m_boType.isInstance(objectArray[0])) {
                            throw new IllegalArgumentException("p_parameters must be of type { " + this.m_boType.getName() + " }");
                        }
                        businessObject.m_thisNode.setMemberBusinessElementReference(this.m_intConsts[0], (BusinessObject)objectArray[0]);
                        return null;
                    }
                    case 22: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, this.m_intConsts[1]);
                        businessObject.m_thisNode.setMemberBusinessElementPrimal(this.m_intConsts[0], primalVal, this.m_stringConsts[0]);
                        return null;
                    }
                    case 23: {
                        if (objectArray != null && objectArray.length != 0) {
                            throw new IllegalArgumentException("p_parameters must be null or have length 0");
                        }
                        primalVal = businessObject.m_thisNode.attributeToPrimalVal(this.m_stringConsts[0], this.m_intConsts[0]);
                        return BusinessObject.primalValToDcdString(primalVal, this.m_intConsts[0]);
                    }
                    case 24: {
                        if (objectArray == null || objectArray.length != 1) {
                            throw new IllegalArgumentException("p_parameters must be non-null and have length 1");
                        }
                        try {
                            string = (String)objectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            throw new IllegalArgumentException("p_parameters[0] must be of type java.lang.String");
                        }
                        primalVal = BusinessObject.dcdStringToPrimalVal(string, this.m_intConsts[0]);
                        businessObject.m_thisNode.primalValToAttribute(primalVal, this.m_stringConsts[0]);
                        return null;
                    }
                }
                throw new RuntimeException("com.baan.b3.boi1.BusinessObject.BoMethodAdapter.invokeWithStrings: Method number not recognised: " + this.m_methodNr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        }
    }

    protected static class PrimalVal
    implements IPrimalTypeConstants {
        private static final PrimalVal PDEFAULTVAL_BOOLEAN = PrimalVal.getInstance(false);
        private static final PrimalVal PDEFAULTVAL_BYTE = PrimalVal.getInstance((byte)0);
        private static final PrimalVal PDEFAULTVAL_SHORT = PrimalVal.getInstance((short)0);
        private static final PrimalVal PDEFAULTVAL_INT = PrimalVal.getInstance(0);
        private static final PrimalVal PDEFAULTVAL_LONG = PrimalVal.getInstance(0L);
        private static final PrimalVal PDEFAULTVAL_FLOAT = PrimalVal.getInstance(0.0f);
        private static final PrimalVal PDEFAULTVAL_DOUBLE = PrimalVal.getInstance(0.0);
        private static final PrimalVal PDEFAULTVAL_STRING = PrimalVal.getInstance(new String().intern());
        private static final PrimalVal PDEFAULTVAL_BIGINTEGER = PrimalVal.getInstance(BigInteger.valueOf(0L));
        private static final PrimalVal PDEFAULTVAL_BIGDECIMAL = PrimalVal.getInstance(BigDecimal.valueOf(0L));
        private static final PrimalVal PDEFAULTVAL_DATE = PrimalVal.getInstance(BusinessElementImpl.String2Date(null));
        private static final PrimalVal PDEFAULTVAL_XML_NODE = PrimalVal.getInstance(BusinessElementImpl.String2XMLNode(null));
        private static final PrimalVal PDEFAULTVAL_BIN_BASE64 = PrimalVal.getInstance(BusinessElementImpl.String2BinBase64(null));
        private static final PrimalVal PDEFAULTVAL_CHAR = PrimalVal.getInstance('\u0000');
        private int m_type;
        private boolean m_booleanVal = false;
        private byte m_byteVal = 0;
        private short m_shortVal = 0;
        private int m_intVal = 0;
        private long m_longVal = 0L;
        private float m_floatVal = 0.0f;
        private double m_doubleVal = 0.0;
        private String m_stringVal = null;
        private BigInteger m_bigIntegerVal = null;
        private BigDecimal m_bigDecimalVal = null;
        private Date m_dateVal = null;
        private Node m_xmlNodeVal = null;
        private byte[] m_binBase64Val = null;
        private char m_charVal = '\u0000';

        public static PrimalVal getInstance(boolean bl) {
            return new PrimalVal(bl);
        }

        public static PrimalVal getInstance(byte by) {
            return new PrimalVal(by);
        }

        public static PrimalVal getInstance(short s) {
            return new PrimalVal(s);
        }

        public static PrimalVal getInstance(int n) {
            return new PrimalVal(n);
        }

        public static PrimalVal getInstance(long l) {
            return new PrimalVal(l);
        }

        public static PrimalVal getInstance(float f) {
            return new PrimalVal(f);
        }

        public static PrimalVal getInstance(double d) {
            return new PrimalVal(d);
        }

        public static PrimalVal getInstance(String string) {
            return new PrimalVal(string);
        }

        public static PrimalVal getInstance(BigInteger bigInteger) {
            return new PrimalVal(bigInteger);
        }

        public static PrimalVal getInstance(BigDecimal bigDecimal) {
            return new PrimalVal(bigDecimal);
        }

        public static PrimalVal getInstance(Date date) {
            return new PrimalVal(date);
        }

        public static PrimalVal getInstance(Node node) {
            return new PrimalVal(node);
        }

        public static PrimalVal getInstance(byte[] byArray) {
            return new PrimalVal(byArray);
        }

        public static PrimalVal getInstance(char c) {
            return new PrimalVal(c);
        }

        public static PrimalVal getInstance(Object object, int n) throws ClassCastException, RuntimeException {
            switch (n) {
                case 0: {
                    return PrimalVal.getInstance((Boolean)object);
                }
                case 1: {
                    return PrimalVal.getInstance((Byte)object);
                }
                case 2: {
                    return PrimalVal.getInstance((Short)object);
                }
                case 3: {
                    return PrimalVal.getInstance((Integer)object);
                }
                case 4: {
                    return PrimalVal.getInstance((Long)object);
                }
                case 5: {
                    return PrimalVal.getInstance(((Float)object).floatValue());
                }
                case 6: {
                    return PrimalVal.getInstance((Double)object);
                }
                case 7: {
                    return PrimalVal.getInstance((String)object);
                }
                case 8: {
                    return PrimalVal.getInstance((BigInteger)object);
                }
                case 9: {
                    return PrimalVal.getInstance((BigDecimal)object);
                }
                case 10: {
                    return PrimalVal.getInstance((Date)object);
                }
                case 11: {
                    return PrimalVal.getInstance((byte[])object);
                }
                case 12: {
                    return PrimalVal.getInstance((Node)object);
                }
                case 13: {
                    return PrimalVal.getInstance(((Character)object).charValue());
                }
            }
            throw new RuntimeException("com.baan.b3.boi1.BusinessObject.PrimalVal.getInstance(Object, int): Primal type not recognised (" + n + ")");
        }

        public static PrimalVal getDefaultValue(int n) {
            switch (n) {
                case 0: {
                    return PDEFAULTVAL_BOOLEAN;
                }
                case 1: {
                    return PDEFAULTVAL_BYTE;
                }
                case 2: {
                    return PDEFAULTVAL_SHORT;
                }
                case 3: {
                    return PDEFAULTVAL_INT;
                }
                case 4: {
                    return PDEFAULTVAL_LONG;
                }
                case 5: {
                    return PDEFAULTVAL_FLOAT;
                }
                case 6: {
                    return PDEFAULTVAL_DOUBLE;
                }
                case 7: {
                    return PDEFAULTVAL_STRING;
                }
                case 8: {
                    return PDEFAULTVAL_BIGINTEGER;
                }
                case 9: {
                    return PDEFAULTVAL_BIGDECIMAL;
                }
                case 10: {
                    return PDEFAULTVAL_DATE;
                }
                case 11: {
                    return PDEFAULTVAL_BIN_BASE64;
                }
                case 12: {
                    return PDEFAULTVAL_XML_NODE;
                }
                case 13: {
                    return PDEFAULTVAL_CHAR;
                }
            }
            throw new RuntimeException("com.baan.b3.boi1.BusinessObject.PrimalVal.getDefaultValue(int): Primal type not recognised (" + n + ")");
        }

        private PrimalVal(boolean bl) {
            this.m_booleanVal = bl;
            this.m_type = 0;
        }

        private PrimalVal(byte by) {
            this.m_byteVal = by;
            this.m_type = 1;
        }

        private PrimalVal(short s) {
            this.m_shortVal = s;
            this.m_type = 2;
        }

        private PrimalVal(int n) {
            this.m_intVal = n;
            this.m_type = 3;
        }

        private PrimalVal(long l) {
            this.m_longVal = l;
            this.m_type = 4;
        }

        private PrimalVal(float f) {
            this.m_floatVal = f;
            this.m_type = 5;
        }

        private PrimalVal(double d) {
            this.m_doubleVal = d;
            this.m_type = 6;
        }

        private PrimalVal(String string) {
            this.m_stringVal = string;
            this.m_type = 7;
        }

        private PrimalVal(BigInteger bigInteger) {
            this.m_bigIntegerVal = bigInteger;
            this.m_type = 8;
        }

        private PrimalVal(BigDecimal bigDecimal) {
            this.m_bigDecimalVal = bigDecimal;
            this.m_type = 9;
        }

        private PrimalVal(Date date) {
            this.m_dateVal = date;
            this.m_type = 10;
        }

        private PrimalVal(byte[] byArray) {
            this.m_binBase64Val = byArray;
            this.m_type = 11;
        }

        private PrimalVal(Node node) {
            this.m_xmlNodeVal = node;
            this.m_type = 12;
        }

        private PrimalVal(char c) {
            this.m_charVal = c;
            this.m_type = 13;
        }

        public int getType() {
            return this.m_type;
        }

        public boolean getBoolean() {
            return this.m_booleanVal;
        }

        public byte getByte() {
            return this.m_byteVal;
        }

        public short getShort() {
            return this.m_shortVal;
        }

        public int getInt() {
            return this.m_intVal;
        }

        public long getLong() {
            return this.m_longVal;
        }

        public float getFloat() {
            return this.m_floatVal;
        }

        public double getDouble() {
            return this.m_doubleVal;
        }

        public String getString() {
            return this.m_stringVal;
        }

        public BigInteger getBigInteger() {
            return this.m_bigIntegerVal;
        }

        public BigDecimal getBigDecimal() {
            return this.m_bigDecimalVal;
        }

        public Date getDate() {
            return this.m_dateVal;
        }

        public byte[] getByteArray() {
            return this.m_binBase64Val;
        }

        public Node getXMLNode() {
            return this.m_xmlNodeVal;
        }

        public char getChar() {
            return this.m_charVal;
        }

        public Object getObject() {
            switch (this.m_type) {
                case 0: {
                    return new Boolean(this.m_booleanVal);
                }
                case 1: {
                    return new Byte(this.m_byteVal);
                }
                case 2: {
                    return new Short(this.m_shortVal);
                }
                case 3: {
                    return new Integer(this.m_intVal);
                }
                case 4: {
                    return new Long(this.m_longVal);
                }
                case 5: {
                    return new Float(this.m_floatVal);
                }
                case 6: {
                    return new Double(this.m_doubleVal);
                }
                case 7: {
                    return this.m_stringVal;
                }
                case 8: {
                    return this.m_bigIntegerVal;
                }
                case 9: {
                    return this.m_bigDecimalVal;
                }
                case 10: {
                    return this.m_dateVal;
                }
                case 11: {
                    return this.m_binBase64Val;
                }
                case 12: {
                    return this.m_xmlNodeVal;
                }
                case 13: {
                    return new Character(this.m_charVal);
                }
            }
            throw new RuntimeException("com.baan.b3.boi1.BusinessObject.objectToPrimalVal(): Primal type not recognised (" + this.m_type + ")");
        }

        public void setBoolean(boolean bl) {
            this.m_booleanVal = bl;
        }

        public void setByte(byte by) {
            this.m_byteVal = by;
        }

        public void setShort(short s) {
            this.m_shortVal = s;
        }

        public void setInt(int n) {
            this.m_intVal = n;
        }

        public void setLong(long l) {
            this.m_longVal = l;
        }

        public void setFloat(float f) {
            this.m_floatVal = f;
        }

        public void setDouble(double d) {
            this.m_doubleVal = d;
        }

        public void setString(String string) {
            this.m_stringVal = string;
        }

        public void setBigInteger(BigInteger bigInteger) {
            this.m_bigIntegerVal = bigInteger;
        }

        public void setBigDecimal(BigDecimal bigDecimal) {
            this.m_bigDecimalVal = bigDecimal;
        }

        public void setDouble(Date date) {
            this.m_dateVal = date;
        }

        public void setBinBase64(byte[] byArray) {
            this.m_binBase64Val = byArray;
        }

        public void setXMLNode(Node node) {
            this.m_xmlNodeVal = node;
        }

        public void setChar(char c) {
            this.m_charVal = c;
        }

        public String toString() {
            switch (this.m_type) {
                case 0: {
                    return this.m_booleanVal ? "true" : "false";
                }
                case 1: {
                    return Byte.toString(this.m_byteVal);
                }
                case 2: {
                    return Short.toString(this.m_shortVal);
                }
                case 3: {
                    return Integer.toString(this.m_intVal);
                }
                case 4: {
                    return Long.toString(this.m_longVal);
                }
                case 5: {
                    return Float.toString(this.m_floatVal);
                }
                case 6: {
                    return Double.toString(this.m_doubleVal);
                }
                case 7: {
                    return this.m_stringVal;
                }
                case 8: {
                    return this.m_bigIntegerVal.toString();
                }
                case 9: {
                    return this.m_bigDecimalVal.toString();
                }
                case 10: {
                    return this.m_dateVal.toString();
                }
                case 12: {
                    return this.m_xmlNodeVal.toString();
                }
                case 11: {
                    return this.m_binBase64Val.toString();
                }
                case 13: {
                    return "" + this.m_charVal;
                }
            }
            throw new RuntimeException("com.baan.b3.boi1.BusinessObject.PrimalVal.toString(): Primal type not recognised (" + this.m_type + ")");
        }
    }

    protected class BusinessElementAdapter
    extends BusinessElementImpl
    implements IBusinessElementAdapter {
        BusinessElementAdapter(String string, int n, int n2, Class[] classArray, Dictionary dictionary, boolean bl) {
            super(string);
            if (bl) {
                this.makeNonSynchronizable();
            }
            if (n != 0) {
                this.memberElements = new BusinessElementImpl[n];
                if (n2 != 0) {
                    this.vectorElements = new Vector[n2];
                }
                this.classElements = classArray;
                this.elementsByTagName = dictionary;
            }
        }

        public Class getBusinessObjectClass() {
            return BusinessObject.this.getClass();
        }

        private PrimalVal elementToPrimalVal(BusinessElementImpl businessElementImpl, int n) {
            switch (n) {
                case 0: {
                    return PrimalVal.getInstance(this.element2boolean(businessElementImpl));
                }
                case 1: {
                    return PrimalVal.getInstance(this.element2byte(businessElementImpl));
                }
                case 2: {
                    return PrimalVal.getInstance(this.element2short(businessElementImpl));
                }
                case 3: {
                    return PrimalVal.getInstance(this.element2int(businessElementImpl));
                }
                case 4: {
                    return PrimalVal.getInstance(this.element2long(businessElementImpl));
                }
                case 5: {
                    return PrimalVal.getInstance(this.element2float(businessElementImpl));
                }
                case 6: {
                    return PrimalVal.getInstance(this.element2double(businessElementImpl));
                }
                case 7: {
                    return PrimalVal.getInstance(this.element2String(businessElementImpl));
                }
                case 8: {
                    return PrimalVal.getInstance(this.element2BigInteger(businessElementImpl));
                }
                case 9: {
                    return PrimalVal.getInstance(this.element2BigDecimal(businessElementImpl));
                }
                case 10: {
                    return PrimalVal.getInstance(this.element2Date(businessElementImpl));
                }
                case 11: {
                    return PrimalVal.getInstance(this.element2BinBase64(businessElementImpl));
                }
                case 12: {
                    return PrimalVal.getInstance(this.element2XMLNode(businessElementImpl));
                }
                case 13: {
                    return PrimalVal.getInstance(this.element2char(businessElementImpl));
                }
            }
            throw new IllegalArgumentException("com.baan.b3.boi1.businessObject.element2PrimalVal(): Primal type not recognised (" + n + ")");
        }

        private BusinessElementImpl primalValToElement(PrimalVal primalVal, String string, BusinessElementImpl businessElementImpl) {
            switch (primalVal.getType()) {
                case 0: {
                    return this.boolean2Element(primalVal.getBoolean(), string, businessElementImpl);
                }
                case 1: {
                    return this.byte2Element(primalVal.getByte(), string, businessElementImpl);
                }
                case 2: {
                    return this.short2Element(primalVal.getShort(), string, businessElementImpl);
                }
                case 3: {
                    return this.int2Element(primalVal.getInt(), string, businessElementImpl);
                }
                case 4: {
                    return this.long2Element(primalVal.getLong(), string, businessElementImpl);
                }
                case 5: {
                    return this.float2Element(primalVal.getFloat(), string, businessElementImpl);
                }
                case 6: {
                    return this.double2Element(primalVal.getDouble(), string, businessElementImpl);
                }
                case 7: {
                    return this.String2Element(primalVal.getString(), string, businessElementImpl);
                }
                case 8: {
                    return this.BigInteger2Element(primalVal.getBigInteger(), string, businessElementImpl);
                }
                case 9: {
                    return this.BigDecimal2Element(primalVal.getBigDecimal(), string, businessElementImpl);
                }
                case 10: {
                    return this.Date2Element(primalVal.getDate(), string, businessElementImpl);
                }
                case 11: {
                    return this.BinBase642Element(primalVal.getByteArray(), string, businessElementImpl);
                }
                case 12: {
                    return this.XMLNode2Element(primalVal.getXMLNode(), string, businessElementImpl);
                }
                case 13: {
                    return this.char2Element(primalVal.getChar(), string, businessElementImpl);
                }
            }
            throw new RuntimeException("com.baan.b3.boi1.businessObject.primalValToElement(): Primal type not recognised (" + primalVal.getType() + ")");
        }

        BusinessObject vectorElementsAt(int n, int n2) {
            if (this.vectorElements[n] == null) {
                return null;
            }
            return ((BusinessElementAdapter)this.vectorElements[n].elementAt(n2)).getBusinessObject();
        }

        BusinessObject vectorElementsAtReference(int n, int n2) {
            if (this.vectorElements[n] == null) {
                return null;
            }
            BusinessElementAdapter businessElementAdapter = (BusinessElementAdapter)((BusinessElementImpl)this.vectorElements[n].elementAt(n2)).traverse();
            if (businessElementAdapter != null) {
                return businessElementAdapter.getBusinessObject();
            }
            return null;
        }

        PrimalVal vectorElementsAtPrimal(int n, int n2, int n3) {
            BusinessElementImpl businessElementImpl = this.vectorElements[n] == null ? null : (BusinessElementImpl)this.vectorElements[n].elementAt(n2);
            return this.elementToPrimalVal(businessElementImpl, n3);
        }

        void addMemberBusinessElement(int n, BusinessObject businessObject, int n2) {
            this.ensureNotNullVectorElement(n2);
            this.addMemberBusinessElement(this.memberElements, n, businessObject.getNode(), this.vectorElements[n2]);
        }

        void addMemberBusinessElementReference(int n, BusinessObject businessObject, int n2) {
            BusinessDocumentManager businessDocumentManager = this.getManager();
            if (businessDocumentManager == null) {
                throw new BoiProgrammingRException("Parent BusinessObject must be in a BusinessObjectManager before associated child BusinessObjects can be added");
            }
            BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            businessElementAdapter.setManager(businessDocumentManager);
            this.ensureNotNullVectorElement(n2);
            this.addMemberBusinessElement(this.memberElements, n, (BusinessElementImpl)businessElementAdapter.createLinkedElement(), this.vectorElements[n2]);
        }

        void addMemberBusinessElementPrimal(int n, PrimalVal primalVal, String string, int n2) {
            this.ensureNotNullVectorElement(n2);
            this.addMemberBusinessElement(this.memberElements, n, this.primalValToElement(primalVal, string, null), this.vectorElements[n2]);
        }

        void setMemberBusinessElementAt(int n, BusinessObject businessObject, int n2, int n3) {
            this.ensureNotNullVectorElement(n2);
            this.setMemberBusinessElementAt(this.memberElements, n, businessObject.getNode(), this.vectorElements[n2], n3, (BusinessElementImpl)this.vectorElements[n2].elementAt(n3));
        }

        void setMemberBusinessElementAtReference(int n, BusinessObject businessObject, int n2, int n3) {
            BusinessDocumentManager businessDocumentManager = this.getManager();
            if (businessDocumentManager == null) {
                throw new BoiProgrammingRException("Parent BusinessObject must be in a BusinessObjectManager before associated child BusinessObjects can be added");
            }
            BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            businessElementAdapter.setManager(businessDocumentManager);
            this.ensureNotNullVectorElement(n2);
            this.setMemberBusinessElementAt(this.memberElements, n, (BusinessElementImpl)businessElementAdapter.createLinkedElement(), this.vectorElements[n2], n3, (BusinessElementImpl)this.vectorElements[n2].elementAt(n3));
        }

        void setMemberBusinessElementAtPrimal(int n, PrimalVal primalVal, String string, int n2, int n3) {
            this.ensureNotNullVectorElement(n2);
            this.setMemberBusinessElementAt(this.memberElements, n, this.primalValToElement(primalVal, string, (BusinessElementImpl)this.vectorElements[n2].elementAt(n3)), this.vectorElements[n2], n3, (BusinessElementImpl)this.vectorElements[n2].elementAt(n3));
        }

        void insertMemberBusinessElementAt(int n, BusinessObject businessObject, int n2, int n3) {
            this.ensureNotNullVectorElement(n2);
            this.insertMemberBusinessElementAt(this.memberElements, n, businessObject.getNode(), this.vectorElements[n2], n3);
        }

        void insertMemberBusinessElementAtReference(int n, BusinessObject businessObject, int n2, int n3) {
            BusinessDocumentManager businessDocumentManager = this.getManager();
            if (businessDocumentManager == null) {
                throw new BoiProgrammingRException("Parent BusinessObject must be in a BusinessObjectManager before associated child BusinessObjects can be added");
            }
            BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            businessElementAdapter.setManager(businessDocumentManager);
            this.ensureNotNullVectorElement(n2);
            this.insertMemberBusinessElementAt(this.memberElements, n, (BusinessElementImpl)businessElementAdapter.createLinkedElement(), this.vectorElements[n2], n3);
        }

        void insertMemberBusinessElementAtPrimal(int n, PrimalVal primalVal, String string, int n2, int n3) {
            this.ensureNotNullVectorElement(n2);
            this.insertMemberBusinessElementAt(this.memberElements, n, this.primalValToElement(primalVal, string, null), this.vectorElements[n2], n3);
        }

        void removeAllMemberBusinessElement(int n, int n2) {
            this.removeAllMemberBusinessElement(this.memberElements, n, this.vectorElements[n2]);
            this.vectorElements[n2] = null;
        }

        void removeMemberBusinessElementAt(int n, int n2, int n3, String string) {
            if (this.vectorElements[n2] == null) {
                throw new IndexOutOfBoundsException("Vector 'vectorElements[" + string + "]' not present");
            }
            this.removeMemberBusinessElementAt(this.memberElements, n, this.vectorElements[n2], n3);
        }

        boolean removeMemberBusinessElement(int n, BusinessObject businessObject, int n2, String string) {
            if (this.vectorElements[n2] == null) {
                throw new IndexOutOfBoundsException("Vector 'vectorElements[" + string + "]' not present");
            }
            return this.removeMemberBusinessElement(this.memberElements, n, businessObject.getNode(), this.vectorElements[n2]);
        }

        int sizeVectorElements(int n) {
            if (this.vectorElements[n] == null) {
                return 0;
            }
            return this.vectorElements[n].size();
        }

        boolean hasMember(int n) {
            return this.memberElements[n] != null;
        }

        BusinessObject getMemberElement(int n) {
            if (this.memberElements[n] == null) {
                return null;
            }
            return ((BusinessElementAdapter)this.memberElements[n]).getBusinessObject();
        }

        BusinessObject getMemberElementReference(int n) {
            if (this.memberElements[n] == null) {
                return null;
            }
            BusinessElementAdapter businessElementAdapter = (BusinessElementAdapter)this.memberElements[n].traverse();
            if (businessElementAdapter != null) {
                return businessElementAdapter.getBusinessObject();
            }
            return null;
        }

        PrimalVal getMemberElementPrimal(int n, int n2) {
            return this.elementToPrimalVal(this.memberElements[n], n2);
        }

        void setMemberBusinessElement(int n, BusinessObject businessObject) {
            this.setMemberBusinessElement(this.memberElements, n, businessObject.getNode());
        }

        void setMemberBusinessElementReference(int n, BusinessObject businessObject) {
            BusinessDocumentManager businessDocumentManager = this.getManager();
            if (businessDocumentManager == null) {
                throw new BoiProgrammingRException("Parent BusinessObject must be in a BusinessObjectManager before associated child BusinessObjects can be added");
            }
            BusinessElementAdapter businessElementAdapter = businessObject.getNode();
            businessElementAdapter.setManager(businessDocumentManager);
            this.setMemberBusinessElement(this.memberElements, n, (BusinessElementImpl)businessElementAdapter.createLinkedElement());
        }

        void setMemberBusinessElementPrimal(int n, PrimalVal primalVal, String string) {
            this.setMemberBusinessElement(this.memberElements, n, this.primalValToElement(primalVal, string, this.memberElements[n]));
        }

        protected boolean hasMethod(int n) {
            return this.memberElements[n] != null;
        }

        private void ensureNotNullVectorElement(int n) {
            if (this.vectorElements[n] == null) {
                this.vectorElements[n] = new Vector();
            }
        }

        public BusinessObject getBusinessObject() {
            return BusinessObject.this;
        }

        protected boolean hasAttribute(String string) {
            return this.getAttributeNode(string) != null;
        }

        PrimalVal attributeToPrimalVal(String string, int n) {
            switch (n) {
                case 0: {
                    return PrimalVal.getInstance(this.attribute2boolean(string));
                }
                case 1: {
                    return PrimalVal.getInstance(this.attribute2byte(string));
                }
                case 2: {
                    return PrimalVal.getInstance(this.attribute2short(string));
                }
                case 3: {
                    return PrimalVal.getInstance(this.attribute2int(string));
                }
                case 4: {
                    return PrimalVal.getInstance(this.attribute2long(string));
                }
                case 5: {
                    return PrimalVal.getInstance(this.attribute2float(string));
                }
                case 6: {
                    return PrimalVal.getInstance(this.attribute2double(string));
                }
                case 7: {
                    return PrimalVal.getInstance(this.attribute2String(string));
                }
                case 8: {
                    return PrimalVal.getInstance(this.attribute2BigInteger(string));
                }
                case 9: {
                    return PrimalVal.getInstance(this.attribute2BigDecimal(string));
                }
                case 10: {
                    return PrimalVal.getInstance(this.attribute2Date(string));
                }
                case 11: {
                    return PrimalVal.getInstance(this.attribute2BinBase64(string));
                }
                case 12: {
                    return PrimalVal.getInstance(this.attribute2XMLNode(string));
                }
                case 13: {
                    return PrimalVal.getInstance(this.attribute2char(string));
                }
            }
            throw new IllegalArgumentException("com.baan.b3.boi1.businessObject.businessElementAdapter.attribute2PrimalVal(): Primal type not recognised (" + n + ")");
        }

        void primalValToAttribute(PrimalVal primalVal, String string) {
            switch (primalVal.getType()) {
                case 0: {
                    this.boolean2Attribute(primalVal.getBoolean(), string);
                    break;
                }
                case 1: {
                    this.byte2Attribute(primalVal.getByte(), string);
                    break;
                }
                case 2: {
                    this.short2Attribute(primalVal.getShort(), string);
                    break;
                }
                case 3: {
                    this.int2Attribute(primalVal.getInt(), string);
                    break;
                }
                case 4: {
                    this.long2Attribute(primalVal.getLong(), string);
                    break;
                }
                case 5: {
                    this.float2Attribute(primalVal.getFloat(), string);
                    break;
                }
                case 6: {
                    this.double2Attribute(primalVal.getDouble(), string);
                    break;
                }
                case 7: {
                    this.String2Attribute(primalVal.getString(), string);
                    break;
                }
                case 8: {
                    this.BigInteger2Attribute(primalVal.getBigInteger(), string);
                    break;
                }
                case 9: {
                    this.BigDecimal2Attribute(primalVal.getBigDecimal(), string);
                    break;
                }
                case 10: {
                    this.Date2Attribute(primalVal.getDate(), string);
                    break;
                }
                case 11: {
                    this.BinBase642Attribute(primalVal.getByteArray(), string);
                    break;
                }
                case 12: {
                    this.XMLNode2Attribute(primalVal.getXMLNode(), string);
                    break;
                }
                case 13: {
                    this.char2Attribute(primalVal.getChar(), string);
                    break;
                }
                default: {
                    throw new RuntimeException("com.baan.b3.boi1.businessObject.businessElementAdapter.primalValToAttribute(): Primal type not recognised (" + primalVal.getType() + ")");
                }
            }
        }
    }
}

