/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.boi1;

import com.baan.b3.boi1.BoiApplicationException;
import com.baan.b3.boi1.BoiSynchronizationException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.ISynchronizationExceptionDescriptor;
import com.baan.b3.boi1.dt.SynchronizationActionType;
import com.baan.b3impl.ExceptionStore;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.co.BusError;
import com.eibus.co.BusinessElement;
import com.eibus.co.SynchronizationError;
import com.eibus.co.Tuple;
import com.eibus.exception.BusException;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class BoiException
extends Exception {
    private static final IExceptionDescriptor[] NO_DESCRIPTORS = new IExceptionDescriptor[0];
    private final IExceptionDescriptor[] m_descriptors;
    private final String m_stackTrace;

    BoiException(BusException busException, IExceptionDescriptor[] iExceptionDescriptorArray) {
        super(busException.getMessage());
        this.m_descriptors = iExceptionDescriptorArray == null ? NO_DESCRIPTORS : iExceptionDescriptorArray;
        this.m_stackTrace = BoiException.getStackTrace(busException);
        ExceptionStore.newThrowable(this);
    }

    static BoiException convert(BusException busException) {
        try {
            if (busException instanceof BusSynchronizationException) {
                return new BoiSynchronizationException((BusSynchronizationException)busException);
            }
            if (busException instanceof BusApplicationException) {
                return new BoiApplicationException((BusApplicationException)busException);
            }
            return new BoiException(busException, null);
        }
        catch (RuntimeException runtimeException) {
            String[] stringArray = new String[]{"Could not convert exception because of:", runtimeException.toString(), BoiException.getStackTrace(runtimeException)};
            IExceptionDescriptor[] iExceptionDescriptorArray = new IExceptionDescriptor[]{BoiToolkit.getDefaultToolkit().createExceptionDescriptor(true, stringArray)};
            return new BoiException(busException, iExceptionDescriptorArray);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return charArrayWriter.toString();
    }

    static IExceptionDescriptor[] createDescriptors(Enumeration enumeration2) throws IllegalArgumentException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = new Vector();
        while (enumeration2.hasMoreElements()) {
            Object object2;
            String[] stringArray;
            String[] stringArray2;
            Object e = enumeration2.nextElement();
            if (e instanceof BusError) {
                object = (BusError)e;
                stringArray2 = object.getErrorMessages();
                while (stringArray2.hasMoreElements()) {
                    vector2.addElement(stringArray2.nextElement());
                }
                int n = vector2.size();
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = (String)vector2.elementAt(n2);
                    ++n2;
                }
                vector2.removeAllElements();
                object2 = BoiToolkit.getDefaultToolkit().createExceptionDescriptor(object.isError(), stringArray);
                vector.addElement(object2);
                continue;
            }
            if (e instanceof SynchronizationError) {
                object = (SynchronizationError)e;
                stringArray2 = new String[]{object.getMessageDescription()};
                BusinessElement businessElement = object.getBusinessElement();
                stringArray = BusinessObject.elementToBo(businessElement);
                Tuple tuple = businessElement.getTuple();
                object2 = null;
                object2 = tuple.getOriginal() == null ? SynchronizationActionType.INSERT : (tuple.getCurrent() == null ? SynchronizationActionType.DELETE : SynchronizationActionType.CHANGE);
                ISynchronizationExceptionDescriptor iSynchronizationExceptionDescriptor = BoiToolkit.getDefaultToolkit().createSynchronizationExceptionDescriptor(object.isError(), stringArray2, object.getFieldName(), object.getMessageCode(), (BusinessObject)stringArray, (SynchronizationActionType)object2);
                vector.addElement(iSynchronizationExceptionDescriptor);
                continue;
            }
            throw new IllegalArgumentException("p_busErrors has to contain classes of type BusError or SynchronizationError");
        }
        int n = vector.size();
        object = new IExceptionDescriptor[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = (IExceptionDescriptor)vector.elementAt(n3);
            ++n3;
        }
        return object;
    }

    public IExceptionDescriptor[] getDescriptors() {
        IExceptionDescriptor[] iExceptionDescriptorArray = new IExceptionDescriptor[this.m_descriptors.length];
        System.arraycopy(this.m_descriptors, 0, iExceptionDescriptorArray, 0, this.m_descriptors.length);
        return iExceptionDescriptorArray;
    }

    public void printStackTrace() {
        super.printStackTrace();
        System.out.println(this.m_stackTrace);
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.println(this.m_stackTrace);
    }

    public String toString() {
        String string = this.getMessage();
        StringBuffer stringBuffer = string == null ? new StringBuffer() : new StringBuffer(string);
        if (this.m_descriptors != NO_DESCRIPTORS) {
            stringBuffer.append("\nDescriptors:");
            int n = 0;
            while (n < this.m_descriptors.length) {
                stringBuffer.append("\n*** ").append(n).append(" ***\n");
                stringBuffer.append(this.m_descriptors[n].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

