/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.aps;

import com.baan.b3.aps.ActivationPoolingService;
import com.baan.b3.aps.LogAndPrint;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.IPoolPolicy;
import com.baan.b3impl.connection.PoolPoliciesImpl;
import com.baan.b3impl.connection.PooledConnection;
import com.eibus.exception.BusException;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import java.util.Hashtable;

public class ConnectionFactory {
    private Directory m_directoryService = null;
    private static ConnectionFactory s_instance = new ConnectionFactory();
    private ConnectionPool m_connectionPool = new ConnectionPool();
    private boolean m_firstTime = true;

    public static ConnectionFactory getInstance() {
        return s_instance;
    }

    public ConnectionFactory() {
        try {
            this.m_directoryService = new DirectoryServiceProvider().getDirectoryService();
        }
        catch (DirectoryException directoryException) {
            this.m_directoryService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Connection giveConnection(String var1_1, UserSession var2_2) throws BusException {
        var3_3 = var2_2;
        synchronized (var3_3) {
            block16: {
                var4_4 = null;
                var5_5 = null;
                if (this.m_directoryService == null) {
                    throw new BusException("Initializing/loading of the directory failed.");
                }
                try {
                    var4_4 = this.m_directoryService.retrieveBusComponent(var1_1);
                }
                catch (DirectoryException var6_6) {
                    throw new BusException(var6_6);
                }
                var6_7 = var4_4.getActivation();
                if (var6_7 != null && var6_7.getAPSBusComponent() != null) {
                    var7_8 = var6_7.getServiceReference();
                    var8_9 = var6_7.getType();
                    LogAndPrint.message("Patch Activation to '" + (String)var8_9 + "', with service ref '" + (String)var7_8 + "'");
                    var6_7.resetAPSComponent();
                    LogAndPrint.message("Pooling Policy in use = '" + var6_7.getPolicy() + "'");
                }
                if ((var7_8 = this.m_connectionPool.getPooledConnection(var2_2, var1_1)) == null) {
                    LogAndPrint.message("Create a new Backend, and return a reference");
                    var8_9 = PoolPoliciesImpl.getInstance(var4_4, false);
                    var7_8 = new PooledConnection(var4_4, var2_2, (IPoolPolicy)var8_9);
                    var5_5 = var8_9.GetReference((PooledConnection)var7_8);
                    var9_11 = var7_8.getIndex(var5_5);
                    var10_13 = var7_8.getNrReferences(var9_11);
                    LogAndPrint.message("References to Connection " + (var10_13 - 1) + " -> " + var10_13);
                    this.m_connectionPool.putPooledConnection(var2_2, var1_1, (PooledConnection)var7_8, var5_5);
                } else {
                    LogAndPrint.message("Ask the policy to return a new reference (can be pooled)");
                    var5_5 = var7_8.getPolicy().GetReference((PooledConnection)var7_8);
                    var8_10 = var7_8.getIndex(var5_5);
                    var9_12 = var7_8.getNrReferences(var8_10);
                    LogAndPrint.message("References to Connection " + (var9_12 - 1) + " -> " + var9_12);
                    var10_14 = this.m_connectionPool.getPooledConnection(var5_5);
                    if (var10_14 == null) {
                        this.m_connectionPool.putPooledConnection(var2_2, var1_1, (PooledConnection)var7_8, var5_5);
                    }
                    if ((var11_15 = ActivationPoolingService.getBackendPingTimeout()) != -1L) {
                        try {
                            var5_5.sendControlMessage("ping", "", var11_15);
                            break block16;
                        }
                        catch (BusException var13_16) {
                            LogAndPrint.error("Pooled Connection refers to a server that is unavailable or is already closed: (" + var5_5.getServerComponentId() + "). Trying to delete the connection from the pool. " + "Deactivating clients which are refering to the closed connection can give multiple exceptions in the logfile.");
                            ** while (var7_8.getNrReferences((int)var8_10) > 0)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.releaseConnection(var5_5, true);
                            continue;
                        }
lbl48:
                        // 1 sources

                        this.m_connectionPool.removePooledConnection(var5_5);
                        if (this.m_firstTime) {
                            this.m_firstTime = false;
                            var5_5 = this.giveConnection(var1_1, var2_2);
                        } else {
                            this.m_firstTime = true;
                            throw new BusException("Unable to create a new Backend reference");
                        }
                    }
                }
            }
            return var5_5;
        }
    }

    public synchronized void releaseConnection(Connection connection, boolean bl) throws BusException {
        PooledConnection pooledConnection;
        if (connection != null && (pooledConnection = this.m_connectionPool.getPooledConnection(connection)) != null) {
            LogAndPrint.message("Ask the policy to release this reference");
            boolean bl2 = pooledConnection.getPolicy().ReleaseReference(pooledConnection, connection, bl);
            int n = pooledConnection.getIndex(connection);
            int n2 = pooledConnection.getNrReferences(n);
            if (n2 != -1) {
                LogAndPrint.message("References to Connection " + (n2 + 1) + " -> " + n2);
            }
            if (bl2 && !bl) {
                this.m_connectionPool.removePooledConnection(connection);
            }
        }
    }

    private class ConnectionPool {
        private Hashtable m_userSessions = new Hashtable();
        private Hashtable m_pooledConnectionsPerBusComponentId = null;
        private Hashtable m_pooledConnectionsPerConnection = new Hashtable();

        ConnectionPool() {
        }

        synchronized PooledConnection getPooledConnection(Connection connection) {
            if (connection != null) {
                return (PooledConnection)this.m_pooledConnectionsPerConnection.get(connection);
            }
            return null;
        }

        synchronized PooledConnection getPooledConnection(UserSession userSession, String string) {
            this.m_pooledConnectionsPerBusComponentId = (Hashtable)this.m_userSessions.get(userSession);
            if (this.m_pooledConnectionsPerBusComponentId != null) {
                return (PooledConnection)this.m_pooledConnectionsPerBusComponentId.get(string);
            }
            return null;
        }

        synchronized void putPooledConnection(UserSession userSession, String string, PooledConnection pooledConnection, Connection connection) {
            this.m_pooledConnectionsPerBusComponentId = (Hashtable)this.m_userSessions.get(userSession);
            if (this.m_pooledConnectionsPerBusComponentId == null) {
                this.m_pooledConnectionsPerBusComponentId = new Hashtable();
                this.m_userSessions.put(userSession, this.m_pooledConnectionsPerBusComponentId);
            }
            this.m_pooledConnectionsPerBusComponentId.put(string, pooledConnection);
            this.m_pooledConnectionsPerConnection.put(connection, pooledConnection);
        }

        synchronized void removePooledConnection(Connection connection) {
            this.m_pooledConnectionsPerConnection.remove(connection);
        }
    }
}

