/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.aps;

import com.baan.b3.aps.APSImpl;
import com.baan.b3.aps.LogAndPrint;
import com.baan.b3.server.IParameter;
import com.baan.b3.server.ServerException;
import com.baan.b3.server.ServerLicenseException;
import com.baan.b3.server.ServerRuntimeImpl;

public class APServerImpl
extends ServerRuntimeImpl {
    private static String LIBRARY = "APSServer";
    private static String FUNCTION_ACTIVATE = "Activate";
    private static String FUNCTION_DEACTIVATE = "DeActivate";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static String START_LINE = NEWLINE + "->>-------------------------------------------------------------------------------------";
    private static String END_LINE = "-<<-------------------------------------------------------------------------------------" + NEWLINE;

    APServerImpl() throws ServerLicenseException {
        super(null, -795243658, "Activation and Pooling Service", true);
    }

    public String dispatch(String string, String string2, IParameter[] iParameterArray, IParameter iParameter) throws ServerException {
        LogAndPrint.print(START_LINE);
        LogAndPrint.message("APS Server received message (dll='" + string + "', function='" + string2 + "')");
        if (string.equalsIgnoreCase(LIBRARY)) {
            if (string2.equalsIgnoreCase(FUNCTION_ACTIVATE)) {
                String string3 = iParameterArray[0].getValueString();
                String string4 = iParameterArray[1].getValueString();
                String string5 = iParameterArray[2].getValueString();
                try {
                    String string6 = APSImpl.activate(string3, string4, string5);
                    iParameterArray[3].setValue(string6);
                    iParameter.setValue("0");
                }
                catch (Exception exception) {
                    LogAndPrint.print(exception.toString());
                    iParameter.setValue("-1");
                    iParameterArray[4].setValue(exception.getMessage());
                }
                LogAndPrint.print(END_LINE);
                return null;
            }
            if (string2.equalsIgnoreCase(FUNCTION_DEACTIVATE)) {
                String string7 = iParameterArray[0].getValueString();
                try {
                    APSImpl.deActivate(string7);
                    iParameter.setValue("0");
                }
                catch (Exception exception) {
                    iParameter.setValue("-1");
                    iParameterArray[1].setValue(exception.getMessage());
                }
                LogAndPrint.print(END_LINE);
                return null;
            }
        }
        LogAndPrint.message("Received unknown message, ignoring");
        LogAndPrint.message("Returning error to APS client");
        LogAndPrint.print(END_LINE);
        throw new ServerException("APS Service received unknown message");
    }
}

