/*
 * Decompiled with CFR 0.152.
 */
package com.baan.b3.aps;

import com.baan.b3.aps.ConnectionFactory;
import com.baan.b3.aps.LogAndPrint;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.eibus.co.dom.UserInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.security.BlockEncryption;
import com.eibus.xml.util.DOMWriter;
import java.util.Hashtable;

public class APSImpl {
    private static int m_Counter = 0;
    private static Hashtable m_UserSessions = new Hashtable();
    private static Hashtable m_Connections = new Hashtable();
    private static ConnectionFactory m_connectionFactory = ConnectionFactory.getInstance();

    static String activate(String string, String string2, String string3) throws Exception {
        LogAndPrint.message("Try to get reference (start server) for BC '" + string + "'");
        UserSession userSession = APSImpl.createUserSessionFromCryptedUserNamePass(string2);
        try {
            Connection connection = m_connectionFactory.giveConnection(string, userSession);
            BusComponent busComponent = connection.getServerComponent();
            String string4 = string + "-" + ++m_Counter;
            busComponent.setIdentifier(string4);
            LogAndPrint.message("Started BC Identifier = '" + string4 + "'");
            m_Connections.put(string4, connection);
            String string5 = new DOMWriter(busComponent.toDOM()).toString();
            LogAndPrint.message("Started BC = '" + string5 + "'");
            return string5;
        }
        catch (BusException busException) {
            LogAndPrint.message("Error in creating/starting " + busException.getMessage());
            LogAndPrint.message("Returning error to APS client");
            throw new Exception(busException.getMessage());
        }
    }

    public static void deActivate(String string) throws Exception {
        try {
            LogAndPrint.message("Try to Release Reference (stop server) for BC '" + string + "'");
            Connection connection = (Connection)m_Connections.get(string);
            m_connectionFactory.releaseConnection(connection, false);
            m_Connections.remove(string);
        }
        catch (BusException busException) {
            LogAndPrint.error("Error in releasing/stopping " + busException.getMessage());
        }
    }

    private static UserSession createUserSessionFromCryptedUserNamePass(String string) {
        String string2 = BlockEncryption.DecryptToString(string, "B25149AC9E975F30F59EBA40592746FCB25149AC9E975F30F59EBA40592746FC");
        UserSession userSession = (UserSession)m_UserSessions.get(string2);
        String string3 = "-";
        if (userSession == null) {
            LogAndPrint.message("UserSession not exists, creating new one");
            int n = string2.indexOf("#");
            String string4 = string2.substring(0, n);
            String string5 = string2.substring(n + 1);
            UserInfoCoImpl userInfoCoImpl = new UserInfoCoImpl();
            userInfoCoImpl.setPassword(string5, true);
            userInfoCoImpl.setUsername(string4, true);
            UserInfo userInfo = new UserInfo(userInfoCoImpl);
            string3 = userInfo.getUsername();
            IUserSession iUserSession = BoiToolkit.getDefaultToolkit().createUserSession(userInfo);
            userSession = (UserSession)iUserSession;
            m_UserSessions.put(string2, userSession);
        } else {
            LogAndPrint.message("UserSession exists, returning existing one");
            string3 = userSession.getUserInfo().getUsername();
        }
        LogAndPrint.message("Username = " + string3);
        return userSession;
    }
}

