/*
 * Decompiled with CFR 0.152.
 */
package com.baan.asm;

import com.baan.asm.AsmInstance;
import com.baan.asm.AsmInstanceList;
import com.baan.asm.AsmRequestBlock;
import com.baan.asm.AsmResponseBlock;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class AsmClientAPI {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.asm", "AsmClientAPI");
    private static final int ASM_DEFAULT_PORT = 7150;
    public static final int ASM_MAX_TIMEOUT = 120000;
    private static final String ASM_REQUESTTAG = "ASMRequest";
    private static short ASM_CURRVERSION = (short)2;
    public static final int ASM_SUCCESS = 0;
    public static final int ASM_EPROTO_INVAL = -1;
    public static final int ASM_ESERVICE_INVAL = -2;
    public static final int ASM_ESERVICE_ALREADY_STARTED = -3;
    public static final int ASM_ESERVICE_NOT_STARTED = -4;
    public static final int ASM_ESERVICE_ALREADY_STOPPED = -5;
    public static final int ASM_ESERVICE_NOT_STOPPED = -6;
    public static final int ASM_EVERSION_MISMATCH = -7;
    public static final int ASM_ECOMMUNICATION_FAILED = -8;
    public static final int ASM_ESERVER_TIMEOUT = -9;
    public static final int ASM_ENORESPONSE = -10;
    public static final int ASM_EADDRESS_IN_USE = -11;
    public static final int ASM_ESOCK_INVAL = -12;
    public static final String STR_ASM_SUCCESS = "success";
    public static final String STR_ASM_EPROTO_INVAL = "Invalid protocol usage.";
    public static final String STR_ASM_ESERVICE_INVAL = "Invalid service name.";
    public static final String STR_ASM_ESERVICE_ALREADY_STARTED = "Service already started.";
    public static final String STR_ASM_ESERVICE_NOT_STARTED = "Service could not be started.";
    public static final String STR_ASM_ESERVICE_ALREADY_STOPPED = "Service already stopped.";
    public static final String STR_ASM_ESERVICE_NOT_STOPPED = "Service could not be stopped.";
    public static final String STR_ASM_EVERSION_MISMATCH = "Version mismatch between client and server.";
    public static final String STR_ASM_ECOMMUNICATION_FAILED = "Failed to communicate with ASM daemon.";
    public static final String STR_ASM_ESERVER_TIMEOUT = "Application Services Manager did not respond within timeout period.";
    public static final String STR_ASM_ENORESPONSE = "No response from host.";
    public static final String STR_ASM_EADDRESS_IN_USE = "Port address already in use.";
    public static final String STR_ASM_ESOCK_INVAL = "Invalid Socket descriptor.";
    private static final short ASM_MSG_OpenConnection = 1;
    private static final short ASM_MSG_CloseConnection = 2;
    private static final short ASM_MSG_GetServiceInstances = 3;
    private static final short ASM_MSG_StartServiceInstance = 4;
    private static final short ASM_MSG_StopServiceInstance = 5;
    private static final short ASM_MSG_StartAllInstances = 6;
    private static final short ASM_MSG_StopAllInstances = 7;
    private static final short ASM_MSG_PutInstanceID = 8;
    private static final short ASM_MSG_Unknown = 9;
    public static final int ASM_ISTAT_Stopped = 0;
    public static final int ASM_ISTAT_Running = 1;
    public static final int ASM_ISTAT_Defined = 2;
    private static final int NR_MSGS_ONE_INSTANCE = 5;
    private String m_hostname = null;
    private int m_port = 0;
    private boolean m_connected = false;
    private Socket m_socket = null;
    private DataInputStream m_is = null;
    private DataOutputStream m_os = null;
    private String m_LastError = "";

    public synchronized int ASM_OpenConnection(String string, int n) {
        AsmResponseBlock asmResponseBlock;
        int n2 = 0;
        if (this.m_connected) {
            return 0;
        }
        n = this.determineASMPort(n);
        try {
            this.m_socket = new Socket(string, n);
            this.m_socket.setSoTimeout(120000);
            this.m_is = new DataInputStream(this.m_socket.getInputStream());
            this.m_os = new DataOutputStream(this.m_socket.getOutputStream());
            s_logger.flowMessage("ASMClient: ASM_OpenConnection, created output stream '" + this.m_os.toString() + "', to socket adress '" + n + "', on host '" + string + "'");
        }
        catch (UnknownHostException unknownHostException) {
            this.m_LastError = unknownHostException.toString();
            return -12;
        }
        catch (SocketException socketException) {
            if (this.m_socket == null) {
                this.m_LastError = socketException.toString();
                return -12;
            }
        }
        catch (IOException iOException) {
            this.m_LastError = iOException.toString();
            return -12;
        }
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(1);
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n2 = -8;
        }
        if (n2 == 0 && (n2 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            n2 = asmResponseBlock.getReturnCode();
        }
        if (n2 == 0) {
            this.m_connected = true;
            this.m_port = n;
            this.m_hostname = string;
        } else {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                this.m_LastError = iOException.toString();
            }
            this.m_socket = null;
            this.m_is = null;
            this.m_os = null;
        }
        return n2;
    }

    public synchronized int ASM_CloseConnection() {
        AsmResponseBlock asmResponseBlock;
        int n = 0;
        if (!this.m_connected) {
            return -12;
        }
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(2);
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n = -8;
        }
        if (n == 0 && (n = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            n = asmResponseBlock.getReturnCode();
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            s_logger.errorMessage("com.baan.asm.ASMClientAPI.CloseFailed ASM_CloseConnection, error closing connection");
            s_logger.errorException(iOException);
            this.m_LastError = iOException.toString();
        }
        this.m_socket = null;
        this.m_is = null;
        this.m_os = null;
        this.m_connected = false;
        this.m_hostname = null;
        this.m_port = 0;
        return n;
    }

    public synchronized int ASM_GetServiceInstances(int n, Integer n2, AsmInstanceList asmInstanceList) {
        AsmResponseBlock asmResponseBlock;
        int n3 = 0;
        if (!this.m_connected) {
            return -12;
        }
        this.setSocketTimeout(n);
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(3);
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n3 = -8;
        }
        if (n3 == 0 && (n3 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            short s = asmResponseBlock.getReturnCode();
            n3 = s;
            if (s == 0) {
                n3 = this.constructInstanceList(asmResponseBlock, asmInstanceList, n2);
            }
        }
        return n3;
    }

    public synchronized int ASM_StartServiceInstance(int n, String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        int n2 = 0;
        if (!this.m_connected) {
            return -12;
        }
        this.setSocketTimeout(n);
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(4);
        asmRequestBlock.addParam(string);
        asmRequestBlock.addParam(string2);
        asmRequestBlock.addParam(string3);
        asmRequestBlock.addParam(n / 1000);
        if (string4 != null) {
            asmRequestBlock.addParam(string4);
            if (string5 != null) {
                asmRequestBlock.addParam(string5);
            }
        }
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n2 = -8;
        }
        if (n2 == 0) {
            AsmResponseBlock asmResponseBlock = new AsmResponseBlock();
            n2 = this.receiveAsmResponseBlock(asmResponseBlock);
            if (n2 == 0) {
                n2 = asmResponseBlock.getReturnCode();
            }
            if (n2 == 0) {
                stringBuffer.setLength(0);
                if (asmResponseBlock.nrMsgs() == 1) {
                    stringBuffer.append(asmResponseBlock.getMsg(0));
                } else if (asmResponseBlock.nrMsgs() != 0) {
                    n2 = -1;
                }
            }
        }
        return n2;
    }

    public synchronized int ASM_StopServiceInstance(int n, String string, String string2, String string3, String string4, String string5) {
        AsmResponseBlock asmResponseBlock;
        int n2 = 0;
        if (!this.m_connected) {
            return -12;
        }
        this.setSocketTimeout(n);
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(5);
        asmRequestBlock.addParam(string);
        asmRequestBlock.addParam(string2);
        asmRequestBlock.addParam(string3);
        if (string4 != null) {
            asmRequestBlock.addParam(string4);
            if (string5 != null) {
                asmRequestBlock.addParam(string5);
            }
        }
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n2 = -8;
        }
        if (n2 == 0 && (n2 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            n2 = asmResponseBlock.getReturnCode();
        }
        return n2;
    }

    public synchronized int ASM_StartAllInstances(int n, String string, Integer n2, AsmInstanceList asmInstanceList) {
        AsmResponseBlock asmResponseBlock;
        int n3 = 0;
        if (!this.m_connected) {
            return -12;
        }
        this.setSocketTimeout(n);
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(6);
        asmRequestBlock.addParam(string);
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n3 = -8;
        }
        if (n3 == 0 && (n3 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            short s = asmResponseBlock.getReturnCode();
            n3 = s;
            if (s == 0) {
                n3 = this.constructInstanceList(asmResponseBlock, asmInstanceList, n2);
            }
        }
        return n3;
    }

    public synchronized int ASM_StopAllInstances(int n, String string, Integer n2, AsmInstanceList asmInstanceList) {
        AsmResponseBlock asmResponseBlock;
        int n3 = 0;
        if (!this.m_connected) {
            return -12;
        }
        this.setSocketTimeout(n);
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(7);
        asmRequestBlock.addParam(string);
        if (this.sendAsmRequestBlock(asmRequestBlock) < 0) {
            n3 = -8;
        }
        if (n3 == 0 && (n3 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            short s = asmResponseBlock.getReturnCode();
            n3 = s;
            if (s == 0) {
                n3 = this.constructInstanceList(asmResponseBlock, asmInstanceList, n2);
            }
        }
        return n3;
    }

    public synchronized int ASM_PutInstanceID(int n, int n2, String string) {
        AsmResponseBlock asmResponseBlock;
        String string2 = new String("localhost");
        int n3 = 0;
        if (this.m_connected) {
            return -1;
        }
        try {
            s_logger.flowMessage("ASM: Creating socket to host:'" + string2 + "', port'" + n + "'");
            this.m_socket = new Socket(string2, n);
            this.m_socket.setSoTimeout(n2);
            this.m_is = new DataInputStream(this.m_socket.getInputStream());
            this.m_os = new DataOutputStream(this.m_socket.getOutputStream());
        }
        catch (UnknownHostException unknownHostException) {
            s_logger.errorException(unknownHostException);
            this.m_LastError = unknownHostException.toString();
            return -12;
        }
        catch (SocketException socketException) {
            s_logger.errorException(socketException);
            if (this.m_socket == null) {
                this.m_LastError = socketException.toString();
                return -12;
            }
        }
        catch (IOException iOException) {
            s_logger.errorException(iOException);
            this.m_LastError = iOException.toString();
            return -12;
        }
        AsmRequestBlock asmRequestBlock = new AsmRequestBlock(8);
        asmRequestBlock.addParam(string);
        n3 = this.sendAsmRequestBlock(asmRequestBlock);
        if (n3 < 0) {
            s_logger.errorMessage("Failed to communicate with ASM daemon. (-8)");
            n3 = -8;
        }
        if (n3 == 0 && (n3 = this.receiveAsmResponseBlock(asmResponseBlock = new AsmResponseBlock())) == 0) {
            n3 = asmResponseBlock.getReturnCode();
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                this.m_LastError = iOException.toString();
            }
            this.m_socket = null;
            this.m_is = null;
            this.m_os = null;
        }
        return n3;
    }

    public synchronized void ASM_FreeInstanceList(AsmInstance asmInstance) {
    }

    public synchronized void ASM_FreeInstanceID(String string) {
    }

    public String ASM_GiveErrorStringFromCode(int n) {
        switch (n) {
            case 0: {
                return STR_ASM_SUCCESS;
            }
            case -1: {
                return STR_ASM_EPROTO_INVAL;
            }
            case -2: {
                return STR_ASM_ESERVICE_INVAL;
            }
            case -3: {
                return STR_ASM_ESERVICE_ALREADY_STARTED;
            }
            case -4: {
                return STR_ASM_ESERVICE_NOT_STARTED;
            }
            case -5: {
                return STR_ASM_ESERVICE_ALREADY_STOPPED;
            }
            case -6: {
                return STR_ASM_ESERVICE_NOT_STOPPED;
            }
            case -7: {
                return STR_ASM_EVERSION_MISMATCH;
            }
            case -8: {
                return STR_ASM_ECOMMUNICATION_FAILED;
            }
            case -9: {
                return STR_ASM_ESERVER_TIMEOUT;
            }
            case -10: {
                return STR_ASM_ENORESPONSE;
            }
            case -11: {
                return STR_ASM_EADDRESS_IN_USE;
            }
            case -12: {
                return STR_ASM_ESOCK_INVAL;
            }
        }
        return "undefined error";
    }

    public synchronized String ASM_GiveLastErrorString() {
        String string = this.m_LastError;
        this.m_LastError = "";
        return string;
    }

    private synchronized int constructInstanceList(AsmResponseBlock asmResponseBlock, AsmInstanceList asmInstanceList, Integer n) {
        int n2 = 1;
        asmInstanceList = null;
        if (asmResponseBlock == null || asmResponseBlock.nrMsgs() % 5 != 0) {
            return -1;
        }
        if (asmResponseBlock.nrMsgs() < 1) {
            n = new Integer(0);
            return 0;
        }
        asmInstanceList = new AsmInstanceList();
        n2 = 1;
        while (n2 <= asmResponseBlock.nrMsgs()) {
            String string = asmResponseBlock.getMsg(n2++);
            String string2 = asmResponseBlock.getMsg(n2++);
            String string3 = asmResponseBlock.getMsg(n2++);
            String string4 = asmResponseBlock.getMsg(n2++);
            int n3 = Integer.valueOf(asmResponseBlock.getMsg(n2++));
            asmInstanceList.addInstance(string, string2, string3, string4, n3);
        }
        n = new Integer(asmInstanceList.nrInstances());
        return 0;
    }

    private synchronized int sendAsmRequestBlock(AsmRequestBlock asmRequestBlock) {
        int n = 0;
        if (this.sendString(ASM_REQUESTTAG) == -1 || this.sendShort(ASM_CURRVERSION) == -1 || this.sendShort(asmRequestBlock.getRemainingBytes()) == -1 || this.sendShort(asmRequestBlock.getCommand()) == -1 || this.sendShort(asmRequestBlock.nrParams()) == -1) {
            return -8;
        }
        n = 0;
        while (n < asmRequestBlock.nrParams()) {
            if (this.sendString(asmRequestBlock.getParam(n)) == -1) {
                return -8;
            }
            ++n;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int receiveAsmResponseBlock(AsmResponseBlock asmResponseBlock) {
        String string = null;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        try {
            s2 = this.recvShort();
            s3 = this.recvShort();
            if (s2 != ASM_CURRVERSION) {
                this.discardBytes(s3);
                s_logger.errorMessage("Version mismatch between client and server. (-7)");
                return -7;
            }
            s4 = this.recvShort();
            s = this.recvShort();
            asmResponseBlock.setReturnCode(s4);
            asmResponseBlock.setRemainingBytes(s3);
            while (true) {
                short s5 = s;
                s = (short)(s5 - 1);
                if (s5 <= 0) {
                    return 0;
                }
                string = this.recvString();
                asmResponseBlock.addMsg(string);
            }
        }
        catch (IOException iOException) {
            this.m_LastError = iOException.toString();
            s_logger.errorMessage("Failed to communicate with ASM daemon. (-8)");
            return -8;
        }
    }

    private int sendShort(short s) {
        s_logger.flowMessage("ASMClient: sendShort : '" + s + "'");
        byte[] byArray = new byte[]{0, 0};
        byArray[0] = new Integer(s >> 8 & 0xFF).byteValue();
        byArray[1] = new Integer(s & 0xFF).byteValue();
        try {
            this.m_os.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            this.m_LastError = iOException.toString();
            s_logger.errorMessage("ASMClient: sendShort exception: " + iOException.toString());
            return -1;
        }
        return 0;
    }

    private int sendString(String string) {
        try {
            int n = string.length();
            byte[] byArray = string.getBytes();
            boolean bl = true;
            s_logger.flowMessage("ASMClient: sendString : '" + string + "' (" + n + ")");
            int n2 = 0;
            while (n2 < n && bl) {
                if (byArray[n2] != 0) {
                    this.m_os.writeByte(byArray[n2]);
                } else {
                    bl = false;
                }
                ++n2;
            }
            this.m_os.writeByte(0);
        }
        catch (IOException iOException) {
            s_logger.errorMessage("ASMClient: sendString exception: " + iOException.toString());
            this.m_LastError = iOException.toString();
            return -1;
        }
        return 0;
    }

    private short recvShort() throws IOException {
        return this.m_is.readShort();
    }

    private void discardBytes(short s) {
        try {
            this.m_is.skipBytes(s);
        }
        catch (IOException iOException) {}
    }

    private String recvString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((by = this.m_is.readByte()) != 0) {
            byteArrayOutputStream.write(by);
        }
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toString();
    }

    private int determineASMPort(int n) {
        if (n <= 0) {
            n = 7150;
        }
        return n;
    }

    private void setSocketTimeout(int n) {
        int n2 = 120000;
        try {
            if (n > 0 && n < 120000) {
                n2 = n;
            }
            this.m_socket.setSoTimeout(n2);
        }
        catch (SocketException socketException) {}
    }
}

