/*
 * Decompiled with CFR 0.152.
 */
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IBackend;
import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;

public class OWPing {
    private static final String COPYRIGHT = new AdapterComponentInfo().getCopyrightMessage();
    public static final String DESCRIPTION = "Command-line Ping";
    private static final String USAGE = "    java OWPing <BusComponentID>";
    private static final String ERROR_ARGS = "Required one argument, the BusComponent Identifier";
    private static final String NEWLINE = System.getProperty("line.separator");

    public static void main(String[] stringArray) {
        ILogger iLogger = LoggerFactory.createLogger("root", "OWPing");
        LoggerFactory.setApplicationName("OWPing");
        String string = " (" + new AdapterComponentInfo().getVersion() + "." + new AdapterComponentInfo().getPatchLevel() + ")";
        System.out.println(DESCRIPTION + string);
        System.out.println(COPYRIGHT);
        System.out.println();
        if (stringArray.length == 1) {
            try {
                IBackend iBackend = BoiToolkit.getDefaultToolkit().createBackend(stringArray[0]);
                System.out.print("ping to backend '" + stringArray[0] + "' ");
                long l = iBackend.ping();
                System.out.println("OK, took " + l + " ms.");
                String string2 = iBackend.getType();
                System.out.println("Backend type = '" + string2 + "'");
                iBackend.close();
            }
            catch (Exception exception) {
                System.out.println("failed!");
                System.out.println(exception.getMessage());
            }
        } else {
            System.out.println(ERROR_ARGS);
            System.out.println();
            System.out.println("usage:");
            System.out.println(USAGE);
        }
        System.out.println(NEWLINE + "bye!");
        LoggerFactory.exit(1);
    }
}

