/*
 * Decompiled with CFR 0.152.
 */
import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.ccf.LoggingConfiguration;
import com.baan.owimpl.fw.ccf.LoggingContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.FileLogger;
import com.baan.owimpl.fw.log.control.LogController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OWLog {
    private static final String COPYRIGHT = new AdapterComponentInfo().getCopyrightMessage();
    public static final String DESCRIPTION = "Command-line Log Tail";

    public void startTail(File file2) {
        LastFileThread lastFileThread = new LastFileThread(file2);
        if (file2 != null) {
            lastFileThread.start();
        }
    }

    public static void main(String[] stringArray) {
        String string = " (" + new AdapterComponentInfo().getVersion() + "." + new AdapterComponentInfo().getPatchLevel() + ")";
        System.out.println(DESCRIPTION + string);
        System.out.println(COPYRIGHT);
        System.out.println();
        try {
            LoggingConfiguration loggingConfiguration = LoggingContext.getInstance().search();
            loggingConfiguration.print(System.out);
            String string2 = loggingConfiguration.getFileName();
            System.out.println();
            String string3 = LogController.getLogLocation(string2);
            try {
                File file2 = new File(string3);
                System.out.println("Using folder '" + string3 + "'");
                OWLog oWLog = new OWLog();
                System.out.println("Start searching for newest logfile ...");
                oWLog.startTail(file2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        catch (OWConfigurationException oWConfigurationException) {
            System.out.println(oWConfigurationException.toString());
        }
    }

    public File findLatestFile(File file2) {
        long l = 0L;
        File file3 = null;
        File[] fileArray = file2.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            long l2;
            if (fileArray[n].isFile() && (l2 = fileArray[n].lastModified()) > l) {
                l = l2;
                file3 = fileArray[n];
            }
            ++n;
        }
        return file3;
    }

    static {
        FileLogger.s_LogEnabled = false;
    }

    public class TailThread
    extends Thread {
        public static final long delay = 200L;
        private File file;
        boolean running = true;
        RandomAccessFile raf = null;
        boolean mFirstFileFound = true;

        public TailThread(File file2, boolean bl) {
            this.file = file2;
            this.mFirstFileFound = bl;
            try {
                this.raf = new RandomAccessFile(this.file, "r");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("");
            System.out.println(" >>> Start tail on '" + this.file.getName() + "'");
            System.out.println("-----------------------------------------------------");
        }

        public void stopTail() {
            System.out.println("-----------------------------------------------------");
            System.out.println(" <<< Stop  tail on '" + this.file.getName() + "'");
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.running = false;
        }

        public void run() {
            try {
                long l = 0L;
                if (this.mFirstFileFound) {
                    l = this.file.length();
                    System.out.println(" . . . (skipped " + l + " bytes)");
                }
                while (this.running) {
                    long l2 = this.file.length();
                    if (l2 > l) {
                        this.raf.seek(l);
                        String string = null;
                        while ((string = this.raf.readLine()) != null) {
                            System.out.println(string);
                        }
                    }
                    l = l2;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class LastFileThread
    extends Thread {
        boolean running = true;
        public static final long delay = 2500L;
        private File directory;
        File fStartedTail = null;
        TailThread tailThread = null;
        boolean bFirstFileFound = true;

        public LastFileThread(File file2) {
            this.directory = file2;
        }

        public void run() {
            while (this.running) {
                File file2 = OWLog.this.findLatestFile(this.directory);
                if (!(file2 == null || this.fStartedTail != null && file2.equals(this.fStartedTail))) {
                    if (this.tailThread != null) {
                        this.tailThread.stopTail();
                    }
                    this.tailThread = new TailThread(file2, this.bFirstFileFound);
                    this.tailThread.start();
                    this.bFirstFileFound = false;
                    this.fStartedTail = file2;
                }
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

