#
# SCCSID ("@(#)info.sh	2.6 05/01/25")
#
InfoLog="LSinfo.txt"
Target="lsserver"

ScanCode=0
case $0 in
*/info.sh)	Prg="info.sh";;
./[!/]*[!/])	Prg=$0;;
*/*|/*|*/)	Prg=`basename $0 2>/dev/null`;;
*)		Prg=$0;;
esac

MinimumInfo()
{
	echo "$Prg failed (exit 1)"
	echo
	echo "id  information:"
	id
	echo
	echo "pwd information:"
	pwd
	echo
	echo "ls  information:"
	ls -l
	echo
	echo "BSE information:"
	echo $BSE
	if [ -s version.txt ]; then
		echo
		echo "Content of version.txt:"
		cat version.txt
	fi
	if [ -s lic.txt ]; then
		echo
		echo "Content of lic.txt:"
		cat lic.txt
	fi
	if [ -s ls_lic.txt ]; then
		echo
		echo "Content of ls_lic.txt:"
		cat ls_lic.txt
	fi
}

Exit()
{
	Ecode="$1"
	case $1 in
	1)	Msg="$Prg: $Target not installed in current directory"
		MinimumInfo >$InfoLog 2>&1
		;;
	2)	Msg="Usage: $Prg [-s] [-p] [-o <LogFile>]"; Ecode=2;;
	3)	Msg="$Prg: $Target should have execute permission [use chmod +x $Target]"; Ecode=3;;
	*)	Msg="$Prg: unexpected error ($1)"; Ecode=4;;
	esac
	ttyDef=0
	if [ $Silent = 0 ]; then
		ttyDef=1
		Machine=`uname 2>/dev/null | sed "/^OS400/!d" 2>/dev/null`
		if [ ! -z "$Machine" ]; then ttyDef=0; fi
	fi
	if [ $ttyDef = 1 ]; then
		echo $Msg >/dev/tty
	else
		echo $Msg
	fi
	exit $Ecode
}

Silent=0
while [ ! $# = 0 ]
do
	if [ "$1" = "-s" ]; then
		Silent=1; shift; continue
	fi
	if [ "$1" = "-p" ]; then
		Target="pns"; InfoLog="scaninfo.txt"; ScanCode=1
		shift; continue
	fi
	if [ "$1" = "-o" ]; then
		shift
		if [ $# = 0 ]; then
			Exit 2
		fi
		InfoLog="$1"
		shift; continue
	fi
	Exit 2
done

PWD=`pwd 2>/dev/null`
Cdir="$PWD"
if [ -z "$Cdir" ]
then Cdir=`pwd 2>/dev/nul`
fi
if [ -z "$Cdir" ]
then Cdir="."
fi

LastFiles()
{
	echo
	if [ ! -d "$1" ]
	then
		echo "++ Directory $1 not existing (yet)"
		return
	fi
	echo "++ Recent files in directory $1:"
	ls -Llt "$1" | head -$2
}

CheckCore()
{
	Cfile=`ls "$Cdir/core" 2>/dev/null`
	echo
	if [ -z "$Cfile" ]
	then echo "++ No core file seen"
	else echo "++ Core file seen:"
	file "$Cdir/core" 2>&1
	fi
}

DumpFiles()
{
	if [ -z "$1" ]
	then return
	fi
	for i in "${@}"
	do
		Fil=`ls "$i" 2>/dev/null`
		if [ -s "$Fil" ]
		then	echo
			Sz=`du -k "$Fil" | cut -f1`
			if [ "$Sz" -le "10" ]
			then
				echo "++ Contents of file $Fil"
				cat "$Fil"
			else
				echo "++ Contents of file $Fil (last 200 lines)"
				tail -200 "$Fil"
			fi
		fi
	done
}

GetVersions()
{
	if [ -z "$1" ]
	then return
	fi
	echo
	echo "++ Version information:"
	for i in $*
	do
		if [ "$i" = "pns" ]
		then DumpFiles "$Cdir/pns/PNS.txt"
		continue
		fi
		Fil=`ls "$Cdir/$i" 2>/dev/null`
		if [ -x "$Fil" ]
		then "$Fil" -V 2>&1
		fi
	done
}

DefParamFiles()
{
	DumpFiles "$Cdir/input.txt" "$Cdir/sys_user.tmp"
	[ -s "$Cdir/comp.tmp" ] && DumpFiles "$Cdir/comp.tmp" && echo
	if [ -d $Cdir/output ]
	then
		Ifil=`ls -t "$Cdir"/output/*input* 2>/dev/null | head -1`
		DumpFiles "$Ifil"
	fi
}

GetProcs()
{
Owner=`ls -ld $Target* | sed -e "/^total /d" -e "/  */s//	/g" | cut -f 3 | sort -u | head -1`
echo
echo "++ Owner of $Target files: $Owner"
echo "++ Processes owned by $Owner"
if [ ! -z "$Owner" ]; then
ps -lfu $Owner
fi
}

if [ ! -x "$Cdir/$Target" ]
then
	if [ ! -s "$Cdir/$Target" ]; then Exit 1; fi
	chmod ug+x "$Cdir/$Target"
	if [ ! -x "$Cdir/$Target" ]; then Exit 3; fi
fi
if [ ! -d "$Cdir/html" ]
then
	if [ $Target = "elles" ]
	then Exit 1
	fi
fi

Sname=`hostname 2>/dev/null`
Dt=`date "+%Y-%m-%d %H:%M:%S" 2>/dev/null`

echo "$Prg executed on $Sname at $Dt ($Target directory: $Cdir; BSE: $BSE)" >$InfoLog

ExcList="elles formatter bboam bboxp freepnso pns"
if [ $ScanCode = 1 ]
then
	ExcList="bboam bboxp pns"
fi
GetVersions $ExcList >>$InfoLog 2>/dev/null

LastFiles "$Cdir" 20 >>$InfoLog 2>/dev/null
if [ $ScanCode = 0 ]
then
	LastFiles "$Cdir/output" 20 >>$InfoLog 2>/dev/null
	LastFiles "$Cdir/download" 20 >>$InfoLog 2>/dev/null
	LastFiles "$Cdir/html" 20 >>$InfoLog 2>/dev/null
	LastFiles "$Cdir/pnso" 20 >>$InfoLog 2>/dev/null
fi
LastFiles "$Cdir/pns" 20 >>$InfoLog 2>/dev/null

CheckCore >>$InfoLog

DumpFiles ./*.log ./*.olg >>$InfoLog
if [ $ScanCode = 0 ]
then
	DumpFiles ./*forout* >>$InfoLog
	DumpFiles ./*fortemp* >>$InfoLog
	DumpFiles ./*pnstempli* >>$InfoLog
fi
DumpFiles "$Cdir/pns/Bsh_vers.txt" >>$InfoLog
DumpFiles "$Cdir/pns/valobj.out" >>$InfoLog
DumpFiles "$Cdir/defparam.def" >>$InfoLog
DumpFiles "$Cdir/pns.env" >>$InfoLog

DumpFiles "$Cdir/pns/scancomp.log" >>$InfoLog
DefParamFiles >>$InfoLog 2>/dev/null

GetProcs >>$InfoLog 2>/dev/null

echo >>$InfoLog
echo "++ End of collected information" >>$InfoLog

if [ $Silent = 0 ]; then
	Ver=`head -1 version.txt 2>/dev/null`
	[ -z "$Ver" ] && Ver="???"
	echo "Data has been collected in file $Cdir/$InfoLog."
	echo "Product details: $Ver"
fi
