#
# SCCSID ("@(#)upgrade.sh	1.1 04/09/28")
#

StartServer=${1-"no"}
Container=${2-"no-container"}
Platform=${3-"unix"}
ResultFile=${4-"updates/results.txt"}

if [ $StartServer = "yes" ]
then
	TmpFile=upgrade-$$.txt
	./ls_ctl -c killall >$TmpFile 2>&1
	rm -f $TmpFile
	./installer -u1 "$Container" $Platform $ResultFile >$TmpFile 2>&1
	if [ $? = 0 ]
	then
		if [ -s $TmpFile ]
		then
			echo "\nMessages issued by installer program:" >>upgrade.log
			cat $TmpFile >>upgrade.log
		fi
		if [ -s PostUpdates.txt ]
		then
			Exc="./lsserver"
			if [ ! -s $Exc ]
			then
				Exc="./elles"
			fi
			$Exc -u PostUpdates.txt 2>>upgrade.log
		fi
	else
		./ls_ctl -d "\n\nError(s) and/or warning(s) during upgrade procedure:\n" $TmpFile
	fi
	./ls_ctl -c start >$TmpFile 2>&1
	rm -f $TmpFile
else
	rm -f $ResultFile
	./installer -u1 "$Container" $Platform $ResultFile
	if [ ! -s $ResultFile ]
	then
		echo "Unexpected result after upgrade script" >$ResultFile
	fi
fi
