#
# SCCSID ("@(#)server.sh	1.8 08/02/06")
#

Prg="server.sh"

Usage()
{
	echo "Usage: $Prg [-start | -stop | -trace <lvl>]"
	exit 1
}

Pwd=`pwd 2>/dev/null`
if [ ! -s config.txt ]
then
	echo "File $Pwd/config.txt not found or empty."
	echo "Execution is to be started from installation directory."
	exit 2
fi

Pnr=`sed -e "/SRV_PortNr/!d" -e "s/.*=[ 	]*//" -e "s/[ 	]*#.*//" config.txt 2>/dev/null`
if [ -z "$Pnr" ]; then
	Pnr="9030"
fi
Mode=1
Trace=""
SrvOnly=""
sArg="srv"
while [ ! $# = 0 ]
do
	if [ "$1" = "-p" ]; then
		shift
		if [ $# = 0 ]; then
			Usage
		fi
		echo "When applicable, adjust port numbers in file $Pwd/config.txt"
		Usage
	fi
	Mode=$1; shift
	case $Mode in
	-startsrv)	Mode=1;SrvOnly="-e";;
	-sta*)		Mode=1
			if [ "$1" = "srv" ]; then
				SrvOnly="-e"; shift
			fi;;
	-killall*)	Mode=3; sArg="all";;
	-killsrv*)	Mode=3; sArg="srv";;
	-killldf*)	Mode=3; sArg="ldf";;
	-kil*)		Mode=3
			if [ $# = 0 ]; then
				sArg="all"
			else
				case $1 in
				-p*)	Usage;;
				srv*)	sArg="srv";shift;;
				ldf*)	sArg="ldf";shift;;
				*)	sArg="all";shift;;
				esac
			fi;;
	-stopall*)	Mode=2; sArg="all";;
	-stopsrv*)	Mode=2; sArg="srv";;
	-stopldf*)	Mode=2; sArg="ldf";;
	-sto*)		Mode=2
			if [ $# = 0 ]; then
				sArg="all"
			else
				case $1 in
				-p*)	Usage;;
				srv*)	sArg="srv";shift;;
				ldf*)	sArg="ldf";shift;;
				*)	sArg="all";shift;;
				esac
			fi;;
	-tra*)		if [ -z "$1" ]; then
				Usage
			fi
			Mode=1;Trace="-t $1";shift;;
	*)		echo "$Prg: option $Mode not expected"; Usage;;
	esac
done

if [ -s qsh_path.sh ]
then
	. ./qsh_path.sh
elif [ -s path.sh ]
then
	. ./path.sh
fi

if [ $Mode = 1 ]; then
	./ls_ctl -c start $Trace $SrvOnly </dev/null
	Rval=$?
	if [ $Rval = 0 ]; then
		if [ -z "$Trace" ]; then
			Hname=`hostname 2>/dev/null`
			echo
			echo "To use Support Portal - type address \"http://$Hname:$Pnr\" in your browser"
		fi
	fi
else
	if [ $Mode = 2 ]; then
		./ls_ctl -c stop$sArg
	else
		./ls_ctl -c kill$sArg
	fi
fi
