/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.taxprovider1;

import com.ssa.ta.taxprovider1.BuyerDestination;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.Manager1;
import com.ssa.ta.taxprovider1.PurchaseOrderTPPRetObj1;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.VendorAdministrativeOrigin;
import com.ssa.ta.taxprovider1.VendorPhysicalOrigin;

public class PurchaseOrderTPPClient {
    private static final String EMPTY_STRING;
    private static final String SYSPROP_BUS_COMPONENT = "bc";
    private static final String DEFAULT_BUS_COMPONENT = "vertex";
    private static final String SYSPROP_DOCUMENT_NR = "documentNr";
    private static final String DEFAULT_DOCUMENT_NR;
    private static final String SYSPROP_DOCUMENT_DATE = "documentDate";
    private static final String DEFAULT_DOCUMENT_DATE = "2005-06-07";
    private static final String SYSPROP_BUYER_COMPANY = "buyerCompany";
    private static final String DEFAULT_BUYER_COMPANY = "buyID99";
    private static final String SYSPROP_BUYER_DEST_GEOCODE = "buyerDestGeocode";
    private static final String DEFAULT_BUYER_DEST_GEOCODE;
    private static final String SYSPROP_BUYER_DEST_STREET = "buyerDestStreet";
    private static final String DEFAULT_BUYER_DEST_STREET;
    private static final String SYSPROP_BUYER_DEST_CITY = "buyerDestCity";
    private static final String DEFAULT_BUYER_DEST_CITY = "Montgomery";
    private static final String SYSPROP_BUYER_DEST_STATE = "buyerDestState";
    private static final String DEFAULT_BUYER_DEST_STATE = "AL";
    private static final String SYSPROP_BUYER_DEST_COUNTY = "buyerDestCounty";
    private static final String DEFAULT_BUYER_DEST_COUNTY = "Montgomery";
    private static final String SYSPROP_BUYER_DEST_ZIP_CODE = "buyerDestZipCode";
    private static final String DEFAULT_BUYER_DEST_ZIP_CODE = "36104";
    private static final String SYSPROP_BUYER_DEST_COUNTRY = "buyerDestCountry";
    private static final String DEFAULT_BUYER_DEST_COUNTRY = "USA";
    private static final String SYSPROP_BUYER_IS_TAX_EXEMPT = "buyerIsTaxExempt";
    private static final String DEFAULT_BUYER_IS_TAX_EXEMPT;
    private static final String SYSPROP_BUYER_EXEMPT_REASON_CODE = "buyerExemptReasonCode";
    private static final String DEFAULT_BUYER_EXEMPT_REASON_CODE;
    private static final String SYSPROP_BUYER_EXEMPT_CERT_NO = "buyerExemptCertNo";
    private static final String DEFAULT_BUYER_EXEMPT_CERT_NO;
    private static final String SYSPROP_VENDOR_CLASS_CODE = "vendorClassCode";
    private static final String DEFAULT_VENDOR_CLASS_CODE;
    private static final String SYSPROP_VENDOR_COMPANY = "vendorCompany";
    private static final String DEFAULT_VENDOR_COMPANY = "vendID00";
    private static final String SYSPROP_VENDOR_AO_GEOCODE = "vendorAoGeocode";
    private static final String DEFAULT_VENDOR_AO_GEOCODE;
    private static final String SYSPROP_VENDOR_AO_STREET = "vendorAoStreet";
    private static final String DEFAULT_VENDOR_AO_STREET;
    private static final String SYSPROP_VENDOR_AO_CITY = "vendorAoCity";
    private static final String DEFAULT_VENDOR_AO_CITY;
    private static final String SYSPROP_VENDOR_AO_STATE = "vendorAoState";
    private static final String DEFAULT_VENDOR_AO_STATE;
    private static final String SYSPROP_VENDOR_AO_COUNTY = "vendorAoCounty";
    private static final String DEFAULT_VENDOR_AO_COUNTY;
    private static final String SYSPROP_VENDOR_AO_ZIP_CODE = "vendorAoZipCode";
    private static final String DEFAULT_VENDOR_AO_ZIP_CODE;
    private static final String SYSPROP_VENDOR_AO_COUNTRY = "vendorAoCountry";
    private static final String DEFAULT_VENDOR_AO_COUNTRY;
    private static final String SYSPROP_VENDOR_PO_GEOCODE = "vendorPoGeocode";
    private static final String DEFAULT_VENDOR_PO_GEOCODE;
    private static final String SYSPROP_VENDOR_PO_STREET = "vendorPoStreet";
    private static final String DEFAULT_VENDOR_PO_STREET;
    private static final String SYSPROP_VENDOR_PO_CITY = "vendorPoCity";
    private static final String DEFAULT_VENDOR_PO_CITY;
    private static final String SYSPROP_VENDOR_PO_STATE = "vendorPoState";
    private static final String DEFAULT_VENDOR_PO_STATE;
    private static final String SYSPROP_VENDOR_PO_COUNTY = "vendorPoCounty";
    private static final String DEFAULT_VENDOR_PO_COUNTY;
    private static final String SYSPROP_VENDOR_PO_ZIP_CODE = "vendorPoZipCode";
    private static final String DEFAULT_VENDOR_PO_ZIP_CODE;
    private static final String SYSPROP_VENDOR_PO_COUNTRY = "vendorPoCountry";
    private static final String DEFAULT_VENDOR_PO_COUNTRY;
    private static final String DEFAULT_CUSTOMER_DEST_COUNTRY = "USA";
    private static final String SYSPROP_ITEM_NUMBER = "itemNumber";
    private static final String DEFAULT_ITEM_NUMBER;
    private static final String SYSPROP_ITEM_PURCHASE = "itemPurchase";
    private static final String DEFAULT_ITEM_PURCHASE;
    private static final String SYSPROP_ITEM_PURCHASE_CLASS = "itemPurchaseClass";
    private static final String DEFAULT_ITEM_PURCHASE_CLASS;
    private static final String SYSPROP_ITEM_QUANTITY = "itemQuantity";
    private static final String DEFAULT_ITEM_QUANTITY = "100";
    private static final String SYSPROP_ITEM_EXTENDED_PRICE = "itemExtendedPrice";
    private static final String DEFAULT_ITEM_EXTENDED_PRICE = "1200";

    private PurchaseOrderTPPClient() {
    }

    public static void main(String[] p_args) {
        try {
            VendorPhysicalOrigin vendorPhysicalOriginReturn;
            VendorAdministrativeOrigin vendorAdministrativeOriginReturn;
            BuyerDestination buyerDestinationReturn;
            PurchaseOrderTPPClient.log("Starting purchaseOrderTPP client...");
            String busComponent = PurchaseOrderTPPClient.getProperty(SYSPROP_BUS_COMPONENT, DEFAULT_BUS_COMPONENT);
            String documentNr = PurchaseOrderTPPClient.getProperty(SYSPROP_DOCUMENT_NR, DEFAULT_DOCUMENT_NR);
            String documentDate = PurchaseOrderTPPClient.getProperty(SYSPROP_DOCUMENT_DATE, DEFAULT_DOCUMENT_DATE);
            String buyerCompany = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_COMPANY, DEFAULT_BUYER_COMPANY);
            String buyerDestGeocode = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_GEOCODE, DEFAULT_BUYER_DEST_GEOCODE);
            String buyerDestStreet = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_STREET, DEFAULT_BUYER_DEST_STREET);
            String buyerDestCity = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_CITY, "Montgomery");
            String buyerDestState = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_STATE, DEFAULT_BUYER_DEST_STATE);
            String buyerDestCounty = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_COUNTY, "Montgomery");
            String buyerDestZipCode = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_ZIP_CODE, DEFAULT_BUYER_DEST_ZIP_CODE);
            String buyerDestCountry = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_DEST_COUNTRY, "USA");
            String buyerIsTaxExemptString = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_IS_TAX_EXEMPT, DEFAULT_BUYER_IS_TAX_EXEMPT);
            boolean buyerIsTaxExempt = "true".equals(buyerIsTaxExemptString);
            String buyerExemptReasonCode = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_EXEMPT_REASON_CODE, DEFAULT_BUYER_EXEMPT_REASON_CODE);
            String buyerExemptCertNo = PurchaseOrderTPPClient.getProperty(SYSPROP_BUYER_EXEMPT_CERT_NO, DEFAULT_BUYER_EXEMPT_CERT_NO);
            String vendorCompany = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_COMPANY, DEFAULT_VENDOR_COMPANY);
            String vendorClassCode = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_CLASS_CODE, DEFAULT_VENDOR_CLASS_CODE);
            String vendorAoGeocode = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_GEOCODE, DEFAULT_VENDOR_AO_GEOCODE);
            String vendorAoStreet = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_STREET, DEFAULT_VENDOR_AO_STREET);
            String vendorAoCity = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_CITY, DEFAULT_VENDOR_AO_CITY);
            String vendorAoState = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_STATE, DEFAULT_VENDOR_AO_STATE);
            String vendorAoCounty = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_COUNTY, DEFAULT_VENDOR_AO_COUNTY);
            String vendorAoZipCode = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_ZIP_CODE, DEFAULT_VENDOR_AO_ZIP_CODE);
            String vendorAoCountry = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_AO_COUNTRY, DEFAULT_VENDOR_AO_COUNTRY);
            String vendorPoGeocode = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_GEOCODE, DEFAULT_VENDOR_PO_GEOCODE);
            String vendorPoStreet = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_STREET, DEFAULT_VENDOR_PO_STREET);
            String vendorPoCity = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_CITY, DEFAULT_VENDOR_PO_CITY);
            String vendorPoState = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_STATE, DEFAULT_VENDOR_PO_STATE);
            String vendorPoCounty = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_COUNTY, DEFAULT_VENDOR_PO_COUNTY);
            String vendorPoZipCode = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_ZIP_CODE, DEFAULT_VENDOR_PO_ZIP_CODE);
            String vendorPoCountry = PurchaseOrderTPPClient.getProperty(SYSPROP_VENDOR_PO_COUNTRY, DEFAULT_VENDOR_PO_COUNTRY);
            String itemNumberString = PurchaseOrderTPPClient.getProperty(SYSPROP_ITEM_NUMBER, DEFAULT_ITEM_NUMBER);
            int itemNumber = itemNumberString != null ? Integer.parseInt(itemNumberString) : -1;
            String itemPurchase = PurchaseOrderTPPClient.getProperty(SYSPROP_ITEM_PURCHASE, DEFAULT_ITEM_PURCHASE);
            String itemPurchaseClass = PurchaseOrderTPPClient.getProperty(SYSPROP_ITEM_PURCHASE_CLASS, DEFAULT_ITEM_PURCHASE_CLASS);
            String itemQuantityString = PurchaseOrderTPPClient.getProperty(SYSPROP_ITEM_QUANTITY, DEFAULT_ITEM_QUANTITY);
            double itemQuantity = itemQuantityString != null ? Double.parseDouble(itemQuantityString) : -1.0;
            String itemExtendedPriceString = PurchaseOrderTPPClient.getProperty(SYSPROP_ITEM_EXTENDED_PRICE, DEFAULT_ITEM_EXTENDED_PRICE);
            double itemExtendedPrice = itemExtendedPriceString != null ? Double.parseDouble(itemExtendedPriceString) : -1.0;
            PurchaseOrderTPPClient.log("");
            PurchaseOrderTPPClient.log("Connecting to bridge...");
            Manager1 taxProvider = new Manager1();
            taxProvider.initialize(busComponent);
            BuyerDestination buyerDestination = new BuyerDestination();
            Location buyerDestinationLocation = PurchaseOrderTPPClient.newLocation(buyerDestGeocode, buyerDestStreet, buyerDestCity, buyerDestZipCode, buyerDestCounty, buyerDestState, buyerDestCountry);
            if (buyerDestinationLocation != null) {
                buyerDestination.setLocation(buyerDestinationLocation);
            }
            VendorAdministrativeOrigin vendorAdministrativeOrigin = new VendorAdministrativeOrigin();
            Location vendorAdministrativeOriginLocation = PurchaseOrderTPPClient.newLocation(vendorAoGeocode, vendorAoStreet, vendorAoCity, vendorAoZipCode, vendorAoCounty, vendorAoState, vendorAoCountry);
            if (vendorAdministrativeOriginLocation != null) {
                vendorAdministrativeOrigin.setLocation(vendorAdministrativeOriginLocation);
            }
            VendorPhysicalOrigin vendorPhysicalOrigin = new VendorPhysicalOrigin();
            Location vendorPhysicalOriginLocation = PurchaseOrderTPPClient.newLocation(vendorPoGeocode, vendorPoStreet, vendorPoCity, vendorPoZipCode, vendorPoCounty, vendorPoState, vendorPoCountry);
            if (vendorPhysicalOriginLocation != null) {
                vendorPhysicalOrigin.setLocation(vendorPhysicalOriginLocation);
            }
            PurchaseOrderTPPRetObj1 returnObject = taxProvider.purchaseOrderTPP(documentNr, documentDate, buyerCompany, buyerDestination, buyerIsTaxExempt, buyerExemptReasonCode, buyerExemptCertNo, vendorCompany, vendorAdministrativeOrigin, vendorPhysicalOrigin, itemNumber, itemPurchase, itemPurchaseClass, itemQuantity, itemExtendedPrice);
            PurchaseOrderTPPClient.log("Response:");
            if (returnObject.hasDocumentNumber()) {
                String documentNrReturn = returnObject.getDocumentNumber();
                PurchaseOrderTPPClient.log("\tDocumentNr: " + documentNrReturn);
            }
            if (returnObject.hasDocumentDate()) {
                String documentDateReturn = returnObject.getDocumentDate();
                PurchaseOrderTPPClient.log("\tDocumentDate: " + documentDateReturn);
            }
            if (returnObject.hasBuyerDestination() && (buyerDestinationReturn = returnObject.getBuyerDestination()).hasLocation()) {
                PurchaseOrderTPPClient.logLocation(buyerDestinationReturn.getLocation(), "\tBuyerDestination");
            }
            if (returnObject.hasVendorAdministrativeOrigin() && (vendorAdministrativeOriginReturn = returnObject.getVendorAdministrativeOrigin()).hasLocation()) {
                PurchaseOrderTPPClient.logLocation(vendorAdministrativeOriginReturn.getLocation(), "\tVendorAdministrativeOrigin");
            }
            if (returnObject.hasVendorPhysicalOrigin() && (vendorPhysicalOriginReturn = returnObject.getVendorPhysicalOrigin()).hasLocation()) {
                PurchaseOrderTPPClient.logLocation(vendorPhysicalOriginReturn.getLocation(), "\tVendorPhysicalOrigin");
            }
            if (returnObject.hasItemNumber()) {
                int itemNumberReturn = returnObject.getItemNumber();
                PurchaseOrderTPPClient.log("\tItemNumber: " + itemNumberReturn);
            }
            if (returnObject.hasItemPurchase()) {
                String itemPurchaseReturn = returnObject.getItemPurchase();
                PurchaseOrderTPPClient.log("\tItemPurchase: " + itemPurchaseReturn);
            }
            if (returnObject.hasItemPurchaseClass()) {
                String itemPurchaseClassReturn = returnObject.getItemPurchaseClass();
                PurchaseOrderTPPClient.log("\tItemPurchaseClass: " + itemPurchaseClassReturn);
            }
            if (returnObject.hasItemQuantity()) {
                double itemQuantityReturn = returnObject.getItemQuantity();
                PurchaseOrderTPPClient.log("\tItemQuantity: " + itemQuantityReturn);
            }
            if (returnObject.hasItemExtendedPrice()) {
                double itemExtendedPriceReturn = returnObject.getItemExtendedPrice();
                PurchaseOrderTPPClient.log("\tItemExtendedPrice: " + itemExtendedPriceReturn);
            }
            if (returnObject.hasTaxArray()) {
                TaxArray taxArrayReturn = returnObject.getTaxArray();
                int nrTaxes = taxArrayReturn.sizeTax();
                for (int i = 0; i < nrTaxes; ++i) {
                    Tax tax = taxArrayReturn.getTaxAt(i);
                    PurchaseOrderTPPClient.log("\tTax[" + i + "]:");
                    if (tax.hasCalculatedTax()) {
                        double calculatedTax = tax.getCalculatedTax();
                        PurchaseOrderTPPClient.log("\t\tCalculatedTax: " + calculatedTax);
                    }
                    if (tax.hasEffectiveRate()) {
                        double effectiveRate = tax.getEffectiveRate();
                        PurchaseOrderTPPClient.log("\t\tEffectiveRate: " + effectiveRate);
                    }
                    if (tax.hasJurisdiction()) {
                        Jurisdiction jurisdiction = tax.getJurisdiction();
                        String jurisdictionName = "UNDEFINED";
                        String jurisdictionLevel = "UNDEFINED";
                        if (jurisdiction.hasJurisdictionName()) {
                            jurisdictionName = jurisdiction.getJurisdictionName();
                        }
                        if (jurisdiction.hasJurisdictionLevel()) {
                            jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                        }
                        PurchaseOrderTPPClient.log("\t\tJurisdiction: " + jurisdictionName + " (" + jurisdictionLevel + ')');
                    }
                    if (!tax.hasTaxResult()) continue;
                    String taxResult = tax.getTaxResult();
                    PurchaseOrderTPPClient.log("\t\tTaxResult: " + taxResult);
                }
            }
            if (returnObject.hasItemTotalTax()) {
                double itemTotalTaxReturn = returnObject.getItemTotalTax();
                PurchaseOrderTPPClient.log("\tItemTotalTax: " + itemTotalTaxReturn);
            }
            PurchaseOrderTPPClient.log("");
            taxProvider.close();
        }
        catch (Exception ex) {
            PurchaseOrderTPPClient.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static void logLocation(Location p_location, String p_prefix) {
        if (p_location.hasGeocode()) {
            PurchaseOrderTPPClient.log(p_prefix + "Geocode: " + p_location.getGeocode());
        }
        if (p_location.hasStreet()) {
            PurchaseOrderTPPClient.log(p_prefix + "Street: " + p_location.getStreet());
        }
        if (p_location.hasCity()) {
            PurchaseOrderTPPClient.log(p_prefix + "City: " + p_location.getCity());
        }
        if (p_location.hasZipCode()) {
            PurchaseOrderTPPClient.log(p_prefix + "ZipCode: " + p_location.getZipCode());
        }
        if (p_location.hasCounty()) {
            PurchaseOrderTPPClient.log(p_prefix + "County: " + p_location.getCounty());
        }
        if (p_location.hasState()) {
            PurchaseOrderTPPClient.log(p_prefix + "State: " + p_location.getState());
        }
        if (p_location.hasCountry()) {
            PurchaseOrderTPPClient.log(p_prefix + "Country: " + p_location.getCountry());
        }
    }

    private static Location newLocation(String p_geocode, String p_street, String p_city, String p_zipCode, String p_county, String p_state, String p_country) {
        if (p_geocode == null && p_street == null && p_city == null && p_zipCode == null && p_county == null && p_state == null && p_country == null) {
            return null;
        }
        Location location = new Location();
        if (p_geocode != null) {
            int geocode = Integer.parseInt(p_geocode);
            location.setGeocode(geocode);
        }
        if (p_street != null) {
            location.setStreet(p_street);
        }
        if (p_city != null) {
            location.setCity(p_city);
        }
        if (p_zipCode != null) {
            location.setZipCode(p_zipCode);
        }
        if (p_county != null) {
            location.setCounty(p_county);
        }
        if (p_state != null) {
            location.setState(p_state);
        }
        if (p_country != null) {
            location.setCountry(p_country);
        }
        return location;
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        String displayValue = '\"' + value + '\"';
        if (value == null) {
            displayValue = "NOT SET";
        }
        PurchaseOrderTPPClient.log("Using argument -D" + p_key + '=' + displayValue);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }

    static {
        DEFAULT_DOCUMENT_NR = EMPTY_STRING = new String().intern();
        DEFAULT_BUYER_DEST_GEOCODE = null;
        DEFAULT_BUYER_DEST_STREET = null;
        DEFAULT_BUYER_IS_TAX_EXEMPT = null;
        DEFAULT_BUYER_EXEMPT_REASON_CODE = EMPTY_STRING;
        DEFAULT_BUYER_EXEMPT_CERT_NO = null;
        DEFAULT_VENDOR_CLASS_CODE = EMPTY_STRING;
        DEFAULT_VENDOR_AO_GEOCODE = null;
        DEFAULT_VENDOR_AO_STREET = null;
        DEFAULT_VENDOR_AO_CITY = null;
        DEFAULT_VENDOR_AO_STATE = null;
        DEFAULT_VENDOR_AO_COUNTY = null;
        DEFAULT_VENDOR_AO_ZIP_CODE = null;
        DEFAULT_VENDOR_AO_COUNTRY = null;
        DEFAULT_VENDOR_PO_GEOCODE = null;
        DEFAULT_VENDOR_PO_STREET = null;
        DEFAULT_VENDOR_PO_CITY = null;
        DEFAULT_VENDOR_PO_STATE = null;
        DEFAULT_VENDOR_PO_COUNTY = null;
        DEFAULT_VENDOR_PO_ZIP_CODE = null;
        DEFAULT_VENDOR_PO_COUNTRY = null;
        DEFAULT_ITEM_NUMBER = null;
        DEFAULT_ITEM_PURCHASE = EMPTY_STRING;
        DEFAULT_ITEM_PURCHASE_CLASS = EMPTY_STRING;
    }
}

