/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TraceOutputStream
extends FilterOutputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        super(outputStream);
        this.traceOut = outputStream2;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setQuote(boolean bl) {
        this.quote = bl;
    }

    public void write(int n) throws IOException {
        if (this.trace) {
            if (this.quote) {
                this.writeByte(n);
            } else {
                this.traceOut.write(n);
            }
        }
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.trace) {
            if (this.quote) {
                for (int i = 0; i < n2; ++i) {
                    this.writeByte(byArray[n + i]);
                }
            } else {
                this.traceOut.write(byArray, n, n2);
            }
        }
        this.out.write(byArray, n, n2);
    }

    private final void writeByte(int n) throws IOException {
        if ((n &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            n &= 0x7F;
        }
        if (n == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (n == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (n == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (n < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + n);
        } else {
            this.traceOut.write(n);
        }
    }
}

