/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1.vertex1;

import com.eibus.util.DoubleHolder;
import com.eibus.util.IntHolder;
import com.eibus.util.StringHolder;
import com.ssa.ta.taxprovider1.BuyerDestination;
import com.ssa.ta.taxprovider1.CustomerDestination;
import com.ssa.ta.taxprovider1.DatabaseVersion;
import com.ssa.ta.taxprovider1.DatabaseVersions;
import com.ssa.ta.taxprovider1.Geocode;
import com.ssa.ta.taxprovider1.GeocodeArray;
import com.ssa.ta.taxprovider1.ITaxProvider;
import com.ssa.ta.taxprovider1.JavaVirtualMachineVersion;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.LibraryVersion;
import com.ssa.ta.taxprovider1.LibraryVersions;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.OperatingSystemVersion;
import com.ssa.ta.taxprovider1.ProductVersion;
import com.ssa.ta.taxprovider1.ProductVersions;
import com.ssa.ta.taxprovider1.QuotationSaleCustomerDestination;
import com.ssa.ta.taxprovider1.QuotationSaleSellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.QuotationSaleSellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.SellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.SellerDestination;
import com.ssa.ta.taxprovider1.SellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.TaxProviderException;
import com.ssa.ta.taxprovider1.VendorAdministrativeOrigin;
import com.ssa.ta.taxprovider1.VendorPhysicalOrigin;
import com.ssa.ta.taxprovider1.VersionResponse;
import com.ssa.ta.vertex1.ws.bindings.AmountType;
import com.ssa.ta.vertex1.ws.bindings.BuyerInputType;
import com.ssa.ta.vertex1.ws.bindings.BuyerOutputType;
import com.ssa.ta.vertex1.ws.bindings.CompanyType;
import com.ssa.ta.vertex1.ws.bindings.CustomerCode;
import com.ssa.ta.vertex1.ws.bindings.CustomerInputType;
import com.ssa.ta.vertex1.ws.bindings.CustomerOutputType;
import com.ssa.ta.vertex1.ws.bindings.ExemptionCertificate;
import com.ssa.ta.vertex1.ws.bindings.InvoiceRequestType;
import com.ssa.ta.vertex1.ws.bindings.InvoiceResponseType;
import com.ssa.ta.vertex1.ws.bindings.JurisdictionLevelCodeType;
import com.ssa.ta.vertex1.ws.bindings.JurisdictionType;
import com.ssa.ta.vertex1.ws.bindings.LineItemISIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemISOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemPOTIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemPOTOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemQSIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemQSOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemTOASIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemTOASOType;
import com.ssa.ta.vertex1.ws.bindings.LocationType;
import com.ssa.ta.vertex1.ws.bindings.LookupResultType;
import com.ssa.ta.vertex1.ws.bindings.ObjectFactory;
import com.ssa.ta.vertex1.ws.bindings.ProcurementTransactionType;
import com.ssa.ta.vertex1.ws.bindings.Product;
import com.ssa.ta.vertex1.ws.bindings.Purchase;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderRequestType;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderResponseType;
import com.ssa.ta.vertex1.ws.bindings.Quantity;
import com.ssa.ta.vertex1.ws.bindings.QuotationRequestType;
import com.ssa.ta.vertex1.ws.bindings.QuotationResponseType;
import com.ssa.ta.vertex1.ws.bindings.SaleTransactionType;
import com.ssa.ta.vertex1.ws.bindings.SellerInputType;
import com.ssa.ta.vertex1.ws.bindings.SellerOutputType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaRequestType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentRequestType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSellerIType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSellerOType;
import com.ssa.ta.vertex1.ws.bindings.TaxResultCodeType;
import com.ssa.ta.vertex1.ws.bindings.TaxesType;
import com.ssa.ta.vertex1.ws.bindings.VendorInputType;
import com.ssa.ta.vertex1.ws.bindings.VendorOutputType;
import com.ssa.ta.vertex1.ws.bindings.VersionRequestType;
import com.ssa.ta.vertex1.ws.bindings.VersionResponseType;
import com.ssa.taimpl.taxprovider1.vertex1.Util;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class TaxProvider
implements ITaxProvider {
    private static final Util UTIL = Util.getInstance();
    private static final Logger s_logger = UTIL.getLogger();
    private static final String C_NAME = TaxProvider.class.getName();
    private static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final String EMPTY_STRING = new String().intern();
    private static final SimpleTimeZone TIMEZONE_UTC = new SimpleTimeZone(0, "UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public void getGeocode(GeocodeArray p_geocodes, String p_city, String p_state, String p_zipCode, String p_country) {
        String M_NAME = "getGeocode";
        s_logger.entering(C_NAME, "getGeocode");
        TaxAreaRequestType request = null;
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        request = objectFactory.createTaxAreaRequestType();
        TaxAreaType taxArea = objectFactory.createTaxAreaType();
        taxArea.setCity(p_city);
        taxArea.setMainDivision(p_state);
        taxArea.setPostalCode(p_zipCode);
        taxArea.setCountry(p_country);
        request.setTaxArea(taxArea);
        TaxAreaResponseType response = (TaxAreaResponseType)UTIL.doLookupTaxAreasRequest(request, TaxAreaResponseType.class);
        List<TaxAreaResponseType.TaxArea> taxAreas = response.getTaxArea();
        int nrTaxAreas = taxAreas.size();
        if (nrTaxAreas == 0) {
            throw UTIL.newSevereRuntimeException("No tax areas received from Vertex");
        }
        for (int i = 0; i < nrTaxAreas; ++i) {
            String country;
            String state;
            String county;
            String city;
            String zipCode;
            Geocode geocodeStruct = new Geocode();
            Location location = new Location();
            TaxAreaResponseType.TaxArea responseTaxArea = taxAreas.get(i);
            BigInteger bigInt = responseTaxArea.getTaxAreaId();
            if (bigInt.compareTo(INTEGER_MIN_VALUE) < 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too low. Cannot fit in a Java int");
            }
            if (bigInt.compareTo(INTEGER_MAX_VALUE) > 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too big. Cannot fit in a Java int");
            }
            int geocode = bigInt.intValue();
            location.setGeocode(geocode);
            String street = responseTaxArea.getStreetAddress();
            if (street != null) {
                location.setStreet(street);
            }
            if ((zipCode = responseTaxArea.getPostalCode()) != null) {
                location.setZipCode(zipCode);
            }
            if ((city = responseTaxArea.getCity()) != null) {
                location.setCity(city);
            }
            if ((county = responseTaxArea.getSubDivision()) != null) {
                location.setCounty(county);
            }
            if ((state = responseTaxArea.getMainDivision()) != null) {
                location.setState(state);
            }
            if ((country = responseTaxArea.getCountry()) != null) {
                location.setCountry(country);
            }
            geocodeStruct.setLocation(location);
            for (JurisdictionType jurisdiction : responseTaxArea.getJurisdiction()) {
                Jurisdiction jurisdictionObject = new Jurisdiction();
                String jurisdictionName = jurisdiction.getValue();
                jurisdictionObject.setJurisdictionName(jurisdictionName);
                JurisdictionLevelCodeType jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                String jurisdictionLevelString = jurisdictionLevel.name();
                jurisdictionObject.setJurisdictionLevel(jurisdictionLevelString);
                geocodeStruct.addJurisdiction(jurisdictionObject);
            }
            p_geocodes.addGeocode(geocodeStruct);
            for (TaxAreaResponseType.TaxArea.Status status : responseTaxArea.getStatus()) {
                LookupResultType lookupResult = status.getLookupResult();
                if ("BAD_REGION_FIELDS".equals((Object)lookupResult)) {
                    throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'BAD_REGION_FIELDS' (" + (Object)((Object)lookupResult) + ')');
                }
                if ("BAD_STREET_INFORMATION".equals((Object)lookupResult)) {
                    throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'BAD_STREET_INFORMATION' (" + (Object)((Object)lookupResult) + ')');
                }
                if (!"IGNORED_REGION_FIELDS".equals((Object)lookupResult)) continue;
                throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'IGNORED_REGION_FIELDS' (" + (Object)((Object)lookupResult) + ')');
            }
        }
        s_logger.exiting(C_NAME, "getGeocode");
    }

    public void calculateTaxForInvoicing40(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, String p_customerCode, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, StringHolder p_customerExemptCertNr, String p_customerCompany, CustomerDestination p_customerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List<LineItemISOType> rLineItems;
        int nrLineItems;
        Location customerDestinationLocation;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "calculateTaxForInvoicing40";
        s_logger.entering(C_NAME, "calculateTaxForInvoicing40");
        InvoiceRequestType request = null;
        try {
            String productClass;
            Location customerDestinationLocation2;
            Location sellerAdministrativeOriginLocation;
            Location sellerPhysicalOriginLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createInvoiceRequestType();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            request.setTransactionType(SaleTransactionType.SALE);
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            TimeZone timeZone = documentDate.getTimeZone();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xml_documentDate = dataFactory.newXMLGregorianCalendar(gregorianCalendar);
            request.setDocumentDate(xml_documentDate);
            SellerInputType seller = objectFactory.createSellerInputType();
            CompanyType sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((sellerPhysicalOriginLocation2 = p_sellerPhysicalOrigin.getLocation()) != null) {
                LocationType sellerPhysicalOriginLocationType = objectFactory.createLocationType();
                if (this.locationToLocationType(sellerPhysicalOriginLocation2, sellerPhysicalOriginLocationType)) {
                    seller.setPhysicalOrigin(sellerPhysicalOriginLocationType);
                } else {
                    sellerPhysicalOriginLocation2 = null;
                }
            }
            if ((sellerAdministrativeOriginLocation = p_sellerAdministrativeOrigin.getLocation()) != null) {
                LocationType sellerAdministrativeOriginLocationType = objectFactory.createLocationType();
                if (this.locationToLocationType(sellerAdministrativeOriginLocation, sellerAdministrativeOriginLocationType)) {
                    seller.setAdministrativeOrigin(sellerAdministrativeOriginLocationType);
                } else {
                    sellerAdministrativeOriginLocation = null;
                }
            }
            if (sellerCompany != null || sellerPhysicalOriginLocation2 != null || sellerAdministrativeOriginLocation != null) {
                request.setSeller(seller);
            }
            CustomerInputType customer = objectFactory.createCustomerInputType();
            CustomerCode customerCode = objectFactory.createCustomerCode();
            if (customerCode != null) {
                if (this.isValid(p_customerCode)) {
                    customerCode.setValue(p_customerCode);
                }
                if (this.isValid(p_customerClassCode)) {
                    customerCode.setClassCode(p_customerClassCode);
                }
                customer.setCustomerCode(customerCode);
            }
            if (p_customerIsTaxExempt) {
                customer.setIsTaxExempt(p_customerIsTaxExempt);
            }
            if (this.isValid(p_customerExemptReasonCode)) {
                customer.setExemptionReasonCode(p_customerExemptReasonCode);
            }
            if ((customerDestinationLocation2 = p_customerDestination.getLocation()) != null) {
                LocationType destinationType = objectFactory.createLocationType();
                if (this.locationToLocationType(customerDestinationLocation2, destinationType)) {
                    customer.setDestination(destinationType);
                } else {
                    customerDestinationLocation2 = null;
                }
            }
            if (this.isValid(p_customerClassCode) || p_customerIsTaxExempt || this.isValid(p_customerExemptReasonCode) || customerDestinationLocation2 != null) {
                request.setCustomer(customer);
            }
            List<LineItemISIType> inputLineItems = request.getLineItem();
            LineItemISIType inputLineItem = objectFactory.createLineItemISIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(xml_documentDate);
            Product product = objectFactory.createProduct();
            String productString = p_itemProduct.toString();
            if (this.isValid(productString)) {
                product.setValue(productString);
            }
            if (this.isValid(productClass = p_itemProductClass.toString())) {
                product.setProductClass(productClass);
            }
            if (this.isValid(productString) || this.isValid(productClass)) {
                inputLineItem.setProduct(product);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue != 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue != 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        catch (DatatypeConfigurationException ex_k) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_k);
        }
        InvoiceResponseType response = (InvoiceResponseType)UTIL.doCalculateTaxRequest(request, InvoiceResponseType.class);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        XMLGregorianCalendar rDocumentDateObject = response.getDocumentDate();
        String rDocumentDateString = rDocumentDateObject.toString();
        p_documentDate.setValue(rDocumentDateString);
        SellerOutputType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_sellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        CustomerOutputType rCustomer = response.getCustomer();
        LocationType rDestinationLocation = null;
        if (rCustomer != null) {
            rDestinationLocation = rCustomer.getDestination();
        }
        if ((customerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_customerDestination.setLocation(customerDestinationLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemISOType rLineItem = rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        Product rProduct = rLineItem.getProduct();
        String rProductValue = null;
        String rProductClass = null;
        if (rProduct != null) {
            rProductValue = rProduct.getValue();
            rProductClass = rProduct.getProductClass();
        }
        this.setValue(p_itemProduct, rProductValue);
        this.setValue(p_itemProductClass, rProductClass);
        Quantity rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List<TaxesType> rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = rTaxes.get(i);
            Tax tax = new Tax();
            TaxResultCodeType rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult.value());
            TaxesType.Jurisdiction rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            JurisdictionLevelCodeType rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel.value());
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "calculateTaxForInvoicing40");
    }

    public void quoteTaxForSale40(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, QuotationSaleSellerPhysicalOrigin p_quotationSaleSellerPhysicalOrigin, QuotationSaleSellerAdministrativeOrigin p_quotationSaleSellerAdministrativeOrigin, String p_customerCode, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, String p_customerExemptCertNr, String p_customerCompany, QuotationSaleCustomerDestination p_quotationSaleCustomerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List<LineItemQSOType> rLineItems;
        int nrLineItems;
        Location quotationSaleCustomerDestinationLocation;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "quoteTaxForSale40";
        s_logger.entering(C_NAME, "quoteTaxForSale40");
        QuotationRequestType request = null;
        try {
            String productClass;
            Location quotationSaleSellerAdministrativeOriginLocation;
            Location quotationSaleSellerPhysicalOriginLocation;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createQuotationRequestType();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            TimeZone timeZone = documentDate.getTimeZone();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xml_documentDate = dataFactory.newXMLGregorianCalendar(gregorianCalendar);
            request.setDocumentDate(xml_documentDate);
            request.setTransactionType(SaleTransactionType.SALE);
            SellerInputType seller = objectFactory.createSellerInputType();
            CompanyType sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((quotationSaleSellerPhysicalOriginLocation = p_quotationSaleSellerPhysicalOrigin.getLocation()) != null) {
                LocationType physicalOriginType = objectFactory.createLocationType();
                if (this.locationToLocationType(quotationSaleSellerPhysicalOriginLocation, physicalOriginType)) {
                    seller.setPhysicalOrigin(physicalOriginType);
                } else {
                    quotationSaleSellerPhysicalOriginLocation = null;
                }
            }
            if ((quotationSaleSellerAdministrativeOriginLocation = p_quotationSaleSellerAdministrativeOrigin.getLocation()) != null) {
                LocationType administrativeOriginType = objectFactory.createLocationType();
                if (this.locationToLocationType(quotationSaleSellerAdministrativeOriginLocation, administrativeOriginType)) {
                    seller.setAdministrativeOrigin(administrativeOriginType);
                } else {
                    quotationSaleSellerAdministrativeOriginLocation = null;
                }
            }
            if (sellerCompany != null || quotationSaleSellerPhysicalOriginLocation != null || quotationSaleSellerAdministrativeOriginLocation != null) {
                request.setSeller(seller);
            }
            CustomerInputType customer = objectFactory.createCustomerInputType();
            CustomerCode customerCode = objectFactory.createCustomerCode();
            if (customerCode != null) {
                if (this.isValid(p_customerCode)) {
                    customerCode.setValue(p_customerCode);
                }
                if (this.isValid(p_customerClassCode)) {
                    customerCode.setClassCode(p_customerClassCode);
                }
                customer.setCustomerCode(customerCode);
            }
            if (p_customerIsTaxExempt) {
                customer.setIsTaxExempt(p_customerIsTaxExempt);
            }
            if (this.isValid(p_customerExemptReasonCode)) {
                customer.setExemptionReasonCode(p_customerExemptReasonCode);
            }
            CompanyType customerCompany = this.newCompany(p_customerCompany);
            Location quotationSaleCustomerDestinationLocation2 = p_quotationSaleCustomerDestination.getLocation();
            if (quotationSaleCustomerDestinationLocation2 != null) {
                LocationType destination = objectFactory.createLocationType();
                if (this.locationToLocationType(quotationSaleCustomerDestinationLocation2, destination)) {
                    customer.setDestination(destination);
                } else {
                    quotationSaleCustomerDestinationLocation2 = null;
                }
            }
            if (this.isValid(p_customerClassCode) || p_customerIsTaxExempt || this.isValid(p_customerExemptReasonCode) || customerCompany != null || quotationSaleCustomerDestinationLocation2 != null) {
                request.setCustomer(customer);
            }
            List<LineItemQSIType> inputLineItems = request.getLineItem();
            LineItemQSIType inputLineItem = objectFactory.createLineItemQSIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(xml_documentDate);
            Product product = objectFactory.createProduct();
            String productString = p_itemProduct.toString();
            if (this.isValid(productString)) {
                product.setValue(productString);
            }
            if (this.isValid(productClass = p_itemProductClass.toString())) {
                product.setProductClass(productClass);
            }
            if (this.isValid(productString) || this.isValid(productClass)) {
                inputLineItem.setProduct(product);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue != 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue != 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        catch (DatatypeConfigurationException ex_k) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_k);
        }
        QuotationResponseType response = (QuotationResponseType)UTIL.doQuoteForSaleRequest(request, QuotationResponseType.class);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        XMLGregorianCalendar rDocumentDateObject = response.getDocumentDate();
        if (rDocumentDateObject != null) {
            String rDocumentDateString = rDocumentDateObject.toString();
            p_documentDate.setValue(rDocumentDateString);
        }
        SellerOutputType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_quotationSaleSellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_quotationSaleSellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        CustomerOutputType rCustomer = response.getCustomer();
        LocationType rDestinationLocation = null;
        if (rCustomer != null) {
            rDestinationLocation = rCustomer.getDestination();
        }
        if ((quotationSaleCustomerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_quotationSaleCustomerDestination.setLocation(quotationSaleCustomerDestinationLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemQSOType rLineItem = rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        Product rProduct = rLineItem.getProduct();
        String rProductValue = null;
        String rProductClass = null;
        if (rProduct != null) {
            rProductValue = rProduct.getValue();
            rProductClass = rProduct.getProductClass();
        }
        this.setValue(p_itemProduct, rProductValue);
        this.setValue(p_itemProductClass, rProductClass);
        Quantity rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List<TaxesType> rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = rTaxes.get(i);
            Tax tax = new Tax();
            TaxResultCodeType rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult.value());
            TaxesType.Jurisdiction rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            JurisdictionLevelCodeType rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel.value());
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "quoteTaxForSale40");
    }

    public void purchaseOrderTPP(StringHolder p_documentNr, StringHolder p_documentDate, String p_buyerCompany, BuyerDestination p_buyerDestination, boolean p_buyerIsTaxExempt, String p_buyerExemptReasonCode, String p_buyerExemptCertNr, String p_vendorCompany, VendorAdministrativeOrigin p_vendorAdministrativeOrigin, VendorPhysicalOrigin p_vendorPhysicalOrigin, IntHolder p_itemNumber, StringHolder p_itemPurchase, StringHolder p_itemPurchaseClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List<LineItemPOTOType> rLineItems;
        int nrLineItems;
        Location vendorAdministrativeLocation;
        Location vendorPhysicalOriginLocation;
        Location buyerDestinationLocation;
        String M_NAME = "purchaseOrderTPP";
        s_logger.entering(C_NAME, "purchaseOrderTPP");
        PurchaseOrderRequestType request = null;
        try {
            String purchaseClass;
            Location vendorPhysicalOriginLocation2;
            ExemptionCertificate exemptCertNr;
            Location buyerDestinationLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createPurchaseOrderRequestType();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            TimeZone timeZone = documentDate.getTimeZone();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xml_documentDate = dataFactory.newXMLGregorianCalendar(gregorianCalendar);
            request.setDocumentDate(xml_documentDate);
            request.setTransactionType(ProcurementTransactionType.PURCHASE);
            BuyerInputType buyer = objectFactory.createBuyerInputType();
            CompanyType buyerCompany = this.newCompany(p_buyerCompany);
            if (buyerCompany != null) {
                buyer.setCompany(buyerCompany);
            }
            if ((buyerDestinationLocation2 = p_buyerDestination.getLocation()) != null) {
                LocationType destination = objectFactory.createLocationType();
                if (this.locationToLocationType(buyerDestinationLocation2, destination)) {
                    buyer.setDestination(destination);
                } else {
                    buyerDestinationLocation2 = null;
                }
            }
            if ((p_buyerIsTaxExempt || this.isValid(p_buyerExemptReasonCode)) && (exemptCertNr = objectFactory.createExemptionCertificate()) != null) {
                exemptCertNr.setExemptionCertificateNumber(p_buyerExemptCertNr);
                buyer.setExemptionCertificate(exemptCertNr);
            }
            VendorInputType vendor = objectFactory.createVendorInputType();
            Location vendorAdministrativeOriginLocation = p_vendorAdministrativeOrigin.getLocation();
            if (vendorAdministrativeOriginLocation != null) {
                LocationType administrativeOrigin = objectFactory.createLocationType();
                if (this.locationToLocationType(vendorAdministrativeOriginLocation, administrativeOrigin)) {
                    vendor.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    vendorAdministrativeOriginLocation = null;
                }
            }
            if ((vendorPhysicalOriginLocation2 = p_vendorPhysicalOrigin.getLocation()) != null) {
                LocationType physicalOrigin = objectFactory.createLocationType();
                if (this.locationToLocationType(vendorPhysicalOriginLocation2, physicalOrigin)) {
                    vendor.setPhysicalOrigin(physicalOrigin);
                } else {
                    vendorPhysicalOriginLocation2 = null;
                }
            }
            if (buyerDestinationLocation2 != null) {
                request.setBuyer(buyer);
            }
            if (vendorPhysicalOriginLocation2 != null || vendorAdministrativeOriginLocation != null) {
                request.setVendor(vendor);
            }
            List<LineItemPOTIType> inputLineItems = request.getLineItem();
            LineItemPOTIType inputLineItem = objectFactory.createLineItemPOTIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(xml_documentDate);
            Purchase purchase = objectFactory.createPurchase();
            String purchaseString = p_itemPurchase.toString();
            if (this.isValid(purchaseString)) {
                purchase.setValue(purchaseString);
            }
            if (this.isValid(purchaseClass = p_itemPurchaseClass.toString())) {
                purchase.setPurchaseClass(purchaseClass);
            }
            if (this.isValid(purchaseString) || this.isValid(purchaseClass)) {
                inputLineItem.setPurchase(purchase);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue != 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue != 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        catch (DatatypeConfigurationException ex_k) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_k);
        }
        PurchaseOrderResponseType response = (PurchaseOrderResponseType)UTIL.doPurchaseOrderTPPRequest(request, PurchaseOrderResponseType.class);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        XMLGregorianCalendar rDocumentDateObject = response.getDocumentDate();
        if (rDocumentDateObject != null) {
            String rDocumentDateString = rDocumentDateObject.toString();
            p_documentDate.setValue(rDocumentDateString);
        }
        BuyerOutputType rBuyer = response.getBuyer();
        LocationType rDestinationLocation = null;
        if (rBuyer != null) {
            rDestinationLocation = rBuyer.getDestination();
        }
        if ((buyerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_buyerDestination.setLocation(buyerDestinationLocation);
        }
        VendorOutputType rVendor = response.getVendor();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rVendor != null) {
            rPhysicalOriginLocation = rVendor.getPhysicalOrigin();
            rAdministrativeOrigin = rVendor.getAdministrativeOrigin();
        }
        if ((vendorPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_vendorPhysicalOrigin.setLocation(vendorPhysicalOriginLocation);
        }
        if ((vendorAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_vendorAdministrativeOrigin.setLocation(vendorAdministrativeLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemPOTOType rLineItem = rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        Purchase rPurchase = rLineItem.getPurchase();
        String rPurchaseValue = null;
        String rPurchaseClass = null;
        if (rPurchase != null) {
            rPurchaseValue = rPurchase.getValue();
            rPurchaseClass = rPurchase.getPurchaseClass();
        }
        this.setValue(p_itemPurchase, rPurchaseValue);
        this.setValue(p_itemPurchaseClass, rPurchaseClass);
        Quantity rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List<TaxesType> rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = rTaxes.get(i);
            Tax tax = new Tax();
            TaxResultCodeType rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult.value());
            TaxesType.Jurisdiction rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            JurisdictionLevelCodeType rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel.value());
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "purchaseOrderTPP");
    }

    public void taxOnlyAdjustmentSale(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, SellerDestination p_sellerDestination, double p_inputTotalTax, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        Location sellerDestinationLocation;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "taxOnlyAdjustmentSale";
        s_logger.entering(C_NAME, "taxOnlyAdjustmentSale");
        TaxOnlyAdjustmentRequestType request = null;
        try {
            Location sellerDestination;
            Location sellerAdministrativeOriginLocation;
            Location sellerPhysicalOriginLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createTaxOnlyAdjustmentRequestType();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            TimeZone timeZone = documentDate.getTimeZone();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xml_documentDate = dataFactory.newXMLGregorianCalendar(gregorianCalendar);
            request.setDocumentDate(xml_documentDate);
            request.setTransactionType(SaleTransactionType.SALE);
            TaxOnlyAdjustmentSellerIType seller = objectFactory.createTaxOnlyAdjustmentSellerIType();
            CompanyType sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((sellerPhysicalOriginLocation2 = p_sellerPhysicalOrigin.getLocation()) != null) {
                LocationType physicalOrigin = objectFactory.createLocationType();
                if (this.locationToLocationType(sellerPhysicalOriginLocation2, physicalOrigin)) {
                    seller.setPhysicalOrigin(physicalOrigin);
                } else {
                    sellerPhysicalOriginLocation2 = null;
                }
            }
            if ((sellerAdministrativeOriginLocation = p_sellerAdministrativeOrigin.getLocation()) != null) {
                LocationType administrativeOrigin = objectFactory.createLocationType();
                if (this.locationToLocationType(sellerAdministrativeOriginLocation, administrativeOrigin)) {
                    seller.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    sellerAdministrativeOriginLocation = null;
                }
            }
            if ((sellerDestination = p_sellerDestination.getLocation()) != null) {
                LocationType destination = objectFactory.createLocationType();
                if (this.locationToLocationType(sellerDestination, destination)) {
                    seller.setDestination(destination);
                } else {
                    sellerDestination = null;
                }
            }
            if (sellerPhysicalOriginLocation2 != null || sellerAdministrativeOriginLocation != null || sellerDestination != null) {
                request.setSeller(seller);
            }
            LineItemTOASIType inputLineItem = objectFactory.createLineItemTOASIType();
            inputLineItem.setTaxDate(xml_documentDate);
            AmountType inputTotalTax = objectFactory.createAmountType();
            inputTotalTax.setValue(p_inputTotalTax);
            if (inputTotalTax != null) {
                inputLineItem.setInputTotalTax(inputTotalTax);
            }
            request.setLineItem(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        catch (DatatypeConfigurationException ex_k) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_k);
        }
        TaxOnlyAdjustmentResponseType response = (TaxOnlyAdjustmentResponseType)UTIL.doTaxOnlyAdjustmentRequest(request, TaxOnlyAdjustmentResponseType.class);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        XMLGregorianCalendar rDocumentDateObject = response.getDocumentDate();
        String rDocumentDateString = rDocumentDateObject.toString();
        p_documentDate.setValue(rDocumentDateString);
        TaxOnlyAdjustmentSellerOType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        LocationType rDestinationLocation = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_sellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        if ((sellerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_sellerDestination.setLocation(sellerDestinationLocation);
        }
        LineItemTOASOType rLineItem = response.getLineItem();
        List<TaxesType> rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = rTaxes.get(i);
            Tax tax = new Tax();
            TaxResultCodeType rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult.value());
            TaxesType.Jurisdiction rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            JurisdictionLevelCodeType rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel.value());
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "taxOnlyAdjustmentSale");
    }

    public VersionResponse VersionResponse() throws TaxProviderException {
        VersionResponseType.JavaVirtualMachineVersion responseJVMVersion;
        VersionResponseType.OperatingSystemVersion responseOperatingVersion;
        VersionResponseType.DatabaseVersions responseDatabaseVersions;
        List<VersionResponseType.LibraryVersions.LibraryVersion> listLibraryVersions;
        VersionResponseType.LibraryVersions responseLibraryVersions;
        List<VersionResponseType.ProductVersions.ProductVersion> listProductVersions;
        String M_NAME = "VersionResponse";
        s_logger.entering(C_NAME, "VersionResponse");
        VersionRequestType request = null;
        ProductVersions p_ProductVersions = new ProductVersions();
        LibraryVersions p_LibraryVersions = new LibraryVersions();
        DatabaseVersions p_DatabaseVersions = new DatabaseVersions();
        String p_configurationVersion = "";
        String p_messageResourceVersion = "";
        OperatingSystemVersion p_OperatingSystemVersion = new OperatingSystemVersion();
        JavaVirtualMachineVersion p_JVMVersion = new JavaVirtualMachineVersion();
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        request = objectFactory.createVersionRequestType();
        VersionResponseType response = (VersionResponseType)UTIL.doVersionRequest(request, VersionResponseType.class);
        VersionResponseType.ProductVersions responseProductVersions = response.getProductVersions();
        if (responseProductVersions != null && (listProductVersions = responseProductVersions.getProductVersion()) != null) {
            int nrProductVersions = responseProductVersions.getProductVersion().size();
            for (int i = 0; i < nrProductVersions; ++i) {
                VersionResponseType.ProductVersions.ProductVersion r_ProductVersion = listProductVersions.get(i);
                String r_productName = r_ProductVersion.getProductName();
                ProductVersion p_ProductVersion = new ProductVersion();
                p_ProductVersion.addProductName(r_productName);
                p_ProductVersions.addProductVersion(p_ProductVersion);
            }
        }
        if ((responseLibraryVersions = response.getLibraryVersions()) != null && (listLibraryVersions = responseLibraryVersions.getLibraryVersion()) != null) {
            int nrLibraryVersions = responseLibraryVersions.getLibraryVersion().size();
            for (int i = 0; i < nrLibraryVersions; ++i) {
                VersionResponseType.LibraryVersions.LibraryVersion r_LibraryVersion = listLibraryVersions.get(i);
                String r_libraryName = r_LibraryVersion.getLibraryName();
                String r_libraryOwner = r_LibraryVersion.getLibraryOwner();
                LibraryVersion p_LibraryVersion = new LibraryVersion();
                p_LibraryVersion.addLibraryName(r_libraryName);
                p_LibraryVersion.addLibraryOwner(r_libraryOwner);
                p_LibraryVersions.addLibraryVersion(p_LibraryVersion);
            }
        }
        if ((responseDatabaseVersions = response.getDatabaseVersions()) != null) {
            List<VersionResponseType.DatabaseVersions.DatabaseVersion> listDatabaseVersions = responseDatabaseVersions.getDatabaseVersion();
            int nrDatabaseVersions = responseDatabaseVersions.getDatabaseVersion().size();
            for (int i = 0; i < nrDatabaseVersions; ++i) {
                DatabaseVersion p_DatabaseVersion = new DatabaseVersion();
                VersionResponseType.DatabaseVersions.DatabaseVersion r_DatabaseVersion = listDatabaseVersions.get(i);
                if (r_DatabaseVersion == null) continue;
                VersionResponseType.DatabaseVersions.DatabaseVersion.DataContentVersions r_DataContentVersions = r_DatabaseVersion.getDataContentVersions();
                String contentNames = "";
                if (r_DataContentVersions != null) {
                    List<VersionResponseType.DatabaseVersions.DatabaseVersion.DataContentVersions.DataContentVersion> r_DataContentVersion = r_DataContentVersions.getDataContentVersion();
                    int nrDataContentVersions = r_DataContentVersions.getDataContentVersion().size();
                    for (int j = 0; j < nrDataContentVersions; ++j) {
                        String r_contentName = r_DataContentVersion.get(j).getContentName();
                        contentNames.concat(r_contentName);
                    }
                }
                String r_logicalName = r_DatabaseVersion.getLogicalName();
                String r_schemaName = r_DatabaseVersion.getSchemaVersion().getValue();
                String r_driverName = r_DatabaseVersion.getDriverVersion().getDriverName();
                String r_platformName = r_DatabaseVersion.getPlatformVersion().getValue();
                String r_platformVendor = r_DatabaseVersion.getPlatformVersion().getVendorName();
                p_DatabaseVersion.addDataContentVersions(contentNames);
                p_DatabaseVersion.addLogicalName(r_logicalName);
                p_DatabaseVersion.addSchemaVersion(r_schemaName);
                p_DatabaseVersion.addDriverVersion(r_driverName);
                p_DatabaseVersion.addPlatformVersion(r_platformName.concat(r_platformVendor));
                p_DatabaseVersions.addDatabaseVersion(p_DatabaseVersion);
            }
        }
        if ((responseOperatingVersion = response.getOperatingSystemVersion()) != null) {
            String rOperatingSystemName = responseOperatingVersion.getOperatingSystemName();
            p_OperatingSystemVersion.setOperatingSystemName(rOperatingSystemName);
        }
        if ((responseJVMVersion = response.getJavaVirtualMachineVersion()) != null) {
            String rJvmName = responseJVMVersion.getJvmName();
            p_JVMVersion.setJvmName(rJvmName);
        }
        p_configurationVersion = response.getConfigurationVersion();
        p_messageResourceVersion = response.getMessageResourceVersion();
        VersionResponse p_VersionResponse = new VersionResponse();
        p_VersionResponse.setProductVersions(p_ProductVersions);
        p_VersionResponse.setLibraryVersions(p_LibraryVersions);
        p_VersionResponse.setDatabaseVersions(p_DatabaseVersions);
        p_VersionResponse.setConfigurationVersion(p_configurationVersion);
        p_VersionResponse.setMessageResourceVersion(p_messageResourceVersion);
        p_VersionResponse.setOperatingSystemVersion(p_OperatingSystemVersion);
        p_VersionResponse.setJavaVirtualMachineVersion(p_JVMVersion);
        return p_VersionResponse;
    }

    private Location newLocation(LocationType p_location) {
        String country;
        String state;
        String county;
        String city;
        String zipCode;
        if (p_location == null) {
            return null;
        }
        Location location = new Location();
        BigInteger bigInt = p_location.getTaxAreaId();
        if (bigInt.compareTo(INTEGER_MIN_VALUE) < 0) {
            throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too low. Cannot fit in a Java int");
        }
        if (bigInt.compareTo(INTEGER_MAX_VALUE) > 0) {
            throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too big. Cannot fit in a Java int");
        }
        int geocode = bigInt.intValue();
        location.setGeocode(geocode);
        String street = p_location.getStreetAddress();
        if (street != null) {
            location.setStreet(street);
        }
        if ((zipCode = p_location.getPostalCode()) != null) {
            location.setZipCode(zipCode);
        }
        if ((city = p_location.getCity()) != null) {
            location.setCity(city);
        }
        if ((county = p_location.getSubDivision()) != null) {
            location.setCounty(county);
        }
        if ((state = p_location.getMainDivision()) != null) {
            location.setState(state);
        }
        if ((country = p_location.getCountry()) != null) {
            location.setCountry(country);
        }
        return location;
    }

    private void setValue(IntHolder p_holder, BigInteger p_value) {
        if (p_value != null) {
            if (p_value.compareTo(INTEGER_MIN_VALUE) < 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + p_value + " is too low. Cannot fit in a Java int");
            }
            if (p_value.compareTo(INTEGER_MAX_VALUE) > 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + p_value + " is too big. Cannot fit in a Java int");
            }
            int value = p_value.intValue();
            p_holder.setValue(value);
        } else {
            p_holder.setValue(-1);
        }
    }

    private void setValue(StringHolder p_holder, String p_value) {
        if (p_value != null) {
            p_holder.setValue(p_value);
        } else {
            p_holder.setValue(EMPTY_STRING);
        }
    }

    private boolean isValid(String p_parameter) {
        return p_parameter != null && p_parameter.length() > 0;
    }

    private CompanyType newCompany(String p_company) throws JAXBException {
        if (!this.isValid(p_company)) {
            return null;
        }
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        CompanyType company = objectFactory.createCompanyType();
        List<Serializable> companyObjects = company.getContent();
        companyObjects.add((Serializable)((Object)p_company));
        return company;
    }

    private CompanyType newCompany(StringHolder p_company) throws JAXBException {
        if (p_company == null) {
            return null;
        }
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        CompanyType company = objectFactory.createCompanyType();
        List<Serializable> companyObjects = company.getContent();
        companyObjects.add((Serializable)p_company);
        return company;
    }

    private Calendar stringToCalendar(String p_date) {
        try {
            Date datetime = DATE_FORMAT.parse(p_date);
            Calendar date = Calendar.getInstance(TIMEZONE_UTC);
            date.setTime(datetime);
            return date;
        }
        catch (ParseException ex_p) {
            throw UTIL.newSevereRuntimeException("Could not convert date string to Calendar object", ex_p);
        }
    }

    private boolean locationToLocationType(Location p_location, LocationType p_locationType) {
        int nrFields = 0;
        if (p_location.hasGeocode()) {
            p_locationType.setTaxAreaId(BigInteger.valueOf(p_location.getGeocode()));
            ++nrFields;
        }
        if (p_location.hasStreet()) {
            p_locationType.setStreetAddress(p_location.getStreet());
            ++nrFields;
        }
        if (p_location.hasCity()) {
            p_locationType.setCity(p_location.getCity());
            ++nrFields;
        }
        if (p_location.hasZipCode()) {
            p_locationType.setPostalCode(p_location.getZipCode());
            ++nrFields;
        }
        if (p_location.hasCounty()) {
            p_locationType.setSubDivision(p_location.getCounty());
            ++nrFields;
        }
        if (p_location.hasState()) {
            p_locationType.setMainDivision(p_location.getState());
            ++nrFields;
        }
        if (p_location.hasCountry()) {
            p_locationType.setCountry(p_location.getCountry());
            ++nrFields;
        }
        return nrFields != 0;
    }

    static {
        DATE_FORMAT.setTimeZone(TIMEZONE_UTC);
    }
}

