/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.tatest.taxprovider1;

import com.ssa.ta.taxprovider1.DatabaseVersion;
import com.ssa.ta.taxprovider1.DatabaseVersions;
import com.ssa.ta.taxprovider1.JavaVirtualMachineVersion;
import com.ssa.ta.taxprovider1.LibraryVersion;
import com.ssa.ta.taxprovider1.LibraryVersions;
import com.ssa.ta.taxprovider1.Manager1;
import com.ssa.ta.taxprovider1.OperatingSystemVersion;
import com.ssa.ta.taxprovider1.ProductVersion;
import com.ssa.ta.taxprovider1.ProductVersions;
import com.ssa.ta.taxprovider1.VersionResponse;

public class VersionRequestClient {
    private static final String SYSPROP_BUS_COMPONENT = "bc";
    private static final String DEFAULT_BUS_COMPONENT = "vertex";

    private VersionRequestClient() {
    }

    public static void main(String[] p_args) {
        try {
            int i;
            VersionRequestClient.log("Starting VersionRequest client...");
            String busComponent = VersionRequestClient.getProperty(SYSPROP_BUS_COMPONENT, DEFAULT_BUS_COMPONENT);
            ProductVersions p_ProductVersions = new ProductVersions();
            LibraryVersions p_LibraryVersions = new LibraryVersions();
            DatabaseVersions p_DatabaseVersions = new DatabaseVersions();
            String p_configurationVersion = "";
            String p_messageResourceVersion = "";
            OperatingSystemVersion p_OperatingSystemVersion = new OperatingSystemVersion();
            JavaVirtualMachineVersion p_JVMVersion = new JavaVirtualMachineVersion();
            VersionRequestClient.log("");
            VersionRequestClient.log("Connecting to bridge...");
            Manager1 taxProvider = new Manager1();
            taxProvider.initialize(busComponent);
            VersionResponse rVersionResponse = taxProvider.VersionResponse();
            p_ProductVersions = rVersionResponse.getProductVersions();
            if (p_ProductVersions != null) {
                int nrProductVersions = p_ProductVersions.sizeProductVersion();
                for (i = 0; i < nrProductVersions; ++i) {
                    VersionRequestClient.log("Found productVersion[" + i + "]:");
                    ProductVersion productVersion = p_ProductVersions.getProductVersionAt(i);
                    VersionRequestClient.log("\tName: " + productVersion.getProductNameAt(i));
                }
            }
            if (rVersionResponse.hasLibraryVersions()) {
                p_LibraryVersions = rVersionResponse.getLibraryVersions();
                int nrLibraryVersions = p_LibraryVersions.sizeLibraryVersion();
                for (i = 0; i < nrLibraryVersions; ++i) {
                    VersionRequestClient.log("Found libraryVersion[" + i + "]:");
                    LibraryVersion libraryVersion = p_LibraryVersions.getLibraryVersionAt(i);
                    VersionRequestClient.log("\tName: " + libraryVersion.getLibraryNameAt(i));
                    VersionRequestClient.log("\tOwner: " + libraryVersion.getLibraryOwnerAt(i));
                }
            }
            if (rVersionResponse.hasDatabaseVersions()) {
                p_DatabaseVersions = rVersionResponse.getDatabaseVersions();
                int nrDatabaseVersions = p_DatabaseVersions.sizeDatabaseVersion();
                for (i = 0; i < nrDatabaseVersions; ++i) {
                    VersionRequestClient.log("Found databaseVersion[" + i + "]:");
                    DatabaseVersion databaseVersion = p_DatabaseVersions.getDatabaseVersionAt(i);
                    VersionRequestClient.log("\tLogicalName: " + databaseVersion.getLogicalNameAt(i));
                    VersionRequestClient.log("\tSchemaVersion: " + databaseVersion.getSchemaVersionAt(i));
                    VersionRequestClient.log("\tPlatformVersionValue: " + databaseVersion.getPlatformVersionAt(i));
                    VersionRequestClient.log("\tDataContextVersion: " + databaseVersion.getDataContentVersionsAt(i));
                    VersionRequestClient.log("\tDriverVersion: " + databaseVersion.getDriverVersionAt(i));
                }
            }
            if (rVersionResponse.hasJavaVirtualMachineVersion()) {
                p_JVMVersion = rVersionResponse.getJavaVirtualMachineVersion();
                VersionRequestClient.log("\tJVMVersion: " + p_JVMVersion.getJvmName());
            }
            if (rVersionResponse.hasOperatingSystemVersion()) {
                p_OperatingSystemVersion = rVersionResponse.getOperatingSystemVersion();
                VersionRequestClient.log("\tOpsVersionName: " + p_OperatingSystemVersion.getOperatingSystemName());
            }
            if (rVersionResponse.hasConfigurationVersion()) {
                p_configurationVersion = rVersionResponse.getConfigurationVersion();
                VersionRequestClient.log("\tConfigurationVersion: " + p_configurationVersion);
            }
            if (rVersionResponse.hasMessageResourceVersion()) {
                p_messageResourceVersion = rVersionResponse.getMessageResourceVersion();
                VersionRequestClient.log("\tMessageResourceVersion: " + p_messageResourceVersion);
            }
            VersionRequestClient.log("");
            taxProvider.close();
        }
        catch (Exception ex) {
            VersionRequestClient.log("");
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getProperty(String p_key, String p_defaultValue) {
        String value = System.getProperty(p_key, p_defaultValue);
        VersionRequestClient.log("Using argument -D" + p_key + '=' + value);
        return value;
    }

    private static void log(String p_message) {
        System.out.println(p_message);
    }
}

